/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.course.service.impl;

import java.io.InputStream;
import java.io.Serializable;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Locale;
import org.beangle.data.dao.EntityDao;
import org.beangle.data.dao.OqlBuilder;
import org.beangle.data.dao.OqlBuilder$;
import org.beangle.data.dao.QueryBuilder;
import org.beangle.data.model.LongId;
import org.beangle.ems.app.EmsApp$;
import org.beangle.ems.app.blob.BlobMeta;
import org.beangle.ems.app.blob.Repository;
import org.openurp.base.edu.model.Course;
import org.openurp.base.model.User;
import org.openurp.base.service.SemesterService;
import org.openurp.edu.course.model.Syllabus;
import org.openurp.edu.course.model.SyllabusFile;
import org.openurp.edu.course.service.SyllabusService;
import scala.Function1;
import scala.Int$;
import scala.Option;
import scala.collection.immutable.Seq;
import scala.runtime.ScalaRunTime$;

public class SyllabusServiceImpl
implements SyllabusService {
    private SemesterService semesterService;
    private EntityDao entityDao;
    private int validateYears = 4;

    public SemesterService semesterService() {
        return this.semesterService;
    }

    public void semesterService_$eq(SemesterService x$1) {
        this.semesterService = x$1;
    }

    public EntityDao entityDao() {
        return this.entityDao;
    }

    public void entityDao_$eq(EntityDao x$1) {
        this.entityDao = x$1;
    }

    public int validateYears() {
        return this.validateYears;
    }

    public void validateYears_$eq(int x$1) {
        this.validateYears = x$1;
    }

    @Override
    public Syllabus upload(Course course, User author, InputStream data, String extension, Locale locale, Instant updatedAt) {
        Repository blob = EmsApp$.MODULE$.getBlobRepository(true);
        LocalDate today = updatedAt.atZone(ZoneId.systemDefault()).toLocalDate();
        Option<Syllabus> existed = this.getLastSyllabus(course, author);
        Syllabus syllabus = (Syllabus)existed.getOrElse(SyllabusServiceImpl::$anonfun$1);
        syllabus.course_$eq(course);
        syllabus.updatedAt_$eq(updatedAt);
        syllabus.author_$eq(author);
        syllabus.department_$eq(course.department());
        syllabus.semester_$eq(this.semesterService().get(course.project(), today));
        if (syllabus.beginOn() == null) {
            syllabus.beginOn_$eq(today);
        }
        syllabus.endOn_$eq(today.plusYears(Int$.MODULE$.int2long(this.validateYears())));
        this.entityDao().saveOrUpdate((Object)syllabus, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Syllabus[0]));
        if (syllabus.attachments().nonEmpty()) {
            syllabus.attachments().find((Function1 & Serializable)x -> {
                Locale locale = x.docLocale();
                Locale locale2 = locale;
                return !(locale != null ? !((Object)locale).equals(locale2) : locale2 != null);
            }).foreach((Function1 & Serializable)removed -> {
                syllabus.attachments().$minus$eq(removed);
                return blob.remove(removed.filePath());
            });
        }
        String fileName = course.code() + "\u5927\u7eb2." + extension;
        BlobMeta meta = blob.upload("/course/" + course.id() + "/syllabus/" + author.id() + "_" + today.toString() + "/", data, fileName, author.code() + " " + author.name());
        SyllabusFile attachment = new SyllabusFile();
        attachment.fileSize_$eq(meta.fileSize());
        attachment.mimeType_$eq(meta.mediaType());
        attachment.docLocale_$eq(locale);
        attachment.filePath_$eq(meta.filePath());
        attachment.syllabus_$eq(syllabus);
        syllabus.attachments().$plus$eq((Object)attachment);
        this.entityDao().saveOrUpdate((Object)syllabus, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LongId[]{attachment}));
        return syllabus;
    }

    private Option<Syllabus> getLastSyllabus(Course course, User author) {
        OqlBuilder query = OqlBuilder$.MODULE$.from(Syllabus.class, "s");
        query.where("s.course = :course", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{course}));
        query.where("s.author=:author", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{author}));
        query.orderBy("s.semester.beginOn desc");
        query.limit(1, 1);
        return this.entityDao().search((QueryBuilder)query).headOption();
    }

    private static final Syllabus $anonfun$1() {
        return new Syllabus();
    }
}

