/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.course.web.action;

import jakarta.servlet.http.Part;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.time.Instant;
import java.time.LocalDate;
import java.util.Locale;
import org.beangle.commons.file.zip.Zipper$;
import org.beangle.commons.io.Files$;
import org.beangle.commons.io.IOs$;
import org.beangle.commons.lang.Strings$;
import org.beangle.commons.logging.Logger$;
import org.beangle.commons.net.http.HttpUtils$;
import org.beangle.data.dao.EntityDao;
import org.beangle.data.dao.OqlBuilder;
import org.beangle.data.dao.OqlBuilder$;
import org.beangle.data.dao.QueryBuilder;
import org.beangle.data.model.Entity;
import org.beangle.data.model.pojo.Named;
import org.beangle.ems.app.Ems$;
import org.beangle.ems.app.EmsApp$;
import org.beangle.ems.app.blob.Repository;
import org.beangle.security.Securities$;
import org.beangle.web.action.annotation.mapping;
import org.beangle.web.action.annotation.param;
import org.beangle.web.action.support.ActionSupport;
import org.beangle.web.action.support.EntitySupport;
import org.beangle.web.action.view.Stream$;
import org.beangle.web.action.view.View;
import org.beangle.webmvc.support.action.EntityAction;
import org.openurp.base.edu.code.CourseCategory;
import org.openurp.base.edu.code.CourseType;
import org.openurp.base.edu.model.Course;
import org.openurp.base.edu.model.TeachingOffice;
import org.openurp.base.model.AuditStatus$;
import org.openurp.base.model.Project;
import org.openurp.base.model.User;
import org.openurp.base.profile.model.CourseProfile;
import org.openurp.base.service.ProjectPropertyService;
import org.openurp.base.service.SemesterService;
import org.openurp.code.edu.model.CourseNature;
import org.openurp.code.service.CodeService;
import org.openurp.edu.clazz.model.Clazz;
import org.openurp.edu.course.model.Syllabus;
import org.openurp.edu.course.model.SyllabusFile;
import org.openurp.edu.course.service.SyllabusService;
import org.openurp.edu.course.web.helper.StatHelper;
import org.openurp.starter.web.support.ProjectSupport;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.collection.Iterable;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LazyRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction0;

public class DepartAction
extends ActionSupport
implements EntityAction<Course>,
ProjectSupport {
    private Class entityClass;
    private CodeService codeService;
    private ProjectPropertyService projectPropertyService;
    private SemesterService semesterService;
    private EntityDao entityDao;
    private SyllabusService syllabusService;

    public DepartAction() {
        EntitySupport.$init$((EntitySupport)this);
        ProjectSupport.$init$((ProjectSupport)this);
        Statics.releaseFence();
    }

    public Class entityClass() {
        return this.entityClass;
    }

    public void org$beangle$web$action$support$EntitySupport$_setter_$entityClass_$eq(Class x$0) {
        this.entityClass = x$0;
    }

    public CodeService codeService() {
        return this.codeService;
    }

    public ProjectPropertyService projectPropertyService() {
        return this.projectPropertyService;
    }

    public SemesterService semesterService() {
        return this.semesterService;
    }

    public void codeService_$eq(CodeService x$1) {
        this.codeService = x$1;
    }

    public void projectPropertyService_$eq(ProjectPropertyService x$1) {
        this.projectPropertyService = x$1;
    }

    public void semesterService_$eq(SemesterService x$1) {
        this.semesterService = x$1;
    }

    public EntityDao entityDao() {
        return this.entityDao;
    }

    public void entityDao_$eq(EntityDao x$1) {
        this.entityDao = x$1;
    }

    public SyllabusService syllabusService() {
        return this.syllabusService;
    }

    public void syllabusService_$eq(SyllabusService x$1) {
        this.syllabusService = x$1;
    }

    public View index() {
        LazyRef lazyRef = new LazyRef();
        this.put("courseTypes", this.getCodes(CourseType.class, this.project$1(lazyRef)));
        this.put("courseCategories", this.getCodes(CourseCategory.class, this.project$1(lazyRef)));
        this.put("courseNatures", this.getCodes(CourseNature.class, this.project$1(lazyRef)));
        this.put("teachingOffices", this.entityDao().getAll(TeachingOffice.class));
        this.put("departments", this.getDeparts(this.project$1(lazyRef)));
        this.put("project", this.getProject());
        return this.forward(this.forward$default$1());
    }

    public View search() {
        OqlBuilder<Course> query = this.getQueryBuilder();
        Seq courses = this.entityDao().search(query);
        StatHelper statHelper = new StatHelper(this.entityDao());
        this.put("hasProfileCourses", statHelper.hasSyllabus((Iterable<Course>)courses));
        this.put("hasSyllabusCourses", statHelper.hasProfile((Iterable<Course>)courses));
        this.put("courses", courses);
        return this.forward(this.forward$default$1());
    }

    public OqlBuilder<Course> getQueryBuilder() {
        LazyRef lazyRef = new LazyRef();
        OqlBuilder builder = EntityAction.getQueryBuilder$((EntityAction)this);
        builder.where("course.department in(:departs)", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.getDeparts(this.project$2(lazyRef))}));
        builder.where(this.simpleEntityName() + ".project = :project", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.getProject()}));
        this.addTemporalOn(builder, (Option<Object>)Some$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)true)));
        Option hasClazz = this.getBoolean("hasClazz");
        Option semesterId = this.getInt("semester.id");
        hasClazz.foreach((Function1 & Serializable)x$1 -> DepartAction.getQueryBuilder$$anonfun$1(builder, semesterId, BoxesRunTime.unboxToBoolean((Object)x$1)));
        this.getBoolean("hasProfile").foreach((Function1 & Serializable)x$1 -> DepartAction.getQueryBuilder$$anonfun$2(builder, BoxesRunTime.unboxToBoolean((Object)x$1)));
        this.getBoolean("hasSyllabus").foreach((Function1 & Serializable)x$1 -> DepartAction.getQueryBuilder$$anonfun$3(builder, BoxesRunTime.unboxToBoolean((Object)x$1)));
        return builder;
    }

    private <T extends Entity<?>> OqlBuilder<T> addTemporalOn(OqlBuilder<T> builder, Option<Object> active2) {
        active2.foreach((Function1 & Serializable)active -> DepartAction.addTemporalOn$$anonfun$1(builder, BoxesRunTime.unboxToBoolean((Object)active)));
        return builder;
    }

    @mapping(value="{id}/edit")
    public View edit(@param(value="id") String id) {
        CourseProfile courseProfile;
        Course course = (Course)this.entityDao().get(Course.class, (Object)BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(id))));
        Option<CourseProfile> option = this.getProfile(course);
        if (option instanceof Some) {
            CourseProfile p;
            courseProfile = p = (CourseProfile)((Some)option).value();
        } else if (None$.MODULE$.equals(option)) {
            CourseProfile cp = new CourseProfile();
            cp.course_$eq(course);
            courseProfile = cp;
        } else {
            throw new MatchError(option);
        }
        CourseProfile profile = courseProfile;
        this.put("profile", profile);
        this.put("course", course);
        OqlBuilder syllabusQuery = OqlBuilder$.MODULE$.from(Syllabus.class, "s");
        syllabusQuery.where("s.course = :course", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{course}));
        syllabusQuery.orderBy("s.semester.beginOn desc");
        syllabusQuery.limit(1, 1);
        this.put("syllabuses", this.entityDao().search((QueryBuilder)syllabusQuery));
        this.put("Ems", Ems$.MODULE$);
        return this.forward(this.forward$default$1());
    }

    @mapping(value="{id}", method="put")
    public View update(@param(value="id") String id) {
        Course course = (Course)this.entityDao().get(Course.class, (Object)BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(id))));
        CourseProfile profile = (CourseProfile)this.getProfile(course).getOrElse(DepartAction::$anonfun$1);
        Option user = this.entityDao().findBy(User.class, "code", package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{Securities$.MODULE$.user()}))).headOption();
        profile.course_$eq(course);
        this.populate((Entity)profile, "profile");
        profile.updatedAt_$eq(Instant.now());
        profile.updatedBy_$eq(user);
        this.entityDao().saveOrUpdate((Object)profile, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CourseProfile[0]));
        Iterable parts = this.getAll("attachment", Part.class, ClassTag$.MODULE$.apply(Part.class));
        Option authorId = this.getLong("syllabus.author.id");
        if (parts.size() > 0 && ((Part)parts.head()).getSize() > 0L && authorId.nonEmpty()) {
            Part part = (Part)parts.head();
            User author = (User)this.entityDao().get(User.class, authorId.get());
            Syllabus syllabus = this.syllabusService().upload(course, author, part.getInputStream(), Strings$.MODULE$.substringAfterLast(part.getSubmittedFileName(), "."), Locale.SIMPLIFIED_CHINESE, Instant.now());
            syllabus.status_$eq(AuditStatus$.Published);
            this.entityDao().saveOrUpdate((Object)syllabus, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Syllabus[0]));
        }
        return this.redirect("search", "info.save.success");
    }

    private Option<CourseProfile> getProfile(Course course) {
        OqlBuilder query = OqlBuilder$.MODULE$.from(CourseProfile.class, "cp");
        query.where("cp.course = :course", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{course}));
        return this.entityDao().search((QueryBuilder)query).headOption();
    }

    public View attachment() {
        SyllabusFile file = (SyllabusFile)this.entityDao().get(SyllabusFile.class, (Object)BoxesRunTime.boxToLong((long)this.getLongId("file")));
        Option path = EmsApp$.MODULE$.getBlobRepository(true).url(file.filePath());
        this.response().sendRedirect(((URL)path.get()).toString());
        return null;
    }

    public View batchDownload() {
        List courseIds = this.getLongIds("course");
        OqlBuilder query = OqlBuilder$.MODULE$.from(Syllabus.class, "s");
        query.where("s.course.id in(:courseIds)", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{courseIds}));
        query.where("not exists(from " + Syllabus.class.getName() + " s2 where s2.course=s.course and s2.updatedAt>s.updatedAt)", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
        Seq syllabuses = this.entityDao().search((QueryBuilder)query);
        Seq departs = (Seq)((SeqOps)syllabuses.map((Function1 & Serializable)_$3 -> _$3.course().department())).distinct();
        File dir = new File(System.getProperty("java.io.tmpdir") + "syllabus" + Files$.MODULE$.$div() + System.currentTimeMillis());
        if (dir.exists()) {
            Files$.MODULE$.travel(dir, (Function1)(JProcedure1 & Serializable)f -> f.delete());
        }
        dir.mkdirs();
        IntRef paperCount = IntRef.create((int)0);
        Repository blob = EmsApp$.MODULE$.getBlobRepository(true);
        syllabuses.foreach((Function1)(JProcedure1 & Serializable)syllabus -> syllabus.attachments().headOption().foreach((Function1)(JProcedure1 & Serializable)attachment -> blob.url(attachment.filePath()).foreach((Function1)(JProcedure1 & Serializable)url -> {
            int n;
            String courseName = syllabus.course().code() + " " + syllabus.course().name();
            String fileName = dir.getAbsolutePath() + Files$.MODULE$.$div() + courseName + "." + Strings$.MODULE$.substringAfterLast(attachment.filePath(), ".");
            this.downloading(url.openConnection(), new File(fileName));
            paperCount$3.elem = n = paperCount$3.elem + 1;
        })));
        File targetZip = new File(System.getProperty("java.io.tmpdir") + "syllabus" + Files$.MODULE$.$div() + "batch.zip");
        Zipper$.MODULE$.zip(dir, targetZip, Zipper$.MODULE$.zip$default$3());
        String fileName = (String)(departs.size() == 1 ? ((Named)departs.head()).name() : ((Named)departs.head()).name() + "\u7b49\u9662\u7cfb") + ("\u8bfe\u7a0b\u5927\u7eb2(" + paperCount.elem + ").zip");
        return Stream$.MODULE$.apply(targetZip, "application/zip", fileName).cleanup((Function0)(JFunction0.mcV.sp & Serializable)() -> {
            Files$.MODULE$.travel(dir, (Function1)(JProcedure1 & Serializable)f -> f.delete());
            dir.delete();
            targetZip.delete();
        });
    }

    private void downloading(URLConnection c, File location) {
        HttpURLConnection conn = HttpUtils$.MODULE$.followRedirect(c, "GET");
        InputStream input = null;
        FileOutputStream output = null;
        try {
            try {
                File file = new File(location.toString() + ".part");
                file.delete();
                byte[] buffer = new byte[4096];
                input = conn.getInputStream();
                output = new FileOutputStream(file);
                int n = input.read(buffer);
                while (-1 != n) {
                    ((OutputStream)output).write(buffer, 0, n);
                    n = input.read(buffer);
                }
                IOs$.MODULE$.close((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AutoCloseable[]{input, output}));
                input = null;
                output = null;
                file.renameTo(location);
            }
            catch (Throwable e) {
                Logger$.MODULE$.warn$extension(this.logger(), () -> DepartAction.downloading$$anonfun$1(location));
            }
        }
        catch (Throwable throwable) {
            IOs$.MODULE$.close((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AutoCloseable[]{input, output}));
            throw throwable;
        }
        IOs$.MODULE$.close((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AutoCloseable[]{input, output}));
    }

    private final Project project$lzyINIT1$1(LazyRef project$lzy1$1) {
        Project project;
        LazyRef lazyRef = project$lzy1$1;
        synchronized (lazyRef) {
            project = (Project)(project$lzy1$1.initialized() ? project$lzy1$1.value() : project$lzy1$1.initialize((Object)this.getProject()));
        }
        return project;
    }

    private final Project project$1(LazyRef project$lzy1$2) {
        return (Project)(project$lzy1$2.initialized() ? project$lzy1$2.value() : this.project$lzyINIT1$1(project$lzy1$2));
    }

    private final Project project$lzyINIT2$1(LazyRef project$lzy2$1) {
        Project project;
        LazyRef lazyRef = project$lzy2$1;
        synchronized (lazyRef) {
            project = (Project)(project$lzy2$1.initialized() ? project$lzy2$1.value() : project$lzy2$1.initialize((Object)this.getProject()));
        }
        return project;
    }

    private final Project project$2(LazyRef project$lzy2$2) {
        return (Project)(project$lzy2$2.initialized() ? project$lzy2$2.value() : this.project$lzyINIT2$1(project$lzy2$2));
    }

    private static final /* synthetic */ OqlBuilder getQueryBuilder$$anonfun$1(OqlBuilder builder$1, Option semesterId$1, boolean x$1) {
        boolean bl = x$1;
        if (bl) {
            Option option = semesterId$1;
            if (option instanceof Some) {
                int sid = BoxesRunTime.unboxToInt((Object)((Some)option).value());
                return (OqlBuilder)builder$1.where("exists(from " + Clazz.class.getName() + " clz where clz.course=course and clz.semester.id=:semesterId)", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)sid)}));
            }
            if (None$.MODULE$.equals(option)) {
                return (OqlBuilder)builder$1.where("exists(from " + Clazz.class.getName() + " clz where clz.course=course)", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
            }
            throw new MatchError((Object)option);
        }
        if (!bl) {
            Option option = semesterId$1;
            if (option instanceof Some) {
                int sid = BoxesRunTime.unboxToInt((Object)((Some)option).value());
                return (OqlBuilder)builder$1.where("not exists(from " + Clazz.class.getName() + " clz where clz.course=course and clz.semester.id=:semesterId)", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)sid)}));
            }
            if (None$.MODULE$.equals(option)) {
                return (OqlBuilder)builder$1.where("not exists(from " + Clazz.class.getName() + " clz where clz.course=course)", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
            }
            throw new MatchError((Object)option);
        }
        throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
    }

    private static final /* synthetic */ OqlBuilder getQueryBuilder$$anonfun$2(OqlBuilder builder$2, boolean x$1) {
        boolean bl = x$1;
        if (bl) {
            return (OqlBuilder)builder$2.where("exists(from " + CourseProfile.class.getName() + " clz where clz.course=course)", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
        }
        if (!bl) {
            return (OqlBuilder)builder$2.where("not exists(from " + CourseProfile.class.getName() + " clz where clz.course=course)", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
        }
        throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
    }

    private static final /* synthetic */ OqlBuilder getQueryBuilder$$anonfun$3(OqlBuilder builder$3, boolean x$1) {
        boolean bl = x$1;
        if (bl) {
            return (OqlBuilder)builder$3.where("exists(from " + Syllabus.class.getName() + " clz where clz.course=course)", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
        }
        if (!bl) {
            return (OqlBuilder)builder$3.where("not exists(from " + Syllabus.class.getName() + " clz where clz.course=course)", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
        }
        throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
    }

    private static final /* synthetic */ OqlBuilder addTemporalOn$$anonfun$1(OqlBuilder builder$4, boolean active) {
        if (active) {
            return (OqlBuilder)builder$4.where(builder$4.alias() + ".beginOn <= :now and (" + builder$4.alias() + ".endOn is null or " + builder$4.alias() + ".endOn >= :now)", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{LocalDate.now()}));
        }
        return (OqlBuilder)builder$4.where("not (" + builder$4.alias() + ".beginOn <= :now and (" + builder$4.alias() + ".endOn is null or " + builder$4.alias() + ".endOn >= :now))", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{LocalDate.now()}));
    }

    private static final CourseProfile $anonfun$1() {
        return new CourseProfile();
    }

    private static final String downloading$$anonfun$1(File location$1) {
        return "Cannot download file " + location$1;
    }
}

