/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.course.web.action;

import java.io.Serializable;
import java.net.URL;
import java.time.LocalDate;
import org.beangle.data.dao.EntityDao;
import org.beangle.data.dao.OqlBuilder;
import org.beangle.data.dao.OqlBuilder$;
import org.beangle.data.dao.QueryBuilder;
import org.beangle.ems.app.EmsApp$;
import org.beangle.web.action.annotation.mapping;
import org.beangle.web.action.annotation.param;
import org.beangle.web.action.support.ActionSupport;
import org.beangle.web.action.support.EntitySupport;
import org.beangle.web.action.view.Status$;
import org.beangle.web.action.view.View;
import org.beangle.webmvc.support.action.EntityAction;
import org.openurp.base.edu.model.Course;
import org.openurp.base.model.AuditStatus;
import org.openurp.base.model.AuditStatus$;
import org.openurp.base.profile.model.CourseProfile;
import org.openurp.base.service.ProjectPropertyService;
import org.openurp.base.service.SemesterService;
import org.openurp.code.service.CodeService;
import org.openurp.edu.clazz.model.Clazz;
import org.openurp.edu.course.model.Syllabus;
import org.openurp.edu.course.model.SyllabusFile;
import org.openurp.edu.course.web.helper.StatHelper;
import org.openurp.starter.web.support.ProjectSupport;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

public class InfoAction
extends ActionSupport
implements EntityAction<Course>,
ProjectSupport {
    private Class entityClass;
    private CodeService codeService;
    private ProjectPropertyService projectPropertyService;
    private SemesterService semesterService;
    private EntityDao entityDao;

    public InfoAction() {
        EntitySupport.$init$((EntitySupport)this);
        ProjectSupport.$init$((ProjectSupport)this);
        Statics.releaseFence();
    }

    public Class entityClass() {
        return this.entityClass;
    }

    public void org$beangle$web$action$support$EntitySupport$_setter_$entityClass_$eq(Class x$0) {
        this.entityClass = x$0;
    }

    public CodeService codeService() {
        return this.codeService;
    }

    public ProjectPropertyService projectPropertyService() {
        return this.projectPropertyService;
    }

    public SemesterService semesterService() {
        return this.semesterService;
    }

    public void codeService_$eq(CodeService x$1) {
        this.codeService = x$1;
    }

    public void projectPropertyService_$eq(ProjectPropertyService x$1) {
        this.projectPropertyService = x$1;
    }

    public void semesterService_$eq(SemesterService x$1) {
        this.semesterService = x$1;
    }

    public EntityDao entityDao() {
        return this.entityDao;
    }

    public void entityDao_$eq(EntityDao x$1) {
        this.entityDao = x$1;
    }

    public View index() {
        OqlBuilder dQuery = OqlBuilder$.MODULE$.from(Course.class.getName(), "c");
        dQuery.where("c.endOn is null or c.endOn > :now", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{LocalDate.now()}));
        dQuery.select("c.department.id,c.department.name,count(*)");
        dQuery.groupBy("c.department.id,c.department.code,c.department.name");
        dQuery.orderBy("c.department.code");
        this.put("departStat", this.entityDao().search((QueryBuilder)dQuery));
        OqlBuilder ctQuery = OqlBuilder$.MODULE$.from(Course.class.getName(), "c");
        ctQuery.where("c.endOn is null or c.endOn > :now", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{LocalDate.now()}));
        ctQuery.select("c.courseType.id,c.courseType.name,count(*)");
        ctQuery.groupBy("c.courseType.id,c.courseType.code,c.courseType.name");
        ctQuery.orderBy("c.courseType.code");
        this.put("typeStat", this.entityDao().search((QueryBuilder)ctQuery));
        OqlBuilder ccQuery = OqlBuilder$.MODULE$.from(Course.class.getName(), "c");
        ccQuery.where("c.endOn is null or c.endOn > :now", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{LocalDate.now()}));
        ccQuery.select("c.nature.id,c.nature.name,count(*)");
        ccQuery.groupBy("c.nature.id,c.nature.code,c.nature.name");
        ccQuery.orderBy("c.nature.code");
        this.put("natureStat", this.entityDao().search((QueryBuilder)ccQuery));
        return this.forward(this.forward$default$1());
    }

    public View search() {
        OqlBuilder query = this.getQueryBuilder();
        this.get("q").foreach((Function1 & Serializable)q -> (OqlBuilder)query.where("course.code like :q or course.name like :q", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"%" + q.trim() + "%"})));
        query.where("course.endOn is null or course.endOn > :now", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{LocalDate.now()}));
        query.orderBy("course.code");
        this.getBoolean("hasClazz").foreach((Function1 & Serializable)x$1 -> InfoAction.search$$anonfun$2(query, BoxesRunTime.unboxToBoolean((Object)x$1)));
        this.put("courses", this.entityDao().search((QueryBuilder)query));
        return this.forward(this.forward$default$1());
    }

    @mapping(value="{id}")
    public View info(@param(value="id") String id) {
        Course course = (Course)this.entityDao().get(Course.class, (Object)BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(id))));
        this.put(this.simpleEntityName(), course);
        OqlBuilder profileQuery = OqlBuilder$.MODULE$.from(CourseProfile.class, "cp");
        profileQuery.where("cp.course = :course", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{course}));
        this.put("profile", this.entityDao().search((QueryBuilder)profileQuery).headOption());
        OqlBuilder syllabusQuery = OqlBuilder$.MODULE$.from(Syllabus.class, "s");
        syllabusQuery.where("s.course = :course", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{course}));
        syllabusQuery.where("s.status=:publishsed", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{AuditStatus$.Published}));
        syllabusQuery.orderBy("s.updatedAt desc");
        this.put("syllabuses", this.entityDao().search((QueryBuilder)syllabusQuery));
        StatHelper statHelper = new StatHelper(this.entityDao());
        this.put("clazzInfos", statHelper.statClazzInfo(course));
        this.put("planCourseInfos", statHelper.statPlanCourseInfo(course));
        return this.forward(this.forward$default$1());
    }

    public View attachment() {
        SyllabusFile file = (SyllabusFile)this.entityDao().get(SyllabusFile.class, (Object)BoxesRunTime.boxToLong((long)this.getLongId("file")));
        AuditStatus auditStatus = file.syllabus().status();
        AuditStatus auditStatus2 = AuditStatus$.Published;
        if (!(auditStatus != null ? !auditStatus.equals(auditStatus2) : auditStatus2 != null)) {
            Option path = EmsApp$.MODULE$.getBlobRepository(true).url(file.filePath());
            this.response().sendRedirect(((URL)path.get()).toString());
            return null;
        }
        return Status$.MODULE$.NotFound();
    }

    private static final /* synthetic */ OqlBuilder search$$anonfun$2(OqlBuilder query$2, boolean x$1) {
        boolean bl = x$1;
        if (bl) {
            return (OqlBuilder)query$2.where("exists(from " + Clazz.class.getName() + " clz where clz.course=course)", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
        }
        if (!bl) {
            return (OqlBuilder)query$2.where("not exists(from " + Clazz.class.getName() + " clz where clz.course=course)", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
        }
        throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
    }
}

