/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.course.web.action.info;

import java.io.File;
import java.io.Serializable;
import java.net.URI;
import org.beangle.data.dao.EntityDao;
import org.beangle.data.dao.OqlBuilder;
import org.beangle.data.dao.OqlBuilder$;
import org.beangle.data.dao.QueryBuilder;
import org.beangle.doc.core.PrintOptions;
import org.beangle.doc.pdf.SPDConverter$;
import org.beangle.template.freemarker.ProfileTemplateLoader$;
import org.beangle.web.action.support.ActionSupport;
import org.beangle.web.action.support.EntitySupport;
import org.beangle.web.action.view.Stream$;
import org.beangle.web.action.view.View;
import org.beangle.webmvc.support.action.EntityAction;
import org.openurp.base.model.AuditStatus;
import org.openurp.base.model.AuditStatus$;
import org.openurp.base.model.Department;
import org.openurp.base.model.Project;
import org.openurp.base.model.Semester;
import org.openurp.base.service.ProjectConfigService;
import org.openurp.base.service.SemesterService;
import org.openurp.code.edu.model.CourseModule;
import org.openurp.code.edu.model.CourseNature;
import org.openurp.code.edu.model.CourseRank;
import org.openurp.code.edu.model.ExamMode;
import org.openurp.code.service.CodeService;
import org.openurp.edu.course.model.ClazzPlan;
import org.openurp.edu.course.model.Syllabus;
import org.openurp.edu.course.web.helper.ClazzPlanHelper;
import org.openurp.edu.course.web.helper.EmsUrl$;
import org.openurp.edu.course.web.helper.StatHelper;
import org.openurp.edu.course.web.helper.SyllabusHelper;
import org.openurp.starter.web.support.ProjectSupport;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

public class SyllabusAction
extends ActionSupport
implements EntityAction<Syllabus>,
ProjectSupport {
    private Class entityClass;
    private CodeService codeService;
    private ProjectConfigService configService;
    private SemesterService semesterService;
    private EntityDao entityDao;

    public SyllabusAction() {
        EntitySupport.$init$((EntitySupport)this);
        ProjectSupport.$init$((ProjectSupport)this);
        Statics.releaseFence();
    }

    public Class entityClass() {
        return this.entityClass;
    }

    public void org$beangle$web$action$support$EntitySupport$_setter_$entityClass_$eq(Class x$0) {
        this.entityClass = x$0;
    }

    public CodeService codeService() {
        return this.codeService;
    }

    public ProjectConfigService configService() {
        return this.configService;
    }

    public SemesterService semesterService() {
        return this.semesterService;
    }

    public void codeService_$eq(CodeService x$1) {
        this.codeService = x$1;
    }

    public void configService_$eq(ProjectConfigService x$1) {
        this.configService = x$1;
    }

    public void semesterService_$eq(SemesterService x$1) {
        this.semesterService = x$1;
    }

    public EntityDao entityDao() {
        return this.entityDao;
    }

    public void entityDao_$eq(EntityDao x$1) {
        this.entityDao = x$1;
    }

    public View index() {
        LazyRef lazyRef = new LazyRef();
        Semester semester = this.getSemester(this.project$1(lazyRef));
        this.put("project", this.project$1(lazyRef));
        this.put("semester", semester);
        OqlBuilder q = OqlBuilder$.MODULE$.from(Semester.class, "s");
        q.where("s.calendar=:calendar", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.project$1(lazyRef).calendar()}));
        q.where("s.archived=false", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
        q.orderBy("s.endOn desc");
        this.put("semesters", this.entityDao().search((QueryBuilder)q));
        OqlBuilder dQuery = OqlBuilder$.MODULE$.from(Syllabus.class.getName(), "c");
        dQuery.where("c.course.project=:project", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.project$1(lazyRef)}));
        dQuery.where(":day between c.beginOn and c.endOn", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{semester.beginOn().plusDays(30L)}));
        dQuery.select("c.department.id,c.department.name,count(*)");
        dQuery.groupBy("c.department.id,c.department.code,c.department.name");
        dQuery.orderBy("c.department.code,c.department.name");
        dQuery.where("c.status in(:statuses)", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.statuses()}));
        this.put("departStat", this.entityDao().search((QueryBuilder)dQuery));
        return this.forward(this.forward$default$1());
    }

    public View search() {
        LazyRef lazyRef = new LazyRef();
        Semester semester = (Semester)this.entityDao().get(Semester.class, (Object)BoxesRunTime.boxToInteger((int)this.getIntId("semester")));
        OqlBuilder query = this.getQueryBuilder();
        this.get("q").foreach((Function1 & Serializable)q -> (OqlBuilder)query.where("syllabus.course.code like :q or syllabus.course.name like :q", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"%" + q.trim() + "%"})));
        query.where(":day between syllabus.beginOn and syllabus.endOn", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{semester.beginOn().plusDays(30L)}));
        query.where("syllabus.course.project=:project", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.project$2(lazyRef)}));
        query.orderBy("syllabus.course.code");
        query.where("syllabus.status in(:statuses)", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.statuses()}));
        this.put("syllabuses", this.entityDao().search((QueryBuilder)query));
        this.getInt("syllabus.department.id").foreach((Function1)(JFunction1.mcVI.sp & Serializable)departId -> this.put("department", this.entityDao().get(Department.class, (Object)BoxesRunTime.boxToInteger((int)departId))));
        this.put("examModes", this.getCodes(ExamMode.class, this.project$2(lazyRef)));
        this.put("natures", this.getCodes(CourseNature.class, this.project$2(lazyRef)));
        this.put("modules", this.getCodes(CourseModule.class, this.project$2(lazyRef)));
        this.put("ranks", this.getCodes(CourseRank.class, this.project$2(lazyRef)));
        this.put("semester", semester);
        return this.forward(this.forward$default$1());
    }

    private Seq<AuditStatus> statuses() {
        return (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AuditStatus[]{AuditStatus$.PassedByDirector, AuditStatus$.PassedByDepart, AuditStatus$.Passed, AuditStatus$.Published}));
    }

    public View info() {
        Syllabus syllabus = (Syllabus)this.entityDao().get(Syllabus.class, (Object)BoxesRunTime.boxToLong((long)this.getLongId("syllabus")));
        this.put("course", syllabus.course());
        this.put("syllabus", syllabus);
        ObjectRef semester = ObjectRef.create((Object)syllabus.semester());
        this.getInt("semester.id").foreach((Function1)(JFunction1.mcVI.sp & Serializable)semesterId -> {
            Semester semester = (Semester)this.entityDao().get(Semester.class, (Object)BoxesRunTime.boxToInteger((int)semesterId));
            semester$1.elem = semester;
            semester = null;
        });
        this.put("semester", (Semester)semester.elem);
        StatHelper statHelper = new StatHelper(this.entityDao());
        OqlBuilder p = OqlBuilder$.MODULE$.from(ClazzPlan.class, "p");
        p.where("p.semester=:semester", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{(Semester)semester.elem}));
        p.where("p.clazz.course=:course", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{syllabus.course()}));
        p.where("p.status in(:statuses)", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.statuses()}));
        this.put("plans", this.entityDao().search((QueryBuilder)p));
        return this.forward(this.forward$default$1());
    }

    public View syllabus() {
        Semester semester;
        Syllabus syllabus = (Syllabus)this.entityDao().get(Syllabus.class, (Object)BoxesRunTime.boxToLong((long)this.getLongId("syllabus")));
        new SyllabusHelper(this.entityDao()).collectDatas(syllabus).foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                Object v = tuple2._2();
                this.put(k, v);
                return;
            }
            throw new MatchError((Object)tuple2);
        });
        Project project = syllabus.course().project();
        ProfileTemplateLoader$.MODULE$.setProfile((Object)(project.school().id() + "/" + project.id()));
        Option option = this.getInt("semester.id");
        if (option instanceof Some) {
            int sid = BoxesRunTime.unboxToInt((Object)((Some)option).value());
            semester = (Semester)this.entityDao().get(Semester.class, (Object)BoxesRunTime.boxToInteger((int)sid));
        } else if (None$.MODULE$.equals(option)) {
            semester = syllabus.semester();
        } else {
            throw new MatchError((Object)option);
        }
        Semester semester2 = semester;
        this.put("semester", semester2);
        return this.forward("/org/openurp/edu/course/web/components/syllabus/report_" + syllabus.docLocale());
    }

    public View plan() {
        ClazzPlan plan = (ClazzPlan)this.entityDao().get(ClazzPlan.class, (Object)BoxesRunTime.boxToLong((long)this.getLongId("plan")));
        new ClazzPlanHelper(this.entityDao()).collectDatas(plan).foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                Object v = tuple2._2();
                this.put(k, v);
                return;
            }
            throw new MatchError((Object)tuple2);
        });
        Project project = plan.clazz().course().project();
        ProfileTemplateLoader$.MODULE$.setProfile((Object)(project.school().id() + "/" + project.id()));
        return this.forward("/org/openurp/edu/course/web/components/plan/report_zh_CN");
    }

    public View syllabusPdf() {
        long id = this.getLongId("syllabus");
        Syllabus syllabus = (Syllabus)this.entityDao().get(Syllabus.class, (Object)BoxesRunTime.boxToLong((long)id));
        String semesterId = (String)this.get("semester.id", "");
        Object semesterParam = StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(semesterId)) ? "&semester.id=" + semesterId : "";
        String url = EmsUrl$.MODULE$.url("/info/syllabus/syllabus?syllabus.id=" + id + (String)semesterParam);
        File pdf = File.createTempFile("doc", ".pdf");
        PrintOptions options = new PrintOptions();
        options.scale_$eq(0.66);
        SPDConverter$.MODULE$.getInstance().convert(URI.create(url), pdf, options);
        return Stream$.MODULE$.apply(pdf, syllabus.course().code() + "_" + syllabus.course().name() + " \u6559\u5b66\u5927\u7eb2.pdf").cleanup((Function0)(JFunction0.mcV.sp & Serializable)() -> pdf.delete());
    }

    public View planPdf() {
        long id = this.getLongId("plan");
        ClazzPlan plan = (ClazzPlan)this.entityDao().get(ClazzPlan.class, (Object)BoxesRunTime.boxToLong((long)id));
        String url = EmsUrl$.MODULE$.url("/info/syllabus/plan?plan.id=" + plan.id());
        File pdf = File.createTempFile("doc", ".pdf");
        PrintOptions options = new PrintOptions();
        SPDConverter$.MODULE$.getInstance().convert(URI.create(url), pdf, options);
        return Stream$.MODULE$.apply(pdf, plan.clazz().crn() + "_" + plan.clazz().course().name() + " \u6388\u8bfe\u8ba1\u5212.pdf").cleanup((Function0)(JFunction0.mcV.sp & Serializable)() -> pdf.delete());
    }

    private final Project project$lzyINIT1$1(LazyRef project$lzy1$1) {
        Project project;
        LazyRef lazyRef = project$lzy1$1;
        synchronized (lazyRef) {
            project = (Project)(project$lzy1$1.initialized() ? project$lzy1$1.value() : project$lzy1$1.initialize((Object)this.getProject()));
        }
        return project;
    }

    private final Project project$1(LazyRef project$lzy1$2) {
        return (Project)(project$lzy1$2.initialized() ? project$lzy1$2.value() : this.project$lzyINIT1$1(project$lzy1$2));
    }

    private final Project project$lzyINIT2$1(LazyRef project$lzy2$1) {
        Project project;
        LazyRef lazyRef = project$lzy2$1;
        synchronized (lazyRef) {
            project = (Project)(project$lzy2$1.initialized() ? project$lzy2$1.value() : project$lzy2$1.initialize((Object)this.getProject()));
        }
        return project;
    }

    private final Project project$2(LazyRef project$lzy2$2) {
        return (Project)(project$lzy2$2.initialized() ? project$lzy2$2.value() : this.project$lzyINIT2$1(project$lzy2$2));
    }
}

