/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.course.web.action.plan;

import java.io.Serializable;
import java.util.Locale;
import org.beangle.data.dao.OqlBuilder;
import org.beangle.data.dao.OqlBuilder$;
import org.beangle.data.dao.QueryBuilder;
import org.beangle.data.model.NumId;
import org.beangle.security.Securities$;
import org.beangle.template.freemarker.ProfileTemplateLoader$;
import org.beangle.web.action.annotation.mapping;
import org.beangle.web.action.annotation.param;
import org.beangle.web.action.view.View;
import org.beangle.webmvc.support.action.EntityAction;
import org.beangle.webmvc.support.action.RestfulAction;
import org.openurp.base.edu.model.TeachingOffice;
import org.openurp.base.model.AuditStatus;
import org.openurp.base.model.AuditStatus$;
import org.openurp.base.model.Project;
import org.openurp.base.service.ProjectConfigService;
import org.openurp.base.service.SemesterService;
import org.openurp.code.service.CodeService;
import org.openurp.edu.course.model.ClazzPlan;
import org.openurp.edu.course.web.helper.ClazzPlanHelper;
import org.openurp.starter.web.support.ProjectSupport;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public class OfficeAction
extends RestfulAction<ClazzPlan>
implements ProjectSupport {
    private CodeService codeService;
    private ProjectConfigService configService;
    private SemesterService semesterService;

    public OfficeAction() {
        ProjectSupport.$init$((ProjectSupport)this);
    }

    public CodeService codeService() {
        return this.codeService;
    }

    public ProjectConfigService configService() {
        return this.configService;
    }

    public SemesterService semesterService() {
        return this.semesterService;
    }

    public void codeService_$eq(CodeService x$1) {
        this.codeService = x$1;
    }

    public void configService_$eq(ProjectConfigService x$1) {
        this.configService = x$1;
    }

    public void semesterService_$eq(SemesterService x$1) {
        this.semesterService = x$1;
    }

    public void indexSetting() {
        LazyRef lazyRef = new LazyRef();
        super.indexSetting();
        this.put("project", this.project$1(lazyRef));
        this.put("semester", this.getSemester(this.project$1(lazyRef)));
        this.put("offices", this.getOffices(this.project$1(lazyRef)));
        this.put("statuses", this.auditStatuses());
        this.forward(this.forward$default$1());
    }

    private Seq<TeachingOffice> getOffices(Project project) {
        OqlBuilder q = OqlBuilder$.MODULE$.from(TeachingOffice.class, "o");
        q.where("o.project = :project", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{project}));
        q.where("o.director.staff.code = :me", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{Securities$.MODULE$.user()}));
        return this.entityDao().search((QueryBuilder)q);
    }

    public OqlBuilder<ClazzPlan> getQueryBuilder() {
        Project project = this.getProject();
        OqlBuilder query = EntityAction.getQueryBuilder$((EntityAction)this);
        query.where("clazzPlan.clazz.course.project=:project", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{project}));
        query.where("clazzPlan.status in(:statuses)", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.auditStatuses()}));
        Seq<TeachingOffice> offices = this.getOffices(project);
        if (offices.nonEmpty()) {
            query.where("clazzPlan.office in(:offices)", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{offices}));
        }
        query.where("clazzPlan.reviewer.code=:reviewerCode", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{Securities$.MODULE$.user()}));
        Object[] objectArray = new Tuple2[2];
        Locale locale = (Locale)Predef$.MODULE$.ArrowAssoc((Object)new Locale("zh", "CN"));
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)locale, (Object)"\u4e2d\u6587");
        Locale locale2 = (Locale)Predef$.MODULE$.ArrowAssoc((Object)new Locale("en", "US"));
        objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)locale2, (Object)"English");
        this.put("locales", Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)));
        return query;
    }

    public View audit() {
        Seq<AuditStatus> statuses = this.auditStatuses();
        Seq plans = (Seq)this.entityDao().find(ClazzPlan.class, (Iterable)this.getLongIds("clazzPlan")).filter((Function1 & Serializable)x -> statuses.contains((Object)x.status()));
        this.getBoolean("passed").foreach((Function1 & Serializable)v1 -> {
            OfficeAction.audit$$anonfun$1(plans, BoxesRunTime.unboxToBoolean((Object)v1));
            return BoxedUnit.UNIT;
        });
        this.entityDao().saveOrUpdate((Iterable)plans);
        boolean toInfo = this.getBoolean("toInfo", false);
        if (toInfo) {
            return this.redirect("info", "id=" + ((NumId)plans.head()).id(), "\u5ba1\u6838\u6210\u529f");
        }
        return this.redirect("search", "\u5ba1\u6838\u6210\u529f");
    }

    @mapping(value="{id}")
    public View info(@param(value="id") String id) {
        ClazzPlan plan = (ClazzPlan)this.entityDao().get(ClazzPlan.class, (Object)BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(id))));
        new ClazzPlanHelper(this.entityDao()).collectDatas(plan).foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                Object v = tuple2._2();
                this.put(k, v);
                return;
            }
            throw new MatchError((Object)tuple2);
        });
        Project project = plan.clazz().course().project();
        ProfileTemplateLoader$.MODULE$.setProfile((Object)(project.school().id() + "/" + project.id()));
        this.put("auditable", BoxesRunTime.boxToBoolean((boolean)this.auditStatuses().contains((Object)plan.status())));
        return this.forward("/org/openurp/edu/course/web/components/plan/report_zh_CN");
    }

    private Seq<AuditStatus> auditStatuses() {
        return (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AuditStatus[]{AuditStatus$.Submited, AuditStatus$.PassedByDirector, AuditStatus$.RejectedByDirector, AuditStatus$.RejectedByDepart}));
    }

    private final Project project$lzyINIT1$1(LazyRef project$lzy1$1) {
        Project project;
        LazyRef lazyRef = project$lzy1$1;
        synchronized (lazyRef) {
            project = (Project)(project$lzy1$1.initialized() ? project$lzy1$1.value() : project$lzy1$1.initialize((Object)this.getProject()));
        }
        return project;
    }

    private final Project project$1(LazyRef project$lzy1$2) {
        return (Project)(project$lzy1$2.initialized() ? project$lzy1$2.value() : this.project$lzyINIT1$1(project$lzy1$2));
    }

    private static final /* synthetic */ void audit$$anonfun$1(Seq plans$1, boolean passed) {
        AuditStatus status = passed ? AuditStatus$.PassedByDirector : AuditStatus$.RejectedByDirector;
        plans$1.foreach((Function1)(JProcedure1 & Serializable)s -> s.status_$eq(status));
    }
}

