/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.course.web.action.syllabus;

import java.io.Serializable;
import java.util.Locale;
import org.beangle.data.dao.OqlBuilder;
import org.beangle.data.dao.OqlBuilder$;
import org.beangle.data.dao.QueryBuilder;
import org.beangle.data.model.NumId;
import org.beangle.ems.app.web.WebBusinessLogger;
import org.beangle.security.Securities$;
import org.beangle.template.freemarker.ProfileTemplateLoader$;
import org.beangle.web.action.annotation.mapping;
import org.beangle.web.action.annotation.param;
import org.beangle.web.action.view.View;
import org.beangle.webmvc.support.action.EntityAction;
import org.beangle.webmvc.support.action.RestfulAction;
import org.openurp.base.edu.model.TeachingOffice;
import org.openurp.base.model.AuditStatus;
import org.openurp.base.model.AuditStatus$;
import org.openurp.base.model.Project;
import org.openurp.base.model.Semester;
import org.openurp.base.service.ProjectConfigService;
import org.openurp.base.service.SemesterService;
import org.openurp.code.service.CodeService;
import org.openurp.edu.course.model.Syllabus;
import org.openurp.edu.course.web.helper.SyllabusHelper;
import org.openurp.edu.course.web.helper.SyllabusValidator$;
import org.openurp.starter.web.support.ProjectSupport;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LazyRef;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public class OfficeAction
extends RestfulAction<Syllabus>
implements ProjectSupport {
    private CodeService codeService;
    private ProjectConfigService configService;
    private SemesterService semesterService;
    private WebBusinessLogger businessLogger;

    public OfficeAction() {
        ProjectSupport.$init$((ProjectSupport)this);
    }

    public CodeService codeService() {
        return this.codeService;
    }

    public ProjectConfigService configService() {
        return this.configService;
    }

    public SemesterService semesterService() {
        return this.semesterService;
    }

    public void codeService_$eq(CodeService x$1) {
        this.codeService = x$1;
    }

    public void configService_$eq(ProjectConfigService x$1) {
        this.configService = x$1;
    }

    public void semesterService_$eq(SemesterService x$1) {
        this.semesterService = x$1;
    }

    public WebBusinessLogger businessLogger() {
        return this.businessLogger;
    }

    public void businessLogger_$eq(WebBusinessLogger x$1) {
        this.businessLogger = x$1;
    }

    public void indexSetting() {
        LazyRef lazyRef = new LazyRef();
        super.indexSetting();
        this.put("project", this.project$1(lazyRef));
        this.put("semester", this.getSemester(this.project$1(lazyRef)));
        this.put("offices", this.getOffices(this.project$1(lazyRef)));
        this.forward(this.forward$default$1());
    }

    private Seq<TeachingOffice> getOffices(Project project) {
        OqlBuilder q = OqlBuilder$.MODULE$.from(TeachingOffice.class, "o");
        q.where("o.project = :project", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{project}));
        q.where("o.director.staff.code = :me", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{Securities$.MODULE$.user()}));
        return this.entityDao().search((QueryBuilder)q);
    }

    public OqlBuilder<Syllabus> getQueryBuilder() {
        Project project = this.getProject();
        Seq<TeachingOffice> offices = this.getOffices(project);
        Semester semester = (Semester)this.entityDao().get(Semester.class, (Object)BoxesRunTime.boxToInteger((int)this.getInt("semester.id", 0)));
        this.put("semester", semester);
        OqlBuilder query = EntityAction.getQueryBuilder$((EntityAction)this);
        query.where(":date between syllabus.beginOn and syllabus.endOn", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{semester.beginOn().plusDays(30L)}));
        query.where("syllabus.course.project=:project", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{project}));
        if (offices.nonEmpty()) {
            query.where("syllabus.office in(:offices)", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{offices}));
        }
        Object[] objectArray = new Tuple2[2];
        Locale locale = (Locale)Predef$.MODULE$.ArrowAssoc((Object)new Locale("zh", "CN"));
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)locale, (Object)"\u4e2d\u6587");
        Locale locale2 = (Locale)Predef$.MODULE$.ArrowAssoc((Object)new Locale("en", "US"));
        objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)locale2, (Object)"English");
        this.put("locales", Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)));
        return query;
    }

    public View audit() {
        Seq<AuditStatus> statuses = this.auditStatuses();
        Seq syllabuses = (Seq)this.entityDao().find(Syllabus.class, (Iterable)this.getLongIds("syllabus")).filter((Function1 & Serializable)x -> statuses.contains((Object)x.status()));
        IntRef hasErrors = IntRef.create((int)0);
        ObjectRef processed = ObjectRef.create(null);
        Set toPassedStatuses = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AuditStatus[]{AuditStatus$.Submited, AuditStatus$.RejectedByDirector}));
        Set toFailedStatuses = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AuditStatus[]{AuditStatus$.Submited, AuditStatus$.PassedByDirector}));
        this.getBoolean("passed").foreach((Function1 & Serializable)v1 -> {
            OfficeAction.audit$$anonfun$1(syllabuses, toPassedStatuses, hasErrors, processed, toFailedStatuses, BoxesRunTime.unboxToBoolean((Object)v1));
            return BoxedUnit.UNIT;
        });
        this.entityDao().saveOrUpdate((Iterable)((Seq)processed.elem));
        Map list = ((Seq)processed.elem).groupBy((Function1 & Serializable)_$2 -> _$2.status());
        list.foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                AuditStatus status = (AuditStatus)tuple2._1();
                Seq s = (Seq)tuple2._2();
                AuditStatus auditStatus = status;
                AuditStatus auditStatus2 = AuditStatus$.PassedByDirector;
                if (!(auditStatus != null ? !auditStatus.equals(auditStatus2) : auditStatus2 != null)) {
                    if (s.size() == 1) {
                        Syllabus h = (Syllabus)s.head();
                        Object[] objectArray = new Tuple2[1];
                        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"syllabus");
                        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)h.id().toString());
                        this.businessLogger().info("\u6559\u7814\u5ba4\u5ba1\u6838\u901a\u8fc7\u8bfe\u7a0b\u6559\u5b66\u5927\u7eb2:" + h.course().code() + " " + h.course().name(), h.id(), Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)));
                        return;
                    }
                    Object[] objectArray = new Tuple2[1];
                    String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"ids");
                    objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)((IterableOnceOps)s.map((Function1 & Serializable)_$3 -> _$3.id().toString())).mkString(","));
                    this.businessLogger().info("\u6559\u7814\u5ba4\u5ba1\u6838\u901a\u8fc7" + s.size() + "\u4e2a\u8bfe\u7a0b\u6559\u5b66\u5927\u7eb2", ((NumId)s.head()).id(), Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)));
                    return;
                }
                if (s.size() == 1) {
                    Syllabus h = (Syllabus)s.head();
                    Object[] objectArray = new Tuple2[1];
                    String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"syllabus");
                    objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)h.id().toString());
                    this.businessLogger().info("\u6559\u7814\u5ba4\u9a73\u56de\u4e86\u8bfe\u7a0b\u6559\u5b66\u5927\u7eb2:" + h.course().code() + " " + h.course().name(), h.id(), Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)));
                    return;
                }
                Object[] objectArray = new Tuple2[1];
                String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"ids");
                objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)((IterableOnceOps)s.map((Function1 & Serializable)_$4 -> _$4.id().toString())).mkString(","));
                this.businessLogger().info("\u6559\u7814\u5ba4\u9a73\u56de\u4e86" + s.size() + "\u4e2a\u8bfe\u7a0b\u6559\u5b66\u5927\u7eb2", ((NumId)s.head()).id(), Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)));
                return;
            }
            throw new MatchError((Object)tuple2);
        });
        String message = hasErrors.elem > 0 ? "\u5ba1\u6838\u6210\u529f" + (syllabuses.size() - hasErrors.elem) + "\u4e2a \u5931\u8d25" + hasErrors.elem + "\u4e2a" : "\u5ba1\u6838\u6210\u529f";
        boolean toInfo = this.getBoolean("toInfo", false);
        if (toInfo) {
            return this.redirect("info", "id=" + ((NumId)syllabuses.head()).id(), message);
        }
        return this.redirect("search", message);
    }

    @mapping(value="{id}")
    public View info(@param(value="id") String id) {
        Semester semester;
        Syllabus syllabus = (Syllabus)this.entityDao().get(Syllabus.class, (Object)BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(id))));
        new SyllabusHelper(this.entityDao()).collectDatas(syllabus).foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                Object v = tuple2._2();
                this.put(k, v);
                return;
            }
            throw new MatchError((Object)tuple2);
        });
        Project project = syllabus.course().project();
        ProfileTemplateLoader$.MODULE$.setProfile((Object)(project.school().id() + "/" + project.id()));
        this.put("auditable", BoxesRunTime.boxToBoolean((boolean)this.auditStatuses().contains((Object)syllabus.status())));
        Option option = this.getInt("semester.id");
        if (option instanceof Some) {
            int sid = BoxesRunTime.unboxToInt((Object)((Some)option).value());
            semester = (Semester)this.entityDao().get(Semester.class, (Object)BoxesRunTime.boxToInteger((int)sid));
        } else if (None$.MODULE$.equals(option)) {
            semester = syllabus.semester();
        } else {
            throw new MatchError((Object)option);
        }
        Semester semester2 = semester;
        this.put("semester", semester2);
        return this.forward("/org/openurp/edu/course/web/components/syllabus/report_" + syllabus.docLocale());
    }

    private Seq<AuditStatus> auditStatuses() {
        return (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AuditStatus[]{AuditStatus$.Submited, AuditStatus$.PassedByDirector, AuditStatus$.RejectedByDirector, AuditStatus$.RejectedByDepart, AuditStatus$.Rejected}));
    }

    private final Project project$lzyINIT1$1(LazyRef project$lzy1$1) {
        Project project;
        LazyRef lazyRef = project$lzy1$1;
        synchronized (lazyRef) {
            project = (Project)(project$lzy1$1.initialized() ? project$lzy1$1.value() : project$lzy1$1.initialize((Object)this.getProject()));
        }
        return project;
    }

    private final Project project$1(LazyRef project$lzy1$2) {
        return (Project)(project$lzy1$2.initialized() ? project$lzy1$2.value() : this.project$lzyINIT1$1(project$lzy1$2));
    }

    private static final /* synthetic */ void audit$$anonfun$1(Seq syllabuses$1, Set toPassedStatuses$1, IntRef hasErrors$1, ObjectRef processed$1, Set toFailedStatuses$1, boolean passed) {
        int n;
        AuditStatus status;
        AuditStatus auditStatus = status = passed ? AuditStatus$.PassedByDirector : AuditStatus$.RejectedByDirector;
        AuditStatus auditStatus2 = AuditStatus$.PassedByDirector;
        if (!(auditStatus != null ? !auditStatus.equals(auditStatus2) : auditStatus2 != null)) {
            int n2;
            Seq oks = (Seq)syllabuses$1.filter((Function1 & Serializable)s -> SyllabusValidator$.MODULE$.validate((Syllabus)s).isEmpty() && toPassedStatuses$1.contains((Object)s.status()));
            oks.foreach((Function1)(JProcedure1 & Serializable)s -> s.status_$eq(status));
            hasErrors$1.elem = n2 = syllabuses$1.size() - oks.size();
            Seq seq = oks;
            processed$1.elem = seq;
            seq = null;
            return;
        }
        Seq oks = (Seq)syllabuses$1.filter((Function1 & Serializable)s -> toFailedStatuses$1.contains((Object)s.status()));
        oks.foreach((Function1)(JProcedure1 & Serializable)s -> s.status_$eq(status));
        hasErrors$1.elem = n = syllabuses$1.size() - oks.size();
        Seq seq = oks;
        processed$1.elem = seq;
        seq = null;
    }
}

