/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.course.web.helper;

import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Iterator;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.apache.poi.xwpf.usermodel.XWPFTableRow;
import org.beangle.commons.collection.Collections$;
import org.beangle.commons.lang.Numbers$;
import org.beangle.commons.lang.Strings$;
import org.openurp.edu.course.model.LessonDesign;
import org.openurp.edu.course.model.LessonDesignSection;
import org.openurp.edu.course.model.LessonDesignText;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.StringBuilder;
import scala.jdk.javaapi.CollectionConverters$;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public final class LessonDesignDocParser$
implements Serializable {
    private static final Seq<String[]> seqIndices;
    public static final LessonDesignDocParser$ MODULE$;

    private LessonDesignDocParser$() {
    }

    static {
        MODULE$ = new LessonDesignDocParser$();
        seqIndices = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[][]{{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15"}, {"\u4e00", "\u4e8c", "\u4e09", "\u56db", "\u4e94", "\u516d", "\u4e03", "\u516b", "\u4e5d", "\u5341", "\u5341\u4e00", "\u5341\u4e8c", "\u5341\u4e09", "\u5341\u56db", "\u5341\u4e94"}, {"I", "II", "III", "IV", "V", "VI", "VII", "VIII", "IX", "X", "XI", "XII", "XIII", "XIV", "XV"}}));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(LessonDesignDocParser$.class);
    }

    public void main(String[] args) {
        Tuple2<Option<LessonDesign>, String> rs = this.parse(new FileInputStream("C:\\Users\\duantihua\\Desktop\\\u6559\u6848.docx"));
        Predef$.MODULE$.println(rs._1());
        ((Option)rs._1()).foreach((Function1)(JProcedure1 & Serializable)d -> Predef$.MODULE$.println((Object)d.homework()));
    }

    public Tuple2<Option<LessonDesign>, String> parse(InputStream is) {
        XWPFDocument doc = new XWPFDocument(is);
        Option<XWPFTable> option = this.findProgramTable(doc);
        if (None$.MODULE$.equals(option)) {
            return Tuple2$.MODULE$.apply((Object)None$.MODULE$, (Object)"\u627e\u4e0d\u5230\u6559\u6848\u6240\u5728\u7684\u8868\u683c");
        }
        if (option instanceof Some) {
            XWPFTable table = (XWPFTable)((Some)option).value();
            Option<Object> option2 = this.findSectionTitleRowIndex(table);
            if (None$.MODULE$.equals(option2)) {
                return Tuple2$.MODULE$.apply((Object)None$.MODULE$, (Object)"\u627e\u4e0d\u5230\u6559\u5b66\u5185\u5bb9\u4e0e\u8fc7\u7a0b\u8bbe\u8ba1");
            }
            if (option2 instanceof Some) {
                int row = BoxesRunTime.unboxToInt((Object)((Some)option2).value());
                return Tuple2$.MODULE$.apply((Object)Some$.MODULE$.apply((Object)this.readProgram(table, row)), (Object)"");
            }
            throw new MatchError(option2);
        }
        throw new MatchError(option);
    }

    private LessonDesign readProgram(XWPFTable table, int separatorIndex) {
        LessonDesign ld = new LessonDesign();
        Iterator rowIter = table.getRows().iterator();
        int i = 0;
        int sectionIdx = 1;
        while (rowIter.hasNext()) {
            XWPFTableRow row = (XWPFTableRow)rowIter.next();
            if (i < separatorIndex) {
                String title = ((XWPFTableCell)row.getTableCells().get(0)).getText();
                if (title.contains("\u6559\u5b66\u4e3b\u9898")) {
                    ld.subject_$eq(this.readCell((XWPFTableCell)row.getTableCells().get(1)));
                } else {
                    this.readText(title, (XWPFTableCell)row.getTableCells().get(1), ld);
                }
            } else if (i > separatorIndex) {
                Buffer sectionRows = Collections$.MODULE$.newBuffer();
                sectionRows.addOne((Object)row);
                for (int fectched = 0; rowIter.hasNext() && fectched < 2; ++fectched) {
                    sectionRows.addOne(rowIter.next());
                }
                if (sectionRows.size() == 3) {
                    this.readSection(ld, sectionIdx, (Buffer<XWPFTableRow>)sectionRows);
                    ++sectionIdx;
                } else {
                    String title = ((XWPFTableCell)row.getTableCells().get(0)).getText();
                    if (title.contains("\u8bfe\u540e\u4f5c\u4e1a")) {
                        ld.homework_$eq((Option)Some$.MODULE$.apply((Object)this.readCell((XWPFTableCell)row.getTableCells().get(1))));
                    }
                }
            }
            ++i;
        }
        return ld;
    }

    private void readSection(LessonDesign design, int index, Buffer<XWPFTableRow> sectionRows) {
        String details;
        String summary;
        XWPFTableRow row1 = (XWPFTableRow)sectionRows.head();
        XWPFTableRow row2 = (XWPFTableRow)sectionRows.apply(1);
        XWPFTableRow row3 = (XWPFTableRow)sectionRows.apply(2);
        ObjectRef title = ObjectRef.create((Object)this.readCell((XWPFTableCell)row1.getTableCells().get(0)));
        seqIndices.find((Function1 & Serializable)x -> index < ((String[])x).length && ((String)title$1.elem).startsWith(x[index - 1])).foreach((Function1)(JProcedure1 & Serializable)seq -> {
            String string = ((String)title$2.elem).substring(seq[index - 1].length() + 1);
            title$2.elem = string;
            string = null;
        });
        String duration = row1.getTableCells().size() > 1 ? this.readCell((XWPFTableCell)row1.getTableCells().get(1)) : "";
        duration = Strings$.MODULE$.replace(duration, "\u5206\u949f", "").trim();
        int minutes = 0;
        if (Numbers$.MODULE$.isDigits(duration)) {
            minutes = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(duration));
        }
        if ((summary = this.readCell((XWPFTableCell)row2.getTableCells().get(0))).startsWith("\u6559\u5b66\u5185\u5bb9\u63d0\u8981")) {
            summary = summary.substring("\u6559\u5b66\u5185\u5bb9\u63d0\u8981\uff1a".length());
        }
        if ((details = this.readCell((XWPFTableCell)row3.getTableCells().get(0))).startsWith("\u6559\u5b66\u8fc7\u7a0b\u8bbe\u8ba1")) {
            details = Strings$.MODULE$.substringAfter(details, "\uff1a");
        }
        LessonDesignSection section = new LessonDesignSection(design, index, (String)title.elem, minutes, summary, details);
        design.sections().addOne((Object)section);
    }

    private void readText(String title, XWPFTableCell cell, LessonDesign design) {
        String contents = this.readCell(cell);
        if (Strings$.MODULE$.isNotBlank((CharSequence)contents)) {
            if (title.contains("\u6559\u5b66\u76ee\u6807")) {
                design.texts().addOne((Object)new LessonDesignText(design, "target", contents));
                return;
            }
            if (title.contains("\u6559\u5b66\u91cd\u70b9")) {
                design.texts().addOne((Object)new LessonDesignText(design, "emphasis", contents));
                return;
            }
            if (title.contains("\u6559\u5b66\u96be\u70b9")) {
                design.texts().addOne((Object)new LessonDesignText(design, "difficulties", contents));
                return;
            }
            if (title.contains("\u6559\u5b66\u8d44\u6e90")) {
                design.texts().addOne((Object)new LessonDesignText(design, "resources", contents));
                return;
            }
            if (title.contains("\u8bfe\u7a0b\u601d\u653f")) {
                design.texts().addOne((Object)new LessonDesignText(design, "values", contents));
                return;
            }
            return;
        }
    }

    private Option<Object> findSectionTitleRowIndex(XWPFTable table) {
        Option rs = CollectionConverters$.MODULE$.asScala(table.getRows()).find((Function1 & Serializable)r -> r.getTableCells().size() == 1 && ((XWPFTableCell)r.getTableCells().get(0)).getText().contains("\u6559\u5b66\u5185\u5bb9\u4e0e\u8fc7\u7a0b\u8bbe\u8ba1"));
        return rs.map((Function1 & Serializable)r -> table.getRows().indexOf(r));
    }

    private Option<XWPFTable> findProgramTable(XWPFDocument document) {
        return CollectionConverters$.MODULE$.asScala(document.getTables()).find((Function1 & Serializable)t -> {
            if (t.getRows().size() > 1 && ((XWPFTableRow)t.getRows().get(0)).getTableCells().size() > 1) {
                return ((XWPFTableCell)((XWPFTableRow)t.getRows().get(0)).getTableCells().get(0)).getText().contains("\u6559\u5b66\u4e3b\u9898");
            }
            return false;
        });
    }

    private String readCell(XWPFTableCell cell) {
        StringBuilder sb = new StringBuilder();
        CollectionConverters$.MODULE$.asScala(cell.getParagraphs()).foreach((Function1 & Serializable)p -> {
            CollectionConverters$.MODULE$.asScala(p.getRuns()).foreach((Function1)(JProcedure1 & Serializable)run -> {
                String runText = run.getText(0);
                if (Strings$.MODULE$.isNotBlank((CharSequence)runText)) {
                    sb.append(runText);
                    return;
                }
            });
            return sb.append("\n");
        });
        return sb.toString().replace("\r", "").trim();
    }
}

