/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.course.web.helper;

import java.io.Serializable;
import java.time.LocalDate;
import org.beangle.data.dao.EntityDao;
import org.beangle.data.dao.OqlBuilder;
import org.beangle.data.dao.OqlBuilder$;
import org.beangle.data.dao.QueryBuilder;
import org.beangle.data.model.pojo.Coded;
import org.openurp.base.edu.model.Course;
import org.openurp.base.edu.model.CourseProfile;
import org.openurp.base.edu.model.Major;
import org.openurp.base.edu.model.Terms;
import org.openurp.base.hr.model.Teacher;
import org.openurp.base.model.Department;
import org.openurp.base.model.Semester;
import org.openurp.code.edu.model.CourseType;
import org.openurp.code.edu.model.EducationLevel;
import org.openurp.edu.clazz.model.Clazz;
import org.openurp.edu.course.model.SyllabusDoc;
import org.openurp.edu.course.web.helper.ClazzInfo;
import org.openurp.edu.course.web.helper.ClazzInfo$;
import org.openurp.edu.course.web.helper.PlanCourseInfo;
import org.openurp.edu.course.web.helper.PlanCourseInfo$;
import org.openurp.edu.program.model.ExecutivePlanCourse;
import org.openurp.edu.program.model.PlanCourse;
import scala.Function1;
import scala.Tuple3;
import scala.Tuple3$;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.SeqOps;
import scala.collection.Set;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.math.Ordering;
import scala.package$;
import scala.runtime.IntRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public class StatHelper {
    private final EntityDao entityDao;

    public StatHelper(EntityDao entityDao) {
        this.entityDao = entityDao;
    }

    public Iterable<ClazzInfo> statClazzInfo(Course course) {
        OqlBuilder clazzQuery = OqlBuilder$.MODULE$.from(Clazz.class, "c");
        clazzQuery.where("c.project=:project", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{course.project()}));
        clazzQuery.where("c.course=:course", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{course}));
        clazzQuery.where("c.semester.beginOn > :yearBefore", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{LocalDate.now().minusYears(10L)}));
        Seq clazzes = this.entityDao.search((QueryBuilder)clazzQuery);
        scala.collection.immutable.Iterable clazzInfos = (scala.collection.immutable.Iterable)clazzes.groupBy((Function1 & Serializable)x -> Tuple3$.MODULE$.apply((Object)x.course(), (Object)x.semester(), (Object)x.teachDepart())).map((Function1 & Serializable)x -> ClazzInfo$.MODULE$.apply((Course)((Tuple3)x._1())._1(), (Semester)((Tuple3)x._1())._2(), (Department)((Tuple3)x._1())._3(), this.collectTeachers((Iterable<Clazz>)((Iterable)x._2())), ((SeqOps)x._2()).size()));
        List list = clazzInfos.toList();
        Function1 & Serializable intersect = (Function1 & Serializable)x -> x.semester().beginOn().toString();
        package$.MODULE$.Ordering();
        return (Iterable)list.sortBy((Function1)intersect, Ordering.String$.MODULE$.reverse());
    }

    public Iterable<PlanCourseInfo> statPlanCourseInfo(Course course) {
        OqlBuilder pQuery = OqlBuilder$.MODULE$.from(ExecutivePlanCourse.class, "pc");
        pQuery.where("pc.course=:course", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{course}));
        LocalDate today = LocalDate.now();
        pQuery.where(":today < pc.group.plan.program.endOn", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{today}));
        Seq pcs = this.entityDao.search((QueryBuilder)pQuery);
        scala.collection.immutable.Iterable pcis = (scala.collection.immutable.Iterable)pcs.groupBy((Function1 & Serializable)x -> Tuple3$.MODULE$.apply((Object)x.course(), (Object)x.group().courseType(), (Object)x.group().plan().program().grade())).map((Function1 & Serializable)x2 -> {
            scala.collection.immutable.Set levels = ((IterableOnceOps)((IterableOps)x2._2()).map((Function1 & Serializable)_$1 -> _$1.group().plan().program().level())).toSet();
            List levelsList = (List)levels.toList().sortBy((Function1 & Serializable)_$2 -> _$2.code(), (Ordering)Ordering.String$.MODULE$);
            scala.collection.immutable.Set majors = ((IterableOnceOps)((IterableOps)x2._2()).map((Function1 & Serializable)_$3 -> _$3.group().plan().program().major())).toSet();
            List majorList = (List)majors.toList().sortBy((Function1 & Serializable)x -> x.code(), (Ordering)Ordering.String$.MODULE$);
            return PlanCourseInfo$.MODULE$.apply((Course)((Tuple3)x2._1())._1(), (CourseType)((Tuple3)x2._1())._2(), ((Coded)((Tuple3)x2._1())._3()).code(), (Iterable<EducationLevel>)levelsList, (Iterable<Major>)majorList, this.collectTerms((Iterable<PlanCourse>)((Iterable)x2._2())), ((SeqOps)x2._2()).size());
        });
        List list = pcis.toList();
        Function1 & Serializable intersect = (Function1 & Serializable)x -> x.grade();
        package$.MODULE$.Ordering();
        return (Iterable)list.sortBy((Function1)intersect, Ordering.String$.MODULE$.reverse());
    }

    public Set<Object> hasSyllabus(Iterable<Course> courses) {
        OqlBuilder pQuery = OqlBuilder$.MODULE$.from(SyllabusDoc.class.getName(), "cp");
        pQuery.where("cp.course in(:course)", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{courses}));
        pQuery.select("cp.course.id");
        return this.entityDao.search((QueryBuilder)pQuery).toSet();
    }

    public Set<Object> hasProfile(Iterable<Course> courses) {
        OqlBuilder sQuery = OqlBuilder$.MODULE$.from(CourseProfile.class.getName(), "s");
        sQuery.where("s.course in(:course)", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{courses}));
        sQuery.select("s.course.id");
        return this.entityDao.search((QueryBuilder)sQuery).toSet();
    }

    private Terms collectTerms(Iterable<PlanCourse> pcs) {
        IntRef t = IntRef.create((int)0);
        pcs.foreach((Function1)(JProcedure1 & Serializable)x -> {
            int n;
            t$1.elem = n = t$1.elem | x.terms().value();
        });
        return new Terms(t.elem);
    }

    private Iterable<Teacher> collectTeachers(Iterable<Clazz> clazzes) {
        scala.collection.immutable.Set teachers = ((IterableOnceOps)clazzes.flatMap((Function1 & Serializable)_$4 -> _$4.teachers())).toSet();
        return (Iterable)teachers.toList().sortBy((Function1 & Serializable)x -> x.staff().name(), (Ordering)Ordering.String$.MODULE$);
    }
}

