/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.course.service.impl;

import java.io.InputStream;
import java.time.Instant;
import java.util.Locale;
import org.beangle.data.dao.EntityDao;
import org.beangle.data.dao.OqlBuilder;
import org.beangle.data.dao.OqlBuilder$;
import org.beangle.data.dao.QueryBuilder;
import org.beangle.data.model.pojo.TemporalOn$;
import org.beangle.ems.app.EmsApp$;
import org.beangle.ems.app.blob.BlobMeta;
import org.beangle.ems.app.blob.Repository;
import org.openurp.base.edu.model.Course;
import org.openurp.base.model.Semester;
import org.openurp.base.model.User;
import org.openurp.base.service.SemesterService;
import org.openurp.edu.course.model.SyllabusDoc;
import org.openurp.edu.course.service.SyllabusService;
import scala.Option;
import scala.collection.Iterable;
import scala.collection.immutable.Seq;
import scala.runtime.ScalaRunTime$;

public class SyllabusServiceImpl
implements SyllabusService {
    private SemesterService semesterService;
    private EntityDao entityDao;
    private int validateYears = 4;

    public SemesterService semesterService() {
        return this.semesterService;
    }

    public void semesterService_$eq(SemesterService x$1) {
        this.semesterService = x$1;
    }

    public EntityDao entityDao() {
        return this.entityDao;
    }

    public void entityDao_$eq(EntityDao x$1) {
        this.entityDao = x$1;
    }

    public int validateYears() {
        return this.validateYears;
    }

    public void validateYears_$eq(int x$1) {
        this.validateYears = x$1;
    }

    @Override
    public SyllabusDoc upload(Course course, User writer, InputStream data, String extension, Locale locale, Semester semester) {
        Repository blob = EmsApp$.MODULE$.getBlobRepository(true);
        Option<SyllabusDoc> existed = this.getLastSyllabusDoc(course, locale, writer);
        SyllabusDoc doc = (SyllabusDoc)existed.getOrElse(SyllabusServiceImpl::$anonfun$1);
        doc.course_$eq(course);
        doc.updatedAt_$eq(Instant.now());
        doc.writer_$eq(writer);
        doc.docLocale_$eq(locale);
        doc.department_$eq(course.department());
        doc.semester_$eq(semester);
        if (doc.beginOn() == null) {
            doc.beginOn_$eq(semester.beginOn());
        }
        if (doc.docPath() != null) {
            blob.remove(doc.docPath());
        }
        String fileName = course.code() + "\u5927\u7eb2." + extension;
        BlobMeta meta = blob.upload("/course/" + course.id() + "/syllabus/" + writer.id() + "_" + doc.beginOn().toString() + "/", data, fileName, writer.code() + " " + writer.name());
        doc.docSize_$eq(meta.fileSize());
        doc.docPath_$eq(meta.filePath());
        this.entityDao().saveOrUpdate((Object)doc, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SyllabusDoc[0]));
        Seq docs = this.entityDao().findBy(SyllabusDoc.class, "course", (Object)course);
        TemporalOn$.MODULE$.calcEndOn((Iterable)docs);
        this.entityDao().saveOrUpdate((Iterable)docs);
        return doc;
    }

    private Option<SyllabusDoc> getLastSyllabusDoc(Course course, Locale locale, User writer) {
        OqlBuilder query = OqlBuilder$.MODULE$.from(SyllabusDoc.class, "s");
        query.where("s.course = :course", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{course}));
        query.where("s.writer=:writer", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{writer}));
        query.where("s.docLocale=:locale", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{locale}));
        query.orderBy("s.semester.beginOn desc");
        query.limit(1, 1);
        return this.entityDao().search((QueryBuilder)query).headOption();
    }

    private static final SyllabusDoc $anonfun$1() {
        return new SyllabusDoc();
    }
}

