/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.course.web.action.admin;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.time.LocalDate;
import org.beangle.commons.activation.MediaTypes$;
import org.beangle.commons.bean.PropertyExtractor;
import org.beangle.commons.collection.Collections$;
import org.beangle.commons.lang.Strings$;
import org.beangle.data.dao.OqlBuilder;
import org.beangle.data.dao.OqlBuilder$;
import org.beangle.data.dao.QueryBuilder;
import org.beangle.data.model.Entity;
import org.beangle.doc.excel.schema.ExcelColumn;
import org.beangle.doc.excel.schema.ExcelScheet;
import org.beangle.doc.excel.schema.ExcelSchema;
import org.beangle.doc.transfer.exporter.ExportContext;
import org.beangle.doc.transfer.importer.ImportSetting;
import org.beangle.doc.transfer.importer.listener.ForeignerListener;
import org.beangle.webmvc.annotation.response;
import org.beangle.webmvc.support.action.EntityAction;
import org.beangle.webmvc.support.action.ExportSupport;
import org.beangle.webmvc.support.action.ImportSupport;
import org.beangle.webmvc.support.action.RestfulAction;
import org.beangle.webmvc.view.Stream$;
import org.beangle.webmvc.view.View;
import org.openurp.base.edu.model.CourseDirector;
import org.openurp.base.edu.model.TeachingOffice;
import org.openurp.base.hr.model.Teacher;
import org.openurp.base.model.AuditStatus$;
import org.openurp.base.model.Department;
import org.openurp.base.model.Project;
import org.openurp.base.model.School;
import org.openurp.base.model.Semester;
import org.openurp.base.service.ProjectConfigService;
import org.openurp.base.service.SemesterService;
import org.openurp.code.edu.model.CourseCategory;
import org.openurp.code.edu.model.CourseNature;
import org.openurp.code.service.CodeService;
import org.openurp.edu.clazz.model.Clazz;
import org.openurp.edu.course.model.ClazzPlan;
import org.openurp.edu.course.model.CourseTask;
import org.openurp.edu.course.model.Syllabus;
import org.openurp.edu.course.service.CourseTaskService;
import org.openurp.edu.course.web.helper.CourseTaskImportListener;
import org.openurp.edu.course.web.helper.CourseTaskPropertyExtractor;
import org.openurp.starter.web.support.ProjectSupport;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction1;

public class TaskAction
extends RestfulAction<CourseTask>
implements ProjectSupport,
ImportSupport<CourseTask>,
ExportSupport<CourseTask> {
    private CodeService codeService;
    private ProjectConfigService configService;
    private SemesterService semesterService;
    private CourseTaskService courseTaskService;

    public TaskAction() {
        ProjectSupport.$init$((ProjectSupport)this);
    }

    public CodeService codeService() {
        return this.codeService;
    }

    public ProjectConfigService configService() {
        return this.configService;
    }

    public SemesterService semesterService() {
        return this.semesterService;
    }

    public void codeService_$eq(CodeService x$1) {
        this.codeService = x$1;
    }

    public void configService_$eq(ProjectConfigService x$1) {
        this.configService = x$1;
    }

    public void semesterService_$eq(SemesterService x$1) {
        this.semesterService = x$1;
    }

    public CourseTaskService courseTaskService() {
        return this.courseTaskService;
    }

    public void courseTaskService_$eq(CourseTaskService x$1) {
        this.courseTaskService = x$1;
    }

    public void indexSetting() {
        LazyRef lazyRef = new LazyRef();
        super.indexSetting();
        scala.collection.immutable.Seq departs = this.getDeparts(this.project$1(lazyRef));
        this.put("departments", departs);
        this.put("project", this.project$1(lazyRef));
        this.put("semester", this.getSemester(this.project$1(lazyRef)));
        this.put("offices", this.getOffices(this.project$1(lazyRef), (scala.collection.immutable.Seq<Department>)departs));
        this.forward(this.forward$default$1());
    }

    public OqlBuilder<CourseTask> getQueryBuilder() {
        OqlBuilder query = EntityAction.getQueryBuilder$((EntityAction)this);
        query.where("courseTask.course.project=:project", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.getProject()}));
        this.queryByDepart(query, "courseTask.department");
        this.get("teachers").foreach((Function1 & Serializable)x$1 -> {
            String string = x$1;
            switch (string == null ? 0 : string.hashCode()) {
                case 48: {
                    if (!"0".equals(string)) break;
                    return query.where("size(courseTask.teachers) = 0", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
                }
                case 49: {
                    if (!"1".equals(string)) break;
                    return query.where("size(courseTask.teachers) = 1", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
                }
                case 50: {
                    if (!"2".equals(string)) break;
                    return query.where("size(courseTask.teachers) > 1", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
                }
            }
            return BoxedUnit.UNIT;
        });
        Semester semester = (Semester)this.entityDao().get(Semester.class, (Object)BoxesRunTime.boxToInteger((int)this.getIntId("courseTask.semester")));
        this.get("syllabus_status").foreach((Function1 & Serializable)x$1 -> {
            String string = x$1;
            if ("1".equals(string)) {
                return query.where("exists(from " + Syllabus.class.getName() + " s where s.course=courseTask.course and :date between s.beginOn and s.endOn and s.status != :draft)", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{semester.beginOn().plusDays(30L), AuditStatus$.Draft}));
            }
            if ("0".equals(string)) {
                query.where("courseTask.syllabusRequired = true", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
                return query.where("not exists(from " + Syllabus.class.getName() + " s where s.course=courseTask.course and :date between s.beginOn and s.endOn and s.status != :draft)", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{semester.beginOn().plusDays(30L), AuditStatus$.Draft}));
            }
            return BoxedUnit.UNIT;
        });
        this.get("plan_status").foreach((Function1 & Serializable)x$1 -> {
            String string = x$1;
            if ("1".equals(string)) {
                return query.where("exists(from " + ClazzPlan.class.getName() + " s where s.clazz.course=courseTask.course and s.semester=courseTask.semester and s.status in (:statuses))", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{new .colon.colon((Object)AuditStatus$.Submited, (List)new .colon.colon((Object)AuditStatus$.PassedByDirector, (List)new .colon.colon((Object)AuditStatus$.PassedByDepart, (List)new .colon.colon((Object)AuditStatus$.Passed, (List)Nil$.MODULE$))))}));
            }
            if ("0".equals(string)) {
                query.where("courseTask.syllabusRequired=true", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
                return query.where("not exists(from " + ClazzPlan.class.getName() + " s where s.clazz.course=courseTask.course and s.semester=courseTask.semester and s.status in (:statuses))", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{new .colon.colon((Object)AuditStatus$.Submited, (List)new .colon.colon((Object)AuditStatus$.PassedByDirector, (List)new .colon.colon((Object)AuditStatus$.PassedByDepart, (List)new .colon.colon((Object)AuditStatus$.Passed, (List)Nil$.MODULE$))))}));
            }
            return BoxedUnit.UNIT;
        });
        this.get("schedule_status").foreach((Function1 & Serializable)x$1 -> {
            String string = x$1;
            switch (string == null ? 0 : string.hashCode()) {
                case 48: {
                    if (!"0".equals(string)) break;
                    return query.where("not exists(from " + Clazz.class.getName() + " s where s.course=courseTask.course and s.semester=courseTask.semester and size(s.schedule.activities)>0)", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
                }
                case 49: {
                    if (!"1".equals(string)) break;
                    return query.where("exists(from " + Clazz.class.getName() + " s where s.course=courseTask.course and s.semester=courseTask.semester and size(s.schedule.activities)>0)", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
                }
                case 51: {
                    if (!"3".equals(string)) break;
                    return query.where("not exists(from " + Clazz.class.getName() + " s where s.course=courseTask.course and s.semester=courseTask.semester)", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
                }
            }
            return BoxedUnit.UNIT;
        });
        this.getBoolean("assigned").foreach((Function1 & Serializable)x$1 -> TaskAction.getQueryBuilder$$anonfun$5(query, BoxesRunTime.unboxToBoolean((Object)x$1)));
        String teacherName = (String)this.get("teacherName").orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
        if (Strings$.MODULE$.isNotBlank((CharSequence)teacherName)) {
            query.where("exists(from courseTask.teachers t where t.name like :name)", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"%" + teacherName + "%"}));
        }
        return query;
    }

    public void editSetting(CourseTask task) {
        LazyRef lazyRef = new LazyRef();
        this.put("project", this.project$2(lazyRef));
        scala.collection.immutable.Seq departs = this.getDeparts(this.project$2(lazyRef));
        this.put("departments", departs);
        Object[] objectArray = new Tuple2[2];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"project");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)this.project$2(lazyRef));
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"department");
        objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)task.department());
        this.put("offices", this.entityDao().findBy(TeachingOffice.class, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)));
        Option director = this.entityDao().findBy(CourseDirector.class, "course", (Object)task.course()).find((Function1 & Serializable)_$2 -> _$2.endOn().isEmpty());
        this.put("director", director);
        Buffer directors = Collections$.MODULE$.newBuffer();
        directors.$plus$plus$eq((IterableOnce)task.teachers());
        director.foreach((Function1)(JProcedure1 & Serializable)d -> {
            if (!directors.contains((Object)d.director())) {
                directors.$plus$eq((Object)d.director());
                return;
            }
        });
        this.put("directors", directors);
        super.editSetting((Entity)task);
    }

    public View autoCreate() {
        LazyRef lazyRef = new LazyRef();
        Semester semester = (Semester)this.entityDao().get(Semester.class, (Object)BoxesRunTime.boxToInteger((int)this.getIntId("courseTask.semester")));
        this.courseTaskService().initTask(this.project$3(lazyRef), semester);
        return this.redirect("search", "\u521d\u59cb\u5316\u6210\u529f");
    }

    public View autoAssign() {
        scala.collection.immutable.Seq tasks = this.entityDao().find(CourseTask.class, (Iterable)this.getLongIds("courseTask"));
        tasks.foreach((Function1)(JProcedure1 & Serializable)t -> {
            if (t.director().isEmpty()) {
                if (t.teachers().size() == 1) {
                    t.director_$eq(t.teachers().headOption());
                } else {
                    this.entityDao().findBy(CourseDirector.class, "course", (Object)t.course()).foreach((Function1)(JProcedure1 & Serializable)d -> {
                        if (t.teachers().contains((Object)d.director()) && d.within(t.semester().beginOn())) {
                            t.director_$eq((Option)Some$.MODULE$.apply((Object)d.director()));
                        }
                        d.office().foreach((Function1)(JProcedure1 & Serializable)o -> t.office_$eq((Option)Some$.MODULE$.apply(o)));
                    });
                }
            }
            if (t.office().isEmpty()) {
                this.entityDao().findBy(CourseDirector.class, "course", (Object)t.course()).foreach((Function1)(JProcedure1 & Serializable)d -> d.office().foreach((Function1)(JProcedure1 & Serializable)o -> t.office_$eq((Option)Some$.MODULE$.apply(o))));
                return;
            }
        });
        this.entityDao().saveOrUpdate((Iterable)tasks);
        return this.redirect("search", "\u81ea\u52a8\u6307\u6d3e\u6210\u529f");
    }

    public View batchEdit() {
        scala.collection.immutable.Seq tasks = this.entityDao().find(CourseTask.class, (Iterable)this.getLongIds("courseTask"));
        CourseTask task = (CourseTask)tasks.head();
        Object[] objectArray = new Tuple2[2];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"project");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)task.course().project());
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"department");
        objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)task.department());
        this.put("offices", this.entityDao().findBy(TeachingOffice.class, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)));
        this.put("courseTasks", tasks);
        this.put("project", this.getProject());
        return this.forward(this.forward$default$1());
    }

    public View batchSave() {
        scala.collection.immutable.Seq tasks = this.entityDao().find(CourseTask.class, (Iterable)this.getLongIds("courseTask"));
        this.getLong("teacher.id").foreach((Function1)(JFunction1.mcVJ.sp & Serializable)id -> {
            Teacher t = (Teacher)this.entityDao().get(Teacher.class, (Object)BoxesRunTime.boxToLong((long)id));
            tasks.foreach((Function1)(JProcedure1 & Serializable)_$3 -> _$3.director_$eq((Option)Some$.MODULE$.apply((Object)t)));
        });
        this.getLong("office.id").foreach((Function1)(JFunction1.mcVJ.sp & Serializable)officeId -> {
            TeachingOffice office = (TeachingOffice)this.entityDao().get(TeachingOffice.class, (Object)BoxesRunTime.boxToLong((long)officeId));
            tasks.foreach((Function1)(JProcedure1 & Serializable)_$4 -> _$4.office_$eq((Option)Some$.MODULE$.apply((Object)office)));
        });
        this.getBoolean("syllabusRequired").foreach((Function1 & Serializable)v1 -> {
            tasks.foreach((Function1)(JProcedure1 & Serializable)_$5 -> _$5.syllabusRequired_$eq(BoxesRunTime.unboxToBoolean((Object)v1)));
            return BoxedUnit.UNIT;
        });
        this.entityDao().saveOrUpdate((Iterable)tasks);
        return this.redirect("search", "\u6279\u91cf\u6210\u529f");
    }

    private scala.collection.immutable.Seq<TeachingOffice> getOffices(Project project, scala.collection.immutable.Seq<Department> departs) {
        OqlBuilder query = OqlBuilder$.MODULE$.from(TeachingOffice.class, "o");
        query.where("o.project=:project", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{project}));
        query.where("o.department in(:departs)", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{departs}));
        query.orderBy("o.name");
        return this.entityDao().search((QueryBuilder)query);
    }

    @response
    public Object downloadTemplate() {
        LazyRef lazyRef = new LazyRef();
        School school = this.project$4(lazyRef).school();
        scala.collection.immutable.Seq departs = this.getDeparts(this.project$4(lazyRef));
        scala.collection.immutable.Seq departNames = (scala.collection.immutable.Seq)this.entityDao().search((QueryBuilder)OqlBuilder$.MODULE$.from(Department.class, "bt").where("bt.school=:school", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{school})).orderBy("bt.name")).map((Function1 & Serializable)x -> x.code() + " " + x.name());
        scala.collection.immutable.Seq offices = (scala.collection.immutable.Seq)this.entityDao().search((QueryBuilder)OqlBuilder$.MODULE$.from(TeachingOffice.class, "t").where("t.project=:project", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.project$4(lazyRef)})).where("t.endOn is null or t.endOn > :today", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{LocalDate.now()})).where("t.department in(:departs)", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{departs})).orderBy("t.code")).map((Function1 & Serializable)x -> x.code() + " " + x.name());
        Seq natures = (Seq)this.codeService().get(CourseNature.class).map((Function1 & Serializable)x -> x.code() + " " + x.name());
        Seq categories = (Seq)this.codeService().get(CourseCategory.class).map((Function1 & Serializable)x -> x.code() + " " + x.name());
        ExcelSchema schema = new ExcelSchema();
        ExcelScheet sheet = schema.createScheet("\u6570\u636e\u6a21\u677f");
        sheet.title("\u8bfe\u7a0b\u8d1f\u8d23\u4eba\u4fe1\u606f\u6a21\u677f");
        sheet.remark("\u7279\u522b\u8bf4\u660e\uff1a\n1\u3001\u4e0d\u53ef\u6539\u53d8\u672c\u8868\u683c\u7684\u884c\u5217\u7ed3\u6784\u4ee5\u53ca\u6279\u6ce8\uff0c\u5426\u5219\u5c06\u4f1a\u5bfc\u5165\u5931\u8d25\uff01\n2\u3001\u5fc5\u987b\u6309\u7167\u89c4\u683c\u8bf4\u660e\u7684\u683c\u5f0f\u586b\u5199\u3002\n3\u3001\u53ef\u4ee5\u591a\u6b21\u5bfc\u5165\uff0c\u91cd\u590d\u7684\u4fe1\u606f\u4f1a\u88ab\u65b0\u6570\u636e\u66f4\u65b0\u8986\u76d6\u3002\n4\u3001\u4fdd\u5b58\u7684excel\u6587\u4ef6\u540d\u79f0\u53ef\u4ee5\u81ea\u5b9a\u3002");
        ExcelColumn excelColumn = sheet.add("\u8bfe\u7a0b\u4ee3\u7801", "course.code").length(10);
        excelColumn.required(excelColumn.required$default$1()).remark("\u226410\u4f4d");
        ExcelColumn excelColumn2 = sheet.add("\u5f00\u8bfe\u9662\u7cfb", "department.code").ref((Seq)departNames);
        excelColumn2.required(excelColumn2.required$default$1());
        ExcelColumn excelColumn3 = sheet.add("\u6559\u7814\u5ba4", "courseTask.office.code").ref((Seq)offices);
        excelColumn3.required(excelColumn3.required$default$1());
        ExcelColumn excelColumn4 = sheet.add("\u8bfe\u7a0b\u8d1f\u8d23\u4eba\u5de5\u53f7\u6216\u59d3\u540d", "teacher.code");
        excelColumn4.required(excelColumn4.required$default$1());
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        schema.generate((OutputStream)os);
        return Stream$.MODULE$.apply((InputStream)new ByteArrayInputStream(os.toByteArray()), MediaTypes$.MODULE$.ApplicationXlsx(), "\u8bfe\u7a0b\u8d1f\u8d23\u4eba.xlsx", Stream$.MODULE$.apply$default$4());
    }

    public void configExport(ExportContext context) {
        ExportSupport.configExport$((ExportSupport)this, (ExportContext)context);
        context.extractor_$eq((PropertyExtractor)new CourseTaskPropertyExtractor());
    }

    public void configImport(ImportSetting setting) {
        Semester semester = (Semester)this.entityDao().get(Semester.class, (Object)BoxesRunTime.boxToInteger((int)this.getIntId("courseTask.semester")));
        setting.listeners_$eq((List)new .colon.colon((Object)new ForeignerListener(this.entityDao()), (List)new .colon.colon((Object)new CourseTaskImportListener(this.entityDao(), semester, this.getProject()), (List)Nil$.MODULE$)));
    }

    private final Project project$lzyINIT1$1(LazyRef project$lzy1$1) {
        Project project;
        LazyRef lazyRef = project$lzy1$1;
        synchronized (lazyRef) {
            project = (Project)(project$lzy1$1.initialized() ? project$lzy1$1.value() : project$lzy1$1.initialize((Object)this.getProject()));
        }
        return project;
    }

    private final Project project$1(LazyRef project$lzy1$2) {
        return (Project)(project$lzy1$2.initialized() ? project$lzy1$2.value() : this.project$lzyINIT1$1(project$lzy1$2));
    }

    private static final /* synthetic */ OqlBuilder getQueryBuilder$$anonfun$5(OqlBuilder query$5, boolean x$1) {
        boolean bl = x$1;
        if (bl) {
            return (OqlBuilder)query$5.where("courseTask.director is not null", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
        }
        if (!bl) {
            return (OqlBuilder)query$5.where("courseTask.director is null", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
        }
        throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
    }

    private final Project project$lzyINIT2$1(LazyRef project$lzy2$1) {
        Project project;
        LazyRef lazyRef = project$lzy2$1;
        synchronized (lazyRef) {
            project = (Project)(project$lzy2$1.initialized() ? project$lzy2$1.value() : project$lzy2$1.initialize((Object)this.getProject()));
        }
        return project;
    }

    private final Project project$2(LazyRef project$lzy2$2) {
        return (Project)(project$lzy2$2.initialized() ? project$lzy2$2.value() : this.project$lzyINIT2$1(project$lzy2$2));
    }

    private final Project project$lzyINIT3$1(LazyRef project$lzy3$1) {
        Project project;
        LazyRef lazyRef = project$lzy3$1;
        synchronized (lazyRef) {
            project = (Project)(project$lzy3$1.initialized() ? project$lzy3$1.value() : project$lzy3$1.initialize((Object)this.getProject()));
        }
        return project;
    }

    private final Project project$3(LazyRef project$lzy3$2) {
        return (Project)(project$lzy3$2.initialized() ? project$lzy3$2.value() : this.project$lzyINIT3$1(project$lzy3$2));
    }

    private final Project project$lzyINIT4$1(LazyRef project$lzy4$1) {
        Project project;
        LazyRef lazyRef = project$lzy4$1;
        synchronized (lazyRef) {
            project = (Project)(project$lzy4$1.initialized() ? project$lzy4$1.value() : project$lzy4$1.initialize((Object)this.getProject()));
        }
        return project;
    }

    private final Project project$4(LazyRef project$lzy4$2) {
        return (Project)(project$lzy4$2.initialized() ? project$lzy4$2.value() : this.project$lzyINIT4$1(project$lzy4$2));
    }
}

