/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.course.web.action.plan;

import java.io.File;
import java.io.Serializable;
import java.net.URI;
import java.util.Locale;
import org.beangle.commons.bean.orderings.PropertyOrdering$;
import org.beangle.commons.collection.Collections$;
import org.beangle.commons.concurrent.Workers$;
import org.beangle.commons.file.zip.Zipper$;
import org.beangle.commons.io.Files$;
import org.beangle.commons.lang.Locales$;
import org.beangle.commons.lang.SystemInfo$;
import org.beangle.data.dao.OqlBuilder;
import org.beangle.data.dao.OqlBuilder$;
import org.beangle.data.dao.QueryBuilder;
import org.beangle.data.model.Entity;
import org.beangle.doc.core.PrintOptions;
import org.beangle.doc.pdf.SPDConverter$;
import org.beangle.ems.app.Ems$;
import org.beangle.security.Securities$;
import org.beangle.webmvc.annotation.mapping;
import org.beangle.webmvc.annotation.param;
import org.beangle.webmvc.context.ActionContext$;
import org.beangle.webmvc.support.action.EntityAction;
import org.beangle.webmvc.support.action.RestfulAction;
import org.beangle.webmvc.view.Stream$;
import org.beangle.webmvc.view.View;
import org.openurp.base.edu.model.TeachingOffice;
import org.openurp.base.model.AuditStatus;
import org.openurp.base.model.AuditStatus$;
import org.openurp.base.model.Project;
import org.openurp.base.model.Semester;
import org.openurp.base.service.ProjectConfigService;
import org.openurp.base.service.SemesterService;
import org.openurp.code.service.CodeService;
import org.openurp.edu.course.model.ClazzPlan;
import org.openurp.edu.course.model.CourseTask;
import org.openurp.edu.course.model.Syllabus;
import org.openurp.edu.course.web.helper.ClazzPlanHelper;
import org.openurp.edu.course.web.helper.StatItem;
import org.openurp.starter.web.helper.ProjectProfile$;
import org.openurp.starter.web.support.ProjectSupport;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Map;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction0;

public class DepartAction
extends RestfulAction<ClazzPlan>
implements ProjectSupport {
    private CodeService codeService;
    private ProjectConfigService configService;
    private SemesterService semesterService;

    public DepartAction() {
        ProjectSupport.$init$((ProjectSupport)this);
    }

    public CodeService codeService() {
        return this.codeService;
    }

    public ProjectConfigService configService() {
        return this.configService;
    }

    public SemesterService semesterService() {
        return this.semesterService;
    }

    public void codeService_$eq(CodeService x$1) {
        this.codeService = x$1;
    }

    public void configService_$eq(ProjectConfigService x$1) {
        this.configService = x$1;
    }

    public void semesterService_$eq(SemesterService x$1) {
        this.semesterService = x$1;
    }

    public void indexSetting() {
        LazyRef lazyRef = new LazyRef();
        super.indexSetting();
        Seq departs = this.getDeparts(this.project$1(lazyRef));
        this.put("departs", departs);
        this.put("project", this.project$1(lazyRef));
        this.put("semester", this.getSemester(this.project$1(lazyRef)));
        this.put("statuses", package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AuditStatus[]{AuditStatus$.Draft, AuditStatus$.Submited, AuditStatus$.RejectedByDirector, AuditStatus$.PassedByDirector, AuditStatus$.RejectedByDepart, AuditStatus$.PassedByDepart, AuditStatus$.Rejected, AuditStatus$.Passed})));
        this.forward(this.forward$default$1());
    }

    public View removeAndRedirect(Seq<ClazzPlan> plans) {
        Seq removables = (Seq)((SeqOps)new .colon.colon((Object)AuditStatus$.RejectedByDirector, (List)new .colon.colon((Object)AuditStatus$.RejectedByDepart, (List)new .colon.colon((Object)AuditStatus$.Draft, (List)Nil$.MODULE$))));
        return super.removeAndRedirect((Seq)plans.filter((Function1 & Serializable)x -> removables.contains((Object)x.status())));
    }

    public OqlBuilder<ClazzPlan> getQueryBuilder() {
        Object[] objectArray = new Tuple2[2];
        Locale locale = (Locale)Predef$.MODULE$.ArrowAssoc((Object)Locales$.MODULE$.chinese());
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)locale, (Object)"\u4e2d\u6587");
        Locale locale2 = (Locale)Predef$.MODULE$.ArrowAssoc((Object)Locales$.MODULE$.us());
        objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)locale2, (Object)"English");
        this.put("locales", Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)));
        OqlBuilder query = EntityAction.getQueryBuilder$((EntityAction)this);
        this.getInt("checkHour").foreach((Function1 & Serializable)x$1 -> DepartAction.getQueryBuilder$$anonfun$1(query, BoxesRunTime.unboxToInt((Object)x$1)));
        return this.queryByDepart(query, "clazzPlan.clazz.teachDepart");
    }

    public View audit() {
        Seq plans = this.entityDao().find(ClazzPlan.class, (Iterable)this.getLongIds("clazzPlan"));
        this.getBoolean("passed").foreach((Function1 & Serializable)v1 -> {
            DepartAction.audit$$anonfun$1(plans, BoxesRunTime.unboxToBoolean((Object)v1));
            return BoxedUnit.UNIT;
        });
        this.entityDao().saveOrUpdate((Iterable)plans);
        return this.redirect("search", "\u5ba1\u6838\u6210\u529f");
    }

    @mapping(value="{id}")
    public View info(@param(value="id") String id) {
        ClazzPlan plan = (ClazzPlan)this.entityDao().get(ClazzPlan.class, (Object)BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(id))));
        new ClazzPlanHelper(this.entityDao()).collectDatas(plan).foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                Object v = tuple2._2();
                this.put(k, v);
                return;
            }
            throw new MatchError((Object)tuple2);
        });
        Project project = plan.clazz().course().project();
        ProjectProfile$.MODULE$.set(project);
        return this.forward("/org/openurp/edu/course/web/components/plan/report_zh_CN");
    }

    public void editSetting(ClazzPlan plan) {
        LazyRef lazyRef = new LazyRef();
        Object[] objectArray = new Tuple2[2];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"project");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)this.project$2(lazyRef));
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"department");
        objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)plan.clazz().teachDepart());
        this.put("offices", this.entityDao().findBy(TeachingOffice.class, (Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)));
        super.editSetting((Entity)plan);
    }

    public View download() {
        Seq clazzPlans = this.entityDao().find(ClazzPlan.class, (Iterable)this.getLongIds("clazzPlan"));
        String pdfDir = SystemInfo$.MODULE$.tmpDir() + "/" + ("clazzPlan_" + Securities$.MODULE$.user());
        Files$.MODULE$.travel(new File(pdfDir), (Function1)(JProcedure1 & Serializable)f -> f.delete());
        String contextPath = ActionContext$.MODULE$.current().request().getContextPath();
        new File(pdfDir).mkdirs();
        if (clazzPlans.size() == 1) {
            ClazzPlan plan = (ClazzPlan)clazzPlans.head();
            String url = Ems$.MODULE$.base() + contextPath + ("/plan/depart/" + plan.id() + "?URP_SID=") + Securities$.MODULE$.session().map((Function1 & Serializable)_$1 -> _$1.id()).getOrElse(DepartAction::$anonfun$2);
            String fileName = Files$.MODULE$.purify(plan.clazz().crn() + "_" + plan.clazz().course().name() + "_\u6388\u8bfe\u8ba1\u5212");
            File pdf = new File(pdfDir + ("/" + fileName + ".pdf"));
            PrintOptions options = new PrintOptions();
            SPDConverter$.MODULE$.getInstance().convert(URI.create(url), pdf, options);
            return Stream$.MODULE$.apply(pdf).cleanup((Function0)(JFunction0.mcV.sp & Serializable)() -> {
                pdf.delete();
                new File(pdfDir).delete();
            });
        }
        Seq datas = (Seq)clazzPlans.map((Function1 & Serializable)x -> Tuple2$.MODULE$.apply(x.id(), (Object)Files$.MODULE$.purify(x.clazz().crn() + "_" + x.clazz().course().name() + "_\u6388\u8bfe\u8ba1\u5212")));
        Workers$.MODULE$.work((Iterable)datas, (Function1)(JProcedure1 & Serializable)data -> {
            String url = Ems$.MODULE$.base() + contextPath + ("/plan/depart/" + data._1() + "?URP_SID=") + Securities$.MODULE$.session().map((Function1 & Serializable)_$2 -> _$2.id()).getOrElse(DepartAction::$anonfun$5);
            File pdf = new File(pdfDir + ("/" + data._2() + ".pdf"));
            PrintOptions options = new PrintOptions();
            SPDConverter$.MODULE$.getInstance().convert(URI.create(url), pdf, options);
        }, Runtime.getRuntime().availableProcessors());
        File zipFile = new File(SystemInfo$.MODULE$.tmpDir() + ("/archive" + Securities$.MODULE$.user() + ".zip"));
        Zipper$.MODULE$.zip(new File(pdfDir), zipFile, "utf-8");
        return Stream$.MODULE$.apply(zipFile).cleanup((Function0)(JFunction0.mcV.sp & Serializable)() -> {
            zipFile.delete();
            Files$.MODULE$.travel(new File(pdfDir), (Function1)(JProcedure1 & Serializable)f -> f.delete());
        });
    }

    public View stat() {
        Project project = this.getProject();
        Semester semester = (Semester)this.entityDao().get(Semester.class, (Object)BoxesRunTime.boxToInteger((int)this.getIntId("clazzPlan.semester")));
        OqlBuilder q = OqlBuilder$.MODULE$.from(CourseTask.class.getName(), "t");
        q.where("t.course.project=:project and t.semester=:semester", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{project, semester}));
        q.where("t.syllabusRequired=true", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
        q.groupBy("t.department.id,t.department.code,t.department.name,t.department.shortName");
        q.select("t.department.id,t.department.code,t.department.name,t.department.shortName,count(*)");
        Seq taskStats = this.entityDao().search((QueryBuilder)q);
        OqlBuilder q1 = OqlBuilder$.MODULE$.from(Syllabus.class.getName(), "s");
        q1.where(":date between s.beginOn and s.endOn", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{semester.beginOn().plusDays(30L)}));
        q1.where("s.course.project=:project", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{project}));
        q1.where("exists(from " + CourseTask.class.getName() + " ct where ct.course=s.course and ct.syllabusRequired=true and ct.semester=:semester)", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{semester}));
        q1.groupBy("s.department.id");
        q1.select("s.department.id,count(distinct s.course.id)");
        q1.where("s.status != :status", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{AuditStatus$.Draft}));
        Seq syllabusStats = this.entityDao().search((QueryBuilder)q1);
        OqlBuilder q2 = OqlBuilder$.MODULE$.from(ClazzPlan.class.getName(), "s");
        q2.where("s.clazz.semester=:semester", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{semester}));
        q2.where("s.clazz.project=:project", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{project}));
        q2.where("exists(from " + CourseTask.class.getName() + " ct where ct.course=s.clazz.course and ct.syllabusRequired=true and ct.semester=:semester)", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{semester}));
        q2.groupBy("s.clazz.teachDepart.id");
        q2.select("s.clazz.teachDepart.id,count(distinct s.clazz.course.id)");
        q2.where("s.status != :status", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{AuditStatus$.Draft}));
        Seq planStats = this.entityDao().search((QueryBuilder)q2);
        Buffer items = Collections$.MODULE$.newBuffer();
        taskStats.foreach((Function1 & Serializable)stat -> {
            Map entry = Collections$.MODULE$.newMap();
            Object enName = stat[3] == null ? stat[2] : stat[3];
            Object[] objectArray = new Tuple2[4];
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"id");
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)stat[0].toString());
            String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"code");
            objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)stat[1].toString());
            String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"name");
            objectArray[2] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Object)stat[2].toString());
            String string4 = (String)Predef$.MODULE$.ArrowAssoc((Object)"shortName");
            objectArray[3] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string4, enName);
            entry.addAll((IterableOnce)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)));
            StatItem item = new StatItem();
            item.entry_$eq(entry);
            Object s1 = syllabusStats.find((Function1 & Serializable)_$3 -> BoxesRunTime.equals((Object)_$3[0], (Object)stat[0])).map((Function1 & Serializable)_$4 -> (Number)_$4[1]).getOrElse(DepartAction::$anonfun$8);
            Object s2 = planStats.find((Function1 & Serializable)_$5 -> BoxesRunTime.equals((Object)_$5[0], (Object)stat[0])).map((Function1 & Serializable)_$6 -> (Number)_$6[1]).getOrElse(DepartAction::$anonfun$11);
            item.counters_$eq((Seq<Object>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{(Number)stat[4], s1, s2}))));
            return (Buffer)items.addOne((Object)item);
        });
        this.put("project", project);
        this.put("semester", semester);
        this.put("items", items.sorted(PropertyOrdering$.MODULE$.by("entry(code)")));
        return this.forward(this.forward$default$1());
    }

    private final Project project$lzyINIT1$1(LazyRef project$lzy1$1) {
        Project project;
        LazyRef lazyRef = project$lzy1$1;
        synchronized (lazyRef) {
            project = (Project)(project$lzy1$1.initialized() ? project$lzy1$1.value() : project$lzy1$1.initialize((Object)this.getProject()));
        }
        return project;
    }

    private final Project project$1(LazyRef project$lzy1$2) {
        return (Project)(project$lzy1$2.initialized() ? project$lzy1$2.value() : this.project$lzyINIT1$1(project$lzy1$2));
    }

    private static final /* synthetic */ Object getQueryBuilder$$anonfun$1(OqlBuilder query$1, int x$1) {
        int n = x$1;
        switch (n) {
            case 1: {
                return query$1.where("clazzPlan.lessonHours + clazzPlan.examHours > clazzPlan.clazz.course.creditHours", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
            }
            case 0: {
                return query$1.where("clazzPlan.lessonHours + clazzPlan.examHours = clazzPlan.clazz.course.creditHours", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
            }
            case -1: {
                return query$1.where("clazzPlan.lessonHours>0 and clazzPlan.lessonHours + clazzPlan.examHours < clazzPlan.clazz.course.creditHours", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
            }
        }
        return BoxedUnit.UNIT;
    }

    private static final /* synthetic */ void audit$$anonfun$1(Seq plans$1, boolean passed) {
        AuditStatus status = passed ? AuditStatus$.PassedByDepart : AuditStatus$.RejectedByDepart;
        plans$1.foreach((Function1)(JProcedure1 & Serializable)s -> s.status_$eq(status));
    }

    private final Project project$lzyINIT2$1(LazyRef project$lzy2$1) {
        Project project;
        LazyRef lazyRef = project$lzy2$1;
        synchronized (lazyRef) {
            project = (Project)(project$lzy2$1.initialized() ? project$lzy2$1.value() : project$lzy2$1.initialize((Object)this.getProject()));
        }
        return project;
    }

    private final Project project$2(LazyRef project$lzy2$2) {
        return (Project)(project$lzy2$2.initialized() ? project$lzy2$2.value() : this.project$lzyINIT2$1(project$lzy2$2));
    }

    private static final String $anonfun$2() {
        return "";
    }

    private static final String $anonfun$5() {
        return "";
    }

    private static final Object $anonfun$8() {
        return BoxesRunTime.boxToInteger((int)0);
    }

    private static final Object $anonfun$11() {
        return BoxesRunTime.boxToInteger((int)0);
    }
}

