/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.course.web.action.profile;

import jakarta.servlet.http.Part;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.time.Instant;
import java.util.Locale;
import org.beangle.commons.activation.MediaTypes$;
import org.beangle.commons.file.zip.Zipper$;
import org.beangle.commons.io.Files$;
import org.beangle.commons.io.IOs$;
import org.beangle.commons.lang.Strings$;
import org.beangle.commons.logging.Logger$;
import org.beangle.commons.logging.Logging;
import org.beangle.commons.net.http.HttpUtils$;
import org.beangle.data.dao.EntityDao;
import org.beangle.data.dao.OqlBuilder;
import org.beangle.data.dao.OqlBuilder$;
import org.beangle.data.dao.QueryBuilder;
import org.beangle.data.model.Entity;
import org.beangle.data.model.pojo.Named;
import org.beangle.ems.app.Ems$;
import org.beangle.ems.app.EmsApp$;
import org.beangle.ems.app.blob.Repository;
import org.beangle.security.Securities$;
import org.beangle.webmvc.annotation.mapping;
import org.beangle.webmvc.annotation.param;
import org.beangle.webmvc.support.ActionSupport;
import org.beangle.webmvc.support.EntitySupport;
import org.beangle.webmvc.support.action.EntityAction;
import org.beangle.webmvc.view.Stream$;
import org.beangle.webmvc.view.View;
import org.openurp.base.edu.model.BookAdoption;
import org.openurp.base.edu.model.BookAdoption$;
import org.openurp.base.edu.model.Course;
import org.openurp.base.edu.model.CourseProfile;
import org.openurp.base.edu.model.TeachingOffice;
import org.openurp.base.edu.model.Textbook;
import org.openurp.base.model.AuditStatus$;
import org.openurp.base.model.Project;
import org.openurp.base.model.User;
import org.openurp.base.service.ProjectConfigService;
import org.openurp.base.service.SemesterService;
import org.openurp.code.edu.model.CourseCategory;
import org.openurp.code.edu.model.CourseNature;
import org.openurp.code.edu.model.CourseType;
import org.openurp.code.service.CodeService;
import org.openurp.edu.course.model.CourseTask;
import org.openurp.edu.course.model.SyllabusDoc;
import org.openurp.edu.course.service.SyllabusService;
import org.openurp.edu.course.web.helper.StatHelper;
import org.openurp.starter.web.support.ProjectSupport;
import org.slf4j.Logger;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LazyRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction0;

public class DepartAction
extends ActionSupport
implements EntityAction<CourseTask>,
ProjectSupport,
Logging {
    private Class entityClass;
    private CodeService codeService;
    private ProjectConfigService configService;
    private SemesterService semesterService;
    private Logger logger;
    private EntityDao entityDao;
    private SyllabusService syllabusService;

    public DepartAction() {
        EntitySupport.$init$((EntitySupport)this);
        ProjectSupport.$init$((ProjectSupport)this);
        Logging.$init$((Logging)this);
        Statics.releaseFence();
    }

    public Class entityClass() {
        return this.entityClass;
    }

    public void org$beangle$webmvc$support$EntitySupport$_setter_$entityClass_$eq(Class x$0) {
        this.entityClass = x$0;
    }

    public CodeService codeService() {
        return this.codeService;
    }

    public ProjectConfigService configService() {
        return this.configService;
    }

    public SemesterService semesterService() {
        return this.semesterService;
    }

    public void codeService_$eq(CodeService x$1) {
        this.codeService = x$1;
    }

    public void configService_$eq(ProjectConfigService x$1) {
        this.configService = x$1;
    }

    public void semesterService_$eq(SemesterService x$1) {
        this.semesterService = x$1;
    }

    public Logger logger() {
        return this.logger;
    }

    public void org$beangle$commons$logging$Logging$_setter_$logger_$eq(Logger x$0) {
        this.logger = x$0;
    }

    public EntityDao entityDao() {
        return this.entityDao;
    }

    public void entityDao_$eq(EntityDao x$1) {
        this.entityDao = x$1;
    }

    public SyllabusService syllabusService() {
        return this.syllabusService;
    }

    public void syllabusService_$eq(SyllabusService x$1) {
        this.syllabusService = x$1;
    }

    public String simpleEntityName() {
        return "task";
    }

    public View index() {
        LazyRef lazyRef = new LazyRef();
        this.put("courseTypes", this.getCodes(CourseType.class, this.project$1(lazyRef)));
        this.put("courseCategories", this.getCodes(CourseCategory.class, this.project$1(lazyRef)));
        this.put("courseNatures", this.getCodes(CourseNature.class, this.project$1(lazyRef)));
        this.put("teachingOffices", this.entityDao().getAll(TeachingOffice.class));
        this.put("departments", this.getDeparts(this.project$1(lazyRef)));
        this.put("project", this.project$1(lazyRef));
        this.put("semester", this.getSemester(this.project$1(lazyRef)));
        return this.forward(this.forward$default$1());
    }

    public View search() {
        OqlBuilder<CourseTask> query = this.getQueryBuilder();
        Seq tasks = this.entityDao().search(query);
        Set courses = ((IterableOnceOps)tasks.map((Function1 & Serializable)_$3 -> _$3.course())).toSet();
        StatHelper statHelper = new StatHelper(this.entityDao());
        this.put("hasProfileCourses", statHelper.hasProfile((Iterable<Course>)courses));
        this.put("hasSyllabusCourses", statHelper.hasSyllabus((Iterable<Course>)courses));
        this.put("tasks", tasks);
        return this.forward(this.forward$default$1());
    }

    public OqlBuilder<CourseTask> getQueryBuilder() {
        LazyRef lazyRef = new LazyRef();
        OqlBuilder builder = EntityAction.getQueryBuilder$((EntityAction)this);
        builder.where("task.department in(:departs)", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.getDeparts(this.project$2(lazyRef))}));
        builder.where("task.course.project = :project", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.getProject()}));
        this.getBoolean("hasProfile").foreach((Function1 & Serializable)x$1 -> DepartAction.getQueryBuilder$$anonfun$1(builder, BoxesRunTime.unboxToBoolean((Object)x$1)));
        this.getBoolean("hasSyllabus").foreach((Function1 & Serializable)x$1 -> DepartAction.getQueryBuilder$$anonfun$2(builder, BoxesRunTime.unboxToBoolean((Object)x$1)));
        return builder;
    }

    @mapping(value="{id}/edit")
    public View edit(@param(value="id") String id) {
        CourseProfile courseProfile;
        CourseTask task = (CourseTask)this.entityDao().get(CourseTask.class, (Object)BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(id))));
        Course course = task.course();
        Option<CourseProfile> option = this.getProfile(course);
        if (option instanceof Some) {
            CourseProfile p;
            courseProfile = p = (CourseProfile)((Some)option).value();
        } else if (None$.MODULE$.equals(option)) {
            CourseProfile cp = new CourseProfile();
            cp.course_$eq(course);
            courseProfile = cp;
        } else {
            throw new MatchError(option);
        }
        CourseProfile profile = courseProfile;
        this.put("project", course.project());
        this.put("profile", profile);
        this.put("course", course);
        this.put("task", task);
        this.put("semester", task.semester());
        OqlBuilder syllabusQuery = OqlBuilder$.MODULE$.from(SyllabusDoc.class, "s");
        syllabusQuery.where("s.course = :course", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{course}));
        syllabusQuery.orderBy("s.semester.beginOn desc");
        syllabusQuery.limit(1, 1);
        this.put("syllabuses", this.entityDao().search((QueryBuilder)syllabusQuery));
        Object object = Predef$.MODULE$.refArrayOps((Object[])BookAdoption$.MODULE$.values());
        this.put("bookAdoptions", Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(object, (Function1 & Serializable)x -> Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)x.id()), (Object)x.name()), ClassTag$.MODULE$.apply(Tuple2.class))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
        this.put("Ems", Ems$.MODULE$);
        return this.forward(this.forward$default$1());
    }

    @mapping(value="{id}", method="put")
    public View update(@param(value="id") String id) {
        CourseTask task = (CourseTask)this.entityDao().get(CourseTask.class, (Object)BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(id))));
        Course course = task.course();
        CourseProfile profile = (CourseProfile)this.getProfile(course).getOrElse(DepartAction::$anonfun$2);
        Option user = this.entityDao().findBy(User.class, "code", (Object)new .colon.colon((Object)Securities$.MODULE$.user(), (List)Nil$.MODULE$)).headOption();
        profile.course_$eq(course);
        if (profile.department() == null) {
            profile.department_$eq(course.department());
        }
        if (profile.semester() == null) {
            profile.semester_$eq(task.semester());
        }
        if (profile.beginOn() == null) {
            profile.beginOn_$eq(task.semester().beginOn());
        }
        this.populate((Entity)profile, "profile");
        profile.updatedAt_$eq(Instant.now());
        profile.writer_$eq(user);
        profile.books().clear();
        profile.books().addAll((IterableOnce)this.entityDao().find(Textbook.class, (Iterable)this.getLongIds("textbook")));
        if (profile.books().isEmpty()) {
            BookAdoption bookAdoption = profile.bookAdoption();
            BookAdoption bookAdoption2 = BookAdoption$.UseTextBook;
            if (!(bookAdoption != null ? !bookAdoption.equals(bookAdoption2) : bookAdoption2 != null)) {
                profile.bookAdoption_$eq(BookAdoption$.UseLecture);
            }
        } else {
            profile.bookAdoption_$eq(BookAdoption$.UseTextBook);
        }
        this.entityDao().saveOrUpdate((Object)profile, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CourseProfile[0]));
        Iterable parts = this.getAll("attachment", Part.class, ClassTag$.MODULE$.apply(Part.class));
        Option writerId = this.getLong("syllabusDoc.writer.id");
        if (parts.nonEmpty() && ((Part)parts.head()).getSize() > 0L && writerId.nonEmpty()) {
            Part part = (Part)parts.head();
            User writer = (User)this.entityDao().get(User.class, writerId.get());
            SyllabusDoc syllabus = this.syllabusService().upload(course, writer, part.getInputStream(), Strings$.MODULE$.substringAfterLast(part.getSubmittedFileName(), "."), Locale.SIMPLIFIED_CHINESE, task.semester());
            syllabus.status_$eq(AuditStatus$.Published);
            this.entityDao().saveOrUpdate((Object)syllabus, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SyllabusDoc[0]));
        }
        return this.redirect("search", "info.save.success");
    }

    private Option<CourseProfile> getProfile(Course course) {
        OqlBuilder query = OqlBuilder$.MODULE$.from(CourseProfile.class, "cp");
        query.where("cp.course = :course", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{course}));
        return this.entityDao().search((QueryBuilder)query).headOption();
    }

    public View attachment() {
        SyllabusDoc doc = (SyllabusDoc)this.entityDao().get(SyllabusDoc.class, (Object)BoxesRunTime.boxToLong((long)this.getLongId("doc")));
        Option path = EmsApp$.MODULE$.getBlobRepository(true).url(doc.docPath());
        this.response().sendRedirect(((URL)path.get()).toString());
        return null;
    }

    public View batchDownload() {
        List taskIds = this.getLongIds("task");
        Seq courses = (Seq)this.entityDao().find(CourseTask.class, (Iterable)taskIds).map((Function1 & Serializable)_$4 -> _$4.course());
        OqlBuilder query = OqlBuilder$.MODULE$.from(SyllabusDoc.class, "s");
        query.where("s.course in(:courses)", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{courses}));
        query.where("not exists(from " + SyllabusDoc.class.getName() + " s2 where s2.course=s.course and s2.updatedAt>s.updatedAt)", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
        Seq docs = this.entityDao().search((QueryBuilder)query);
        Seq departs = (Seq)((SeqOps)docs.map((Function1 & Serializable)_$5 -> _$5.course().department())).distinct();
        File dir = new File(System.getProperty("java.io.tmpdir") + "syllabus" + Files$.MODULE$.$div() + System.currentTimeMillis());
        if (dir.exists()) {
            Files$.MODULE$.travel(dir, (Function1)(JProcedure1 & Serializable)f -> f.delete());
        }
        dir.mkdirs();
        IntRef paperCount = IntRef.create((int)0);
        Repository blob = EmsApp$.MODULE$.getBlobRepository(true);
        docs.foreach((Function1)(JProcedure1 & Serializable)doc -> blob.url(doc.docPath()).foreach((Function1)(JProcedure1 & Serializable)url -> {
            String courseName = doc.course().code();
            String fileName = dir.getAbsolutePath() + Files$.MODULE$.$div() + courseName + "." + Strings$.MODULE$.substringAfterLast(doc.docPath(), ".");
            this.downloading(url.openConnection(), new File(fileName));
            ++paperCount$2.elem;
        }));
        File targetZip = new File(System.getProperty("java.io.tmpdir") + "syllabus" + Files$.MODULE$.$div() + ("batch" + System.currentTimeMillis() + ".zip"));
        Logger$.MODULE$.info$extension(this.logger(), () -> DepartAction.batchDownload$$anonfun$3(targetZip));
        Zipper$.MODULE$.zip(dir, targetZip, Zipper$.MODULE$.zip$default$3());
        String fileName = (String)(departs.size() == 1 ? ((Named)departs.head()).name() : ((Named)departs.head()).name() + "\u7b49\u9662\u7cfb") + ("\u8bfe\u7a0b\u5927\u7eb2(" + paperCount.elem + ").zip");
        return Stream$.MODULE$.apply(targetZip, MediaTypes$.MODULE$.ApplicationZip(), fileName).cleanup((Function0)(JFunction0.mcV.sp & Serializable)() -> {
            Files$.MODULE$.travel(dir, (Function1)(JProcedure1 & Serializable)f -> f.delete());
            dir.delete();
            targetZip.delete();
        });
    }

    private void downloading(URLConnection c, File location) {
        HttpURLConnection conn = HttpUtils$.MODULE$.followRedirect(c, "GET");
        InputStream input = null;
        FileOutputStream output = null;
        try {
            try {
                File file = new File(location.toString() + ".part");
                file.delete();
                byte[] buffer = new byte[4096];
                input = conn.getInputStream();
                output = new FileOutputStream(file);
                int n = input.read(buffer);
                while (-1 != n) {
                    ((OutputStream)output).write(buffer, 0, n);
                    n = input.read(buffer);
                }
                IOs$.MODULE$.close((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AutoCloseable[]{input, output}));
                input = null;
                output = null;
                file.renameTo(location);
            }
            catch (Throwable e) {
                Logger$.MODULE$.warn$extension(this.logger(), () -> DepartAction.downloading$$anonfun$1(location));
            }
        }
        catch (Throwable throwable) {
            IOs$.MODULE$.close((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AutoCloseable[]{input, output}));
            throw throwable;
        }
        IOs$.MODULE$.close((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AutoCloseable[]{input, output}));
    }

    private final Project project$lzyINIT1$1(LazyRef project$lzy1$1) {
        Project project;
        LazyRef lazyRef = project$lzy1$1;
        synchronized (lazyRef) {
            project = (Project)(project$lzy1$1.initialized() ? project$lzy1$1.value() : project$lzy1$1.initialize((Object)this.getProject()));
        }
        return project;
    }

    private final Project project$1(LazyRef project$lzy1$2) {
        return (Project)(project$lzy1$2.initialized() ? project$lzy1$2.value() : this.project$lzyINIT1$1(project$lzy1$2));
    }

    private final Project project$lzyINIT2$1(LazyRef project$lzy2$1) {
        Project project;
        LazyRef lazyRef = project$lzy2$1;
        synchronized (lazyRef) {
            project = (Project)(project$lzy2$1.initialized() ? project$lzy2$1.value() : project$lzy2$1.initialize((Object)this.getProject()));
        }
        return project;
    }

    private final Project project$2(LazyRef project$lzy2$2) {
        return (Project)(project$lzy2$2.initialized() ? project$lzy2$2.value() : this.project$lzyINIT2$1(project$lzy2$2));
    }

    private static final /* synthetic */ OqlBuilder getQueryBuilder$$anonfun$1(OqlBuilder builder$1, boolean x$1) {
        boolean bl = x$1;
        if (bl) {
            return (OqlBuilder)builder$1.where("exists(from " + CourseProfile.class.getName() + " clz where clz.course=course)", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
        }
        if (!bl) {
            return (OqlBuilder)builder$1.where("not exists(from " + CourseProfile.class.getName() + " clz where clz.course=course)", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
        }
        throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
    }

    private static final /* synthetic */ OqlBuilder getQueryBuilder$$anonfun$2(OqlBuilder builder$2, boolean x$1) {
        boolean bl = x$1;
        if (bl) {
            return (OqlBuilder)builder$2.where("exists(from " + SyllabusDoc.class.getName() + " clz where clz.course=course)", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
        }
        if (!bl) {
            return (OqlBuilder)builder$2.where("not exists(from " + SyllabusDoc.class.getName() + " clz where clz.course=course)", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
        }
        throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
    }

    private static final CourseProfile $anonfun$2() {
        return new CourseProfile();
    }

    private static final String batchDownload$$anonfun$3(File targetZip$1) {
        return "download to " + targetZip$1.getAbsolutePath();
    }

    private static final String downloading$$anonfun$1(File location$1) {
        return "Cannot download file " + location$1;
    }
}

