/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.course.web.action.profile;

import jakarta.servlet.http.Part;
import java.io.Serializable;
import java.net.URL;
import java.time.Instant;
import java.util.Locale;
import org.beangle.commons.collection.Collections$;
import org.beangle.commons.lang.Strings$;
import org.beangle.commons.net.http.HttpUtils$;
import org.beangle.commons.net.http.ResourceStatus;
import org.beangle.data.dao.OqlBuilder;
import org.beangle.data.dao.OqlBuilder$;
import org.beangle.data.dao.QueryBuilder;
import org.beangle.ems.app.Ems$;
import org.beangle.ems.app.EmsApp$;
import org.beangle.ems.app.web.WebBusinessLogger;
import org.beangle.security.Securities$;
import org.beangle.webmvc.annotation.mapping;
import org.beangle.webmvc.annotation.param;
import org.beangle.webmvc.context.ActionContext$;
import org.beangle.webmvc.support.EntitySupport;
import org.beangle.webmvc.support.action.EntityAction;
import org.beangle.webmvc.view.View;
import org.openurp.base.edu.model.BookAdoption;
import org.openurp.base.edu.model.BookAdoption$;
import org.openurp.base.edu.model.Course;
import org.openurp.base.edu.model.CourseProfile;
import org.openurp.base.edu.model.Textbook;
import org.openurp.base.hr.model.Teacher;
import org.openurp.base.model.AuditStatus$;
import org.openurp.base.model.Project;
import org.openurp.base.model.Semester;
import org.openurp.base.model.User;
import org.openurp.edu.clazz.domain.ClazzProvider;
import org.openurp.edu.clazz.model.Clazz;
import org.openurp.edu.course.model.CourseTask;
import org.openurp.edu.course.model.SyllabusDoc;
import org.openurp.edu.course.service.CourseTaskService;
import org.openurp.edu.course.service.SyllabusService;
import org.openurp.edu.course.web.helper.StatHelper;
import org.openurp.starter.web.support.TeacherSupport;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.math.Ordering$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;

public class ReviseAction
extends TeacherSupport
implements EntityAction<CourseProfile> {
    private Class entityClass;
    private SyllabusService syllabusService;
    private CourseTaskService courseTaskService;
    private ClazzProvider clazzProvider;
    private WebBusinessLogger businessLogger;

    public ReviseAction() {
        EntitySupport.$init$((EntitySupport)this);
        Statics.releaseFence();
    }

    public Class entityClass() {
        return this.entityClass;
    }

    public void org$beangle$webmvc$support$EntitySupport$_setter_$entityClass_$eq(Class x$0) {
        this.entityClass = x$0;
    }

    public SyllabusService syllabusService() {
        return this.syllabusService;
    }

    public void syllabusService_$eq(SyllabusService x$1) {
        this.syllabusService = x$1;
    }

    public CourseTaskService courseTaskService() {
        return this.courseTaskService;
    }

    public void courseTaskService_$eq(CourseTaskService x$1) {
        this.courseTaskService = x$1;
    }

    public ClazzProvider clazzProvider() {
        return this.clazzProvider;
    }

    public void clazzProvider_$eq(ClazzProvider x$1) {
        this.clazzProvider = x$1;
    }

    public WebBusinessLogger businessLogger() {
        return this.businessLogger;
    }

    public void businessLogger_$eq(WebBusinessLogger x$1) {
        this.businessLogger = x$1;
    }

    public View projectIndex(Teacher teacher, Project project) {
        Semester semester = this.getSemester();
        Seq tasks = this.courseTaskService().getTasks(project, semester, teacher);
        Seq taskCourses = (Seq)tasks.map((Function1 & Serializable)_$5 -> _$5.course());
        Buffer clazzCourses = (Buffer)((IterableOnceOps)this.clazzProvider().getClazzes(semester, teacher, project).map((Function1 & Serializable)_$6 -> _$6.course())).toSet().toBuffer().subtractAll((IterableOnce)taskCourses);
        OqlBuilder query2 = OqlBuilder$.MODULE$.from(Clazz.class.getName(), "c");
        query2.where(":teacher in elements(c.teachers)", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{teacher}));
        query2.where("c.semester.endOn <= :today", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{semester.endOn()}));
        query2.select("distinct c.course");
        query2.orderBy("c.course.code");
        Buffer hisCourses = Collections$.MODULE$.newBuffer((Iterable)this.entityDao().search((QueryBuilder)query2));
        hisCourses.subtractAll((IterableOnce)clazzCourses);
        StatHelper statHelper = new StatHelper(this.entityDao());
        Buffer courses = (Buffer)clazzCourses.$plus$plus((IterableOnce)hisCourses);
        this.put("hasProfileCourses", statHelper.hasSyllabus((Iterable<Course>)courses));
        this.put("hasSyllabusCourses", statHelper.hasProfile((Iterable<Course>)courses));
        this.put("taskCourses", taskCourses);
        this.put("clazzCourses", clazzCourses);
        this.put("hisCourses", hisCourses);
        this.put("courses", courses);
        this.put("zh_template_url", this.getTemplateFile("zh.docx"));
        this.put("en_template_url", this.getTemplateFile("en.docx"));
        this.put("semester", semester);
        return this.forward(this.forward$default$1());
    }

    public Option<URL> getTemplateFile(String name) {
        URL url = new URL(Ems$.MODULE$.api() + "/platform/config/files/" + EmsApp$.MODULE$.name() + "/syllabus/template/" + name);
        ResourceStatus status = HttpUtils$.MODULE$.access(url);
        if (status.isOk()) {
            return Some$.MODULE$.apply((Object)url);
        }
        return None$.MODULE$;
    }

    @mapping(value="{courseId}")
    public View course(@param(value="courseId") String courseId) {
        Course course = (Course)this.entityDao().get(Course.class, (Object)BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(courseId))));
        Semester semester = (Semester)this.entityDao().get(Semester.class, (Object)BoxesRunTime.boxToInteger((int)this.getIntId("semester")));
        Teacher teacher = this.getTeacher();
        Option task = this.courseTaskService().getOrCreateTask(semester, course, teacher);
        this.put("task", task);
        this.put("editable", BoxesRunTime.boxToBoolean((task.nonEmpty() && ((CourseTask)Option$.MODULE$.option2Iterable(task).head()).director().contains((Object)teacher) ? 1 : 0) != 0));
        this.put("course", course);
        this.put("me", teacher.code());
        this.put("profile", this.getProfile(course, semester));
        OqlBuilder docQuery = OqlBuilder$.MODULE$.from(SyllabusDoc.class, "s");
        docQuery.where("s.course = :course and s.beginOn <= :beginOn", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{course, semester.beginOn()}));
        docQuery.orderBy("s.semester.beginOn desc");
        Seq docs = this.entityDao().search((QueryBuilder)docQuery);
        Seq activeDocs = (Seq)docs.filter((Function1 & Serializable)_$7 -> _$7.within(semester.beginOn()));
        this.put("activeDocs", activeDocs);
        this.put("historyDocs", docs.toBuffer().subtractAll((IterableOnce)activeDocs));
        StatHelper statHelper = new StatHelper(this.entityDao());
        this.put("clazzInfos", statHelper.statClazzInfo(course));
        this.put("semester", semester);
        return this.forward(this.forward$default$1());
    }

    public View editProfile() {
        CourseProfile courseProfile;
        Semester semester = (Semester)this.entityDao().get(Semester.class, (Object)BoxesRunTime.boxToInteger((int)this.getIntId("semester")));
        Course course = (Course)this.entityDao().get(Course.class, (Object)BoxesRunTime.boxToLong((long)this.getLongId("course")));
        Option<CourseProfile> option = this.getProfile(course, semester);
        if (option instanceof Some) {
            CourseProfile p;
            courseProfile = p = (CourseProfile)((Some)option).value();
        } else if (None$.MODULE$.equals(option)) {
            CourseProfile cp = new CourseProfile();
            cp.course_$eq(course);
            cp.semester_$eq(semester);
            cp.beginOn_$eq(semester.beginOn());
            courseProfile = cp;
        } else {
            throw new MatchError(option);
        }
        CourseProfile profile = courseProfile;
        this.put("semester", semester);
        this.put("profile", profile);
        this.put("course", course);
        this.put("project", course.project());
        OqlBuilder syllabusQuery = OqlBuilder$.MODULE$.from(SyllabusDoc.class, "s");
        syllabusQuery.where("s.course = :course", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{course}));
        syllabusQuery.orderBy("s.semester.beginOn desc");
        syllabusQuery.limit(1, 1);
        Option writer = this.entityDao().findBy(User.class, "code", (Object)new .colon.colon((Object)Securities$.MODULE$.user(), (List)Nil$.MODULE$)).headOption();
        this.put("writer", writer);
        this.put("syllabusDocs", this.entityDao().search((QueryBuilder)syllabusQuery));
        this.put("Ems", Ems$.MODULE$);
        Object object = Predef$.MODULE$.refArrayOps((Object[])BookAdoption$.MODULE$.values());
        Object object2 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(object, (Function1 & Serializable)_$8 -> _$8.id() > 0));
        this.put("bookAdoptions", Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(object2, (Function1 & Serializable)x -> Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)x.id()), (Object)x.name()), ClassTag$.MODULE$.apply(Tuple2.class))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
        return this.forward("form");
    }

    private Option<CourseProfile> getProfile(Course course, Semester semester) {
        boolean renew = this.getBoolean("renew", false);
        if (renew) {
            return None$.MODULE$;
        }
        OqlBuilder query = OqlBuilder$.MODULE$.from(CourseProfile.class, "cp");
        query.where("cp.course = :course", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{course}));
        query.where("cp.beginOn<=:beginOn", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{semester.beginOn()}));
        query.where("cp.endOn is null or cp.endOn >=:beginOn", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{semester.beginOn()}));
        return this.entityDao().search((QueryBuilder)query).headOption();
    }

    @mapping(value="{id}", method="put")
    public View update(@param(value="id") String id) {
        CourseProfile entity = (CourseProfile)this.populate(this.getModel(id), this.simpleEntityName());
        return this.persist(entity);
    }

    public String simpleEntityName() {
        return "profile";
    }

    public View persist(CourseProfile profile) {
        Course course = (Course)this.entityDao().get(Course.class, profile.course().id());
        Semester semester = (Semester)this.entityDao().get(Semester.class, (Object)BoxesRunTime.boxToInteger((int)this.getIntId("semester")));
        profile.books().clear();
        profile.books().addAll((IterableOnce)this.entityDao().find(Textbook.class, (Iterable)this.getLongIds("textbook")));
        if (profile.books().isEmpty()) {
            BookAdoption bookAdoption = profile.bookAdoption();
            BookAdoption bookAdoption2 = BookAdoption$.UseTextBook;
            if (!(bookAdoption != null ? !bookAdoption.equals(bookAdoption2) : bookAdoption2 != null)) {
                profile.bookAdoption_$eq(BookAdoption$.UseLecture);
            }
        } else {
            profile.bookAdoption_$eq(BookAdoption$.UseTextBook);
        }
        profile.updatedAt_$eq(Instant.now());
        if (profile.beginOn() == null) {
            profile.beginOn_$eq(semester.beginOn());
        }
        if (profile.department() == null) {
            profile.department_$eq(course.department());
        }
        profile.submitAt_$eq((Option)Some$.MODULE$.apply((Object)Instant.now()));
        Option user = this.entityDao().findBy(User.class, "code", (Object)new .colon.colon((Object)Securities$.MODULE$.user(), (List)Nil$.MODULE$)).headOption();
        profile.writer_$eq(user);
        this.entityDao().saveOrUpdate((Object)profile, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CourseProfile[0]));
        OqlBuilder q = OqlBuilder$.MODULE$.from(CourseProfile.class, "cp");
        q.where("cp.course=:course", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{course}));
        q.orderBy("cp.beginOn desc");
        Seq profiles = this.entityDao().findBy(CourseProfile.class, "course", (Object)course);
        profiles.foreach((Function1)(JProcedure1 & Serializable)p -> p.endOn().foreach((Function1)(JProcedure1 & Serializable)endOn -> p.beginOn_$eq(p.semester().beginOn())));
        ObjectRef last = ObjectRef.create((Object)None$.MODULE$);
        ((IterableOnceOps)((SeqOps)profiles.sortBy((Function1 & Serializable)_$9 -> _$9.beginOn(), Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()))).reverse()).foreach((Function1)(JProcedure1 & Serializable)p -> {
            Option option = (Option)last$1.elem;
            if (None$.MODULE$.equals(option)) {
                last$1.elem = Some$.MODULE$.apply(p);
                return;
            }
            if (option instanceof Some) {
                CourseProfile l = (CourseProfile)((Some)option).value();
                p.endOn_$eq((Option)Some$.MODULE$.apply((Object)l.beginOn().minusDays(1L)));
                last$1.elem = Some$.MODULE$.apply(p);
                return;
            }
            throw new MatchError((Object)option);
        });
        this.entityDao().saveOrUpdate((Iterable)profiles);
        Iterable parts = this.getAll("attachment", Part.class, ClassTag$.MODULE$.apply(Part.class));
        Option writerId = this.getLong("syllabusDoc.writer.id");
        if (parts.nonEmpty() && ((Part)parts.head()).getSize() > 0L && writerId.nonEmpty()) {
            Part part = (Part)parts.head();
            User writer = (User)this.entityDao().get(User.class, writerId.get());
            SyllabusDoc doc = this.syllabusService().upload(course, writer, part.getInputStream(), Strings$.MODULE$.substringAfterLast(part.getSubmittedFileName(), "."), Locale.SIMPLIFIED_CHINESE, semester);
            doc.status_$eq(AuditStatus$.Published);
            this.entityDao().saveOrUpdate((Object)doc, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SyllabusDoc[0]));
        }
        return this.redirect("course", "courseId=" + profile.course().id() + "&semester.id=" + semester.id(), "info.save.success");
    }

    @mapping(method="post")
    public View save() {
        Course course = (Course)this.entityDao().get(Course.class, (Object)BoxesRunTime.boxToLong((long)this.getLongId("profile.course")));
        CourseProfile p = (CourseProfile)this.populateEntity();
        View rs = this.persist(p);
        this.businessLogger().info("\u4fee\u6539\u8bfe\u7a0b\u7b80\u4ecb\u4fe1\u606f:" + course.code() + " " + course.name(), p.id(), (Object)ActionContext$.MODULE$.current().params());
        return rs;
    }

    public View attachment() {
        SyllabusDoc doc = (SyllabusDoc)this.entityDao().get(SyllabusDoc.class, (Object)BoxesRunTime.boxToLong((long)this.getLongId("doc")));
        Option path = EmsApp$.MODULE$.getBlobRepository(true).url(doc.docPath());
        this.response().sendRedirect(((URL)path.get()).toString());
        return null;
    }

    public View changeDirector() {
        Teacher director = (Teacher)this.entityDao().get(Teacher.class, (Object)BoxesRunTime.boxToLong((long)this.getLongId("director")));
        CourseTask task = (CourseTask)this.entityDao().get(CourseTask.class, (Object)BoxesRunTime.boxToLong((long)this.getLongId("task")));
        Teacher teacher = this.getTeacher();
        if (task.teachers().contains((Object)teacher) && (task.director().isEmpty() || task.director().contains((Object)teacher))) {
            task.director_$eq((Option)Some$.MODULE$.apply((Object)director));
            this.entityDao().saveOrUpdate((Object)task, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CourseTask[0]));
            this.businessLogger().info("\u4fee\u6539\u8bfe\u7a0b\u8d1f\u8d23\u4eba:" + task.course().code() + " " + task.course().name() + "\u4e3a\uff1a" + director.name(), task.id(), (Object)ActionContext$.MODULE$.current().params());
        }
        return this.redirect("course", "&courseId=" + task.course().id() + "&semester.id=" + task.semester().id(), "\u66f4\u6539\u6210\u529f");
    }
}

