/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.course.web.action.program;

import jakarta.servlet.http.Part;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import java.time.Instant;
import org.beangle.commons.collection.Collections$;
import org.beangle.commons.collection.Properties;
import org.beangle.commons.lang.Strings$;
import org.beangle.data.dao.OqlBuilder;
import org.beangle.data.dao.OqlBuilder$;
import org.beangle.data.dao.QueryBuilder;
import org.beangle.doc.core.PrintOptions;
import org.beangle.doc.html.Document;
import org.beangle.doc.pdf.SPDConverter$;
import org.beangle.ems.app.Ems$;
import org.beangle.ems.app.EmsApi$;
import org.beangle.ems.app.EmsApp$;
import org.beangle.ems.app.blob.BlobMeta;
import org.beangle.ems.app.blob.Repository;
import org.beangle.ems.app.web.WebBusinessLogger;
import org.beangle.security.Securities$;
import org.beangle.webmvc.annotation.response;
import org.beangle.webmvc.support.EntitySupport;
import org.beangle.webmvc.support.action.EntityAction;
import org.beangle.webmvc.view.Stream$;
import org.beangle.webmvc.view.View;
import org.openurp.base.edu.model.Course;
import org.openurp.base.hr.model.Teacher;
import org.openurp.base.model.Project;
import org.openurp.base.model.Semester;
import org.openurp.base.model.User;
import org.openurp.edu.clazz.domain.ClazzProvider;
import org.openurp.edu.clazz.model.Clazz;
import org.openurp.edu.course.model.ClazzPlan;
import org.openurp.edu.course.model.ClazzProgram;
import org.openurp.edu.course.model.CourseTask;
import org.openurp.edu.course.model.LessonDesign;
import org.openurp.edu.course.model.LessonDesignSection;
import org.openurp.edu.course.model.LessonDesignText;
import org.openurp.edu.course.model.Syllabus;
import org.openurp.edu.course.service.CourseTaskService;
import org.openurp.edu.course.web.helper.ClazzPlanHelper;
import org.openurp.edu.course.web.helper.ClazzProgramHelper$;
import org.openurp.edu.course.web.helper.LessonDesignDocParser;
import org.openurp.edu.schedule.service.LessonSchedule;
import org.openurp.edu.schedule.service.LessonSchedule$;
import org.openurp.edu.schedule.service.ScheduleDigestor$;
import org.openurp.starter.web.helper.ProjectProfile$;
import org.openurp.starter.web.support.TeacherSupport;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.collection.SeqOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Map;
import scala.collection.mutable.Set;
import scala.math.Ordering;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

public class ReviseAction
extends TeacherSupport
implements EntityAction<ClazzProgram> {
    private Class entityClass;
    private ClazzProvider clazzProvider;
    private WebBusinessLogger businessLogger;
    private CourseTaskService courseTaskService;

    public ReviseAction() {
        EntitySupport.$init$((EntitySupport)this);
        Statics.releaseFence();
    }

    public Class entityClass() {
        return this.entityClass;
    }

    public void org$beangle$webmvc$support$EntitySupport$_setter_$entityClass_$eq(Class x$0) {
        this.entityClass = x$0;
    }

    public ClazzProvider clazzProvider() {
        return this.clazzProvider;
    }

    public void clazzProvider_$eq(ClazzProvider x$1) {
        this.clazzProvider = x$1;
    }

    public WebBusinessLogger businessLogger() {
        return this.businessLogger;
    }

    public void businessLogger_$eq(WebBusinessLogger x$1) {
        this.businessLogger = x$1;
    }

    public CourseTaskService courseTaskService() {
        return this.courseTaskService;
    }

    public void courseTaskService_$eq(CourseTaskService x$1) {
        this.courseTaskService = x$1;
    }

    public View projectIndex(Teacher teacher, Project project) {
        Semester semester = this.getSemester();
        this.put("semester", semester);
        Set clazzes = Collections$.MODULE$.newSet();
        scala.collection.immutable.Seq myClazzes = (scala.collection.immutable.Seq)((SeqOps)this.clazzProvider().getClazzes(semester, teacher, project).filter((Function1 & Serializable)_$4 -> _$4.schedule().activities().nonEmpty())).sortBy((Function1 & Serializable)_$5 -> _$5.crn(), (Ordering)Ordering.String$.MODULE$);
        OqlBuilder q = OqlBuilder$.MODULE$.from(CourseTask.class, "c");
        q.where("c.course.project=:project", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{project}));
        q.where("c.semester=:semester", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{semester}));
        q.where("c.director=:me", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{teacher}));
        scala.collection.immutable.Seq tasks = this.entityDao().search((QueryBuilder)q);
        if (tasks.nonEmpty()) {
            ClazzPlanHelper helper = new ClazzPlanHelper(this.entityDao());
            tasks.foreach((Function1 & Serializable)task -> (Set)clazzes.addAll(helper.getCourseTaskClazzes((CourseTask)task)));
        }
        Buffer scheduled = (Buffer)((IterableOnceOps)clazzes.filter((Function1 & Serializable)_$6 -> _$6.schedule().activities().nonEmpty())).toBuffer().sortBy((Function1 & Serializable)_$7 -> _$7.crn(), (Ordering)Ordering.String$.MODULE$);
        scheduled.subtractAll((IterableOnce)myClazzes);
        scheduled.prependAll((IterableOnce)myClazzes);
        if (scheduled.nonEmpty()) {
            this.put("plans", ((IterableOnceOps)this.entityDao().findBy(ClazzPlan.class, "clazz", (Object)scheduled).map((Function1 & Serializable)x -> Tuple2$.MODULE$.apply((Object)x.clazz(), x))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
            scala.collection.immutable.Seq clazzPrograms = this.entityDao().findBy(ClazzProgram.class, "clazz", (Object)scheduled);
            this.put("programs", ((IterableOnceOps)clazzPrograms.map((Function1 & Serializable)x -> Tuple2$.MODULE$.apply((Object)x.clazz(), x))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
            scala.collection.immutable.Set courses = ((IterableOnceOps)scheduled.map((Function1 & Serializable)_$8 -> _$8.course())).toSet();
            OqlBuilder p = OqlBuilder$.MODULE$.from(ClazzProgram.class, "c");
            p.where("c.clazz.project=:project", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{project}));
            p.where("c.semester=:semester", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{semester}));
            p.where("c.clazz.course in(:courses)", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{courses}));
            scala.collection.immutable.Seq programs = this.entityDao().search((QueryBuilder)p);
            Iterable tasks2 = new ClazzPlanHelper(this.entityDao()).findCourseTasks((Iterable<Clazz>)scheduled).values();
            Map coursePrograms = Collections$.MODULE$.newMap();
            tasks2.foreach((Function1)(JProcedure1 & Serializable)task -> programs.find((Function1 & Serializable)p -> {
                Course course = p.clazz().course();
                Course course2 = task.course();
                if (course == null) {
                    if (course2 != null) {
                        return false;
                    }
                } else if (!course.equals(course2)) return false;
                String string = ((Teacher)task.director().get()).code();
                String string2 = p.writer().code();
                if (string == null) {
                    if (string2 == null) return true;
                    return false;
                } else {
                    if (!string.equals(string2)) return false;
                    return true;
                }
            }).foreach((Function1 & Serializable)pr -> coursePrograms.put((Object)task.course(), pr)));
            this.put("coursePrograms", coursePrograms);
        } else {
            this.put("plans", Predef$.MODULE$.Map().empty());
            this.put("programs", Predef$.MODULE$.Map().empty());
        }
        this.put("clazzes", scheduled);
        return this.forward(this.forward$default$1());
    }

    public View edit() {
        Clazz clazz = (Clazz)this.entityDao().get(Clazz.class, (Object)BoxesRunTime.boxToLong((long)this.getLongId("clazz")));
        ClazzPlan plan = (ClazzPlan)this.entityDao().findBy(ClazzPlan.class, "clazz", (Object)clazz).head();
        this.put("clazz", clazz);
        this.put("plan", plan);
        this.put("schedules", LessonSchedule$.MODULE$.convert(clazz));
        this.put("schedule", ScheduleDigestor$.MODULE$.digest(clazz, ":day :units(:time) :weeks :room"));
        scala.collection.immutable.Seq programs = this.entityDao().findBy(ClazzProgram.class, "clazz", (Object)clazz);
        ClazzProgram program = (ClazzProgram)programs.headOption().getOrElse(() -> ReviseAction.$anonfun$6(clazz));
        if (!program.persisted()) {
            Object[] objectArray = new Tuple2[2];
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"school");
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)plan.clazz().project().school());
            String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"code");
            objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)Securities$.MODULE$.user());
            program.writer_$eq((User)this.entityDao().findBy(User.class, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)).head());
            program.updatedAt_$eq(Instant.now());
            this.entityDao().saveOrUpdate((Object)program, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ClazzProgram[0]));
        }
        this.put("program", program);
        Project project = program.clazz().project();
        ProjectProfile$.MODULE$.set(project);
        return this.forward(this.forward$default$1());
    }

    public View info() {
        ClazzProgram program = (ClazzProgram)this.entityDao().get(ClazzProgram.class, (Object)BoxesRunTime.boxToLong((long)this.getLongId("program")));
        Clazz clazz = (Clazz)this.entityDao().get(Clazz.class, (Object)BoxesRunTime.boxToLong((long)this.getLongId("clazz")));
        ClazzPlan plan = (ClazzPlan)this.entityDao().findBy(ClazzPlan.class, "clazz", (Object)clazz).head();
        this.put("clazz", clazz);
        this.put("plan", plan);
        this.put("schedules", LessonSchedule$.MODULE$.convert(clazz));
        this.put("schedule", ScheduleDigestor$.MODULE$.digest(clazz, ":day :units(:time) :weeks :room"));
        this.put("program", program);
        Project project = program.clazz().project();
        ProjectProfile$.MODULE$.set(project);
        return this.forward(this.forward$default$1());
    }

    public View save() {
        return this.forward(this.forward$default$1());
    }

    public View editDesign() {
        LessonDesign lessonDesign;
        ClazzProgram program = (ClazzProgram)this.entityDao().get(ClazzProgram.class, (Object)BoxesRunTime.boxToLong((long)this.getLongId("program")));
        Option option = this.getLong("design.id");
        if (option instanceof Some) {
            long id = BoxesRunTime.unboxToLong((Object)((Some)option).value());
            lessonDesign = (LessonDesign)this.entityDao().get(LessonDesign.class, (Object)BoxesRunTime.boxToLong((long)id));
        } else if (None$.MODULE$.equals(option)) {
            int idx = this.getInt("idx", 1);
            lessonDesign = (LessonDesign)program.get(idx).getOrElse(() -> ReviseAction.$anonfun$7(program, idx));
        } else {
            throw new MatchError((Object)option);
        }
        LessonDesign design = lessonDesign;
        Seq schedules = LessonSchedule$.MODULE$.convert(program.clazz());
        if (design.idx() - 1 < schedules.length()) {
            design.creditHours_$eq(((LessonSchedule)schedules.apply(design.idx() - 1)).hours());
        }
        this.getLong("from.id").foreach((Function1)(JFunction1.mcVJ.sp & Serializable)fromId -> {
            LessonDesign fromDesign = (LessonDesign)this.entityDao().get(LessonDesign.class, (Object)BoxesRunTime.boxToLong((long)fromId));
            this.copyTo(fromDesign, design);
            this.put("fromDesign", fromDesign);
        });
        OqlBuilder q = OqlBuilder$.MODULE$.from(LessonDesign.class, "d");
        q.where("d.program.clazz.project=:project", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{program.clazz().project()}));
        q.where("d.idx = :idx", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)design.idx())}));
        q.where("d.program.clazz.course=:course", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{program.clazz().course()}));
        q.where("d.program.clazz.semester=:semester", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{program.clazz().semester()}));
        if (design.persisted()) {
            q.where("d.id != :designId", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{design.id()}));
        }
        Buffer otherDesigns = this.entityDao().search((QueryBuilder)q).toBuffer();
        OqlBuilder q2 = OqlBuilder$.MODULE$.from(LessonDesign.class, "d");
        q2.where("d.program.clazz.project=:project", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{program.clazz().project()}));
        q2.where("d.idx = :idx", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)design.idx())}));
        q2.where("d.program.clazz.semester.beginOn <= :beginOn", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{program.clazz().semester().beginOn()}));
        q2.where("(d.program.clazz.course=:course or d.program.writer.code=:me)", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{program.clazz().course(), Securities$.MODULE$.user()}));
        if (design.persisted()) {
            q2.where("d.id != :designId", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{design.id()}));
        }
        otherDesigns.addAll((IterableOnce)this.entityDao().search((QueryBuilder)q2));
        this.put("otherDesigns", otherDesigns);
        this.put("design", design);
        this.put("program", program);
        return this.forward(this.forward$default$1());
    }

    @response
    public Properties uploadImage() {
        Properties rs = new Properties();
        rs.put((Object)"error", (Object)BoxesRunTime.boxToInteger((int)0));
        ClazzProgram program = (ClazzProgram)this.entityDao().get(ClazzProgram.class, (Object)BoxesRunTime.boxToLong((long)this.getLongId("program")));
        Teacher teacher = this.getTeacher();
        Clazz clazz = program.clazz();
        Option option = this.get("imgFile", Part.class);
        if (option instanceof Some) {
            Part part = (Part)((Some)option).value();
            Repository blob = EmsApp$.MODULE$.getBlobRepository(true);
            String storeName = part.getSubmittedFileName();
            BlobMeta meta = blob.upload("/course/program/" + program.id() + "/", part.getInputStream(), storeName, teacher.code() + " " + teacher.name());
            rs.put((Object)"url", blob.path(meta.filePath()).get());
            v0 = rs.put((Object)"message", (Object)"\u4e0a\u4f20\u6210\u529f");
        } else if (None$.MODULE$.equals(option)) {
            rs.put((Object)"error", (Object)BoxesRunTime.boxToInteger((int)1));
            v0 = rs.put((Object)"message", (Object)"\u56fe\u7247\u4e0d\u80fd\u4e3a\u7a7a");
        } else {
            throw new MatchError((Object)option);
        }
        return rs;
    }

    public View saveDesign() {
        int idx;
        ClazzProgram program = (ClazzProgram)this.entityDao().get(ClazzProgram.class, (Object)BoxesRunTime.boxToLong((long)this.getLongId("program")));
        LessonDesign design = (LessonDesign)program.get(idx = this.getInt("design.idx", 1)).getOrElse(() -> ReviseAction.$anonfun$8(program, idx));
        if (!design.persisted()) {
            program.designs().addOne((Object)design);
        }
        design.subject_$eq((String)this.get("design.subject", ""));
        design.homework_$eq(this.get("design.homework"));
        Clazz clazz = program.clazz();
        this.populateText(design, "design.target");
        this.populateText(design, "design.emphasis");
        this.populateText(design, "design.difficulties");
        this.populateText(design, "design.resources");
        this.populateText(design, "design.values");
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 10).foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            String title = (String)this.get("sections[" + i + "].title", "");
            int duration = this.getInt("sections[" + i + "].duration", 0);
            String summary = ((String)this.get("sections[" + i + "].summary", " ")).trim();
            String details = ((String)this.get("sections[" + i + "].details", " ")).trim();
            if (Strings$.MODULE$.isNotBlank((CharSequence)title)) {
                LessonDesignSection section2 = (LessonDesignSection)design.getSection(i).getOrElse(() -> ReviseAction.$anonfun$9(design, i, title, duration, summary, details));
                section2.title_$eq(title);
                section2.duration_$eq(duration);
                section2.summary_$eq(summary);
                section2.details_$eq(details);
                design.sections().$plus$eq((Object)section2);
                if (!section2.persisted()) {
                    design.sections().$plus$eq((Object)section2);
                    return;
                }
                return;
            }
            design.getSection(i).foreach((Function1 & Serializable)section -> design.sections().subtractOne(section));
        });
        ClazzProgramHelper$.MODULE$.updateStatInfo(program);
        this.entityDao().saveOrUpdate((Object)design, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LessonDesign[0]));
        Object[] objectArray = new Tuple2[1];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"program");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)program.id().toString());
        this.businessLogger().info("\u4fdd\u5b58\u4e86\u6559\u6848:" + clazz.course().name() + " \u7b2c" + idx + "\u6b21\u8bfe", design.id(), Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)));
        return this.redirect("designInfo", "design.id=" + design.id() + "&editable=1", "info.save.success");
    }

    public View designInfo() {
        LessonDesign design = (LessonDesign)this.entityDao().get(LessonDesign.class, (Object)BoxesRunTime.boxToLong((long)this.getLongId("design")));
        this.put("design", design);
        Clazz clazz = design.program().clazz();
        ClazzPlan plan = (ClazzPlan)this.entityDao().findBy(ClazzPlan.class, "clazz", (Object)clazz).head();
        this.put("plan", plan);
        this.put("program", design.program());
        return this.forward(this.forward$default$1());
    }

    public View designReport() {
        Clazz clazz;
        LessonDesign design = (LessonDesign)this.entityDao().get(LessonDesign.class, (Object)BoxesRunTime.boxToLong((long)this.getLongId("design")));
        this.put("design", design);
        Option option = this.getLong("clazz.id");
        if (None$.MODULE$.equals(option)) {
            clazz = design.program().clazz();
        } else if (option instanceof Some) {
            long clazzId = BoxesRunTime.unboxToLong((Object)((Some)option).value());
            clazz = (Clazz)this.entityDao().get(Clazz.class, (Object)BoxesRunTime.boxToLong((long)clazzId));
        } else {
            throw new MatchError((Object)option);
        }
        Clazz clazz2 = clazz;
        this.put("plan", this.entityDao().findBy(ClazzPlan.class, "clazz", (Object)clazz2).headOption());
        Option<Syllabus> syllabus = new ClazzPlanHelper(this.entityDao()).findSyllabus(clazz2);
        this.put("clazz", clazz2);
        this.put("syllabus", syllabus);
        Project project = design.program().clazz().project();
        ProjectProfile$.MODULE$.set(project);
        return this.forward("/org/openurp/edu/course/web/components/program/designReport");
    }

    public View designPdf() {
        long id = this.getLongId("design");
        long clazzId = this.getLongId("clazz");
        LessonDesign design = (LessonDesign)this.entityDao().get(LessonDesign.class, (Object)BoxesRunTime.boxToLong((long)id));
        String url = EmsApi$.MODULE$.url("/program/revise/designReport?design.id=" + id + "&clazz.id=" + clazzId);
        File pdf = File.createTempFile("doc", ".pdf");
        PrintOptions options = new PrintOptions();
        SPDConverter$.MODULE$.getInstance().convert(URI.create(url), pdf, options);
        Clazz clazz = design.program().clazz();
        return Stream$.MODULE$.apply(pdf, clazz.crn() + "_" + clazz.course().name() + (" \u6388\u8bfe\u6559\u6848 \u7b2c" + design.idx() + "\u6b21\u8bfe.pdf")).cleanup((Function0)(JFunction0.mcV.sp & Serializable)() -> pdf.delete());
    }

    private void populateText(LessonDesign design, String name) {
        String contents = this.cleanText((String)this.get(name, ""));
        String textName = name.substring("design.".length());
        Option option = design.getText(textName);
        if (None$.MODULE$.equals(option)) {
            if (Strings$.MODULE$.isNotBlank((CharSequence)contents)) {
                LessonDesignText o = new LessonDesignText(design, textName, contents);
                design.texts().$plus$eq((Object)o);
                return;
            }
            return;
        }
        if (option instanceof Some) {
            LessonDesignText o = (LessonDesignText)((Some)option).value();
            if (Strings$.MODULE$.isBlank((CharSequence)contents)) {
                design.texts().$minus$eq((Object)o);
                return;
            }
            o.contents_$eq(contents);
            return;
        }
        throw new MatchError((Object)option);
    }

    public View importSetting() {
        this.put("program", this.entityDao().get(ClazzProgram.class, (Object)BoxesRunTime.boxToLong((long)this.getLongId("program"))));
        this.put("idx", BoxesRunTime.boxToInteger((int)this.getInt("idx", 1)));
        return this.forward(this.forward$default$1());
    }

    public View importDesign() {
        ClazzProgram program = (ClazzProgram)this.entityDao().get(ClazzProgram.class, (Object)BoxesRunTime.boxToLong((long)this.getLongId("program")));
        int index = this.getInt("idx", 0);
        this.put("program", program);
        this.put("idx", BoxesRunTime.boxToInteger((int)index));
        Teacher teacher = this.getTeacher();
        Option option = this.get("attachment", Part.class);
        if (option instanceof Some) {
            Part part = (Part)((Some)option).value();
            Tuple3<Option<LessonDesign>, Option<Document>, String> rs = new LessonDesignDocParser().parse(part.getInputStream());
            if (((Option)rs._1()).nonEmpty()) {
                LessonDesign lessonDesign;
                Option option2 = program.get(index);
                if (option2 instanceof Some) {
                    LessonDesign d = (LessonDesign)((Some)option2).value();
                    lessonDesign = this.copyTo((LessonDesign)((Option)rs._1()).get(), d);
                } else if (None$.MODULE$.equals(option2)) {
                    LessonDesign d = (LessonDesign)((Option)rs._1()).get();
                    d.idx_$eq(index);
                    d.program_$eq(program);
                    program.designs().addOne((Object)d);
                    lessonDesign = d;
                } else {
                    throw new MatchError((Object)option2);
                }
                LessonDesign design = lessonDesign;
                ClazzProgramHelper$.MODULE$.updateStatInfo(program);
                Repository blob = EmsApp$.MODULE$.getBlobRepository(true);
                ((Option)rs._2()).foreach((Function1)(JProcedure1 & Serializable)doc -> doc.images().foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
                    String string = (String)x$1._1();
                    byte[] byArray = (byte[])x$1._2();
                    BlobMeta meta = blob.upload("/course/program/" + program.id() + "/" + design.id() + "/", (InputStream)new ByteArrayInputStream(byArray), string, teacher.code() + " " + teacher.name());
                    design.sections().foreach((Function1)(JProcedure1 & Serializable)section -> {
                        ObjectRef path = ObjectRef.create((Object)((String)blob.path(meta.filePath()).get()));
                        path.elem = ((String)path.elem).substring(Ems$.MODULE$.base().length());
                        section.summary_$eq(section.summary().replaceAll(string, (String)path.elem));
                        section.details_$eq(section.details().replaceAll(string, (String)path.elem));
                        design.homework().foreach((Function1)(JProcedure1 & Serializable)hw -> design.homework_$eq((Option)Some$.MODULE$.apply((Object)hw.replaceAll(string, (String)path$1.elem))));
                    });
                }));
                this.entityDao().saveOrUpdate((Object)design, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LessonDesign[0]));
                Object[] objectArray = new Tuple2[1];
                String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"program");
                objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)program.id().toString());
                this.businessLogger().info("\u5bfc\u5165\u6559\u6848:" + program.clazz().course().name() + " \u7b2c" + index + "\u6b21\u8bfe", design.id(), Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)));
                return this.redirect("designInfo", "design.id=" + design.id() + "&editable=1", "\u8bc6\u522b\u5b8c\u6210\uff0c\u8bf7\u6838\u5bf9");
            }
            this.addError("\u6587\u4ef6\u89e3\u6790\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u662f\u5426\u7b26\u5408\u6a21\u677f\u8981\u6c42:" + rs._3(), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
            return this.forward("importSetting");
        }
        if (None$.MODULE$.equals(option)) {
            this.addError("\u7f3a\u5c11word\u6587\u4ef6", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
            return this.forward("importSetting");
        }
        throw new MatchError((Object)option);
    }

    private LessonDesign copyTo(LessonDesign src, LessonDesign dest) {
        dest.homework_$eq(src.homework());
        dest.subject_$eq(src.subject());
        src.texts().foreach((Function1 & Serializable)st -> {
            String k = st.name();
            String v = st.contents();
            Option option = dest.getText(k);
            if (option instanceof Some) {
                LessonDesignText t = (LessonDesignText)((Some)option).value();
                t.contents_$eq(v);
                return BoxedUnit.UNIT;
            }
            if (None$.MODULE$.equals(option)) {
                LessonDesignText t = new LessonDesignText(dest, k, v);
                return dest.texts().addOne((Object)t);
            }
            throw new MatchError((Object)option);
        });
        scala.collection.immutable.Set textNames = ((IterableOnceOps)src.texts().map((Function1 & Serializable)_$9 -> _$9.name())).toSet();
        Buffer abandons = (Buffer)dest.texts().filter((Function1 & Serializable)x -> !textNames.contains((Object)x.name()));
        dest.texts().subtractAll((IterableOnce)abandons);
        src.sections().foreach((Function1 & Serializable)section -> {
            Option option = dest.getSection(section.idx());
            if (option instanceof Some) {
                LessonDesignSection ds = (LessonDesignSection)((Some)option).value();
                ds.idx_$eq(section.idx());
                ds.duration_$eq(section.duration());
                ds.title_$eq(section.title());
                ds.summary_$eq(section.summary());
                ds.details_$eq(section.details());
                return BoxedUnit.UNIT;
            }
            if (None$.MODULE$.equals(option)) {
                LessonDesignSection ds = new LessonDesignSection(dest, section.idx(), section.title(), section.duration(), section.summary(), section.details());
                return dest.sections().addOne((Object)ds);
            }
            throw new MatchError((Object)option);
        });
        scala.collection.immutable.Set sectionIndices = ((IterableOnceOps)src.sections().map((Function1 & Serializable)_$10 -> _$10.idx())).toSet();
        Buffer abandonSections = (Buffer)dest.sections().filter((Function1 & Serializable)x -> !sectionIndices.contains((Object)BoxesRunTime.boxToInteger((int)x.idx())));
        dest.sections().subtractAll((IterableOnce)abandonSections);
        return dest;
    }

    public View removeDesign() {
        LessonDesign design = (LessonDesign)this.entityDao().get(LessonDesign.class, (Object)BoxesRunTime.boxToLong((long)this.getLongId("design")));
        ClazzProgram program = design.program();
        program.designs().subtractOne((Object)design);
        ClazzProgramHelper$.MODULE$.updateStatInfo(program);
        this.entityDao().remove((Object)design, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LessonDesign[0]));
        Object[] objectArray = new Tuple2[1];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"program");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)program.id().toString());
        this.businessLogger().info("\u5220\u9664\u6559\u6848:" + program.clazz().course().name() + " \u7b2c" + design.idx() + "\u6b21\u8bfe", design.id(), Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)));
        return this.redirect("edit", "clazz.id=" + program.clazz().id(), "\u5220\u9664\u6210\u529f");
    }

    public View remove() {
        ClazzProgram program = (ClazzProgram)this.entityDao().get(ClazzProgram.class, (Object)BoxesRunTime.boxToLong((long)this.getLongId("program")));
        String string = program.writer().code();
        String string2 = Securities$.MODULE$.user();
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            if (program.designs().isEmpty()) {
                this.entityDao().remove((Object)program, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ClazzProgram[0]));
                return this.redirect("index", "\u5220\u9664\u6210\u529f");
            }
            return this.redirect("index", "\u8be5\u6559\u6848\u5185\u90e8\u8fd8\u6709\u5185\u5bb9\uff0c\u65e0\u6cd5\u5220\u9664,\u5220\u9664\u5931\u8d25");
        }
        return this.redirect("index", "\u5220\u9664\u5931\u8d25");
    }

    public View copyDesign() {
        long id = this.getLongId("from");
        return this.forward(this.forward$default$1());
    }

    private String cleanText(String contents) {
        return Strings$.MODULE$.replace(contents, "\r", "").trim();
    }

    public View report() {
        return this.forward(this.forward$default$1());
    }

    public View pdf() {
        long id = this.getLongId("plan");
        ClazzPlan plan = (ClazzPlan)this.entityDao().get(ClazzPlan.class, (Object)BoxesRunTime.boxToLong((long)id));
        return this.forward(this.forward$default$1());
    }

    private static final ClazzProgram $anonfun$6(Clazz clazz$1) {
        return new ClazzProgram(clazz$1);
    }

    private static final LessonDesign $anonfun$7(ClazzProgram program$1, int idx$1) {
        return new LessonDesign(program$1, idx$1);
    }

    private static final LessonDesign $anonfun$8(ClazzProgram program$2, int idx$2) {
        return new LessonDesign(program$2, idx$2);
    }

    private static final LessonDesignSection $anonfun$9(LessonDesign design$3, int i$1, String title$1, int duration$1, String summary$1, String details$1) {
        return new LessonDesignSection(design$3, i$1, title$1, duration$1, summary$1, details$1);
    }
}

