/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.course.web.action.syllabus;

import java.io.File;
import java.io.Serializable;
import java.net.URI;
import java.time.Instant;
import java.util.Locale;
import org.beangle.commons.collection.Collections$;
import org.beangle.commons.collection.Properties;
import org.beangle.commons.lang.Locales$;
import org.beangle.commons.lang.Strings$;
import org.beangle.data.dao.OqlBuilder;
import org.beangle.data.dao.OqlBuilder$;
import org.beangle.data.dao.QueryBuilder;
import org.beangle.data.model.Entity;
import org.beangle.data.model.LongId;
import org.beangle.data.model.meta.EntityType;
import org.beangle.doc.core.PrintOptions;
import org.beangle.doc.pdf.SPDConverter$;
import org.beangle.ems.app.EmsApi$;
import org.beangle.ems.app.web.WebBusinessLogger;
import org.beangle.security.Securities$;
import org.beangle.webmvc.annotation.mapping;
import org.beangle.webmvc.annotation.response;
import org.beangle.webmvc.support.EntitySupport;
import org.beangle.webmvc.support.action.EntityAction;
import org.beangle.webmvc.support.helper.PopulateHelper$;
import org.beangle.webmvc.view.Status$;
import org.beangle.webmvc.view.Stream$;
import org.beangle.webmvc.view.View;
import org.openurp.base.edu.model.Course;
import org.openurp.base.edu.model.CourseCluster;
import org.openurp.base.edu.model.CourseProfile;
import org.openurp.base.edu.model.Experiment;
import org.openurp.base.edu.model.Major;
import org.openurp.base.edu.model.Textbook;
import org.openurp.base.hr.model.Teacher;
import org.openurp.base.model.AuditStatus;
import org.openurp.base.model.AuditStatus$;
import org.openurp.base.model.CalendarStage;
import org.openurp.base.model.Department;
import org.openurp.base.model.Project;
import org.openurp.base.model.Semester;
import org.openurp.base.model.User;
import org.openurp.code.edu.model.CourseModule;
import org.openurp.code.edu.model.CourseNature;
import org.openurp.code.edu.model.CourseRank;
import org.openurp.code.edu.model.CourseRank$;
import org.openurp.code.edu.model.CourseType;
import org.openurp.code.edu.model.ExamMode;
import org.openurp.code.edu.model.ExperimentCategory;
import org.openurp.code.edu.model.ExperimentType;
import org.openurp.code.edu.model.GradeType;
import org.openurp.code.edu.model.GradeType$;
import org.openurp.code.edu.model.GradingMode;
import org.openurp.code.edu.model.GraduateObjective;
import org.openurp.code.edu.model.Level1Discipline;
import org.openurp.code.edu.model.SyllabusTopicLabel;
import org.openurp.code.edu.model.TeachingNature;
import org.openurp.edu.clazz.domain.ClazzProvider;
import org.openurp.edu.clazz.model.Clazz;
import org.openurp.edu.course.model.CourseTask;
import org.openurp.edu.course.model.Syllabus;
import org.openurp.edu.course.model.Syllabus$;
import org.openurp.edu.course.model.SyllabusAssessment;
import org.openurp.edu.course.model.SyllabusCase;
import org.openurp.edu.course.model.SyllabusExperiment;
import org.openurp.edu.course.model.SyllabusHour;
import org.openurp.edu.course.model.SyllabusMethodDesign;
import org.openurp.edu.course.model.SyllabusObjective;
import org.openurp.edu.course.model.SyllabusOutcome;
import org.openurp.edu.course.model.SyllabusText;
import org.openurp.edu.course.model.SyllabusTopic;
import org.openurp.edu.course.model.SyllabusTopicElement;
import org.openurp.edu.course.model.SyllabusTopicHour;
import org.openurp.edu.course.service.CourseTaskService;
import org.openurp.edu.course.web.helper.SyllabusHelper;
import org.openurp.edu.course.web.helper.SyllabusValidator$;
import org.openurp.edu.schedule.service.LessonSchedule$;
import org.openurp.starter.web.helper.ProjectProfile$;
import org.openurp.starter.web.support.TeacherSupport;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Map;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LazyRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

public class ReviseAction
extends TeacherSupport
implements EntityAction<Syllabus> {
    private Class entityClass;
    private ClazzProvider clazzProvider;
    private WebBusinessLogger businessLogger;
    private CourseTaskService courseTaskService;

    public ReviseAction() {
        EntitySupport.$init$((EntitySupport)this);
        Statics.releaseFence();
    }

    public Class entityClass() {
        return this.entityClass;
    }

    public void org$beangle$webmvc$support$EntitySupport$_setter_$entityClass_$eq(Class x$0) {
        this.entityClass = x$0;
    }

    public ClazzProvider clazzProvider() {
        return this.clazzProvider;
    }

    public void clazzProvider_$eq(ClazzProvider x$1) {
        this.clazzProvider = x$1;
    }

    public WebBusinessLogger businessLogger() {
        return this.businessLogger;
    }

    public void businessLogger_$eq(WebBusinessLogger x$1) {
        this.businessLogger = x$1;
    }

    public CourseTaskService courseTaskService() {
        return this.courseTaskService;
    }

    public void courseTaskService_$eq(CourseTaskService x$1) {
        this.courseTaskService = x$1;
    }

    public View projectIndex(Teacher teacher, Project project) {
        Semester semester = this.getSemester();
        scala.collection.immutable.Seq tasks = this.courseTaskService().getTasks(project, semester, teacher);
        scala.collection.immutable.Seq taskCourses = (scala.collection.immutable.Seq)tasks.map((Function1 & Serializable)_$4 -> _$4.course());
        Buffer clazzCourses = (Buffer)((IterableOnceOps)this.clazzProvider().getClazzes(semester, teacher, project).map((Function1 & Serializable)_$5 -> _$5.course())).toSet().toBuffer().subtractAll((IterableOnce)taskCourses);
        OqlBuilder query2 = OqlBuilder$.MODULE$.from(Clazz.class.getName(), "c");
        query2.join("c.teachers", "t");
        query2.where("c.semester.beginOn <= :today", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{semester.beginOn()}));
        query2.where("t.staff.code=:me", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{Securities$.MODULE$.user()}));
        query2.select("distinct c.course");
        query2.orderBy("c.course.code");
        Buffer hisCourses = Collections$.MODULE$.newBuffer((Iterable)this.entityDao().search((QueryBuilder)query2));
        hisCourses.subtractAll((IterableOnce)clazzCourses);
        hisCourses.subtractAll((IterableOnce)taskCourses);
        this.put("taskCourses", taskCourses);
        this.put("clazzCourses", clazzCourses);
        this.put("hisCourses", hisCourses);
        this.put("courses", taskCourses.$plus$plus((IterableOnce)clazzCourses));
        this.put("project", project);
        this.put("semester", semester);
        return this.forward(this.forward$default$1());
    }

    public View edit() {
        LazyRef lazyRef = new LazyRef();
        Syllabus syllabus = (Syllabus)this.entityDao().get(Syllabus.class, (Object)BoxesRunTime.boxToLong((long)this.getLongId("syllabus")));
        this.put("course", syllabus.course());
        this.put("syllabus", syllabus);
        syllabus.creditHours_$eq(syllabus.course().getJournal(syllabus.semester()).creditHours());
        this.entityDao().saveOrUpdate((Object)syllabus, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Syllabus[0]));
        this.putBasicDatas(syllabus.course());
        if (this.get("step").contains((Object)"textbook")) {
            this.put("textbooks", this.entityDao().getAll(Textbook.class));
            if (syllabus.textbooks().isEmpty()) {
                Object[] objectArray = new Tuple2[2];
                String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"course");
                objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)syllabus.course());
                String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"semester");
                objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)syllabus.semester());
                scala.collection.immutable.Seq clazzes = this.entityDao().findBy(Clazz.class, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
                scala.collection.immutable.Seq books = (scala.collection.immutable.Seq)((SeqOps)clazzes.flatMap((Function1 & Serializable)_$6 -> _$6.books())).distinct();
                syllabus.textbooks().addAll((IterableOnce)books);
            }
            this.put("director", this.courseTaskService().getOfficeDirector(syllabus.semester(), syllabus.course(), syllabus.department()));
            this.put("me", Securities$.MODULE$.user());
            this.put("warningMessages", SyllabusValidator$.MODULE$.validate(syllabus));
        }
        if (this.get("step").contains((Object)"requirements")) {
            Buffer orderedOutcomes = (Buffer)syllabus.outcomes().sortBy((Function1 & Serializable)_$7 -> _$7.idx(), (Ordering)Ordering.Int$.MODULE$);
            IntRef idx = IntRef.create((int)1);
            orderedOutcomes.foreach((Function1)(JProcedure1 & Serializable)o -> {
                o.idx_$eq(idx$1.elem);
                ++idx$1.elem;
            });
            this.entityDao().saveOrUpdate((Object)syllabus, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Syllabus[0]));
            Buffer requirements = (Buffer)orderedOutcomes.map((Function1 & Serializable)_$8 -> _$8.title());
            if (requirements.isEmpty()) {
                Locale locale = syllabus.docLocale();
                Locale locale2 = Locale.SIMPLIFIED_CHINESE;
                if (!(locale != null ? !((Object)locale).equals(locale2) : locale2 != null)) {
                    requirements.addAll((IterableOnce)((IterableOps)this.entityDao().getAll(GraduateObjective.class).sortBy((Function1 & Serializable)_$9 -> _$9.code(), (Ordering)Ordering.String$.MODULE$)).map((Function1 & Serializable)_$10 -> _$10.name()));
                } else {
                    requirements.addAll((IterableOnce)((IterableOps)this.entityDao().getAll(GraduateObjective.class).sortBy((Function1 & Serializable)_$11 -> _$11.code(), (Ordering)Ordering.String$.MODULE$)).map((Function1 & Serializable)_$12 -> _$12.enName2()));
                }
            }
            this.put("requirements", requirements);
        }
        if (this.get("step").contains((Object)"topics")) {
            if (syllabus.examCreditHours() == 0) {
                IntRef examHours = IntRef.create((int)0);
                Option<Clazz> first = this.findScheduledClazz(syllabus.course(), syllabus.semester());
                first.foreach((Function1)(JProcedure1 & Serializable)clazz -> {
                    int scheduleHours = BoxesRunTime.unboxToInt((Object)((IterableOnceOps)LessonSchedule$.MODULE$.convert(clazz).map((Function1 & Serializable)_$13 -> _$13.hours())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
                    if (scheduleHours <= syllabus.creditHours()) {
                        examHours$1.elem = syllabus.creditHours() - scheduleHours;
                        return;
                    }
                });
                if (examHours.elem > 0 && !syllabus.topics().exists((Function1 & Serializable)_$14 -> _$14.exam())) {
                    SyllabusTopic examTopic = new SyllabusTopic();
                    examTopic.syllabus_$eq(syllabus);
                    examTopic.idx_$eq((short)99);
                    examTopic.exam_$eq(true);
                    Locale locale = syllabus.docLocale();
                    Locale locale3 = Locale.SIMPLIFIED_CHINESE;
                    if (!(locale != null ? !((Object)locale).equals(locale3) : locale3 != null)) {
                        examTopic.name_$eq("\u671f\u672b\u8003\u6838");
                        examTopic.contents_$eq(" ");
                    } else {
                        examTopic.name_$eq("Course assessments");
                        examTopic.contents_$eq(" ");
                    }
                    syllabus.examCreditHours_$eq(examHours.elem);
                    syllabus.topics().addOne((Object)examTopic);
                    this.entityDao().saveOrUpdate((Object)syllabus, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Syllabus[0]));
                    this.put("examTopic", examTopic);
                }
            }
            this.put("topicLabels", this.getCodes(SyllabusTopicLabel.class, ReviseAction.project$1(lazyRef, syllabus)));
            this.put("teachingMethods", ((IterableOnceOps)syllabus.teachingMethods().map((Function1 & Serializable)x -> Tuple2$.MODULE$.apply(x, x))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
            this.put("validateHourMessages", SyllabusValidator$.MODULE$.validateHours(syllabus).$plus$plus(SyllabusValidator$.MODULE$.validateObjectives(syllabus)));
        }
        if (this.get("step").isEmpty()) {
            Object[] objectArray = new Tuple2[1];
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"project");
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)syllabus.course().project());
            scala.collection.immutable.Seq majors = this.entityDao().findBy(Major.class, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
            scala.collection.immutable.Seq courseMajors = (scala.collection.immutable.Seq)majors.filter((Function1 & Serializable)m -> m.active() && m.journals().exists((Function1 & Serializable)_$15 -> {
                Department department = _$15.depart();
                Department department2 = syllabus.department();
                return !(department != null ? !department.equals(department2) : department2 != null);
            }));
            this.put("majors", courseMajors);
        }
        Locale locale = syllabus.docLocale();
        Option option = this.get("step");
        if (None$.MODULE$.equals(option)) {
            return this.forward(locale + "/form");
        }
        if (option instanceof Some) {
            String s = (String)((Some)option).value();
            return this.forward(locale + "/" + s);
        }
        throw new MatchError((Object)option);
    }

    public View remove() {
        Syllabus syllabus = (Syllabus)this.entityDao().get(Syllabus.class, (Object)BoxesRunTime.boxToLong((long)this.getLongId("syllabus")));
        Semester semester = (Semester)this.entityDao().get(Semester.class, (Object)BoxesRunTime.boxToInteger((int)this.getIntId("semester")));
        String string = syllabus.writer().code();
        String string2 = Securities$.MODULE$.user();
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            Set statuses = (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AuditStatus[]{AuditStatus$.Draft, AuditStatus$.RejectedByDirector, AuditStatus$.RejectedByDepart}));
            if (statuses.contains((Object)syllabus.status())) {
                this.entityDao().remove((Object)syllabus, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Syllabus[0]));
                Object[] objectArray = new Tuple2[1];
                String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"id");
                objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Object)syllabus.id().toString());
                this.businessLogger().info("\u5220\u9664\u8bfe\u7a0b\u6559\u5b66\u5927\u7eb2:" + syllabus.course().name(), syllabus.id(), Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)));
                return this.redirect("course", "course.id=" + syllabus.course().id() + "&semester.id=" + semester.id(), "\u5220\u9664\u6210\u529f");
            }
            return this.redirect("course", "course.id=" + syllabus.course().id() + "&semester.id=" + semester.id(), "\u5927\u7eb2\u72b6\u6001\u4e0d\u5141\u8bb8\u5220\u9664");
        }
        return this.redirect("course", "course.id=" + syllabus.course().id() + "&semester.id=" + semester.id(), "\u53ea\u80fd\u5220\u9664\u81ea\u5df1\u7f16\u5199\u7684\u5927\u7eb2");
    }

    private void putBasicDatas(Course course) {
        LazyRef lazyRef = new LazyRef();
        this.put("project", ReviseAction.project$2(lazyRef, course));
        this.put("departments", new .colon.colon((Object)course.department(), (List)Nil$.MODULE$));
        this.put("teachingNatures", this.getCodes(TeachingNature.class, ReviseAction.project$2(lazyRef, course)));
        this.put("courseNatures", this.getCodes(CourseNature.class, ReviseAction.project$2(lazyRef, course)));
        this.put("examModes", this.getCodes(ExamMode.class, ReviseAction.project$2(lazyRef, course)));
        this.put("gradingModes", this.getCodes(GradingMode.class, ReviseAction.project$2(lazyRef, course)));
        this.put("courseModules", this.getCodes(CourseModule.class, ReviseAction.project$2(lazyRef, course)));
        this.put("courseRanks", this.getCodes(CourseRank.class, ReviseAction.project$2(lazyRef, course)).filter((Function1 & Serializable)_$16 -> BoxesRunTime.unboxToInt((Object)_$16.id()) != CourseRank$.MODULE$.Selective()));
        this.put("experimentTypes", this.getCodes(ExperimentType.class, ReviseAction.project$2(lazyRef, course)));
        OqlBuilder s = OqlBuilder$.MODULE$.from(CalendarStage.class, "s");
        s.where("s.school=:school and s.vacation=false", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{ReviseAction.project$2(lazyRef, course).school()}));
        OqlBuilder oqlBuilder = (OqlBuilder)s.orderBy("s.startWeek");
        oqlBuilder.cacheable(oqlBuilder.cacheable$default$1());
        this.put("calendarStages", this.entityDao().search((QueryBuilder)s));
        Object[] objectArray = new Tuple2[2];
        Locale locale = (Locale)Predef$.MODULE$.ArrowAssoc((Object)Locales$.MODULE$.chinese());
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)locale, (Object)"\u4e2d\u6587\u5927\u7eb2");
        Locale locale2 = (Locale)Predef$.MODULE$.ArrowAssoc((Object)Locales$.MODULE$.us());
        objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)locale2, (Object)"English Syllabus");
        this.put("locales", Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)));
    }

    @mapping(value="new", view="new,form")
    public View editNew() {
        LazyRef lazyRef = new LazyRef();
        Course course = (Course)this.entityDao().get(Course.class, (Object)BoxesRunTime.boxToLong((long)this.getLongId("course")));
        this.putBasicDatas(course);
        Teacher teacher = this.getTeacher();
        Semester semester = (Semester)this.entityDao().get(Semester.class, (Object)BoxesRunTime.boxToInteger((int)this.getIntId("semester")));
        CourseTask task = (CourseTask)this.courseTaskService().getTask(semester, course, teacher).get();
        Syllabus syllabus = this.newSyllabus(task);
        this.put("course", course);
        this.put("syllabus", syllabus);
        Locale locale = (Locale)this.get("locale", Locale.class).getOrElse(ReviseAction::$anonfun$8);
        this.put("locale", locale);
        syllabus.docLocale_$eq(locale);
        Object[] objectArray = new Tuple2[1];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"project");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)syllabus.course().project());
        scala.collection.immutable.Seq majors = this.entityDao().findBy(Major.class, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        scala.collection.immutable.Seq courseMajors = (scala.collection.immutable.Seq)majors.filter((Function1 & Serializable)m -> m.active() && m.journals().exists((Function1 & Serializable)_$17 -> {
            Department department = _$17.depart();
            Department department2 = syllabus.department();
            return !(department != null ? !department.equals(department2) : department2 != null);
        }));
        this.put("majors", courseMajors);
        Option option = this.get("step");
        if (None$.MODULE$.equals(option)) {
            return this.forward(locale + "/form");
        }
        if (option instanceof Some) {
            String s = (String)((Some)option).value();
            return this.forward(locale + "/" + s);
        }
        throw new MatchError((Object)option);
    }

    private Option<Clazz> findScheduledClazz(Course course, Semester semester) {
        Object[] objectArray = new Tuple2[2];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"course");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)course);
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"semester");
        objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)semester);
        return this.entityDao().findBy(Clazz.class, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)).find((Function1 & Serializable)_$18 -> _$18.schedule().activities().nonEmpty());
    }

    private Syllabus newSyllabus(CourseTask task) {
        Option<Clazz> first;
        Course course = task.course();
        Semester semester = task.semester();
        Syllabus syllabus = new Syllabus();
        syllabus.course_$eq(course);
        CourseType ct = task.courseType();
        ct.module().foreach((Function1)(JProcedure1 & Serializable)m -> syllabus.module_$eq(m));
        ct.rank().foreach((Function1)(JProcedure1 & Serializable)m -> syllabus.rank_$eq(m));
        if (ct.name().contains("-")) {
            String prefix = Strings$.MODULE$.substringBefore(ct.name(), "-");
            scala.collection.immutable.Seq stages = (scala.collection.immutable.Seq)this.attribute("calendarStages", scala.collection.immutable.Seq.class);
            stages.find((Function1 & Serializable)_$19 -> _$19.name().startsWith(prefix)).foreach((Function1)(JProcedure1 & Serializable)stage -> syllabus.stage_$eq((Option)Some$.MODULE$.apply(stage)));
        }
        if (syllabus.module() != null && syllabus.module().practical()) {
            scala.collection.immutable.Seq natures = (scala.collection.immutable.Seq)this.attribute("courseNatures", scala.collection.immutable.Seq.class);
            syllabus.nature_$eq((CourseNature)natures.find((Function1 & Serializable)_$20 -> _$20.practical()).get());
        }
        syllabus.department_$eq(course.department());
        syllabus.examMode_$eq(course.examMode());
        syllabus.gradingMode_$eq(course.gradingMode());
        syllabus.creditHours_$eq(course.creditHours());
        syllabus.semester_$eq(semester);
        this.put("examHours", BoxesRunTime.boxToInteger((int)0));
        Option<Clazz> option = first = this.findScheduledClazz(course, semester);
        if (None$.MODULE$.equals(option)) {
            if (course.defaultCredits() > 1.0f || course.creditHours() >= 30) {
                syllabus.examCreditHours_$eq((int)course.defaultCredits());
                this.put("examHours", BoxesRunTime.boxToInteger((int)syllabus.examCreditHours()));
            }
        } else if (option instanceof Some) {
            Clazz clazz = (Clazz)((Some)option).value();
            int scheduleHours = BoxesRunTime.unboxToInt((Object)((IterableOnceOps)LessonSchedule$.MODULE$.convert(clazz).map((Function1 & Serializable)_$21 -> _$21.hours())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
            if (scheduleHours < course.creditHours()) {
                syllabus.examCreditHours_$eq(course.creditHours() - scheduleHours);
            }
            this.put("examHours", BoxesRunTime.boxToInteger((int)syllabus.examCreditHours()));
        } else {
            throw new MatchError(option);
        }
        return syllabus;
    }

    public View save() {
        LazyRef lazyRef = new LazyRef();
        Course course = (Course)this.entityDao().get(Course.class, (Object)BoxesRunTime.boxToLong((long)this.getLongId("course")));
        Syllabus syllabus = (Syllabus)this.populateEntity();
        if (syllabus.beginOn() == null) {
            Semester semester = (Semester)this.entityDao().get(Semester.class, syllabus.semester().id());
            syllabus.beginOn_$eq(semester.beginOn());
            syllabus.endOn_$eq(semester.endOn());
        }
        if (!syllabus.persisted()) {
            syllabus.course_$eq(course);
        }
        if (syllabus.description() == null) {
            syllabus.description_$eq(" ");
        }
        this.populateHours(syllabus, ReviseAction.project$4(lazyRef, course));
        if (syllabus.writer() == null) {
            User me = (User)this.entityDao().findBy(User.class, "code", (Object)Securities$.MODULE$.user()).head();
            syllabus.writer_$eq(me);
        }
        syllabus.creditHours_$eq(course.creditHours());
        List majorIds = this.getLongIds("major");
        syllabus.majors().clear();
        syllabus.majors().addAll((IterableOnce)this.entityDao().find(Major.class, (Iterable)majorIds));
        this.updateState(syllabus);
        this.entityDao().saveOrUpdate((Object)syllabus, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Syllabus[0]));
        Object[] objectArray = new Tuple2[1];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"course");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)course.id().toString());
        this.businessLogger().info("\u4fdd\u5b58\u4e86\u8bfe\u7a0b\u6559\u5b66\u5927\u7eb2:" + course.name(), syllabus.id(), Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)));
        return this.toStep(syllabus);
    }

    private void populateHours(Syllabus syllabus, Project project) {
        Seq teachingNatures = this.getCodes(TeachingNature.class, project);
        teachingNatures.foreach((Function1 & Serializable)ht -> {
            Option creditHour = this.getFloat("creditHour" + ht.id());
            Option option = syllabus.hours().find((Function1 & Serializable)h -> {
                TeachingNature teachingNature = h.nature();
                TeachingNature teachingNature2 = ht;
                return !(teachingNature != null ? !teachingNature.equals(teachingNature2) : teachingNature2 != null);
            });
            if (option instanceof Some) {
                SyllabusHour hour = (SyllabusHour)((Some)option).value();
                if (creditHour.isEmpty()) {
                    return syllabus.hours().$minus$eq((Object)hour);
                }
                hour.creditHours_$eq(BoxesRunTime.unboxToFloat((Object)creditHour.getOrElse(ReviseAction::populateHours$$anonfun$1$$anonfun$2)));
                return BoxedUnit.UNIT;
            }
            if (None$.MODULE$.equals(option)) {
                if (creditHour.nonEmpty()) {
                    syllabus.hours().$plus$eq((Object)new SyllabusHour(syllabus, ht, BoxesRunTime.unboxToFloat((Object)creditHour.getOrElse(ReviseAction::populateHours$$anonfun$1$$anonfun$3))));
                    return BoxedUnit.UNIT;
                }
                return BoxedUnit.UNIT;
            }
            throw new MatchError((Object)option);
        });
        Buffer deprecated = (Buffer)syllabus.hours().filter((Function1 & Serializable)x -> !teachingNatures.contains((Object)x.nature()));
        syllabus.hours().subtractAll((IterableOnce)deprecated);
    }

    private String cleanText(String contents) {
        String c = Strings$.MODULE$.replace(contents, "\r", "");
        c = Strings$.MODULE$.replace(c, "\n", "");
        return c;
    }

    public View saveObjectives() {
        Syllabus syllabus = (Syllabus)this.populateEntity();
        Option option = syllabus.getText("values");
        if (option instanceof Some) {
            SyllabusText values = (SyllabusText)((Some)option).value();
            values.contents_$eq((String)this.get("values", " "));
            v0 = BoxedUnit.UNIT;
        } else if (None$.MODULE$.equals(option)) {
            SyllabusText v = new SyllabusText(syllabus, "2", "values", (String)this.get("values", " "));
            v0 = syllabus.texts().addOne((Object)v);
        } else {
            throw new MatchError((Object)option);
        }
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 8).foreach((Function1 & Serializable)i -> this.saveObjectives$$anonfun$1(syllabus, BoxesRunTime.unboxToInt((Object)i)));
        new SyllabusHelper(this.entityDao()).cleanMissingObjectives(syllabus);
        this.updateState(syllabus);
        this.entityDao().saveOrUpdate((Object)syllabus, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Syllabus[0]));
        this.entityDao().refresh((Object)syllabus);
        Buffer olders = (Buffer)syllabus.objectives().filter((Function1 & Serializable)o1 -> syllabus.objectives().exists((Function1 & Serializable)o2 -> {
            String string = o2.code();
            String string2 = o1.code();
            return !(string != null ? !string.equals(string2) : string2 != null) && BoxesRunTime.unboxToLong((Object)o1.id()) > BoxesRunTime.unboxToLong((Object)o2.id());
        }));
        syllabus.objectives().subtractAll((IterableOnce)olders);
        this.entityDao().saveOrUpdate((Object)syllabus, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Syllabus[0]));
        boolean justSave = this.getBoolean("justSave", false);
        if (justSave) {
            return this.redirect("edit", "syllabus.id=" + syllabus.id() + "&step=objectives", "info.save.success");
        }
        return this.toStep(syllabus);
    }

    public View saveRequirements() {
        Syllabus syllabus = (Syllabus)this.populateEntity();
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 12).foreach((Function1 & Serializable)idx -> this.saveRequirements$$anonfun$1(syllabus, BoxesRunTime.unboxToInt((Object)idx)));
        this.updateState(syllabus);
        this.entityDao().saveOrUpdate((Object)syllabus, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Syllabus[0]));
        boolean justSave = this.getBoolean("justSave", false);
        if (justSave) {
            return this.redirect("edit", "syllabus.id=" + syllabus.id() + "&step=requirements", "info.save.success");
        }
        return this.toStep(syllabus);
    }

    public View saveOutcomes() {
        LazyRef lazyRef = new LazyRef();
        Syllabus syllabus = (Syllabus)this.populateEntity();
        syllabus.outcomes().foreach((Function1)(JProcedure1 & Serializable)r -> {
            String prefix = "R" + r.id();
            Object object = Predef$.MODULE$.refArrayOps((Object[])Strings$.MODULE$.split((String)this.get(prefix + ".courseObjectives", "")));
            String cos = ((IterableOnceOps)ArrayOps$.MODULE$.toSeq$extension(object).sorted((Ordering)Ordering.String$.MODULE$)).mkString(",");
            String contents = this.cleanText((String)this.get(prefix + ".contents", ""));
            r.contents_$eq(contents);
            r.courseObjectives_$eq(cos);
        });
        this.updateState(syllabus);
        this.entityDao().saveOrUpdate((Object)syllabus, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Syllabus[0]));
        boolean justSave = this.getBoolean("justSave", false);
        if (justSave) {
            return this.redirect("edit", "syllabus.id=" + syllabus.id() + "&step=outcomes", "info.save.success");
        }
        return this.toStep(syllabus);
    }

    public View newTopic() {
        LazyRef lazyRef = new LazyRef();
        Syllabus syllabus = (Syllabus)this.entityDao().get(Syllabus.class, (Object)BoxesRunTime.boxToLong((long)this.getLongId("syllabus")));
        SyllabusTopic topic = new SyllabusTopic();
        topic.exam_$eq(this.getBoolean("topic.exam", false));
        topic.idx_$eq((short)(syllabus.topics().size() + 1));
        this.put("teachingNatures", this.getCodes(TeachingNature.class, ReviseAction.project$6(lazyRef, syllabus)));
        this.put("topicLabels", this.getCodes(SyllabusTopicLabel.class, ReviseAction.project$6(lazyRef, syllabus)));
        this.put("topic", topic);
        this.put("teachingMethods", ((IterableOnceOps)syllabus.teachingMethods().map((Function1 & Serializable)x -> Tuple2$.MODULE$.apply(x, x))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
        this.put("syllabus", syllabus);
        return this.forward(syllabus.docLocale() + "/editTopic");
    }

    public View editTopic() {
        LazyRef lazyRef = new LazyRef();
        SyllabusTopic topic = (SyllabusTopic)this.entityDao().get(SyllabusTopic.class, (Object)BoxesRunTime.boxToLong((long)this.getLongId("topic")));
        this.getBoolean("topic.exam").foreach((Function1 & Serializable)v1 -> {
            topic.exam_$eq(BoxesRunTime.unboxToBoolean((Object)v1));
            return BoxedUnit.UNIT;
        });
        this.put("teachingNatures", this.getCodes(TeachingNature.class, ReviseAction.project$7(lazyRef, topic)));
        this.put("topicLabels", this.getCodes(SyllabusTopicLabel.class, ReviseAction.project$7(lazyRef, topic)));
        this.put("topic", topic);
        this.put("teachingMethods", ((IterableOnceOps)topic.syllabus().teachingMethods().map((Function1 & Serializable)x -> Tuple2$.MODULE$.apply(x, x))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
        this.put("syllabus", topic.syllabus());
        return this.forward(topic.syllabus().docLocale() + "/editTopic");
    }

    public View saveTopic() {
        Buffer examTopics;
        LazyRef lazyRef = new LazyRef();
        Syllabus syllabus = (Syllabus)this.entityDao().get(Syllabus.class, (Object)BoxesRunTime.boxToLong((long)this.getLongId("syllabus")));
        SyllabusTopic topic = (SyllabusTopic)this.populateEntity(SyllabusTopic.class, "topic");
        if (!topic.persisted()) {
            topic.syllabus_$eq(syllabus);
            syllabus.topics().$plus$eq((Object)topic);
        }
        this.getCodes(SyllabusTopicLabel.class, ReviseAction.project$8(lazyRef, syllabus)).foreach((Function1 & Serializable)label -> {
            String elm = (String)this.get("element" + label.id(), "");
            Option option = topic.getElement(label);
            if (None$.MODULE$.equals(option)) {
                if (Strings$.MODULE$.isNotBlank((CharSequence)elm)) {
                    topic.elements().$plus$eq((Object)new SyllabusTopicElement(topic, label, elm));
                    return BoxedUnit.UNIT;
                }
                return BoxedUnit.UNIT;
            }
            if (option instanceof Some) {
                SyllabusTopicElement e = (SyllabusTopicElement)((Some)option).value();
                if (Strings$.MODULE$.isBlank((CharSequence)elm)) {
                    return topic.elements().$minus$eq((Object)e);
                }
                e.contents_$eq(elm);
                return BoxedUnit.UNIT;
            }
            throw new MatchError((Object)option);
        });
        Seq teachingNatures = this.getCodes(TeachingNature.class, ReviseAction.project$8(lazyRef, syllabus));
        teachingNatures.foreach((Function1 & Serializable)ht -> {
            Option creditHour = this.getFloat("creditHour" + ht.id());
            Option option = topic.hours().find((Function1 & Serializable)h -> {
                TeachingNature teachingNature = h.nature();
                TeachingNature teachingNature2 = ht;
                return !(teachingNature != null ? !teachingNature.equals(teachingNature2) : teachingNature2 != null);
            });
            if (option instanceof Some) {
                SyllabusTopicHour hour = (SyllabusTopicHour)((Some)option).value();
                if (creditHour.isEmpty()) {
                    return topic.hours().$minus$eq((Object)hour);
                }
                hour.creditHours_$eq(BoxesRunTime.unboxToFloat((Object)creditHour.getOrElse(ReviseAction::saveTopic$$anonfun$2$$anonfun$2)));
                return BoxedUnit.UNIT;
            }
            if (None$.MODULE$.equals(option)) {
                if (creditHour.nonEmpty()) {
                    topic.hours().$plus$eq((Object)new SyllabusTopicHour(topic, ht, BoxesRunTime.unboxToFloat((Object)creditHour.getOrElse(ReviseAction::saveTopic$$anonfun$2$$anonfun$3))));
                    return BoxedUnit.UNIT;
                }
                return BoxedUnit.UNIT;
            }
            throw new MatchError((Object)option);
        });
        Buffer deprecated = (Buffer)topic.hours().filter((Function1 & Serializable)x -> !teachingNatures.contains((Object)x.nature()));
        topic.hours().subtractAll((IterableOnce)deprecated);
        scala.collection.immutable.Seq objectives = this.entityDao().find(SyllabusObjective.class, (Iterable)this.getLongIds("objective"));
        topic.objectives_$eq((Option)None$.MODULE$);
        if (objectives.nonEmpty()) {
            topic.objectives_$eq((Option)Some$.MODULE$.apply((Object)((IterableOnceOps)((SeqOps)objectives.map((Function1 & Serializable)_$24 -> _$24.code())).sorted((Ordering)Ordering.String$.MODULE$)).mkString(",")));
        }
        Iterable methods = this.getAll("teachingMethod", String.class, ClassTag$.MODULE$.apply(String.class));
        topic.methods_$eq((Option)None$.MODULE$);
        Locale locale = syllabus.docLocale();
        Locale locale2 = Locale.SIMPLIFIED_CHINESE;
        String sep = !(locale != null ? !((Object)locale).equals(locale2) : locale2 != null) ? "\u3001" : ",";
        topic.methods_$eq((Option)Some$.MODULE$.apply((Object)methods.mkString(sep)));
        if (topic.contents() == null) {
            topic.contents_$eq(" ");
        }
        if ((examTopics = (Buffer)syllabus.topics().filter((Function1 & Serializable)_$25 -> _$25.exam())).nonEmpty()) {
            SyllabusTopic last = (SyllabusTopic)examTopics.maxBy((Function1 & Serializable)_$26 -> _$26.idx(), (Ordering)Ordering.Short$.MODULE$);
            syllabus.examCreditHours_$eq(last.exam() ? (int)BoxesRunTime.unboxToFloat((Object)((IterableOnceOps)last.hours().map((Function1 & Serializable)_$27 -> _$27.creditHours())).sum((Numeric)Numeric.FloatIsFractional$.MODULE$)) : 0);
        } else {
            syllabus.examCreditHours_$eq(0);
        }
        this.updateState(syllabus);
        this.entityDao().saveOrUpdate((Object)syllabus, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LongId[]{topic}));
        return this.redirect("edit", "syllabus.id=" + syllabus.id() + "&step=topics", "info.save.success");
    }

    public View removeTopic() {
        SyllabusTopic topic = (SyllabusTopic)this.entityDao().get(SyllabusTopic.class, (Object)BoxesRunTime.boxToLong((long)this.getLongId("topic")));
        Syllabus syllabus = topic.syllabus();
        syllabus.topics().$minus$eq((Object)topic);
        this.updateState(syllabus);
        this.entityDao().saveOrUpdate((Object)syllabus, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Syllabus[0]));
        return this.redirect("edit", "syllabus.id=" + syllabus.id() + "&step=topics", "info.save.success");
    }

    public View topicInfo() {
        SyllabusTopic topic = (SyllabusTopic)this.entityDao().get(SyllabusTopic.class, (Object)BoxesRunTime.boxToLong((long)this.getLongId("topic")));
        this.put("topic", topic);
        return this.forward(topic.syllabus().docLocale() + "/topicInfo");
    }

    public View editDesign() {
        LazyRef lazyRef = new LazyRef();
        SyllabusMethodDesign design = (SyllabusMethodDesign)this.entityDao().get(SyllabusMethodDesign.class, (Object)BoxesRunTime.boxToLong((long)this.getLongId("design")));
        this.put("design", design);
        this.put("syllabus", design.syllabus());
        this.put("experimentTypes", this.getCodes(ExperimentType.class, ReviseAction.project$9(lazyRef, design)));
        return this.forward(design.syllabus().docLocale() + "/editDesign");
    }

    public View submit() {
        Syllabus syllabus;
        block2: {
            block4: {
                block3: {
                    syllabus = (Syllabus)this.entityDao().get(Syllabus.class, (Object)BoxesRunTime.boxToLong((long)this.getLongId("syllabus")));
                    if (!this.isSubmitable(syllabus)) break block2;
                    syllabus.status_$eq(AuditStatus$.Submited);
                    if (syllabus.writer() == null) break block3;
                    String string = syllabus.writer().code();
                    String string2 = Securities$.MODULE$.user();
                    if (!(string == null ? string2 != null : !string.equals(string2))) break block4;
                }
                User me = (User)this.entityDao().findBy(User.class, "code", (Object)Securities$.MODULE$.user()).head();
                syllabus.writer_$eq(me);
            }
            this.entityDao().saveOrUpdate((Object)syllabus, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Syllabus[0]));
            Object[] objectArray = new Tuple2[1];
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"course");
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)syllabus.course().id().toString());
            this.businessLogger().info("\u63d0\u4ea4\u8bfe\u7a0b\u6559\u5b66\u5927\u7eb2:" + syllabus.course().name(), syllabus.id(), Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)));
        }
        return this.redirect("info", "&id=" + syllabus.id(), "\u63d0\u4ea4\u6210\u529f");
    }

    public View saveDesign() {
        Set caseAndExps;
        Syllabus syllabus = (Syllabus)this.entityDao().get(Syllabus.class, (Object)BoxesRunTime.boxToLong((long)this.getLongId("syllabus")));
        SyllabusMethodDesign design = (SyllabusMethodDesign)this.populateEntity(SyllabusMethodDesign.class, "design");
        if (!design.persisted()) {
            design.syllabus_$eq(syllabus);
            design.idx_$eq(syllabus.designs().size());
            syllabus.designs().$plus$eq((Object)design);
        }
        if ((caseAndExps = this.getAll("caseAndExperiments", String.class, ClassTag$.MODULE$.apply(String.class)).toSet()).contains((Object)"hasCase")) {
            scala.collection.immutable.Map cases = ((IterableOnceOps)syllabus.cases().map((Function1 & Serializable)x -> Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)x.idx()), x))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
            RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 15).foreach((Function1 & Serializable)i -> this.saveDesign$$anonfun$1(cases, syllabus, BoxesRunTime.unboxToInt((Object)i)));
            design.hasCase_$eq(true);
        } else {
            design.hasCase_$eq(false);
        }
        if (caseAndExps.contains((Object)"hasExperiment")) {
            scala.collection.immutable.Map experiments = ((IterableOnceOps)syllabus.experiments().map((Function1 & Serializable)x -> Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)x.idx()), x))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
            RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 15).foreach((Function1 & Serializable)i -> this.saveDesign$$anonfun$2(experiments, syllabus, BoxesRunTime.unboxToInt((Object)i)));
            design.hasExperiment_$eq(true);
        } else {
            design.hasExperiment_$eq(false);
        }
        if (!syllabus.designs().exists((Function1 & Serializable)_$28 -> _$28.hasCase())) {
            syllabus.cases().clear();
        }
        if (!syllabus.designs().exists((Function1 & Serializable)_$29 -> _$29.hasExperiment())) {
            syllabus.experiments().clear();
        }
        Buffer olders = (Buffer)syllabus.experiments().filter((Function1 & Serializable)o1 -> syllabus.experiments().exists((Function1 & Serializable)o2 -> {
            Experiment experiment = o2.experiment();
            Experiment experiment2 = o1.experiment();
            return !(experiment != null ? !experiment.equals(experiment2) : experiment2 != null) && BoxesRunTime.unboxToLong((Object)o1.id()) > BoxesRunTime.unboxToLong((Object)o2.id());
        }));
        syllabus.experiments().subtractAll((IterableOnce)olders);
        Buffer oldercases = (Buffer)syllabus.cases().filter((Function1 & Serializable)o1 -> syllabus.cases().exists((Function1 & Serializable)o2 -> {
            String string = o2.name();
            String string2 = o1.name();
            return !(string != null ? !string.equals(string2) : string2 != null) && BoxesRunTime.unboxToLong((Object)o1.id()) > BoxesRunTime.unboxToLong((Object)o2.id());
        }));
        syllabus.cases().subtractAll((IterableOnce)oldercases);
        this.entityDao().saveOrUpdate((Object)syllabus, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Syllabus[0]));
        syllabus.reIndex();
        this.updateState(syllabus);
        this.entityDao().saveOrUpdate((Object)syllabus, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Syllabus[0]));
        return this.redirect("edit", "syllabus.id=" + syllabus.id() + "&step=designs", "info.save.success");
    }

    public View removeDesign() {
        SyllabusMethodDesign design = (SyllabusMethodDesign)this.entityDao().get(SyllabusMethodDesign.class, (Object)BoxesRunTime.boxToLong((long)this.getLongId("design")));
        Syllabus syllabus = design.syllabus();
        syllabus.designs().$minus$eq((Object)design);
        this.updateState(syllabus);
        this.entityDao().saveOrUpdate((Object)syllabus, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Syllabus[0]));
        return this.redirect("edit", "syllabus.id=" + syllabus.id() + "&step=designs", "info.save.success");
    }

    public View assesses() {
        LazyRef lazyRef = new LazyRef();
        Syllabus syllabus = (Syllabus)this.entityDao().get(Syllabus.class, (Object)BoxesRunTime.boxToLong((long)this.getLongId("syllabus")));
        this.put("usualType", this.entityDao().get(GradeType.class, (Object)BoxesRunTime.boxToInteger((int)GradeType$.MODULE$.Usual())));
        this.put("endType", this.entityDao().get(GradeType.class, (Object)BoxesRunTime.boxToInteger((int)GradeType$.MODULE$.End())));
        this.put("syllabus", syllabus);
        return this.forward(syllabus.docLocale() + "/assesses");
    }

    public View saveAssess() {
        Syllabus syllabus = (Syllabus)this.entityDao().get(Syllabus.class, (Object)BoxesRunTime.boxToLong((long)this.getLongId("syllabus")));
        GradeType usualType = (GradeType)this.entityDao().get(GradeType.class, (Object)BoxesRunTime.boxToInteger((int)GradeType$.MODULE$.Usual()));
        GradeType endType = (GradeType)this.entityDao().get(GradeType.class, (Object)BoxesRunTime.boxToInteger((int)GradeType$.MODULE$.End()));
        this.populateAssessment(syllabus, endType, 0, (Option<String>)None$.MODULE$);
        this.populateAssessment(syllabus, usualType, 0, (Option<String>)None$.MODULE$);
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 6).foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            String component = (String)this.get("grade" + usualType.id() + "_" + i + ".component", "");
            int percent = this.getInt("grade" + usualType.id() + "_" + i + ".weight", 0);
            if (percent > 0 && Strings$.MODULE$.isNotBlank((CharSequence)component)) {
                this.populateAssessment(syllabus, usualType, i, (Option<String>)Some$.MODULE$.apply((Object)component));
                return;
            }
        });
        this.updateState(syllabus);
        this.entityDao().saveOrUpdate((Object)syllabus, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Syllabus[0]));
        boolean justSave = this.getBoolean("justSave", false);
        if (justSave) {
            return this.redirect("assesses", "syllabus.id=" + syllabus.id(), "info.save.success");
        }
        return this.toStep(syllabus);
    }

    public View removeAssess() {
        SyllabusAssessment assessment = (SyllabusAssessment)this.entityDao().get(SyllabusAssessment.class, (Object)BoxesRunTime.boxToLong((long)this.getLongId("assessment")));
        Syllabus syllabus = assessment.syllabus();
        syllabus.assessments().$minus$eq((Object)assessment);
        syllabus.reIndex();
        this.updateState(syllabus);
        this.entityDao().saveOrUpdate((Object)syllabus, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Syllabus[0]));
        return this.redirect("assesses", "syllabus.id=" + syllabus.id(), "info.remove.success");
    }

    public View moveAssess() {
        SyllabusAssessment assessment = (SyllabusAssessment)this.entityDao().get(SyllabusAssessment.class, (Object)BoxesRunTime.boxToLong((long)this.getLongId("assessment")));
        Syllabus syllabus = assessment.syllabus();
        IntRef idx = IntRef.create((int)this.getInt("idx", 1));
        Buffer usualAssessments = ((IterableOnceOps)syllabus.assessments().filter((Function1 & Serializable)_$30 -> _$30.component().nonEmpty())).toBuffer();
        if (idx.elem < 1) {
            idx.elem = 1;
        } else if (idx.elem > usualAssessments.size()) {
            idx.elem = usualAssessments.size();
        }
        assessment.idx_$eq(idx.elem);
        usualAssessments.subtractOne((Object)assessment);
        IntRef index = IntRef.create((int)1);
        ((IterableOnceOps)usualAssessments.sortBy((Function1 & Serializable)_$31 -> _$31.idx(), (Ordering)Ordering.Int$.MODULE$)).foreach((Function1)(JProcedure1 & Serializable)a -> {
            if (index$1.elem == idx$3.elem) {
                ++index$1.elem;
            }
            a.idx_$eq(index$1.elem);
            ++index$1.elem;
        });
        syllabus.reIndex();
        this.entityDao().saveOrUpdate((Object)syllabus, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Syllabus[0]));
        return this.redirect("assesses", "syllabus.id=" + syllabus.id(), "info.save.success");
    }

    private SyllabusAssessment populateAssessment(Syllabus syllabus, GradeType gradeType, int index, Option<String> componentName) {
        String string;
        SyllabusAssessment assessment;
        SyllabusAssessment syllabusAssessment = assessment = componentName.isEmpty() ? (SyllabusAssessment)syllabus.getAssessment(gradeType, null).getOrElse(() -> ReviseAction.$anonfun$21(syllabus, gradeType)) : (SyllabusAssessment)syllabus.getUsualAssessment(index + 1).getOrElse(() -> ReviseAction.$anonfun$22(syllabus, gradeType, componentName));
        if (!assessment.persisted()) {
            syllabus.assessments().$plus$eq((Object)assessment);
        }
        assessment.idx_$eq(index == 0 ? 0 : index + 1);
        Option<String> option = componentName;
        if (None$.MODULE$.equals(option)) {
            string = "grade" + gradeType.id();
        } else if (option instanceof Some) {
            String n2 = (String)((Some)option).value();
            string = "grade" + gradeType.id() + "_" + index;
        } else {
            throw new MatchError(option);
        }
        String prefix = string;
        this.populate((Entity)assessment, prefix);
        Map percents = Collections$.MODULE$.newMap();
        if (!(assessment.weight() < 0 || BoxesRunTime.unboxToInt((Object)gradeType.id()) == GradeType$.MODULE$.Usual() && index == 0 && componentName.isEmpty())) {
            syllabus.objectives().foreach((Function1)(JProcedure1 & Serializable)co -> {
                float p;
                float f = p = BoxesRunTime.unboxToInt((Object)gradeType.id()) == GradeType$.MODULE$.Usual() ? BoxesRunTime.unboxToFloat((Object)this.getFloat("usual_" + index + "_co" + co.id()).getOrElse(ReviseAction::$anonfun$23)) : BoxesRunTime.unboxToFloat((Object)this.getFloat("end_co" + co.id()).getOrElse(ReviseAction::$anonfun$24));
                if (p > 0.0f) {
                    percents.put((Object)co.code(), (Object)BoxesRunTime.boxToFloat((float)p));
                    return;
                }
            });
        }
        assessment.updateObjectivePercents(percents.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
        assessment.component().foreach((Function1)(JProcedure1 & Serializable)n -> {
            String name = Strings$.MODULE$.replace(n, "\r", "");
            name = Strings$.MODULE$.replace(n, "\n", "");
            name = Strings$.MODULE$.replace(n, " ", "");
            assessment.component_$eq((Option)Some$.MODULE$.apply((Object)name));
        });
        return assessment;
    }

    public View saveTextbook() {
        Syllabus syllabus;
        block3: {
            block2: {
                syllabus = (Syllabus)this.entityDao().get(Syllabus.class, (Object)BoxesRunTime.boxToLong((long)this.getLongId("syllabus")));
                syllabus.textbooks().clear();
                syllabus.textbooks().$plus$plus$eq((IterableOnce)this.entityDao().find(Textbook.class, (Iterable)this.getLongIds("textbook")));
                syllabus.materials_$eq(this.get("syllabus.materials"));
                syllabus.bibliography_$eq(this.get("syllabus.bibliography"));
                syllabus.website_$eq(this.get("syllabus.website"));
                syllabus.office_$eq(this.courseTaskService().getOffice(syllabus.semester(), syllabus.course(), syllabus.department()));
                syllabus.office().foreach((Function1)(JProcedure1 & Serializable)o -> syllabus.reviewer_$eq(this.courseTaskService().getOfficeDirector(syllabus.semester(), syllabus.course(), syllabus.department())));
                this.updateState(syllabus);
                if (syllabus.writer() == null) break block2;
                String string = syllabus.writer().code();
                String string2 = Securities$.MODULE$.user();
                if (!(string == null ? string2 != null : !string.equals(string2))) break block3;
            }
            User me = (User)this.entityDao().findBy(User.class, "code", (Object)Securities$.MODULE$.user()).head();
            syllabus.writer_$eq(me);
        }
        this.entityDao().saveOrUpdate((Object)syllabus, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Syllabus[0]));
        this.getBoolean("submit").foreach((Function1 & Serializable)v1 -> {
            this.saveTextbook$$anonfun$2(syllabus, BoxesRunTime.unboxToBoolean((Object)v1));
            return BoxedUnit.UNIT;
        });
        return this.redirect("info", "&syllabus.id=" + syllabus.id(), "info.save.success");
    }

    private View toStep(Syllabus syllabus) {
        Option option = this.get("step");
        if (None$.MODULE$.equals(option)) {
            return this.redirect("info", "info.save.success");
        }
        if (option instanceof Some) {
            String s = (String)((Some)option).value();
            return this.redirect("edit", "syllabus.id=" + syllabus.id() + "&step=" + s, "info.save.success");
        }
        throw new MatchError((Object)option);
    }

    public View nextStep() {
        return this.redirect("edit", "syllabus.id=" + this.getLongId("syllabus") + "&step=" + this.get("step").get(), "info.save.success");
    }

    public View reuse() {
        Semester semester = (Semester)this.entityDao().get(Semester.class, (Object)BoxesRunTime.boxToInteger((int)this.getIntId("semester")));
        Syllabus syllabus = (Syllabus)this.entityDao().get(Syllabus.class, (Object)BoxesRunTime.boxToLong((long)this.getLongId("syllabus")));
        boolean cancel = this.getBoolean("cancel", false);
        Set reuses = (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AuditStatus[]{AuditStatus$.PassedByDepart, AuditStatus$.Passed, AuditStatus$.Published}));
        String message = "\u6cbf\u7528\u6210\u529f";
        if (cancel) {
            if (syllabus.endOn().isAfter(semester.beginOn())) {
                syllabus.endOn_$eq(semester.beginOn().minusDays(30L));
                this.entityDao().saveOrUpdate((Object)syllabus, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Syllabus[0]));
                message = "\u53d6\u6d88\u6cbf\u7528\u6210\u529f";
            }
        } else if (reuses.contains((Object)syllabus.status()) && syllabus.endOn().isBefore(semester.beginOn())) {
            syllabus.endOn_$eq(semester.endOn());
            this.entityDao().saveOrUpdate((Object)syllabus, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Syllabus[0]));
        }
        return this.redirect("course", "&course.id=" + syllabus.course().id() + "&semester.id=" + semester.id(), message);
    }

    public View course() {
        Course course = (Course)this.entityDao().get(Course.class, (Object)BoxesRunTime.boxToLong((long)this.getLongId("course")));
        Semester semester = (Semester)this.entityDao().get(Semester.class, (Object)BoxesRunTime.boxToInteger((int)this.getIntId("semester")));
        Teacher teacher = this.getTeacher();
        Option task = this.courseTaskService().getTask(semester, course, teacher);
        this.put("task", task);
        this.put("course", course);
        this.put("semester", semester);
        Object[] objectArray = new Tuple2[2];
        Locale locale = (Locale)Predef$.MODULE$.ArrowAssoc((Object)Locales$.MODULE$.chinese());
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)locale, (Object)"\u4e2d\u6587");
        Locale locale2 = (Locale)Predef$.MODULE$.ArrowAssoc((Object)Locales$.MODULE$.us());
        objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)locale2, (Object)"English");
        this.put("locales", Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)));
        scala.collection.immutable.Seq allSyllabuses = this.entityDao().findBy(Syllabus.class, "course", (Object)course);
        scala.collection.immutable.Seq syllabuses = (scala.collection.immutable.Seq)allSyllabuses.filter((Function1 & Serializable)_$32 -> _$32.within(semester.beginOn()));
        OqlBuilder hq = OqlBuilder$.MODULE$.from(Syllabus.class, "s");
        Option option = course.cluster();
        if (None$.MODULE$.equals(option)) {
            v1 = (OqlBuilder)hq.where("s.course.name = :courseName", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{course.name()}));
        } else if (option instanceof Some) {
            CourseCluster c = (CourseCluster)((Some)option).value();
            v1 = (OqlBuilder)hq.where("s.course.name = :courseName or s.course.cluster=:cluster", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{course.name(), c}));
        } else {
            throw new MatchError((Object)option);
        }
        hq.where("s.semester != :semester", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{semester}));
        scala.collection.immutable.Seq histories = this.entityDao().search((QueryBuilder)hq);
        this.put("syllabuses", syllabuses);
        this.put("histories", histories);
        this.put("editables", Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AuditStatus[]{AuditStatus$.Draft, AuditStatus$.Submited, AuditStatus$.RejectedByDirector, AuditStatus$.RejectedByDepart})));
        this.put("reuse", Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AuditStatus[]{AuditStatus$.PassedByDepart, AuditStatus$.Passed, AuditStatus$.Published})));
        Option last = ((IterableOps)this.entityDao().findBy(CourseProfile.class, "course", (Object)course).sortBy((Function1 & Serializable)_$33 -> _$33.beginOn(), Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()))).lastOption();
        this.put("profile", last);
        return this.forward(this.forward$default$1());
    }

    public View editProfile() {
        CourseProfile courseProfile;
        Course course = (Course)this.entityDao().get(Course.class, (Object)BoxesRunTime.boxToLong((long)this.getLongId("course")));
        Option option = this.getLong("profile.id");
        if (None$.MODULE$.equals(option)) {
            CourseProfile profile = new CourseProfile();
            profile.course_$eq(course);
            courseProfile = profile;
        } else if (option instanceof Some) {
            long profileId = BoxesRunTime.unboxToLong((Object)((Some)option).value());
            courseProfile = (CourseProfile)this.entityDao().get(CourseProfile.class, (Object)BoxesRunTime.boxToLong((long)profileId));
        } else {
            throw new MatchError((Object)option);
        }
        CourseProfile profile = courseProfile;
        this.put("profile", profile);
        return this.forward(this.forward$default$1());
    }

    public View saveProfile() {
        CourseProfile courseProfile;
        Course course = (Course)this.entityDao().get(Course.class, (Object)BoxesRunTime.boxToLong((long)this.getLongId("course")));
        Option option = this.getLong("profile.id");
        if (None$.MODULE$.equals(option)) {
            CourseProfile profile = new CourseProfile();
            profile.course_$eq(course);
            courseProfile = profile;
        } else if (option instanceof Some) {
            long profileId = BoxesRunTime.unboxToLong((Object)((Some)option).value());
            courseProfile = (CourseProfile)this.entityDao().get(CourseProfile.class, (Object)BoxesRunTime.boxToLong((long)profileId));
        } else {
            throw new MatchError((Object)option);
        }
        CourseProfile profile = courseProfile;
        profile.description_$eq((String)this.get("description", ""));
        profile.enDescription_$eq(this.get("enDescription"));
        profile.updatedAt_$eq(Instant.now());
        this.entityDao().saveOrUpdate((Object)profile, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CourseProfile[0]));
        return this.redirect("courseInfo", "course.id=" + course.id(), "info.save.success");
    }

    public View courseInfo() {
        Course course = (Course)this.entityDao().get(Course.class, (Object)BoxesRunTime.boxToLong((long)this.getLongId("course")));
        Option last = ((IterableOps)this.entityDao().findBy(CourseProfile.class, "course", (Object)course).sortBy((Function1 & Serializable)_$34 -> _$34.beginOn(), Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()))).lastOption();
        this.put("course", course);
        this.put("profile", last);
        return this.forward(this.forward$default$1());
    }

    public View info() {
        Semester semester;
        Syllabus syllabus = (Syllabus)this.entityDao().get(Syllabus.class, (Object)BoxesRunTime.boxToLong((long)this.getLongId("syllabus")));
        new SyllabusHelper(this.entityDao()).collectDatas(syllabus).foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                Object v = tuple2._2();
                this.put(k, v);
                return;
            }
            throw new MatchError((Object)tuple2);
        });
        this.put("submitable", BoxesRunTime.boxToBoolean((boolean)this.isSubmitable(syllabus)));
        Project project = syllabus.course().project();
        ProjectProfile$.MODULE$.set(project);
        scala.collection.immutable.Seq<String> messages = SyllabusValidator$.MODULE$.validate(syllabus);
        this.put("messages", messages);
        Option option = this.getInt("semester.id");
        if (option instanceof Some) {
            int sid = BoxesRunTime.unboxToInt((Object)((Some)option).value());
            semester = (Semester)this.entityDao().get(Semester.class, (Object)BoxesRunTime.boxToInteger((int)sid));
        } else if (None$.MODULE$.equals(option)) {
            semester = syllabus.semester();
        } else {
            throw new MatchError((Object)option);
        }
        Semester semester2 = semester;
        this.put("semester", semester2);
        return this.forward("/org/openurp/edu/course/web/components/syllabus/report_" + syllabus.docLocale());
    }

    private boolean isSubmitable(Syllabus syllabus) {
        scala.collection.immutable.Seq<String> rs = SyllabusValidator$.MODULE$.validate(syllabus);
        if (rs.isEmpty()) {
            Set submitables = (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AuditStatus[]{AuditStatus$.Draft, AuditStatus$.RejectedByDirector, AuditStatus$.RejectedByDepart, AuditStatus$.Rejected}));
            return submitables.contains((Object)syllabus.status()) && syllabus.reviewer().nonEmpty();
        }
        return false;
    }

    public View pdf() {
        long id = this.getLongId("syllabus");
        Syllabus syllabus = (Syllabus)this.entityDao().get(Syllabus.class, (Object)BoxesRunTime.boxToLong((long)id));
        String semesterId = (String)this.get("semester.id", "");
        Object semesterParam = StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(semesterId)) ? "&semester.id=" + semesterId : "";
        String url = EmsApi$.MODULE$.url("/syllabus/revise/info?id=" + id + (String)semesterParam);
        File pdf = File.createTempFile("doc", ".pdf");
        PrintOptions options = new PrintOptions();
        options.scale_$eq(0.66);
        Predef$.MODULE$.println((Object)("download " + url + " to " + pdf.getAbsolutePath()));
        SPDConverter$.MODULE$.getInstance().convert(URI.create(url), pdf, options);
        if (!pdf.exists() || pdf.length() < 100L) {
            pdf.delete();
            return Status$.MODULE$.NotFound();
        }
        Predef$.MODULE$.println((Object)BoxesRunTime.boxToLong((long)pdf.length()));
        return Stream$.MODULE$.apply(pdf, syllabus.course().code() + "_" + syllabus.course().name() + " \u6559\u5b66\u5927\u7eb2.pdf").cleanup((Function0)(JFunction0.mcV.sp & Serializable)() -> pdf.delete());
    }

    public View copySetting() {
        Syllabus syllabus = (Syllabus)this.entityDao().get(Syllabus.class, (Object)BoxesRunTime.boxToLong((long)this.getLongId("syllabus")));
        Semester semester = (Semester)this.entityDao().get(Semester.class, (Object)BoxesRunTime.boxToInteger((int)this.getIntId("semester")));
        this.put("syllabus", syllabus);
        OqlBuilder q = OqlBuilder$.MODULE$.from(CourseTask.class, "c");
        q.where("c.course.project=:project", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{syllabus.course().project()}));
        q.where("c.semester=:semester", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{semester}));
        q.where("c.director.staff.code=:me", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{Securities$.MODULE$.user()}));
        q.where("not exists(from " + Syllabus.class.getName() + " s where s.semester=c.semester and s.course=c.course and s.docLocale=:docLocale)", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{syllabus.docLocale()}));
        scala.collection.immutable.Seq taskCourses = (scala.collection.immutable.Seq)this.entityDao().search((QueryBuilder)q).map((Function1 & Serializable)_$35 -> _$35.course());
        this.put("taskCourses", taskCourses);
        return this.forward(this.forward$default$1());
    }

    public View copy() {
        Syllabus syllabus = (Syllabus)this.entityDao().get(Syllabus.class, (Object)BoxesRunTime.boxToLong((long)this.getLongId("syllabus")));
        Semester semester = (Semester)this.entityDao().get(Semester.class, (Object)BoxesRunTime.boxToInteger((int)this.getIntId("semester")));
        Teacher teacher = this.getTeacher();
        Course course = (Course)this.entityDao().get(Course.class, (Object)BoxesRunTime.boxToLong((long)this.getLongId("course")));
        boolean isDirector = this.courseTaskService().isDirector(semester, course, teacher);
        if (isDirector) {
            User me = (User)this.entityDao().findBy(User.class, "code", (Object)Securities$.MODULE$.user()).head();
            Syllabus newSyllabus = Syllabus$.MODULE$.copy(syllabus, semester, course);
            newSyllabus.writer_$eq(me);
            this.entityDao().saveOrUpdate((Object)newSyllabus, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Syllabus[0]));
            Object[] objectArray = new Tuple2[1];
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"course");
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)course.id().toString());
            this.businessLogger().info("\u590d\u5236\u4e86\u8bfe\u7a0b\u6559\u5b66\u5927\u7eb2:" + course.name(), syllabus.id(), Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)));
            return this.redirect("course", "&semester.id=" + semester.id() + "&course.id=" + course.id(), "\u590d\u5236\u6210\u529f");
        }
        return this.redirect("course", "&semester.id=" + semester.id() + "&course.id=" + course.id(), "\u4e0d\u662f\u8d1f\u8d23\u4eba\uff0c\u65e0\u6cd5\u590d\u5236");
    }

    public View experiments() {
        Syllabus syllabus = (Syllabus)this.entityDao().get(Syllabus.class, (Object)BoxesRunTime.boxToLong((long)this.getLongId("syllabus")));
        scala.collection.immutable.Seq experiments = (scala.collection.immutable.Seq)this.entityDao().findBy(Experiment.class, "course", (Object)syllabus.course()).sortBy((Function1 & Serializable)_$36 -> _$36.code(), (Ordering)Ordering.String$.MODULE$);
        this.put("experiments", experiments);
        this.put("syllabus", syllabus);
        return this.forward(this.forward$default$1());
    }

    public View editExperiment() {
        Experiment experiment;
        LazyRef lazyRef = new LazyRef();
        Syllabus syllabus = (Syllabus)this.entityDao().get(Syllabus.class, (Object)BoxesRunTime.boxToLong((long)this.getLongId("syllabus")));
        Option option = this.getLong("experiment.id");
        if (None$.MODULE$.equals(option)) {
            experiment = new Experiment(syllabus.course());
        } else if (option instanceof Some) {
            long id = BoxesRunTime.unboxToLong((Object)((Some)option).value());
            experiment = (Experiment)this.entityDao().get(Experiment.class, (Object)BoxesRunTime.boxToLong((long)id));
        } else {
            throw new MatchError((Object)option);
        }
        Experiment expr = experiment;
        this.put("experiment", expr);
        this.put("categories", this.getCodes(ExperimentCategory.class, ReviseAction.project$11(lazyRef, syllabus)));
        this.put("experimentTypes", this.getCodes(ExperimentType.class, ReviseAction.project$11(lazyRef, syllabus)));
        this.put("disciplines", this.getCodes(Level1Discipline.class, ReviseAction.project$11(lazyRef, syllabus)));
        this.put("syllabus", syllabus);
        return this.forward("experimentForm");
    }

    public View saveExperiment() {
        Experiment experiment;
        Syllabus syllabus = (Syllabus)this.entityDao().get(Syllabus.class, (Object)BoxesRunTime.boxToLong((long)this.getLongId("syllabus")));
        Option option = this.getLong("experiment.id");
        if (None$.MODULE$.equals(option)) {
            experiment = new Experiment();
        } else if (option instanceof Some) {
            long id = BoxesRunTime.unboxToLong((Object)((Some)option).value());
            experiment = (Experiment)this.entityDao().get(Experiment.class, (Object)BoxesRunTime.boxToLong((long)id));
        } else {
            throw new MatchError((Object)option);
        }
        Experiment experiment2 = experiment;
        Experiment exp = (Experiment)PopulateHelper$.MODULE$.populate((Entity)experiment2, (EntityType)this.entityDao().domain().getEntity(Experiment.class).get(), "experiment");
        if (!exp.persisted()) {
            exp.code_$eq(this.nextExpCode(syllabus.course()));
            exp.course_$eq(syllabus.course());
            exp.beginOn_$eq(syllabus.semester().beginOn());
        }
        exp.updatedAt_$eq(Instant.now());
        this.entityDao().saveOrUpdate((Object)exp, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Experiment[0]));
        return this.redirect("experiments", "&syllabus.id=" + syllabus.id(), "info.save.success");
    }

    private String nextExpCode(Course course) {
        Object[] objectArray = new Tuple2[1];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"course");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)course);
        scala.collection.immutable.Seq exps = this.entityDao().findBy(Experiment.class, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        int idx = exps.isEmpty() ? 1 : StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString((String)((IterableOnceOps)exps.map((Function1 & Serializable)_$37 -> _$37.code())).max((Ordering)Ordering.String$.MODULE$))) + 1;
        return Strings$.MODULE$.leftPad(BoxesRunTime.boxToInteger((int)idx).toString(), 2, '0');
    }

    @response
    public scala.collection.immutable.Seq<Properties> experimentData() {
        Course course = (Course)this.entityDao().get(Course.class, (Object)BoxesRunTime.boxToLong((long)this.getLongId("course")));
        ObjectRef experiments = ObjectRef.create((Object)((scala.collection.immutable.Seq)this.entityDao().findBy(Experiment.class, "course", (Object)course).sortBy((Function1 & Serializable)_$38 -> _$38.code(), (Ordering)Ordering.String$.MODULE$)));
        this.get("q").foreach((Function1)(JProcedure1 & Serializable)e -> {
            if (Strings$.MODULE$.isNotBlank((CharSequence)e)) {
                String q = e.trim();
                experiments$2.elem = (scala.collection.immutable.Seq)((scala.collection.immutable.Seq)experiments$2.elem).filter((Function1 & Serializable)_$39 -> _$39.description().contains(q));
                return;
            }
        });
        return (scala.collection.immutable.Seq)((scala.collection.immutable.Seq)experiments.elem).map((Function1 & Serializable)x -> new Properties(x, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"id", "description"})));
    }

    @response
    public float experimentCreditHours() {
        scala.collection.immutable.Seq experiments = this.entityDao().find(Experiment.class, (Iterable)this.getLongIds("experiment"));
        return BoxesRunTime.unboxToFloat((Object)((IterableOnceOps)experiments.map((Function1 & Serializable)_$40 -> _$40.creditHours())).sum((Numeric)Numeric.FloatIsFractional$.MODULE$));
    }

    private void updateState(Syllabus syllabus) {
        syllabus.updatedAt_$eq(Instant.now());
        syllabus.complete_$eq(SyllabusValidator$.MODULE$.validate(syllabus).isEmpty());
    }

    private static final Project project$lzyINIT1$1(LazyRef project$lzy1$1, Syllabus syllabus$1) {
        Project project;
        LazyRef lazyRef = project$lzy1$1;
        synchronized (lazyRef) {
            project = (Project)(project$lzy1$1.initialized() ? project$lzy1$1.value() : project$lzy1$1.initialize((Object)syllabus$1.course().project()));
        }
        return project;
    }

    private static final Project project$1(LazyRef project$lzy1$2, Syllabus syllabus$2) {
        return (Project)(project$lzy1$2.initialized() ? project$lzy1$2.value() : ReviseAction.project$lzyINIT1$1(project$lzy1$2, syllabus$2));
    }

    private static final Project project$lzyINIT2$1(LazyRef project$lzy2$1, Course course$1) {
        Project project;
        LazyRef lazyRef = project$lzy2$1;
        synchronized (lazyRef) {
            project = (Project)(project$lzy2$1.initialized() ? project$lzy2$1.value() : project$lzy2$1.initialize((Object)course$1.project()));
        }
        return project;
    }

    private static final Project project$2(LazyRef project$lzy2$2, Course course$2) {
        return (Project)(project$lzy2$2.initialized() ? project$lzy2$2.value() : ReviseAction.project$lzyINIT2$1(project$lzy2$2, course$2));
    }

    private static final Project project$lzyINIT3$1(LazyRef project$lzy3$1, Course course$3) {
        Project project;
        LazyRef lazyRef = project$lzy3$1;
        synchronized (lazyRef) {
            project = (Project)(project$lzy3$1.initialized() ? project$lzy3$1.value() : project$lzy3$1.initialize((Object)course$3.project()));
        }
        return project;
    }

    private static final Project project$3(LazyRef project$lzy3$2, Course course$4) {
        return (Project)(project$lzy3$2.initialized() ? project$lzy3$2.value() : ReviseAction.project$lzyINIT3$1(project$lzy3$2, course$4));
    }

    private static final Locale $anonfun$8() {
        return Locale.SIMPLIFIED_CHINESE;
    }

    private static final Project project$lzyINIT4$1(LazyRef project$lzy4$1, Course course$5) {
        Project project;
        LazyRef lazyRef = project$lzy4$1;
        synchronized (lazyRef) {
            project = (Project)(project$lzy4$1.initialized() ? project$lzy4$1.value() : project$lzy4$1.initialize((Object)course$5.project()));
        }
        return project;
    }

    private static final Project project$4(LazyRef project$lzy4$2, Course course$6) {
        return (Project)(project$lzy4$2.initialized() ? project$lzy4$2.value() : ReviseAction.project$lzyINIT4$1(project$lzy4$2, course$6));
    }

    private static final float populateHours$$anonfun$1$$anonfun$2() {
        return 0.0f;
    }

    private static final float populateHours$$anonfun$1$$anonfun$3() {
        return 0.0f;
    }

    private final /* synthetic */ Object saveObjectives$$anonfun$1(Syllabus syllabus$12, int i) {
        String code = "CO" + i;
        String contents = this.cleanText((String)this.get(code, ""));
        Option option = syllabus$12.getObjective(code);
        if (None$.MODULE$.equals(option)) {
            if (Strings$.MODULE$.isNotBlank((CharSequence)contents)) {
                SyllabusObjective o = new SyllabusObjective(syllabus$12, code, code, contents);
                syllabus$12.objectives().$plus$eq((Object)o);
                return BoxedUnit.UNIT;
            }
            return BoxedUnit.UNIT;
        }
        if (option instanceof Some) {
            SyllabusObjective o = (SyllabusObjective)((Some)option).value();
            if (Strings$.MODULE$.isBlank((CharSequence)contents)) {
                return syllabus$12.objectives().$minus$eq((Object)o);
            }
            o.contents_$eq(contents);
            return BoxedUnit.UNIT;
        }
        throw new MatchError((Object)option);
    }

    private final /* synthetic */ Object saveRequirements$$anonfun$1(Syllabus syllabus$14, int idx) {
        String code = "R" + idx;
        String name = (String)this.get(code, "");
        name = Strings$.MODULE$.replace(name, "\u3010", "");
        if (Strings$.MODULE$.isNotEmpty((CharSequence)(name = Strings$.MODULE$.replace(name, "\u3011", "")))) {
            Option option = syllabus$14.outcomes().find((Function1 & Serializable)_$22 -> _$22.idx() == idx);
            if (None$.MODULE$.equals(option)) {
                SyllabusOutcome g = new SyllabusOutcome(syllabus$14, idx, name, " ", " ");
                return syllabus$14.outcomes().addOne((Object)g);
            }
            if (option instanceof Some) {
                SyllabusOutcome outcome = (SyllabusOutcome)((Some)option).value();
                outcome.title_$eq(name);
                return BoxedUnit.UNIT;
            }
            throw new MatchError((Object)option);
        }
        Buffer buffer = syllabus$14.outcomes();
        syllabus$14.outcomes().find((Function1 & Serializable)_$23 -> {
            String string = _$23.code();
            String string2 = code;
            return !(string != null ? !string.equals(string2) : string2 != null);
        }).foreach((Function1 & Serializable)x -> buffer.subtractOne(x));
        return BoxedUnit.UNIT;
    }

    private final Project project$lzyINIT5$1(LazyRef project$lzy5$1) {
        Project project;
        LazyRef lazyRef = project$lzy5$1;
        synchronized (lazyRef) {
            project = (Project)(project$lzy5$1.initialized() ? project$lzy5$1.value() : project$lzy5$1.initialize((Object)this.getProject()));
        }
        return project;
    }

    private final Project project$5(LazyRef project$lzy5$2) {
        return (Project)(project$lzy5$2.initialized() ? project$lzy5$2.value() : this.project$lzyINIT5$1(project$lzy5$2));
    }

    private static final Project project$lzyINIT6$1(LazyRef project$lzy6$1, Syllabus syllabus$15) {
        Project project;
        LazyRef lazyRef = project$lzy6$1;
        synchronized (lazyRef) {
            project = (Project)(project$lzy6$1.initialized() ? project$lzy6$1.value() : project$lzy6$1.initialize((Object)syllabus$15.course().project()));
        }
        return project;
    }

    private static final Project project$6(LazyRef project$lzy6$2, Syllabus syllabus$16) {
        return (Project)(project$lzy6$2.initialized() ? project$lzy6$2.value() : ReviseAction.project$lzyINIT6$1(project$lzy6$2, syllabus$16));
    }

    private static final Project project$lzyINIT7$1(LazyRef project$lzy7$1, SyllabusTopic topic$1) {
        Project project;
        LazyRef lazyRef = project$lzy7$1;
        synchronized (lazyRef) {
            project = (Project)(project$lzy7$1.initialized() ? project$lzy7$1.value() : project$lzy7$1.initialize((Object)topic$1.syllabus().course().project()));
        }
        return project;
    }

    private static final Project project$7(LazyRef project$lzy7$2, SyllabusTopic topic$2) {
        return (Project)(project$lzy7$2.initialized() ? project$lzy7$2.value() : ReviseAction.project$lzyINIT7$1(project$lzy7$2, topic$2));
    }

    private static final Project project$lzyINIT8$1(LazyRef project$lzy8$1, Syllabus syllabus$17) {
        Project project;
        LazyRef lazyRef = project$lzy8$1;
        synchronized (lazyRef) {
            project = (Project)(project$lzy8$1.initialized() ? project$lzy8$1.value() : project$lzy8$1.initialize((Object)syllabus$17.course().project()));
        }
        return project;
    }

    private static final Project project$8(LazyRef project$lzy8$2, Syllabus syllabus$18) {
        return (Project)(project$lzy8$2.initialized() ? project$lzy8$2.value() : ReviseAction.project$lzyINIT8$1(project$lzy8$2, syllabus$18));
    }

    private static final float saveTopic$$anonfun$2$$anonfun$2() {
        return 0.0f;
    }

    private static final float saveTopic$$anonfun$2$$anonfun$3() {
        return 0.0f;
    }

    private static final Project project$lzyINIT9$1(LazyRef project$lzy9$1, SyllabusMethodDesign design$1) {
        Project project;
        LazyRef lazyRef = project$lzy9$1;
        synchronized (lazyRef) {
            project = (Project)(project$lzy9$1.initialized() ? project$lzy9$1.value() : project$lzy9$1.initialize((Object)design$1.syllabus().course().project()));
        }
        return project;
    }

    private static final Project project$9(LazyRef project$lzy9$2, SyllabusMethodDesign design$2) {
        return (Project)(project$lzy9$2.initialized() ? project$lzy9$2.value() : ReviseAction.project$lzyINIT9$1(project$lzy9$2, design$2));
    }

    private final /* synthetic */ Object saveDesign$$anonfun$1(scala.collection.immutable.Map cases$1, Syllabus syllabus$19, int i) {
        String name = (String)this.get("case" + i + ".name", "");
        Option option = cases$1.get((Object)BoxesRunTime.boxToInteger((int)i));
        if (None$.MODULE$.equals(option)) {
            if (Strings$.MODULE$.isNotBlank((CharSequence)name)) {
                syllabus$19.cases().$plus$eq((Object)new SyllabusCase(syllabus$19, i, name));
                return BoxedUnit.UNIT;
            }
            return BoxedUnit.UNIT;
        }
        if (option instanceof Some) {
            SyllabusCase c = (SyllabusCase)((Some)option).value();
            if (Strings$.MODULE$.isBlank((CharSequence)name)) {
                return syllabus$19.cases().$minus$eq((Object)c);
            }
            c.name_$eq(name);
            return BoxedUnit.UNIT;
        }
        throw new MatchError((Object)option);
    }

    private final /* synthetic */ Object saveDesign$$anonfun$2(scala.collection.immutable.Map experiments$1, Syllabus syllabus$20, int i) {
        Option experimentId = this.getLong("experiment" + i + ".id");
        Option option = experiments$1.get((Object)BoxesRunTime.boxToInteger((int)i));
        if (None$.MODULE$.equals(option)) {
            if (experimentId.nonEmpty()) {
                Experiment experiment = (Experiment)this.entityDao().get(Experiment.class, experimentId.get());
                syllabus$20.experiments().$plus$eq((Object)new SyllabusExperiment(syllabus$20, i, experiment));
                return BoxedUnit.UNIT;
            }
            return BoxedUnit.UNIT;
        }
        if (option instanceof Some) {
            SyllabusExperiment c = (SyllabusExperiment)((Some)option).value();
            if (experimentId.isEmpty()) {
                return syllabus$20.experiments().$minus$eq((Object)c);
            }
            Experiment experiment = (Experiment)this.entityDao().get(Experiment.class, experimentId.get());
            c.experiment_$eq(experiment);
            return BoxedUnit.UNIT;
        }
        throw new MatchError((Object)option);
    }

    private static final Project project$lzyINIT10$1(LazyRef project$lzy10$1, Syllabus syllabus$23) {
        Project project;
        LazyRef lazyRef = project$lzy10$1;
        synchronized (lazyRef) {
            project = (Project)(project$lzy10$1.initialized() ? project$lzy10$1.value() : project$lzy10$1.initialize((Object)syllabus$23.course().project()));
        }
        return project;
    }

    private static final Project project$10(LazyRef project$lzy10$2, Syllabus syllabus$24) {
        return (Project)(project$lzy10$2.initialized() ? project$lzy10$2.value() : ReviseAction.project$lzyINIT10$1(project$lzy10$2, syllabus$24));
    }

    private static final SyllabusAssessment $anonfun$21(Syllabus syllabus$26, GradeType gradeType$1) {
        return new SyllabusAssessment(syllabus$26, gradeType$1, (Option)None$.MODULE$);
    }

    private static final SyllabusAssessment $anonfun$22(Syllabus syllabus$27, GradeType gradeType$2, Option componentName$1) {
        return new SyllabusAssessment(syllabus$27, gradeType$2, componentName$1);
    }

    private static final float $anonfun$23() {
        return 0.0f;
    }

    private static final float $anonfun$24() {
        return 0.0f;
    }

    private final /* synthetic */ void saveTextbook$$anonfun$2(Syllabus syllabus$29, boolean s) {
        syllabus$29.status_$eq(AuditStatus$.Submited);
        this.entityDao().saveOrUpdate((Object)syllabus$29, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Syllabus[0]));
        Object[] objectArray = new Tuple2[1];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"id");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)syllabus$29.id().toString());
        this.businessLogger().info("\u63d0\u4ea4\u8bfe\u7a0b\u6559\u5b66\u5927\u7eb2:" + syllabus$29.course().name(), syllabus$29.id(), Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)));
    }

    private static final Project project$lzyINIT11$1(LazyRef project$lzy11$1, Syllabus syllabus$30) {
        Project project;
        LazyRef lazyRef = project$lzy11$1;
        synchronized (lazyRef) {
            project = (Project)(project$lzy11$1.initialized() ? project$lzy11$1.value() : project$lzy11$1.initialize((Object)syllabus$30.course().project()));
        }
        return project;
    }

    private static final Project project$11(LazyRef project$lzy11$2, Syllabus syllabus$31) {
        return (Project)(project$lzy11$2.initialized() ? project$lzy11$2.value() : ReviseAction.project$lzyINIT11$1(project$lzy11$2, syllabus$31));
    }
}

