/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.course.web.helper;

import java.io.Serializable;
import org.beangle.commons.lang.Strings$;
import org.beangle.data.dao.EntityDao;
import org.beangle.data.dao.OqlBuilder;
import org.beangle.data.dao.OqlBuilder$;
import org.beangle.data.dao.QueryBuilder;
import org.beangle.data.model.LongId;
import org.beangle.doc.transfer.importer.ImportListener;
import org.beangle.doc.transfer.importer.ImportResult;
import org.beangle.doc.transfer.importer.Importer;
import org.openurp.base.edu.model.CourseDirector;
import org.openurp.base.hr.model.Teacher;
import org.openurp.base.model.Department;
import org.openurp.base.model.Project;
import org.openurp.base.model.Semester;
import org.openurp.code.edu.model.CourseType;
import org.openurp.edu.course.model.CourseTask;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public class CourseTaskImportListener
implements ImportListener {
    private Importer transfer;
    private final EntityDao entityDao;
    private final Semester semester;
    private final Project project;

    public CourseTaskImportListener(EntityDao entityDao, Semester semester, Project project) {
        this.entityDao = entityDao;
        this.semester = semester;
        this.project = project;
        ImportListener.$init$((ImportListener)this);
    }

    public Importer transfer() {
        return this.transfer;
    }

    public void transfer_$eq(Importer x$1) {
        this.transfer = x$1;
    }

    public void onItemStart(ImportResult tr) {
        ObjectRef task = ObjectRef.create(null);
        this.transfer().curData().get((Object)"course.code").foreach((Function1)(JProcedure1 & Serializable)code -> {
            OqlBuilder query = OqlBuilder$.MODULE$.from(CourseTask.class, "ct");
            query.where("ct.semester=:semester", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.semester}));
            query.where("ct.course.code =:code and ct.course.project=:project", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{code, this.project}));
            Seq cs = this.entityDao.search((QueryBuilder)query);
            if (cs.nonEmpty()) {
                this.transfer().current_$eq(cs.head());
                task$1.elem = (CourseTask)cs.head();
                return;
            }
            tr.addFailure("\u8bfe\u7a0b\u4fee\u8ba2\u4efb\u52a1\u4e0d\u5b58\u5728", code);
        });
        ObjectRef depart = ObjectRef.create(null);
        this.transfer().curData().get((Object)"department.code").foreach((Function1 & Serializable)c -> {
            String code = c.toString();
            if (code.contains(" ")) {
                code = Strings$.MODULE$.substringBefore(code, " ");
            }
            OqlBuilder query = OqlBuilder$.MODULE$.from(Department.class, "d");
            query.where("(d.code=:code or d.name=:name) and d.school=:school", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{code, code, this.project.school()}));
            Seq departs = this.entityDao.search((QueryBuilder)query);
            if (departs.size() == 1) {
                depart$1.elem = (Department)departs.head();
                return this.transfer().curData().put((Object)"courseTask.department", departs.head());
            }
            tr.addFailure("\u90e8\u95e8\u4ee3\u7801/\u540d\u79f0\u4e0d\u552f\u4e00", (Object)code);
            return BoxedUnit.UNIT;
        });
        this.transfer().curData().get((Object)"teacher.code").foreach((Function1)(JProcedure1 & Serializable)c -> {
            ObjectRef code = ObjectRef.create((Object)c.toString());
            if (((String)code.elem).contains(" ")) {
                code.elem = Strings$.MODULE$.substringBefore((String)code.elem, " ");
            }
            if ((CourseTask)task$2.elem != null) {
                Option option = ((CourseTask)task$2.elem).teachers().find((Function1 & Serializable)x -> {
                    String string = x.code();
                    String string2 = (String)code$1.elem;
                    if (string == null) {
                        if (string2 == null) return true;
                    } else if (string.equals(string2)) return true;
                    String string3 = x.name();
                    String string4 = (String)code$1.elem;
                    if (string3 != null) {
                        if (!string3.equals(string4)) return false;
                        return true;
                    }
                    if (string4 == null) return true;
                    return false;
                });
                if (None$.MODULE$.equals(option)) {
                    OqlBuilder query = OqlBuilder$.MODULE$.from(Teacher.class, "t");
                    query.where("(t.staff.code=:code or t.staff.name=:name) and t.staff.school=:school", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{(String)code.elem, (String)code.elem, this.project.school()}));
                    Seq teachers = this.entityDao.search((QueryBuilder)query);
                    if (teachers.size() == 1) {
                        this.transfer().curData().put((Object)"courseTask.director", teachers.head());
                        return;
                    }
                    if ((Department)depart$2.elem != null) {
                        query.where("t.department=:depart", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{(Department)depart$2.elem}));
                        teachers = this.entityDao.search((QueryBuilder)query);
                        if (teachers.size() == 1) {
                            this.transfer().curData().put((Object)"courseTask.director", teachers.head());
                            return;
                        }
                        tr.addFailure("\u6559\u5e08\u59d3\u540d\u4e0d\u552f\u4e00", (Object)((String)code.elem));
                        return;
                    }
                    tr.addFailure("\u6559\u5e08\u59d3\u540d\u4e0d\u552f\u4e00", (Object)((String)code.elem));
                    return;
                }
                if (option instanceof Some) {
                    Teacher t = (Teacher)((Some)option).value();
                    this.transfer().curData().put((Object)"courseTask.director", (Object)t);
                    return;
                }
                throw new MatchError((Object)option);
            }
        });
    }

    public void onItemFinish(ImportResult tr) {
        CourseTask task = (CourseTask)this.transfer().current();
        if (task.course() != null) {
            if (task.courseType() == null) {
                task.courseType_$eq((CourseType)task.course().courseType().orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()));
            }
            if (task.semester() == null) {
                task.semester_$eq(this.semester);
            }
            if (task.director().nonEmpty()) {
                CourseDirector courseDirector;
                Option directors = this.entityDao.findBy(CourseDirector.class, "course", (Object)task.course()).find((Function1 & Serializable)_$1 -> _$1.within(this.semester.beginOn()));
                Option option = directors;
                if (option instanceof Some) {
                    CourseDirector d;
                    courseDirector = d = (CourseDirector)((Some)option).value();
                } else if (None$.MODULE$.equals(option)) {
                    CourseDirector ncd = new CourseDirector(task.course());
                    ncd.beginOn_$eq(this.semester.beginOn());
                    courseDirector = ncd;
                } else {
                    throw new MatchError((Object)option);
                }
                CourseDirector cd = courseDirector;
                if (task.office().nonEmpty()) {
                    cd.office_$eq(task.office());
                }
                cd.director_$eq((Teacher)task.director().get());
                this.entityDao.saveOrUpdate((Object)task, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LongId[]{cd}));
                return;
            }
            this.entityDao.saveOrUpdate((Object)task, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CourseTask[0]));
            return;
        }
    }
}

