/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.course.web.helper;

import java.io.Serializable;
import java.util.Locale;
import org.beangle.commons.collection.Collections$;
import org.beangle.commons.lang.Strings$;
import org.openurp.code.edu.model.GradeType;
import org.openurp.code.edu.model.GradeType$;
import org.openurp.code.edu.model.TeachingNature$;
import org.openurp.edu.course.model.Syllabus;
import scala.Float$;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.math.Numeric;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.FloatRef;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.function.JProcedure1;

public final class SyllabusValidator$
implements Serializable {
    public static final SyllabusValidator$ MODULE$ = new SyllabusValidator$();

    private SyllabusValidator$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(SyllabusValidator$.class);
    }

    public Seq<String> validate(Syllabus syllabus) {
        Buffer messages = Collections$.MODULE$.newBuffer();
        if (syllabus.creditHours() > 0 && syllabus.topics().isEmpty()) {
            messages.$plus$eq((Object)"\u7f3a\u5c11\u8bfe\u7a0b\u4e3b\u9898");
        }
        if (syllabus.designs().isEmpty()) {
            messages.$plus$eq((Object)"\u7f3a\u5c11\u6559\u5b66\u8bbe\u8ba1");
        }
        messages.$plus$plus$eq(this.validateRequirements(syllabus));
        messages.$plus$plus$eq(this.validateObjectives(syllabus));
        messages.$plus$plus$eq(this.validateHours(syllabus));
        messages.$plus$plus$eq(this.validAssessment(syllabus));
        return messages.toSeq();
    }

    public Seq<String> validateRequirements(Syllabus syllabus) {
        Buffer messages = Collections$.MODULE$.newBuffer();
        syllabus.outcomes().foreach((Function1)(JProcedure1 & Serializable)o -> {
            int max;
            if (Strings$.MODULE$.isBlank((CharSequence)o.contents())) {
                messages.addOne((Object)("\u6bd5\u4e1a\u8981\u6c42\u3010" + o.title() + "\u3011\u7f3a\u5c11\u5185\u5bb9"));
            }
            Locale locale = syllabus.docLocale();
            Locale locale2 = Locale.SIMPLIFIED_CHINESE;
            int n = !(locale != null ? !((Object)locale).equals(locale2) : locale2 != null) ? 30 : (max = 150);
            if (o.title().length() > max) {
                messages.addOne((Object)("\u6bd5\u4e1a\u8981\u6c42[" + o.idx() + "]\u7684\u6807\u9898\u8fc7\u957f\uff1a\u3010" + o.title() + "\u3011"));
                return;
            }
        });
        return messages.toSeq();
    }

    public Seq<String> validAssessment(Syllabus syllabus) {
        int endPercent;
        Buffer messages = Collections$.MODULE$.newBuffer();
        GradeType usualType = new GradeType(GradeType$.MODULE$.Usual());
        GradeType endType = new GradeType(GradeType$.MODULE$.End());
        Option endAssessment = syllabus.getAssessment(endType, null);
        int usualPercent = BoxesRunTime.unboxToInt((Object)syllabus.getAssessment(usualType, null).map((Function1 & Serializable)_$1 -> _$1.weight()).getOrElse(SyllabusValidator$::$anonfun$2));
        if (usualPercent + (endPercent = BoxesRunTime.unboxToInt((Object)endAssessment.map((Function1 & Serializable)_$2 -> _$2.weight()).getOrElse(SyllabusValidator$::$anonfun$4))) != 100) {
            messages.addOne((Object)("\u5e73\u65f6\u671f\u672b\u767e\u5206\u6bd4\u5408\u8ba1\u4e3a" + (usualPercent + endPercent) + "\uff0c\u5e94\u7b49\u4e8e100."));
        }
        endAssessment.foreach((Function1)(JProcedure1 & Serializable)a -> {
            if (a.weight() > 0) {
                float s = BoxesRunTime.unboxToFloat((Object)a.objectivePercentMap().values().sum((Numeric)Numeric.FloatIsFractional$.MODULE$));
                if (s != (float)100) {
                    messages.addOne((Object)("\u671f\u672b\u6210\u7ee9\u5bf9\u8bfe\u7a0b\u76ee\u6807\u7684\u5360\u6bd4\u5408\u8ba1\u4e3a" + s + "\uff0c\u5e94\u7b49\u4e8e100."));
                    return;
                }
                return;
            }
        });
        if (usualPercent > 0) {
            Buffer usualAssessments = (Buffer)syllabus.assessments().filter((Function1 & Serializable)x -> BoxesRunTime.unboxToInt((Object)x.gradeType().id()) == GradeType$.MODULE$.Usual() && x.component().nonEmpty());
            int usualTotal = BoxesRunTime.unboxToInt((Object)((IterableOnceOps)usualAssessments.map((Function1 & Serializable)_$3 -> _$3.weight())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
            if (usualTotal != 100) {
                messages.addOne((Object)("\u5e73\u65f6\u6210\u7ee9\uff0c\u5404\u4e2a\u73af\u8282\u5408\u8ba1\u5360\u6bd4\u4e3a" + usualTotal + "\uff0c\u5e94\u7b49\u4e8e100."));
            }
            usualAssessments.foreach((Function1)(JProcedure1 & Serializable)a -> {
                float s = BoxesRunTime.unboxToFloat((Object)a.objectivePercentMap().values().sum((Numeric)Numeric.FloatIsFractional$.MODULE$));
                if (s != (float)a.weight()) {
                    messages.addOne((Object)("\u5e73\u65f6\u6210\u7ee9--" + a.component().get() + "\u7684\u8bfe\u7a0b\u76ee\u6807\u7684\u5360\u6bd4\u5408\u8ba1\u4e3a" + s + "\uff0c\u5e94\u7b49\u4e8e" + a.weight() + "."));
                    return;
                }
            });
        }
        return messages.toSeq();
    }

    public Seq<String> validateObjectives(Syllabus syllabus) {
        Buffer messages = Collections$.MODULE$.newBuffer();
        syllabus.topics().foreach((Function1)(JProcedure1 & Serializable)topic -> {
            if (!topic.exam()) {
                if (topic.objectives().isEmpty() || Strings$.MODULE$.isBlank((CharSequence)topic.objectives().get())) {
                    messages.$plus$eq((Object)("\u6559\u5b66\u4e3b\u9898:" + topic.name() + " \u7f3a\u5c11\u8bfe\u7a0b\u76ee\u6807"));
                    return;
                }
                return;
            }
        });
        syllabus.objectives().foreach((Function1)(JProcedure1 & Serializable)o -> {
            if (!syllabus.outcomes().exists((Function1 & Serializable)_$4 -> _$4.supportWith(o))) {
                messages.$plus$eq((Object)("\u8bfe\u7a0b\u76ee\u6807" + o.name() + " \u6ca1\u6709\u652f\u6491\u4efb\u4f55\u6bd5\u4e1a\u8981\u6c42"));
            }
            if (!syllabus.topics().exists((Function1 & Serializable)x -> x.objectives().exists((Function1 & Serializable)j -> {
                Object object = Predef$.MODULE$.refArrayOps((Object[])Strings$.MODULE$.split(j));
                return ArrayOps$.MODULE$.toSeq$extension(object).contains((Object)o.name());
            }))) {
                messages.$plus$eq((Object)("\u8bfe\u7a0b\u76ee\u6807" + o.name() + " \u6ca1\u6709\u4f53\u73b0\u5728\u6559\u5b66\u4e3b\u9898\u4e2d"));
                return;
            }
        });
        Buffer errorObjectives = Collections$.MODULE$.newBuffer();
        syllabus.outcomes().foreach((Function1 & Serializable)o -> {
            if (Strings$.MODULE$.isBlank((CharSequence)o.courseObjectives())) {
                return messages.$plus$eq((Object)("\u6bd5\u4e1a\u8981\u6c42" + o.title() + "\u7f3a\u5c11\u8bfe\u7a0b\u76ee\u6807\u652f\u6491"));
            }
            Object object = Predef$.MODULE$.refArrayOps((Object[])Strings$.MODULE$.split(o.courseObjectives()));
            ArrayOps$.MODULE$.foreach$extension(object, (Function1)(JProcedure1 & Serializable)obj -> {
                if (!syllabus.objectives().exists((Function1 & Serializable)_$5 -> {
                    String string = _$5.name();
                    String string2 = obj;
                    return !(string != null ? !string.equals(string2) : string2 != null);
                })) {
                    errorObjectives.addOne(obj);
                    return;
                }
            });
            return BoxedUnit.UNIT;
        });
        if (errorObjectives.nonEmpty()) {
            messages.$plus$eq((Object)("\u6bd5\u4e1a\u8981\u6c42\u652f\u6491\u77e9\u9635\u4e2d\u51fa\u73b0\u4e86\u9519\u8bef\u7684\u8bfe\u7a0b\u76ee\u6807:" + errorObjectives.mkString(",")));
        }
        errorObjectives.clear();
        syllabus.topics().foreach((Function1)(JProcedure1 & Serializable)topic -> topic.objectives().foreach((Function1)(JProcedure1 & Serializable)objectives -> {
            Object object = Predef$.MODULE$.refArrayOps((Object[])Strings$.MODULE$.split(objectives));
            ArrayOps$.MODULE$.foreach$extension(object, (Function1)(JProcedure1 & Serializable)obj -> {
                if (!syllabus.objectives().exists((Function1 & Serializable)_$6 -> {
                    String string = _$6.name();
                    String string2 = obj;
                    return !(string != null ? !string.equals(string2) : string2 != null);
                })) {
                    errorObjectives.addOne(obj);
                    return;
                }
            });
        }));
        if (errorObjectives.nonEmpty()) {
            messages.$plus$eq((Object)("\u6559\u5b66\u4e3b\u9898\u4e2d\u51fa\u73b0\u4e86\u9519\u8bef\u7684\u8bfe\u7a0b\u76ee\u6807:" + errorObjectives.mkString(",")));
        }
        return messages.toSeq();
    }

    public Seq<String> validateHours(Syllabus syllabus) {
        Buffer messages = Collections$.MODULE$.newBuffer();
        FloatRef total = FloatRef.create((float)0.0f);
        syllabus.hours().foreach((Function1)(JProcedure1 & Serializable)h -> total$1.elem += h.creditHours());
        if (Double.compare(total.elem, (double)syllabus.creditHours() * 1.0) != 0) {
            messages.$plus$eq((Object)("\u8bfe\u7a0b\u8981\u6c42" + syllabus.creditHours() + "\u5b66\u65f6\uff0c\u5206\u9879\u7d2f\u8ba1" + total.elem + "\u5b66\u65f6\uff0c\u8bf7\u68c0\u67e5\u3002"));
        }
        syllabus.hours().foreach((Function1)(JProcedure1 & Serializable)h -> {
            FloatRef t = FloatRef.create((float)0.0f);
            syllabus.topics().foreach((Function1)(JProcedure1 & Serializable)p -> t$1.elem += BoxesRunTime.unboxToFloat((Object)p.getHour(h.nature()).map((Function1 & Serializable)_$7 -> _$7.creditHours()).getOrElse(SyllabusValidator$::validateHours$$anonfun$2$$anonfun$1$$anonfun$2)));
            if (Double.compare(Float$.MODULE$.float2double(t.elem), Float$.MODULE$.float2double(h.creditHours())) != 0) {
                messages.$plus$eq((Object)("\u8bfe\u7a0b\u8981\u6c42" + h.nature().name() + h.creditHours() + "\u5b66\u65f6\uff0c\u6559\u5b66\u5185\u5bb9\u7d2f\u8ba1" + t.elem + "\u5b66\u65f6\uff0c\u8bf7\u68c0\u67e5\u3002"));
                return;
            }
        });
        FloatRef totalLearningHours = FloatRef.create((float)0.0f);
        syllabus.topics().foreach((Function1)(JProcedure1 & Serializable)t -> totalLearningHours$1.elem += t.learningHours());
        if (Predef$.MODULE$.float2Float(totalLearningHours.elem * (float)100).intValue() != Predef$.MODULE$.float2Float(syllabus.learningHours() * (float)100).intValue()) {
            messages.$plus$eq((Object)("\u81ea\u4e3b\u5b66\u4e60\u8981\u6c42" + syllabus.learningHours() + "\u5b66\u65f6\uff0c\u6559\u5b66\u5185\u5bb9\u7d2f\u8ba1" + totalLearningHours.elem + "\u5b66\u65f6\uff0c\u8bf7\u68c0\u67e5\u3002"));
        }
        syllabus.topics().foreach((Function1)(JProcedure1 & Serializable)p -> {
            float hours = BoxesRunTime.unboxToFloat((Object)((IterableOnceOps)p.hours().map((Function1 & Serializable)_$8 -> _$8.creditHours())).sum((Numeric)Numeric.FloatIsFractional$.MODULE$));
            if (hours == 0.0f && p.learningHours() == 0.0f) {
                if (p.hours().isEmpty()) {
                    messages.$plus$eq((Object)("\u6559\u5b66\u4e3b\u9898:" + p.name() + ",\u7f3a\u5c11\u5b66\u65f6\u5206\u5e03"));
                } else {
                    messages.$plus$eq((Object)("\u6559\u5b66\u4e3b\u9898:" + p.name() + ",\u5b66\u65f6\u4e3a0"));
                }
            }
            if (!p.exam() && p.methods().isEmpty()) {
                messages.$plus$eq((Object)("\u6559\u5b66\u4e3b\u9898:" + p.name() + ",\u7f3a\u5c11\u6559\u5b66\u65b9\u6cd5"));
                return;
            }
        });
        float totalExperimentHours = BoxesRunTime.unboxToFloat((Object)((IterableOnceOps)syllabus.experiments().map((Function1 & Serializable)_$9 -> _$9.experiment().creditHours())).sum((Numeric)Numeric.FloatIsFractional$.MODULE$));
        float totalPracticalHours = BoxesRunTime.unboxToFloat((Object)syllabus.hours().find((Function1 & Serializable)_$10 -> BoxesRunTime.unboxToInt((Object)_$10.nature().id()) == TeachingNature$.MODULE$.Practice()).map((Function1 & Serializable)_$11 -> _$11.creditHours()).getOrElse(SyllabusValidator$::$anonfun$11));
        if (totalExperimentHours > totalPracticalHours) {
            messages.$plus$eq((Object)("\u5b9e\u9a8c\u8981\u6c42" + totalExperimentHours + "\u5b66\u65f6\uff0c\u8d85\u8fc7\u4e86" + totalPracticalHours + "\u603b\u7684\u5b9e\u8df5\u5b66\u65f6\uff0c\u8bf7\u68c0\u67e5\u3002"));
        }
        return messages.toSeq();
    }

    private static final int $anonfun$2() {
        return 0;
    }

    private static final int $anonfun$4() {
        return 0;
    }

    private static final float validateHours$$anonfun$2$$anonfun$1$$anonfun$2() {
        return 0.0f;
    }

    private static final float $anonfun$11() {
        return 0.0f;
    }
}

