/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.course.web.action.admin;

import java.io.Serializable;
import org.beangle.commons.collection.Collections$;
import org.beangle.commons.lang.Numbers$;
import org.beangle.commons.lang.Strings$;
import org.beangle.data.dao.OqlBuilder;
import org.beangle.data.dao.OqlBuilder$;
import org.beangle.data.dao.QueryBuilder;
import org.beangle.data.model.NumId;
import org.beangle.webmvc.support.action.EntityAction;
import org.beangle.webmvc.support.action.RestfulAction;
import org.beangle.webmvc.view.View;
import org.openurp.base.edu.model.Course;
import org.openurp.base.edu.model.CourseJournal;
import org.openurp.base.model.AuditStatus;
import org.openurp.base.model.AuditStatus$;
import org.openurp.base.model.Project;
import org.openurp.base.service.ProjectConfigService;
import org.openurp.base.service.SemesterService;
import org.openurp.code.edu.model.CourseModule;
import org.openurp.code.edu.model.CourseNature;
import org.openurp.code.edu.model.CourseRank;
import org.openurp.code.edu.model.CourseRank$;
import org.openurp.code.edu.model.CourseTag;
import org.openurp.code.edu.model.ExamMode;
import org.openurp.code.edu.model.GradingMode;
import org.openurp.code.edu.model.TeachingNature;
import org.openurp.code.service.CodeService;
import org.openurp.edu.course.flow.NewCourseApply;
import org.openurp.edu.course.flow.NewCourseCategory;
import org.openurp.edu.course.flow.NewCourseDepart;
import org.openurp.edu.course.service.NewCourseService;
import org.openurp.starter.web.support.ProjectSupport;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.math.Ordering;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public class NewCourseAuditAction
extends RestfulAction<NewCourseApply>
implements ProjectSupport {
    private CodeService codeService;
    private ProjectConfigService configService;
    private SemesterService semesterService;
    private NewCourseService newCourseService;

    public NewCourseAuditAction() {
        ProjectSupport.$init$((ProjectSupport)this);
    }

    public CodeService codeService() {
        return this.codeService;
    }

    public ProjectConfigService configService() {
        return this.configService;
    }

    public SemesterService semesterService() {
        return this.semesterService;
    }

    public void codeService_$eq(CodeService x$1) {
        this.codeService = x$1;
    }

    public void configService_$eq(ProjectConfigService x$1) {
        this.configService = x$1;
    }

    public void semesterService_$eq(SemesterService x$1) {
        this.semesterService = x$1;
    }

    public String simpleEntityName() {
        return "apply";
    }

    public NewCourseService newCourseService() {
        return this.newCourseService;
    }

    public void newCourseService_$eq(NewCourseService x$1) {
        this.newCourseService = x$1;
    }

    public void indexSetting() {
        LazyRef lazyRef = new LazyRef();
        scala.collection.immutable.Seq departs = this.getDeparts(this.project$1(lazyRef));
        scala.collection.immutable.Seq courseDeparts = (scala.collection.immutable.Seq)this.entityDao().getAll(NewCourseDepart.class).map((Function1 & Serializable)_$2 -> _$2.depart());
        scala.collection.immutable.Seq diffs = (scala.collection.immutable.Seq)departs.diff((Seq)courseDeparts);
        departs = ((IterableOnceOps)((SeqOps)departs.toBuffer().subtractAll((IterableOnce)diffs)).sortBy((Function1 & Serializable)_$3 -> _$3.code(), (Ordering)Ordering.String$.MODULE$)).toSeq();
        this.put("departments", (Object)departs);
        this.put("categories", (Object)this.getCodes(NewCourseCategory.class, this.project$1(lazyRef)));
        this.put("ranks", this.getCodes(CourseRank.class, this.project$1(lazyRef)).filter((Function1 & Serializable)_$4 -> BoxesRunTime.unboxToInt((Object)_$4.id()) < 3));
        this.put("statuses", (Object)((SeqOps)new .colon.colon((Object)AuditStatus$.Submited, (List)new .colon.colon((Object)AuditStatus$.Passed, (List)new .colon.colon((Object)AuditStatus$.Rejected, (List)Nil$.MODULE$)))));
        super.indexSetting();
    }

    public OqlBuilder<NewCourseApply> getQueryBuilder() {
        LazyRef lazyRef = new LazyRef();
        OqlBuilder q = EntityAction.getQueryBuilder$((EntityAction)this);
        return this.queryByDepart(q, "apply.department");
    }

    public View auditSetting() {
        LazyRef lazyRef = new LazyRef();
        NewCourseApply apply = (NewCourseApply)this.entityDao().get(NewCourseApply.class, (Object)BoxesRunTime.boxToLong((long)this.getLongId("apply")));
        this.put("apply", (Object)apply);
        this.put("natures", (Object)this.getCodes(CourseNature.class, this.project$3(lazyRef)));
        this.put("modules", (Object)this.getCodes(CourseModule.class, this.project$3(lazyRef)));
        this.put("ranks", (Object)this.entityDao().find(CourseRank.class, (Iterable)new .colon.colon((Object)BoxesRunTime.boxToInteger((int)CourseRank$.MODULE$.Compulsory()), (List)new .colon.colon((Object)BoxesRunTime.boxToInteger((int)CourseRank$.MODULE$.Selective()), (List)Nil$.MODULE$))));
        this.put("teachingNatures", (Object)this.getCodes(TeachingNature.class, this.project$3(lazyRef)));
        this.put("categories", (Object)this.getCodes(NewCourseCategory.class, this.project$3(lazyRef)));
        this.put("examModes", (Object)this.getCodes(ExamMode.class, this.project$3(lazyRef)));
        this.put("gradingModes", (Object)this.getCodes(GradingMode.class, this.project$3(lazyRef)));
        this.put("tags", (Object)this.codeService().get(CourseTag.class));
        return this.forward(this.forward$default$1());
    }

    public View regen() {
        NewCourseApply apply = (NewCourseApply)this.entityDao().get(NewCourseApply.class, (Object)BoxesRunTime.boxToLong((long)this.getLongId("apply")));
        if (apply.code().isEmpty()) {
            return this.redirect("search", "\u8bf7\u9009\u62e9\u5ba1\u6279\u901a\u8fc7\u7684\u7533\u8bf7");
        }
        String oldCode = (String)apply.code().get();
        String newCode = this.generateCode(apply);
        apply.code_$eq((Option)Some$.MODULE$.apply((Object)newCode));
        Object[] objectArray = new Tuple2[2];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"project");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)apply.project());
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"code");
        objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)oldCode);
        scala.collection.immutable.Seq courses = this.entityDao().findBy(Course.class, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        courses.foreach((Function1)(JProcedure1 & Serializable)c -> c.code_$eq(newCode));
        this.entityDao().saveOrUpdate((Iterable)courses);
        this.entityDao().saveOrUpdate((Object)apply, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new NewCourseApply[0]));
        return this.redirect("search", "\u751f\u6210\u5b8c\u6210");
    }

    public View audit() {
        Buffer failed = Collections$.MODULE$.newBuffer();
        NewCourseApply apply = (NewCourseApply)this.populateEntity(NewCourseApply.class, "apply");
        AuditStatus auditStatus = apply.status();
        AuditStatus auditStatus2 = AuditStatus$.Passed;
        if (!(auditStatus != null ? !auditStatus.equals(auditStatus2) : auditStatus2 != null)) {
            return this.redirect("search", "\u5df2\u7ecf\u901a\u8fc7\u65e0\u9700\u518d\u5ba1");
        }
        boolean passed = this.getBoolean("passed", false);
        if (passed) {
            if (apply.code().nonEmpty()) {
                apply.status_$eq(AuditStatus$.Passed);
                this.entityDao().saveOrUpdate((Object)apply, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new NewCourseApply[0]));
                return this.redirect("search", "\u5ba1\u6838\u6210\u529f");
            }
            scala.collection.immutable.Seq errors = this.newCourseService().check(apply);
            if (errors.nonEmpty()) {
                return this.redirect("search", errors.mkString(","));
            }
            Course c = new Course();
            c.project_$eq(apply.project());
            c.code_$eq(this.generateCode(apply));
            c.name_$eq(apply.name());
            c.enName_$eq(apply.enName());
            c.module_$eq(apply.module());
            c.rank_$eq(apply.rank());
            c.nature_$eq(apply.nature());
            c.department_$eq(apply.department());
            c.defaultCredits_$eq(apply.defaultCredits());
            c.creditHours_$eq(apply.creditHours());
            c.weekHours_$eq(apply.weekHours());
            c.examMode_$eq(apply.examMode());
            c.gradingMode_$eq(apply.gradingMode());
            c.tags().addAll((IterableOnce)apply.tags());
            apply.hours().foreach((Function1)(JProcedure1 & Serializable)h -> c.addHour(h.nature(), h.creditHours()));
            c.beginOn_$eq(apply.beginOn());
            c.updatedAt_$eq(apply.updatedAt());
            this.entityDao().saveOrUpdate((Object)c, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Course[0]));
            CourseJournal cj = new CourseJournal(c, apply.beginOn());
            this.entityDao().saveOrUpdate((Object)cj, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CourseJournal[0]));
            apply.status_$eq(AuditStatus$.Passed);
            apply.code_$eq((Option)Some$.MODULE$.apply((Object)c.code()));
            this.entityDao().saveOrUpdate((Object)apply, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new NewCourseApply[0]));
        } else {
            apply.status_$eq(AuditStatus$.Rejected);
            this.entityDao().saveOrUpdate((Object)apply, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new NewCourseApply[0]));
        }
        return this.redirect("search", "\u5ba1\u6838\u6210\u529f");
    }

    private String generateCode(NewCourseApply apply) {
        String departCode = (String)this.entityDao().findBy(NewCourseDepart.class, "depart", (Object)apply.department()).headOption().map((Function1 & Serializable)_$5 -> _$5.code()).getOrElse(() -> NewCourseAuditAction.$anonfun$3(apply));
        String creditCode = (double)(apply.defaultCredits() % 1.0f) > 0.1 ? BoxesRunTime.boxToInteger((int)((int)apply.defaultCredits())).toString() + "H" : "0" + BoxesRunTime.boxToInteger((int)((int)apply.defaultCredits())).toString();
        String rankCode = BoxesRunTime.unboxToInt((Object)((NumId)apply.rank().get()).id()) == CourseRank$.MODULE$.Compulsory() ? "1" : "2";
        String categoryCode = apply.category().code();
        String seqCode = this.getSeq(apply, 3);
        return departCode + seqCode + creditCode + rankCode + categoryCode;
    }

    private String getSeq(NewCourseApply apply, int seqLength) {
        String departCode = (String)this.entityDao().findBy(NewCourseDepart.class, "depart", (Object)apply.department()).headOption().map((Function1 & Serializable)_$6 -> _$6.code()).getOrElse(() -> NewCourseAuditAction.$anonfun$5(apply));
        String codePattern = departCode + StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString("_"), seqLength) + "%";
        OqlBuilder q = OqlBuilder$.MODULE$.from(Course.class.getName(), "c");
        q.where("c.code like :pattern and c.name=:name", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{codePattern, apply.name()}));
        q.where("c.project=:project", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{apply.project()}));
        apply.code().foreach((Function1 & Serializable)code -> (OqlBuilder)q.where("c.code != :thisCourseCode", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{code})));
        q.select("c.code");
        scala.collection.immutable.Seq exists = this.entityDao().search((QueryBuilder)q);
        if (exists.nonEmpty()) {
            return ((String)exists.head()).substring(departCode.length(), departCode.length() + seqLength);
        }
        OqlBuilder q2 = OqlBuilder$.MODULE$.from(Course.class.getName(), "c");
        q2.where("c.code like :pattern", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{codePattern}));
        q2.where("c.project=:project", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{apply.project()}));
        apply.code().foreach((Function1 & Serializable)code -> (OqlBuilder)q2.where("c.code != :thisCourseCode", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{code})));
        q2.select("c.code");
        scala.collection.immutable.Seq codes = this.entityDao().search((QueryBuilder)q2);
        if (codes.nonEmpty()) {
            scala.collection.immutable.Seq seq = (scala.collection.immutable.Seq)((SeqOps)((SeqOps)((IterableOps)((IterableOps)codes.map((Function1 & Serializable)_$7 -> _$7.substring(departCode.length(), departCode.length() + seqLength))).filter((Function1 & Serializable)x -> Numbers$.MODULE$.isDigits(x))).map((Function1 & Serializable)_$8 -> StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(_$8)))).distinct()).sorted((Ordering)Ordering.Int$.MODULE$);
            int start = 1;
            Iterator iter = seq.iterator();
            boolean found = false;
            while (iter.hasNext() && !found) {
                int n = BoxesRunTime.unboxToInt((Object)iter.next());
                if (n - start <= 1) {
                    start = n;
                    continue;
                }
                found = true;
            }
            return Strings$.MODULE$.leftPad(BoxesRunTime.boxToInteger((int)(start + 1)).toString(), seqLength, '0');
        }
        return Strings$.MODULE$.leftPad("1", seqLength, '0');
    }

    private final Project project$lzyINIT1$1(LazyRef project$lzy1$1) {
        Project project;
        LazyRef lazyRef = project$lzy1$1;
        synchronized (lazyRef) {
            project = (Project)(project$lzy1$1.initialized() ? project$lzy1$1.value() : project$lzy1$1.initialize((Object)this.getProject()));
        }
        return project;
    }

    private final Project project$1(LazyRef project$lzy1$2) {
        return (Project)(project$lzy1$2.initialized() ? project$lzy1$2.value() : this.project$lzyINIT1$1(project$lzy1$2));
    }

    private final Project project$lzyINIT2$1(LazyRef project$lzy2$1) {
        Project project;
        LazyRef lazyRef = project$lzy2$1;
        synchronized (lazyRef) {
            project = (Project)(project$lzy2$1.initialized() ? project$lzy2$1.value() : project$lzy2$1.initialize((Object)this.getProject()));
        }
        return project;
    }

    private final Project project$2(LazyRef project$lzy2$2) {
        return (Project)(project$lzy2$2.initialized() ? project$lzy2$2.value() : this.project$lzyINIT2$1(project$lzy2$2));
    }

    private final Project project$lzyINIT3$1(LazyRef project$lzy3$1) {
        Project project;
        LazyRef lazyRef = project$lzy3$1;
        synchronized (lazyRef) {
            project = (Project)(project$lzy3$1.initialized() ? project$lzy3$1.value() : project$lzy3$1.initialize((Object)this.getProject()));
        }
        return project;
    }

    private final Project project$3(LazyRef project$lzy3$2) {
        return (Project)(project$lzy3$2.initialized() ? project$lzy3$2.value() : this.project$lzyINIT3$1(project$lzy3$2));
    }

    private static final String $anonfun$3(NewCourseApply apply$1) {
        return apply$1.department().code();
    }

    private static final String $anonfun$5(NewCourseApply apply$2) {
        return apply$2.department().code();
    }
}

