/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.course.web.action.program;

import java.io.File;
import java.io.Serializable;
import java.net.URI;
import org.beangle.data.dao.OqlBuilder;
import org.beangle.doc.core.PrintOptions;
import org.beangle.doc.pdf.SPDConverter$;
import org.beangle.ems.app.EmsApi$;
import org.beangle.webmvc.annotation.mapping;
import org.beangle.webmvc.annotation.param;
import org.beangle.webmvc.support.action.EntityAction;
import org.beangle.webmvc.support.action.ExportSupport;
import org.beangle.webmvc.support.action.RestfulAction;
import org.beangle.webmvc.view.Stream$;
import org.beangle.webmvc.view.View;
import org.openurp.base.model.Project;
import org.openurp.base.service.ProjectConfigService;
import org.openurp.base.service.SemesterService;
import org.openurp.code.service.CodeService;
import org.openurp.edu.clazz.model.Clazz;
import org.openurp.edu.course.model.ClazzPlan;
import org.openurp.edu.course.model.ClazzProgram;
import org.openurp.edu.course.model.LessonDesign;
import org.openurp.edu.course.web.helper.ClazzPlanHelper;
import org.openurp.edu.course.web.helper.ClazzProgramHelper$;
import org.openurp.edu.schedule.service.LessonSchedule$;
import org.openurp.edu.schedule.service.ScheduleDigestor$;
import org.openurp.starter.web.helper.ProjectProfile$;
import org.openurp.starter.web.support.ProjectSupport;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction0;

public class DepartAction
extends RestfulAction<ClazzProgram>
implements ProjectSupport,
ExportSupport<ClazzProgram> {
    private CodeService codeService;
    private ProjectConfigService configService;
    private SemesterService semesterService;

    public DepartAction() {
        ProjectSupport.$init$((ProjectSupport)this);
    }

    public CodeService codeService() {
        return this.codeService;
    }

    public ProjectConfigService configService() {
        return this.configService;
    }

    public SemesterService semesterService() {
        return this.semesterService;
    }

    public void codeService_$eq(CodeService x$1) {
        this.codeService = x$1;
    }

    public void configService_$eq(ProjectConfigService x$1) {
        this.configService = x$1;
    }

    public void semesterService_$eq(SemesterService x$1) {
        this.semesterService = x$1;
    }

    public void indexSetting() {
        LazyRef lazyRef = new LazyRef();
        super.indexSetting();
        Seq departs = this.getDeparts(this.project$1(lazyRef));
        this.put("departs", (Object)departs);
        this.put("project", (Object)this.project$1(lazyRef));
        this.put("semester", (Object)this.getSemester(this.project$1(lazyRef)));
        this.forward(this.forward$default$1());
    }

    public OqlBuilder<ClazzProgram> getQueryBuilder() {
        OqlBuilder query = EntityAction.getQueryBuilder$((EntityAction)this);
        Option lessonOn = this.getDate("lessonOn");
        Option unit = this.getShort("unit");
        if (lessonOn.nonEmpty() || unit.nonEmpty()) {
            if (lessonOn.nonEmpty() && unit.nonEmpty()) {
                query.where("exists(from clazzProgram.designs as d where d.lessonOn = :lessonOn and :unit between pair_1(d.units) and pair_2(d.units))", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{lessonOn.get(), unit.get()}));
            } else if (lessonOn.nonEmpty()) {
                query.where("exists(from clazzProgram.designs as d where d.lessonOn = :lessonOn)", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{lessonOn.get()}));
            } else {
                query.where("exists(from clazzProgram.designs as d where :unit between pair_1(d.units) and pair_2(d.units))", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{unit.get()}));
            }
        }
        return query;
    }

    @mapping(value="{id}")
    public View info(@param(value="id") String id) {
        ClazzProgram program = (ClazzProgram)this.entityDao().get(ClazzProgram.class, (Object)BoxesRunTime.boxToLong((long)this.getLongId("program")));
        Clazz clazz = program.clazz();
        ClazzPlan plan = (ClazzPlan)this.entityDao().findBy(ClazzPlan.class, "clazz", (Object)clazz).head();
        this.put("clazz", (Object)clazz);
        this.put("plan", (Object)plan);
        this.put("schedules", (Object)LessonSchedule$.MODULE$.convert(clazz));
        this.put("schedule", (Object)ScheduleDigestor$.MODULE$.digest(clazz, ":day :units(:time) :weeks :room"));
        this.put("program", (Object)program);
        Project project = program.clazz().project();
        ProjectProfile$.MODULE$.set(project);
        return this.forward(this.forward$default$1());
    }

    public View designReport() {
        Clazz clazz;
        LessonDesign design = (LessonDesign)this.entityDao().get(LessonDesign.class, (Object)BoxesRunTime.boxToLong((long)this.getLongId("design")));
        this.put("design", (Object)design);
        Option option = this.getLong("clazz.id");
        if (None$.MODULE$.equals(option)) {
            clazz = design.program().clazz();
        } else if (option instanceof Some) {
            long clazzId = BoxesRunTime.unboxToLong((Object)((Some)option).value());
            clazz = (Clazz)this.entityDao().get(Clazz.class, (Object)BoxesRunTime.boxToLong((long)clazzId));
        } else {
            throw new MatchError((Object)option);
        }
        Clazz clazz2 = clazz;
        this.put("plan", (Object)this.entityDao().findBy(ClazzPlan.class, "clazz", (Object)clazz2).headOption());
        Option syllabus = new ClazzPlanHelper(this.entityDao()).findSyllabus(clazz2);
        this.put("clazz", (Object)clazz2);
        this.put("syllabus", (Object)syllabus);
        Project project = design.program().clazz().project();
        ProjectProfile$.MODULE$.set(project);
        return this.forward("/org/openurp/edu/course/web/components/program/designReport");
    }

    public View designPdf() {
        long id = this.getLongId("design");
        long clazzId = this.getLongId("clazz");
        LessonDesign design = (LessonDesign)this.entityDao().get(LessonDesign.class, (Object)BoxesRunTime.boxToLong((long)id));
        String url = EmsApi$.MODULE$.url("/program/depart/designReport?design.id=" + id + "&clazz.id=" + clazzId);
        File pdf = File.createTempFile("doc", ".pdf");
        PrintOptions options = new PrintOptions();
        SPDConverter$.MODULE$.getInstance().convert(URI.create(url), pdf, options);
        Clazz clazz = design.program().clazz();
        return Stream$.MODULE$.apply(pdf, clazz.crn() + "_" + clazz.course().name() + (" \u6388\u8bfe\u6559\u6848 \u7b2c" + design.idx() + "\u6b21\u8bfe.pdf")).cleanup((Function0)(JFunction0.mcV.sp & Serializable)() -> pdf.delete());
    }

    public View fix() {
        Seq programs = this.entityDao().getAll(ClazzProgram.class);
        programs.foreach((Function1)(JProcedure1 & Serializable)p -> {
            ClazzProgramHelper$.MODULE$.updateStatInfo(p);
            this.entityDao().saveOrUpdate(p, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ClazzProgram[0]));
        });
        return this.forward(this.forward$default$1());
    }

    private final Project project$lzyINIT1$1(LazyRef project$lzy1$1) {
        Project project;
        LazyRef lazyRef = project$lzy1$1;
        synchronized (lazyRef) {
            project = (Project)(project$lzy1$1.initialized() ? project$lzy1$1.value() : project$lzy1$1.initialize((Object)this.getProject()));
        }
        return project;
    }

    private final Project project$1(LazyRef project$lzy1$2) {
        return (Project)(project$lzy1$2.initialized() ? project$lzy1$2.value() : this.project$lzyINIT1$1(project$lzy1$2));
    }
}

