/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.course.web.action.syllabus;

import java.io.File;
import java.io.Serializable;
import java.net.URI;
import java.util.Locale;
import org.beangle.commons.bean.PropertyExtractor;
import org.beangle.commons.bean.orderings.PropertyOrdering$;
import org.beangle.commons.collection.Collections$;
import org.beangle.commons.concurrent.Workers$;
import org.beangle.commons.file.zip.Zipper$;
import org.beangle.commons.io.Files$;
import org.beangle.commons.lang.Locales$;
import org.beangle.commons.lang.SystemInfo$;
import org.beangle.data.dao.OqlBuilder;
import org.beangle.data.dao.OqlBuilder$;
import org.beangle.data.dao.QueryBuilder;
import org.beangle.data.model.Entity;
import org.beangle.doc.core.PrintOptions;
import org.beangle.doc.pdf.SPDConverter$;
import org.beangle.doc.transfer.exporter.ExportContext;
import org.beangle.ems.app.EmsApi$;
import org.beangle.security.Securities$;
import org.beangle.webmvc.To;
import org.beangle.webmvc.annotation.mapping;
import org.beangle.webmvc.annotation.param;
import org.beangle.webmvc.context.ActionContext$;
import org.beangle.webmvc.support.action.EntityAction;
import org.beangle.webmvc.support.action.ExportSupport;
import org.beangle.webmvc.support.action.RestfulAction;
import org.beangle.webmvc.view.Stream$;
import org.beangle.webmvc.view.View;
import org.openurp.base.edu.model.TeachingOffice;
import org.openurp.base.model.AuditStatus;
import org.openurp.base.model.AuditStatus$;
import org.openurp.base.model.CalendarStage;
import org.openurp.base.model.Project;
import org.openurp.base.model.Semester;
import org.openurp.base.service.ProjectConfigService;
import org.openurp.base.service.SemesterService;
import org.openurp.code.edu.model.CourseModule;
import org.openurp.code.edu.model.CourseNature;
import org.openurp.code.edu.model.CourseRank;
import org.openurp.code.edu.model.ExamMode;
import org.openurp.code.edu.model.GradingMode;
import org.openurp.code.edu.model.TeachingNature;
import org.openurp.code.service.CodeService;
import org.openurp.edu.course.model.CourseTask;
import org.openurp.edu.course.model.Syllabus;
import org.openurp.edu.course.web.action.syllabus.ReviseAction;
import org.openurp.edu.course.web.helper.StatItem;
import org.openurp.edu.course.web.helper.SyllabusHelper;
import org.openurp.edu.course.web.helper.SyllabusPropertyExtractor;
import org.openurp.edu.course.web.helper.SyllabusValidator$;
import org.openurp.starter.web.helper.ProjectProfile$;
import org.openurp.starter.web.support.ProjectSupport;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Map;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction0;

/*
 * Exception performing whole class analysis ignored.
 */
public class DepartAction
extends RestfulAction<Syllabus>
implements ProjectSupport,
ExportSupport<Syllabus> {
    private CodeService codeService;
    private ProjectConfigService configService;
    private SemesterService semesterService;

    public DepartAction() {
        ProjectSupport.$init$((ProjectSupport)this);
    }

    public CodeService codeService() {
        return this.codeService;
    }

    public ProjectConfigService configService() {
        return this.configService;
    }

    public SemesterService semesterService() {
        return this.semesterService;
    }

    public void codeService_$eq(CodeService x$1) {
        this.codeService = x$1;
    }

    public void configService_$eq(ProjectConfigService x$1) {
        this.configService = x$1;
    }

    public void semesterService_$eq(SemesterService x$1) {
        this.semesterService = x$1;
    }

    public void indexSetting() {
        LazyRef lazyRef = new LazyRef();
        super.indexSetting();
        Seq departs = this.getDeparts(this.project$1(lazyRef));
        this.put("departs", (Object)departs);
        this.put("project", (Object)this.project$1(lazyRef));
        this.put("semester", (Object)this.getSemester(this.project$1(lazyRef)));
        this.put("statuses", package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AuditStatus[]{AuditStatus$.Draft, AuditStatus$.Submited, AuditStatus$.RejectedByDirector, AuditStatus$.PassedByDirector, AuditStatus$.RejectedByDepart, AuditStatus$.PassedByDepart, AuditStatus$.Rejected, AuditStatus$.Passed})));
        this.forward(this.forward$default$1());
    }

    public OqlBuilder<Syllabus> getQueryBuilder() {
        LazyRef lazyRef = new LazyRef();
        Object[] objectArray = new Tuple2[2];
        Locale locale = (Locale)Predef$.MODULE$.ArrowAssoc((Object)Locales$.MODULE$.chinese());
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)locale, (Object)"\u4e2d\u6587");
        Locale locale2 = (Locale)Predef$.MODULE$.ArrowAssoc((Object)Locales$.MODULE$.us());
        objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)locale2, (Object)"English");
        this.put("locales", Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)));
        Semester semester = (Semester)this.entityDao().get(Semester.class, (Object)BoxesRunTime.boxToInteger((int)this.getInt("semester.id", 0)));
        this.put("semester", (Object)semester);
        this.put("teachingNatures", (Object)this.getCodes(TeachingNature.class, this.project$2(lazyRef)));
        OqlBuilder query = EntityAction.getQueryBuilder$((EntityAction)this);
        query.where(":date between syllabus.beginOn and syllabus.endOn", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{semester.beginOn().plusDays(30L)}));
        this.getBoolean("hasTopics").foreach((Function1 & Serializable)hasTopics -> DepartAction.getQueryBuilder$$anonfun$1((OqlBuilder)query, (boolean)BoxesRunTime.unboxToBoolean((Object)hasTopics)));
        this.getBoolean("reuse").foreach((Function1 & Serializable)reuse -> DepartAction.getQueryBuilder$$anonfun$2((OqlBuilder)query, (Semester)semester, (boolean)BoxesRunTime.unboxToBoolean((Object)reuse)));
        return this.queryByDepart(query, "syllabus.department");
    }

    public View audit() {
        Seq syllabuses = this.entityDao().find(Syllabus.class, (Iterable)this.getLongIds("syllabus"));
        this.getBoolean("passed").foreach((Function1 & Serializable)v1 -> {
            DepartAction.audit$$anonfun$1((Seq)syllabuses, (boolean)BoxesRunTime.unboxToBoolean((Object)v1));
            return BoxedUnit.UNIT;
        });
        this.entityDao().saveOrUpdate((Iterable)syllabuses);
        return this.redirect("search", "\u5ba1\u6838\u6210\u529f");
    }

    public View removeAndRedirect(Seq<Syllabus> syllabuses) {
        Seq removables = (Seq)((SeqOps)new .colon.colon((Object)AuditStatus$.RejectedByDirector, (List)new .colon.colon((Object)AuditStatus$.RejectedByDepart, (List)new .colon.colon((Object)AuditStatus$.Draft, (List)Nil$.MODULE$))));
        return super.removeAndRedirect((Seq)syllabuses.filter((Function1 & Serializable)x -> removables.contains((Object)x.status())));
    }

    public void editSetting(Syllabus syllabus) {
        LazyRef lazyRef = new LazyRef();
        this.put("project", (Object)this.project$3(lazyRef));
        this.put("departments", (Object)new .colon.colon((Object)syllabus.department(), (List)Nil$.MODULE$));
        this.put("teachingNatures", (Object)this.getCodes(TeachingNature.class, this.project$3(lazyRef)));
        this.put("courseNatures", (Object)this.getCodes(CourseNature.class, this.project$3(lazyRef)));
        this.put("examModes", (Object)this.getCodes(ExamMode.class, this.project$3(lazyRef)));
        this.put("gradingModes", (Object)this.getCodes(GradingMode.class, this.project$3(lazyRef)));
        this.put("courseModules", (Object)this.getCodes(CourseModule.class, this.project$3(lazyRef)));
        this.put("courseRanks", (Object)this.getCodes(CourseRank.class, this.project$3(lazyRef)));
        OqlBuilder s = OqlBuilder$.MODULE$.from(CalendarStage.class, "s");
        s.where("s.school=:school and s.vacation=false", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.project$3(lazyRef).school()}));
        OqlBuilder oqlBuilder = (OqlBuilder)s.orderBy("s.startWeek");
        oqlBuilder.cacheable(oqlBuilder.cacheable$default$1());
        this.put("calendarStages", (Object)this.entityDao().search((QueryBuilder)s));
        Object[] objectArray = new Tuple2[2];
        Locale locale = (Locale)Predef$.MODULE$.ArrowAssoc((Object)Locales$.MODULE$.chinese());
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)locale, (Object)"\u4e2d\u6587\u5927\u7eb2");
        Locale locale2 = (Locale)Predef$.MODULE$.ArrowAssoc((Object)Locales$.MODULE$.us());
        objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)locale2, (Object)"English Syllabus");
        this.put("locales", Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)));
        Object[] objectArray2 = new Tuple2[2];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"project");
        objectArray2[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)this.project$3(lazyRef));
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"department");
        objectArray2[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)syllabus.department());
        this.put("offices", (Object)this.entityDao().findBy(TeachingOffice.class, (Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray2)));
        super.editSetting((Entity)syllabus);
    }

    @mapping(value="{id}")
    public View info(@param(value="id") String id) {
        Semester semester;
        Syllabus syllabus = (Syllabus)this.entityDao().get(Syllabus.class, (Object)BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(id))));
        new SyllabusHelper(this.entityDao()).collectDatas(syllabus).foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                Object v = tuple2._2();
                this.put(k, v);
                return;
            }
            throw new MatchError((Object)tuple2);
        });
        Project project = syllabus.course().project();
        ProjectProfile$.MODULE$.set(project);
        Seq messages = SyllabusValidator$.MODULE$.validate(syllabus);
        this.put("messages", (Object)messages);
        Option option = this.getInt("semester.id");
        if (option instanceof Some) {
            int sid = BoxesRunTime.unboxToInt((Object)((Some)option).value());
            semester = (Semester)this.entityDao().get(Semester.class, (Object)BoxesRunTime.boxToInteger((int)sid));
        } else if (None$.MODULE$.equals(option)) {
            semester = syllabus.semester();
        } else {
            throw new MatchError((Object)option);
        }
        Semester semester2 = semester;
        this.put("semester", (Object)semester2);
        return this.forward("/org/openurp/edu/course/web/components/syllabus/report_" + syllabus.docLocale());
    }

    public View download() {
        Object semesterParam;
        Seq syllabuses = this.entityDao().find(Syllabus.class, (Iterable)this.getLongIds("syllabus"));
        String pdfDir = SystemInfo$.MODULE$.tmpDir() + "/" + ("syllabus_" + Securities$.MODULE$.user());
        Files$.MODULE$.travel(new File(pdfDir), (Function1)(JProcedure1 & Serializable)f -> f.delete());
        String contextPath = ActionContext$.MODULE$.current().request().getContextPath();
        new File(pdfDir).mkdirs();
        String semesterId = (String)this.get("semester.id", (Object)"");
        Object object = semesterParam = StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(semesterId)) ? "?semester.id=" + semesterId : "";
        if (syllabuses.size() == 1) {
            Syllabus syllabus = (Syllabus)syllabuses.head();
            String contextPath2 = ActionContext$.MODULE$.current().request().getContextPath();
            String url = EmsApi$.MODULE$.url(contextPath2, "/syllabus/depart/" + syllabus.id() + (String)semesterParam);
            String fileName = Files$.MODULE$.purify(syllabus.course().code() + "_" + syllabus.course().name() + "_" + syllabus.writer().name() + "_\u8bfe\u7a0b\u5927\u7eb2");
            File pdf = new File(pdfDir + ("/" + fileName + ".pdf"));
            PrintOptions options = new PrintOptions();
            options.scale_$eq(0.66);
            Predef$.MODULE$.println((Object)("download " + url + " to " + pdf.getAbsolutePath()));
            SPDConverter$.MODULE$.getInstance().convert(URI.create(url), pdf, options);
            return Stream$.MODULE$.apply(pdf).cleanup((Function0)(JFunction0.mcV.sp & Serializable)() -> pdf.delete());
        }
        Seq datas = (Seq)syllabuses.map((Function1 & Serializable)x -> Tuple2$.MODULE$.apply(x.id(), (Object)Files$.MODULE$.purify(x.course().code() + "_" + x.course().name() + "_" + x.writer().name() + "_\u8bfe\u7a0b\u5927\u7eb2")));
        String contextPath3 = ActionContext$.MODULE$.current().request().getContextPath();
        Workers$.MODULE$.work((Iterable)datas, (Function1)((JProcedure1 & Serializable)arg_0 -> DepartAction.download$$anonfun$3(contextPath3, (String)semesterParam, pdfDir, arg_0)), Runtime.getRuntime().availableProcessors());
        File zipFile = new File(SystemInfo$.MODULE$.tmpDir() + ("/syllabus" + Securities$.MODULE$.user() + ".zip"));
        Zipper$.MODULE$.zip(new File(pdfDir), zipFile, "utf-8");
        return Stream$.MODULE$.apply(zipFile).cleanup((Function0)(JFunction0.mcV.sp & Serializable)() -> {
            zipFile.delete();
            Files$.MODULE$.travel(new File(pdfDir), (Function1)(JProcedure1 & Serializable)f -> f.delete());
        });
    }

    public void configExport(ExportContext context) {
        ExportSupport.configExport$((ExportSupport)this, (ExportContext)context);
        Semester semester = (Semester)this.entityDao().get(Semester.class, (Object)BoxesRunTime.boxToInteger((int)this.getInt("semester.id", 0)));
        context.extractor_$eq((PropertyExtractor)new SyllabusPropertyExtractor(semester));
    }

    public View stat() {
        Project project = this.getProject();
        Semester semester = (Semester)this.entityDao().get(Semester.class, (Object)BoxesRunTime.boxToInteger((int)this.getIntId("semester")));
        OqlBuilder q = OqlBuilder$.MODULE$.from(CourseTask.class.getName(), "t");
        q.where("t.course.project=:project and t.semester=:semester", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{project, semester}));
        q.where("t.syllabusRequired=true", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
        q.groupBy("t.department.id,t.department.code,t.department.name,t.department.shortName");
        q.select("t.department.id,t.department.code,t.department.name,t.department.shortName,count(*)");
        Seq taskStats = this.entityDao().search((QueryBuilder)q);
        OqlBuilder q2 = OqlBuilder$.MODULE$.from(Syllabus.class.getName(), "s");
        q2.where(":date between s.beginOn and s.endOn", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{semester.beginOn().plusDays(30L)}));
        q2.where("s.course.project=:project", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{project}));
        q2.where("exists(from " + CourseTask.class.getName() + " ct where ct.course=s.course and ct.syllabusRequired=true and ct.semester=:semester)", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{semester}));
        q2.groupBy("s.department.id");
        q2.select("s.department.id,count(distinct s.course.id)");
        q2.where("s.status != :status", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{AuditStatus$.Draft}));
        Seq syllabusStats = this.entityDao().search((QueryBuilder)q2);
        Buffer items = Collections$.MODULE$.newBuffer();
        taskStats.foreach((Function1 & Serializable)stat -> {
            Map entry = Collections$.MODULE$.newMap();
            Object enName = stat[3] == null ? stat[2] : stat[3];
            Object[] objectArray = new Tuple2[4];
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"id");
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)stat[0].toString());
            String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"code");
            objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)stat[1].toString());
            String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"name");
            objectArray[2] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Object)stat[2].toString());
            String string4 = (String)Predef$.MODULE$.ArrowAssoc((Object)"shortName");
            objectArray[3] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string4, enName);
            entry.addAll((IterableOnce)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)));
            StatItem item = new StatItem();
            item.entry_$eq((Object)entry);
            Object s2 = syllabusStats.find((Function1 & Serializable)_$1 -> BoxesRunTime.equals((Object)_$1[0], (Object)stat[0])).map((Function1 & Serializable)_$2 -> (Number)_$2[1]).getOrElse(DepartAction::$anonfun$4);
            item.counters_$eq((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{(Number)stat[4], s2})));
            return (Buffer)items.addOne((Object)item);
        });
        this.put("project", (Object)project);
        this.put("semester", (Object)semester);
        this.put("items", items.sorted(PropertyOrdering$.MODULE$.by("entry(code)")));
        return this.forward(this.forward$default$1());
    }

    public View revise() {
        long id = this.getLongId("syllabus");
        return this.redirect((To)this.to(ReviseAction.class, "edit", "syllabus.id=" + id), null);
    }

    private final Project project$lzyINIT1$1(LazyRef project$lzy1$1) {
        Project project;
        LazyRef lazyRef = project$lzy1$1;
        synchronized (lazyRef) {
            project = (Project)(project$lzy1$1.initialized() ? project$lzy1$1.value() : project$lzy1$1.initialize((Object)this.getProject()));
        }
        return project;
    }

    private final Project project$1(LazyRef project$lzy1$2) {
        return (Project)(project$lzy1$2.initialized() ? project$lzy1$2.value() : this.project$lzyINIT1$1(project$lzy1$2));
    }

    private final Project project$lzyINIT2$1(LazyRef project$lzy2$1) {
        Project project;
        LazyRef lazyRef = project$lzy2$1;
        synchronized (lazyRef) {
            project = (Project)(project$lzy2$1.initialized() ? project$lzy2$1.value() : project$lzy2$1.initialize((Object)this.getProject()));
        }
        return project;
    }

    private final Project project$2(LazyRef project$lzy2$2) {
        return (Project)(project$lzy2$2.initialized() ? project$lzy2$2.value() : this.project$lzyINIT2$1(project$lzy2$2));
    }

    private static final /* synthetic */ OqlBuilder getQueryBuilder$$anonfun$1(OqlBuilder query$1, boolean hasTopics) {
        if (hasTopics) {
            return (OqlBuilder)query$1.where("size(syllabus.topics)>0", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
        }
        return (OqlBuilder)query$1.where("size(syllabus.topics)=0", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
    }

    private static final /* synthetic */ OqlBuilder getQueryBuilder$$anonfun$2(OqlBuilder query$2, Semester semester$1, boolean reuse) {
        if (reuse) {
            return (OqlBuilder)query$2.where("syllabus.beginOn < :thisSemesterBeginOn", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{semester$1.beginOn()}));
        }
        return (OqlBuilder)query$2.where("syllabus.semester = :thisSemester ", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{semester$1}));
    }

    private static final /* synthetic */ void audit$$anonfun$1(Seq syllabuses$1, boolean passed) {
        AuditStatus status = passed ? AuditStatus$.PassedByDepart : AuditStatus$.RejectedByDepart;
        syllabuses$1.foreach((Function1)(JProcedure1 & Serializable)s -> {
            AuditStatus auditStatus = status;
            AuditStatus auditStatus2 = AuditStatus$.PassedByDepart;
            if (!(auditStatus != null ? !auditStatus.equals(auditStatus2) : auditStatus2 != null)) {
                if (s.reviewer().nonEmpty() && s.approver().nonEmpty()) {
                    s.status_$eq(status);
                    return;
                }
            }
            s.status_$eq(status);
        });
    }

    private final Project project$lzyINIT3$1(LazyRef project$lzy3$1) {
        Project project;
        LazyRef lazyRef = project$lzy3$1;
        synchronized (lazyRef) {
            project = (Project)(project$lzy3$1.initialized() ? project$lzy3$1.value() : project$lzy3$1.initialize((Object)this.getProject()));
        }
        return project;
    }

    private final Project project$3(LazyRef project$lzy3$2) {
        return (Project)(project$lzy3$2.initialized() ? project$lzy3$2.value() : this.project$lzyINIT3$1(project$lzy3$2));
    }

    private static final /* synthetic */ void download$$anonfun$3(String contextPath$1, String semesterParam$1, String pdfDir$1, Tuple2 data) {
        String url = EmsApi$.MODULE$.url(contextPath$1, "/syllabus/depart/" + data._1() + semesterParam$1);
        File pdf = new File(pdfDir$1 + ("/" + data._2() + ".pdf"));
        Predef$.MODULE$.println((Object)("download " + url + " to " + pdf.getAbsolutePath()));
        PrintOptions options = new PrintOptions();
        options.scale_$eq(0.66);
        SPDConverter$.MODULE$.getInstance().convert(URI.create(url), pdf, options);
    }

    private static final Object $anonfun$4() {
        return BoxesRunTime.boxToInteger((int)0);
    }
}

