/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.course.web.helper;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Locale;
import org.beangle.commons.collection.Collections$;
import org.beangle.data.dao.EntityDao;
import org.beangle.data.dao.OqlBuilder;
import org.beangle.data.dao.OqlBuilder$;
import org.beangle.data.dao.QueryBuilder;
import org.openurp.base.model.AuditStatus;
import org.openurp.base.model.AuditStatus$;
import org.openurp.base.model.Semester;
import org.openurp.edu.clazz.model.Clazz;
import org.openurp.edu.course.model.ClazzPlan;
import org.openurp.edu.course.model.CourseTask;
import org.openurp.edu.course.model.Syllabus;
import org.openurp.edu.schedule.service.LessonSchedule$;
import org.openurp.edu.schedule.service.ScheduleDigestor$;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.mutable.Buffer;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public class ClazzPlanHelper {
    private final EntityDao entityDao;

    public ClazzPlanHelper(EntityDao entityDao) {
        this.entityDao = entityDao;
    }

    public CourseTask findCourseTask(Clazz clazz) {
        OqlBuilder q = OqlBuilder$.MODULE$.from(CourseTask.class, "c");
        q.where("c.course.project=:project", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{clazz.project()}));
        q.where("c.semester=:semester", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{clazz.semester()}));
        q.where("c.course=:course", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{clazz.course()}));
        scala.collection.immutable.Seq tasks = this.entityDao.search((QueryBuilder)q);
        if (tasks.isEmpty()) {
            return null;
        }
        if (tasks.size() == 1) {
            return (CourseTask)tasks.head();
        }
        return (CourseTask)tasks.find((Function1 & Serializable)x -> clazz.teachers().toSet().subsetOf((Set)x.teachers())).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public scala.collection.immutable.Map<Clazz, CourseTask> findCourseTasks(Iterable<Clazz> clazzes) {
        if (clazzes.isEmpty()) {
            return Predef$.MODULE$.Map().empty();
        }
        Clazz headClazz = (Clazz)clazzes.head();
        scala.collection.immutable.Set courses = ((IterableOnceOps)clazzes.map((Function1 & Serializable)_$1 -> _$1.course())).toSet();
        OqlBuilder q = OqlBuilder$.MODULE$.from(CourseTask.class, "c");
        q.where("c.course.project=:project", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{headClazz.project()}));
        q.where("c.semester=:semester", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{headClazz.semester()}));
        q.where("c.course in(:courses)", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{courses}));
        q.where("c.director is not null", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
        scala.collection.immutable.Map courseTasks = this.entityDao.search((QueryBuilder)q).groupBy((Function1 & Serializable)_$2 -> _$2.course());
        scala.collection.mutable.Map maps = Collections$.MODULE$.newMap();
        clazzes.foreach((Function1)(JProcedure1 & Serializable)clazz -> courseTasks.get((Object)clazz.course()).foreach((Function1)(JProcedure1 & Serializable)tasks -> {
            if (tasks.nonEmpty()) {
                if (tasks.size() == 1) {
                    maps.put(clazz, tasks.head());
                    return;
                }
                tasks.find((Function1 & Serializable)x -> clazz.teachers().toSet().subsetOf((Set)x.teachers())).foreach((Function1 & Serializable)t -> maps.put(clazz, t));
                return;
            }
        }));
        return maps.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public Iterable<Clazz> getCourseTaskClazzes(CourseTask task) {
        scala.collection.mutable.Set clazzes = Collections$.MODULE$.newSet();
        OqlBuilder q = OqlBuilder$.MODULE$.from(CourseTask.class, "c");
        q.where("c.course.project=:project", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{task.course().project()}));
        q.where("c.semester=:semester", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{task.semester()}));
        q.where("c.course=:course", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{task.course()}));
        q.where("c.id != :taskId", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{task.id()}));
        scala.collection.immutable.Seq otherCourseTasks = this.entityDao.search((QueryBuilder)q);
        OqlBuilder query = OqlBuilder$.MODULE$.from(Clazz.class, "clazz");
        query.where("clazz.project=:project and clazz.semester=:semester", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{task.course().project(), task.semester()}));
        query.where("clazz.course =:course", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{task.course()}));
        scala.collection.immutable.Seq courseClazzes = this.entityDao.search((QueryBuilder)query);
        if (otherCourseTasks.isEmpty()) {
            v0 = clazzes.addAll((IterableOnce)courseClazzes);
        } else {
            courseClazzes.foreach((Function1)(JProcedure1 & Serializable)clazz -> {
                scala.collection.immutable.Set clazzTeachers = clazz.teachers().toSet();
                if (clazzTeachers.subsetOf((Set)task.teachers())) {
                    clazzes.addOne(clazz);
                    return;
                }
            });
            v0 = BoxedUnit.UNIT;
        }
        return clazzes;
    }

    public Option<Syllabus> findSyllabus(Clazz clazz) {
        OqlBuilder query = OqlBuilder$.MODULE$.from(Syllabus.class, "s");
        query.where("s.course=:course", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{clazz.course()}));
        query.where("s.beginOn<=:beginOn and (s.endOn is null or s.endOn >:endOn)", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{clazz.semester().beginOn(), clazz.semester().beginOn()}));
        query.orderBy("s.beginOn desc");
        scala.collection.immutable.Seq syllabuses = this.entityDao.search((QueryBuilder)query);
        if (syllabuses.size() == 1) {
            return syllabuses.headOption();
        }
        OqlBuilder q = OqlBuilder$.MODULE$.from(CourseTask.class, "t");
        q.where("t.course=:course", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{clazz.course()}));
        q.where("t.semester=:semester", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{clazz.semester()}));
        scala.collection.immutable.Set clazzTeachers = clazz.teachers().toSet();
        scala.collection.immutable.Seq tasks = (scala.collection.immutable.Seq)this.entityDao.search((QueryBuilder)q).filter((Function1 & Serializable)x -> clazzTeachers.subsetOf((Set)x.teachers()));
        if (tasks.isEmpty()) {
            return this.chooseZhFirst((Iterable)syllabuses);
        }
        scala.collection.immutable.Set writerCodes = ((IterableOnceOps)tasks.flatMap((Function1 & Serializable)_$3 -> _$3.director().map((Function1 & Serializable)_$4 -> _$4.code()))).toSet();
        scala.collection.immutable.Seq taskSyllabuses = (scala.collection.immutable.Seq)syllabuses.filter((Function1 & Serializable)x -> writerCodes.contains((Object)x.writer().code()));
        return this.chooseZhFirst((Iterable)taskSyllabuses);
    }

    private Option<Syllabus> chooseZhFirst(Iterable<Syllabus> syllabuses) {
        if (syllabuses.size() < 2) {
            return syllabuses.headOption();
        }
        Locale zh = Locale.SIMPLIFIED_CHINESE;
        Iterable nonDraft = (Iterable)syllabuses.filter((Function1 & Serializable)_$5 -> {
            AuditStatus auditStatus = _$5.status();
            AuditStatus auditStatus2 = AuditStatus$.Draft;
            return auditStatus == null ? auditStatus2 != null : !auditStatus.equals(auditStatus2);
        });
        if (nonDraft.nonEmpty()) {
            return nonDraft.find((Function1 & Serializable)_$6 -> {
                Locale locale = _$6.docLocale();
                Locale locale2 = zh;
                return !(locale != null ? !((Object)locale).equals(locale2) : locale2 != null);
            }).orElse(() -> ClazzPlanHelper.chooseZhFirst$$anonfun$2(nonDraft));
        }
        return syllabuses.find((Function1 & Serializable)_$7 -> {
            Locale locale = _$7.docLocale();
            Locale locale2 = zh;
            return !(locale != null ? !((Object)locale).equals(locale2) : locale2 != null);
        }).orElse(() -> ClazzPlanHelper.chooseZhFirst$$anonfun$4(syllabuses));
    }

    public Map<String, Object> collectDatas(ClazzPlan plan) {
        scala.collection.mutable.Map datas = Collections$.MODULE$.newMap();
        Clazz clazz = plan.clazz();
        datas.put((Object)"plan", (Object)plan);
        datas.put((Object)"clazz", (Object)clazz);
        datas.put((Object)"schedule_time", (Object)ScheduleDigestor$.MODULE$.digest(clazz, ":day :units :weeks"));
        datas.put((Object)"schedule_space", (Object)((IterableOnceOps)((IterableOnceOps)clazz.schedule().activities().flatMap((Function1 & Serializable)_$8 -> _$8.rooms())).toSet().map((Function1 & Serializable)_$9 -> _$9.name())).mkString(","));
        Buffer dates = Collections$.MODULE$.newBuffer();
        Semester semester = clazz.semester();
        LocalDateTime beginAt = semester.beginOn().atTime(LocalTime.MIN);
        LocalDateTime endAt = semester.endOn().atTime(LocalTime.MAX);
        datas.put((Object)"syllabus", (Object)this.findSyllabus(clazz));
        Seq schedules = LessonSchedule$.MODULE$.convert(clazz);
        datas.put((Object)"schedules", (Object)schedules);
        return datas;
    }

    private static final Option chooseZhFirst$$anonfun$2(Iterable nonDraft$1) {
        return nonDraft$1.headOption();
    }

    private static final Option chooseZhFirst$$anonfun$4(Iterable syllabuses$1) {
        return syllabuses$1.headOption();
    }
}

