/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.course.web.helper;

import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Iterator;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.apache.poi.xwpf.usermodel.XWPFTableRow;
import org.beangle.commons.collection.Collections$;
import org.beangle.commons.lang.Numbers$;
import org.beangle.commons.lang.Strings$;
import org.beangle.doc.docx.DocParser;
import org.beangle.doc.html.Document;
import org.beangle.doc.html.Dom;
import org.beangle.doc.html.DomNode;
import org.openurp.edu.course.model.LessonDesign;
import org.openurp.edu.course.model.LessonDesignSection;
import org.openurp.edu.course.model.LessonDesignText;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.collection.IterableOnce;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.StringBuilder;
import scala.jdk.javaapi.CollectionConverters$;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.function.JProcedure1;

public class LessonDesignDocParser {
    private XWPFDocument doc;
    private Buffer tables = Collections$.MODULE$.newBuffer();
    private final Document tmpDoc = new Document();
    private final DocParser parser = new DocParser(this.tmpDoc());
    private int sectionIdx = 1;
    private final Seq<String[]> seqIndices = (Seq)((SeqOps)new .colon.colon((Object)new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15"}, (List)new .colon.colon((Object)new String[]{"\u4e00", "\u4e8c", "\u4e09", "\u56db", "\u4e94", "\u516d", "\u4e03", "\u516b", "\u4e5d", "\u5341", "\u5341\u4e00", "\u5341\u4e8c", "\u5341\u4e09", "\u5341\u56db", "\u5341\u4e94"}, (List)new .colon.colon((Object)new String[]{"I", "II", "III", "IV", "V", "VI", "VII", "VIII", "IX", "X", "XI", "XII", "XIII", "XIV", "XV"}, (List)Nil$.MODULE$))));

    public XWPFDocument doc() {
        return this.doc;
    }

    public void doc_$eq(XWPFDocument x$1) {
        this.doc = x$1;
    }

    public Buffer<XWPFTable> tables() {
        return this.tables;
    }

    public void tables_$eq(Buffer<XWPFTable> x$1) {
        this.tables = x$1;
    }

    public Document tmpDoc() {
        return this.tmpDoc;
    }

    public DocParser parser() {
        return this.parser;
    }

    public int sectionIdx() {
        return this.sectionIdx;
    }

    public void sectionIdx_$eq(int x$1) {
        this.sectionIdx = x$1;
    }

    public void main(String[] args) {
        Tuple3 rs = this.parse((InputStream)new FileInputStream("C:\\Users\\duantihua\\Desktop\\ja.docx"));
        Predef$.MODULE$.println(rs._1());
        ((Option)rs._1()).foreach((Function1)(JProcedure1 & Serializable)d -> Predef$.MODULE$.println((Object)d.homework()));
    }

    public Tuple3<Option<LessonDesign>, Option<Document>, String> parse(InputStream is) {
        Option option;
        this.doc_$eq(new XWPFDocument(is));
        this.tables_$eq((Buffer)this.tables().addAll((IterableOnce)CollectionConverters$.MODULE$.asScala(this.doc().getTables())));
        if (this.tables().nonEmpty()) {
            this.markUsed((XWPFTable)this.tables().head());
        }
        if (None$.MODULE$.equals(option = this.findProgramTable(this.doc()))) {
            return Tuple3$.MODULE$.apply((Object)None$.MODULE$, (Object)None$.MODULE$, (Object)"\u627e\u4e0d\u5230\u6559\u6848\u6240\u5728\u7684\u8868\u683c");
        }
        if (option instanceof Some) {
            XWPFTable table = (XWPFTable)((Some)option).value();
            this.markUsed(table);
            Option option2 = this.findSectionTitleRowIndex(table);
            if (None$.MODULE$.equals(option2)) {
                Option option3 = this.findSummaryDetailTable();
                if (None$.MODULE$.equals(option3)) {
                    return Tuple3$.MODULE$.apply((Object)None$.MODULE$, (Object)None$.MODULE$, (Object)"\u627e\u4e0d\u5230\u6559\u5b66\u5185\u5bb9\u4e0e\u8fc7\u7a0b\u8bbe\u8ba1");
                }
                if (option3 instanceof Some) {
                    XWPFTable detailTable = (XWPFTable)((Some)option3).value();
                    this.markUsed(detailTable);
                    LessonDesign design = this.readDesign(table, Integer.MAX_VALUE);
                    this.readSections(design, detailTable, 0);
                    this.readRemindSections(design);
                    return Tuple3$.MODULE$.apply((Object)Some$.MODULE$.apply((Object)design), (Object)Some$.MODULE$.apply((Object)this.tmpDoc()), (Object)"");
                }
                throw new MatchError((Object)option3);
            }
            if (option2 instanceof Some) {
                int row = BoxesRunTime.unboxToInt((Object)((Some)option2).value());
                LessonDesign design = this.readDesign(table, row);
                this.readSections(design, table, row);
                this.readRemindSections(design);
                return Tuple3$.MODULE$.apply((Object)Some$.MODULE$.apply((Object)design), (Object)Some$.MODULE$.apply((Object)this.tmpDoc()), (Object)"");
            }
            throw new MatchError((Object)option2);
        }
        throw new MatchError((Object)option);
    }

    private void readRemindSections(LessonDesign design) {
        while (this.tables().nonEmpty()) {
            XWPFTable table = (XWPFTable)this.tables().head();
            this.markUsed(table);
            this.readSections(design, table, -1);
        }
    }

    private LessonDesign readDesign(XWPFTable table, int separatorIndex) {
        LessonDesign ld = new LessonDesign();
        Iterator rowIter = table.getRows().iterator();
        int i = 0;
        while (rowIter.hasNext()) {
            XWPFTableRow row = (XWPFTableRow)rowIter.next();
            if (i < separatorIndex) {
                String title = ((XWPFTableCell)row.getTableCells().get(0)).getText();
                if (title.contains("\u6559\u5b66\u4e3b\u9898")) {
                    ld.subject_$eq(this.readCell((XWPFTableCell)row.getTableCells().get(1)));
                } else {
                    this.readText(title, (XWPFTableCell)row.getTableCells().get(1), ld);
                }
            }
            ++i;
        }
        return ld;
    }

    private void readSections(LessonDesign design, XWPFTable table, int separatorIndex) {
        Iterator rowIter = table.getRows().iterator();
        int i = 0;
        while (rowIter.hasNext()) {
            XWPFTableRow row = (XWPFTableRow)rowIter.next();
            if (i > separatorIndex) {
                Buffer sectionRows = Collections$.MODULE$.newBuffer();
                sectionRows.addOne((Object)row);
                for (int fectched = 0; rowIter.hasNext() && fectched < 2; ++fectched) {
                    row = (XWPFTableRow)rowIter.next();
                    if (row.getTableCells().size() != 1) continue;
                    sectionRows.addOne((Object)row);
                }
                if (sectionRows.size() == 2) {
                    this.findDesignDetailTable(table).foreach((Function1 & Serializable)detailTable -> {
                        this.markUsed(detailTable);
                        return (Buffer)sectionRows.addOne((Object)detailTable.getRow(0));
                    });
                }
                if (sectionRows.size() >= 2) {
                    this.readSection(design, this.sectionIdx(), sectionRows);
                    this.sectionIdx_$eq(this.sectionIdx() + 1);
                }
            }
            ++i;
        }
        XWPFTableRow lastRow = (XWPFTableRow)table.getRows().get(table.getRows().size() - 1);
        if (lastRow.getTableCells().size() == 2) {
            String title = lastRow.getCell(0).getText();
            if (title.contains("\u8bfe\u540e\u4f5c\u4e1a")) {
                this.tmpDoc().body().children_$eq((Seq)package$.MODULE$.Seq().empty());
                this.parser().parse(((XWPFTableCell)lastRow.getTableCells().get(1)).getBodyElements(), (DomNode)this.tmpDoc().body());
                design.homework_$eq((Option)Some$.MODULE$.apply((Object)this.tmpDoc().body().innerHTML()));
                return;
            }
            return;
        }
    }

    private void readSection(LessonDesign design, int index, Buffer<XWPFTableRow> sectionRows) {
        XWPFTableRow row1 = (XWPFTableRow)sectionRows.head();
        XWPFTableRow row2 = (XWPFTableRow)sectionRows.apply(1);
        ObjectRef title = ObjectRef.create((Object)this.readCell((XWPFTableCell)row1.getTableCells().get(0)));
        this.seqIndices.find((Function1 & Serializable)x -> index < ((String[])x).length && ((String)title$1.elem).startsWith(x[index - 1])).foreach((Function1)(JProcedure1 & Serializable)seq -> {
            title$2.elem = ((String)title$2.elem).substring(seq[index - 1].length() + 1);
        });
        String duration = row1.getTableCells().size() > 1 ? this.readCell((XWPFTableCell)row1.getTableCells().get(1)) : "";
        duration = Strings$.MODULE$.replace(duration, "\u5206\u949f", "").trim();
        int minutes = 0;
        if (Numbers$.MODULE$.isDigits(duration)) {
            minutes = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(duration));
        }
        Dom.Body body = this.tmpDoc().body();
        body.children_$eq((Seq)package$.MODULE$.Seq().empty());
        this.parser().readStyles(row2.getTable().getBody().getXWPFDocument());
        this.parser().parse(((XWPFTableCell)row2.getTableCells().get(0)).getBodyElements(), (DomNode)body);
        body.children().find((Function1 & Serializable)x -> x instanceof Dom.P && ((Dom.P)x).text().contains("\u6559\u5b66\u5185\u5bb9\u63d0\u8981")).foreach((Function1)(JProcedure1 & Serializable)p -> body.remove(p));
        String summary = body.innerHTML();
        String details = "";
        if (sectionRows.size() == 3) {
            XWPFTableRow row3 = (XWPFTableRow)sectionRows.apply(2);
            body.children_$eq((Seq)package$.MODULE$.Seq().empty());
            this.parser().parse(((XWPFTableCell)row3.getTableCells().get(0)).getBodyElements(), (DomNode)body);
            body.children().find((Function1 & Serializable)x -> x instanceof Dom.P && ((Dom.P)x).text().contains("\u6559\u5b66\u8fc7\u7a0b\u8bbe\u8ba1")).foreach((Function1)(JProcedure1 & Serializable)p -> body.remove(p));
            details = body.innerHTML();
        }
        LessonDesignSection section = new LessonDesignSection(design, index, (String)title.elem, minutes, summary, details);
        design.sections().addOne((Object)section);
    }

    private void readText(String title, XWPFTableCell cell, LessonDesign design) {
        String contents = this.readCell(cell);
        if (Strings$.MODULE$.isNotBlank((CharSequence)contents)) {
            if (title.contains("\u6559\u5b66\u76ee\u6807")) {
                design.texts().addOne((Object)new LessonDesignText(design, "target", contents));
                return;
            }
            if (title.contains("\u6559\u5b66\u91cd\u70b9")) {
                design.texts().addOne((Object)new LessonDesignText(design, "emphasis", contents));
                return;
            }
            if (title.contains("\u6559\u5b66\u96be\u70b9")) {
                design.texts().addOne((Object)new LessonDesignText(design, "difficulties", contents));
                return;
            }
            if (title.contains("\u6559\u5b66\u8d44\u6e90")) {
                design.texts().addOne((Object)new LessonDesignText(design, "resources", contents));
                return;
            }
            if (title.contains("\u8bfe\u7a0b\u601d\u653f")) {
                design.texts().addOne((Object)new LessonDesignText(design, "values", contents));
                return;
            }
            return;
        }
    }

    private Option<Object> findSectionTitleRowIndex(XWPFTable table) {
        Option rs = CollectionConverters$.MODULE$.asScala(table.getRows()).find((Function1 & Serializable)r -> r.getTableCells().size() == 1 && ((XWPFTableCell)r.getTableCells().get(0)).getText().contains("\u6559\u5b66\u5185\u5bb9\u4e0e\u8fc7\u7a0b\u8bbe\u8ba1"));
        return rs.map((Function1 & Serializable)r -> table.getRows().indexOf(r));
    }

    private void markUsed(XWPFTable table) {
        this.tables().$minus$eq((Object)table);
    }

    private Option<XWPFTable> findProgramTable(XWPFDocument document) {
        return this.tables().find((Function1 & Serializable)t -> {
            if (t.getRows().size() > 1 && ((XWPFTableRow)t.getRows().get(0)).getTableCells().size() > 1) {
                return ((XWPFTableCell)((XWPFTableRow)t.getRows().get(0)).getTableCells().get(0)).getText().contains("\u6559\u5b66\u4e3b\u9898");
            }
            return false;
        });
    }

    private Option<XWPFTable> findSummaryDetailTable() {
        return this.tables().find((Function1 & Serializable)t -> {
            if (t.getRows().size() > 1 && ((XWPFTableRow)t.getRows().get(0)).getTableCells().size() > 0) {
                return ((XWPFTableCell)((XWPFTableRow)t.getRows().get(0)).getTableCells().get(0)).getText().contains("\u6559\u5b66\u5185\u5bb9\u4e0e\u8fc7\u7a0b\u8bbe\u8ba1");
            }
            return false;
        });
    }

    private Option<XWPFTable> findDesignDetailTable(XWPFTable after) {
        int idx = this.tables().indexOf((Object)after);
        this.tables_$eq((Buffer)this.tables().takeRight(this.tables().size() - idx - 1));
        return this.tables().find((Function1 & Serializable)t -> {
            if (t.getRows().size() > 0 && ((XWPFTableRow)t.getRows().get(0)).getTableCells().size() > 0) {
                return ((XWPFTableCell)((XWPFTableRow)t.getRows().get(0)).getTableCells().get(0)).getText().contains("\u6559\u5b66\u8fc7\u7a0b\u8bbe\u8ba1");
            }
            return false;
        });
    }

    private String readCell(XWPFTableCell cell) {
        StringBuilder sb = new StringBuilder();
        CollectionConverters$.MODULE$.asScala(cell.getParagraphs()).foreach((Function1 & Serializable)p -> {
            CollectionConverters$.MODULE$.asScala(p.getRuns()).foreach((Function1)(JProcedure1 & Serializable)run -> {
                String runText = run.getText(0);
                if (Strings$.MODULE$.isNotBlank((CharSequence)runText)) {
                    sb.append(runText);
                    return;
                }
            });
            return sb.append("\n");
        });
        return sb.toString().replace("\r", "").trim();
    }
}

