/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.evaluation.course.web.action;

import java.io.Serializable;
import java.time.Instant;
import java.time.LocalDate;
import org.beangle.commons.collection.Collections$;
import org.beangle.data.dao.AbstractQueryBuilder;
import org.beangle.data.dao.OqlBuilder;
import org.beangle.data.dao.OqlBuilder$;
import org.beangle.data.dao.QueryBuilder;
import org.beangle.data.model.NumId;
import org.beangle.webmvc.api.view.View;
import org.beangle.webmvc.entity.action.RestfulAction;
import org.openurp.base.model.Semester;
import org.openurp.edu.base.model.Student;
import org.openurp.edu.base.model.Teacher;
import org.openurp.edu.evaluation.app.lesson.service.LessonFilterStrategyFactory;
import org.openurp.edu.evaluation.app.lesson.service.StdEvaluateSwitchService;
import org.openurp.edu.evaluation.lesson.model.QuestionnaireLesson;
import org.openurp.edu.evaluation.lesson.result.model.EvaluateResult;
import org.openurp.edu.evaluation.lesson.result.model.QuestionResult;
import org.openurp.edu.evaluation.model.Option;
import org.openurp.edu.evaluation.model.Question;
import org.openurp.edu.evaluation.model.Questionnaire;
import org.openurp.edu.lesson.model.CourseTaker;
import org.openurp.edu.lesson.model.Lesson;
import org.openurp.platform.api.security.Securities$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.generic.Growable;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005]c\u0001B\u0001\u0003\u0001E\u0011\u0011#\u0012<bYV\fG/Z*uI\u0006\u001bG/[8o\u0015\t\u0019A!\u0001\u0004bGRLwN\u001c\u0006\u0003\u000b\u0019\t1a^3c\u0015\t9\u0001\"\u0001\u0004d_V\u00148/\u001a\u0006\u0003\u0013)\t!\"\u001a<bYV\fG/[8o\u0015\tYA\"A\u0002fIVT!!\u0004\b\u0002\u000f=\u0004XM\\;sa*\tq\"A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001%A\u00191cG\u000f\u000e\u0003QQ!aA\u000b\u000b\u0005Y9\u0012AB3oi&$\u0018P\u0003\u0002\u00193\u00051q/\u001a2nm\u000eT!A\u0007\b\u0002\u000f\t,\u0017M\\4mK&\u0011A\u0004\u0006\u0002\u000e%\u0016\u001cHOZ;m\u0003\u000e$\u0018n\u001c8\u0011\u0005y)S\"A\u0010\u000b\u0005\u0001\n\u0013!B7pI\u0016d'B\u0001\u0012$\u0003\u0019\u0011Xm];mi*\u0011A\u0005C\u0001\u0007Y\u0016\u001c8o\u001c8\n\u0005\u0019z\"AD#wC2,\u0018\r^3SKN,H\u000e\u001e\u0005\u0006Q\u0001!\t!K\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003)\u0002\"a\u000b\u0001\u000e\u0003\tAQ!\f\u0001\u0005\u00029\n1dZ3u%\u0016\u001cX\u000f\u001c;CsN#H-\u00133B]\u0012dUm]:p]&#G\u0003B\u000f0oeBQ\u0001\r\u0017A\u0002E\nQa\u001d;e\u0013\u0012\u0004\"AM\u001b\u000e\u0003MR\u0011\u0001N\u0001\u0006g\u000e\fG.Y\u0005\u0003mM\u0012A\u0001T8oO\")\u0001\b\fa\u0001c\u0005AA.Z:t_:LE\rC\u0003;Y\u0001\u0007\u0011'A\u0005uK\u0006\u001c\u0007.\u001a:JI\")A\b\u0001C\u0001{\u0005yr-\u001a;MKN\u001cxN\\%e\u0003:$G+Z1dQ\u0016\u0014\u0018\nZ(g%\u0016\u001cX\u000f\u001c;\u0015\u0007yz\u0005\f\u0005\u0003@\u0005\u0012#U\"\u0001!\u000b\u0005\u0005\u001b\u0014AC2pY2,7\r^5p]&\u00111\t\u0011\u0002\u0004\u001b\u0006\u0004\bCA#M\u001d\t1%\n\u0005\u0002Hg5\t\u0001J\u0003\u0002J!\u00051AH]8pizJ!aS\u001a\u0002\rA\u0013X\rZ3g\u0013\tieJ\u0001\u0004TiJLgn\u001a\u0006\u0003\u0017NBQ\u0001U\u001eA\u0002E\u000bqa\u001d;vI\u0016tG\u000f\u0005\u0002S-6\t1K\u0003\u0002!)*\u0011QKC\u0001\u0005E\u0006\u001cX-\u0003\u0002X'\n91\u000b^;eK:$\b\"B-<\u0001\u0004Q\u0016\u0001C:f[\u0016\u001cH/\u001a:\u0011\u0005msV\"\u0001/\u000b\u0005\u0001j&BA+\r\u0013\tyFL\u0001\u0005TK6,7\u000f^3s\u0011\u0015\t\u0007\u0001\"\u0001c\u000359W\r^*uI2+7o]8ogR\u00191M]:\u0011\u0007\u0011LGN\u0004\u0002fO:\u0011qIZ\u0005\u0002i%\u0011\u0001nM\u0001\ba\u0006\u001c7.Y4f\u0013\tQ7NA\u0002TKFT!\u0001[\u001a\u0011\u00055\u0004X\"\u00018\u000b\u0005\u0001z'B\u0001\u0013\u000b\u0013\t\thN\u0001\u0004MKN\u001cxN\u001c\u0005\u0006!\u0002\u0004\r!\u0015\u0005\u00063\u0002\u0004\rA\u0017\u0005\nk\u0002\u0001\r\u00111A\u0005\u0002Y\f1\u0004\\3tg>tg)\u001b7uKJ\u001cFO]1uK\u001eLh)Y2u_JLX#A<\u0011\u0005atX\"A=\u000b\u0005i\\\u0018aB:feZL7-\u001a\u0006\u0003IqT!! \u0005\u0002\u0007\u0005\u0004\b/\u0003\u0002\u0000s\nYB*Z:t_:4\u0015\u000e\u001c;feN#(/\u0019;fOf4\u0015m\u0019;pefD1\"a\u0001\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0002\u0006\u0005yB.Z:t_:4\u0015\u000e\u001c;feN#(/\u0019;fOf4\u0015m\u0019;pef|F%Z9\u0015\t\u0005\u001d\u0011Q\u0002\t\u0004e\u0005%\u0011bAA\u0006g\t!QK\\5u\u0011%\ty!!\u0001\u0002\u0002\u0003\u0007q/A\u0002yIEBq!a\u0005\u0001A\u0003&q/\u0001\u000fmKN\u001cxN\u001c$jYR,'o\u0015;sCR,w-\u001f$bGR|'/\u001f\u0011\t\u0017\u0005]\u0001\u00011AA\u0002\u0013\u0005\u0011\u0011D\u0001\u0016KZ\fG.^1uKN;\u0018\u000e^2i'\u0016\u0014h/[2f+\t\tY\u0002E\u0002y\u0003;I1!a\bz\u0005a\u0019F\u000fZ#wC2,\u0018\r^3To&$8\r[*feZL7-\u001a\u0005\f\u0003G\u0001\u0001\u0019!a\u0001\n\u0003\t)#A\rfm\u0006dW/\u0019;f'^LGo\u00195TKJ4\u0018nY3`I\u0015\fH\u0003BA\u0004\u0003OA!\"a\u0004\u0002\"\u0005\u0005\t\u0019AA\u000e\u0011!\tY\u0003\u0001Q!\n\u0005m\u0011AF3wC2,\u0018\r^3To&$8\r[*feZL7-\u001a\u0011\t\u000f\u0005=\u0002\u0001\"\u0015\u00022\u0005a\u0011N\u001c3fqN+G\u000f^5oOR\u0011\u0011q\u0001\u0005\b\u0003k\u0001A\u0011IA\u001c\u0003\u0019\u0019X-\u0019:dQR\u0011\u0011\u0011\b\t\u0005\u0003w\t)%\u0004\u0002\u0002>)!\u0011qHA!\u0003\u00111\u0018.Z<\u000b\u0007\u0005\rs#A\u0002ba&LA!a\u0012\u0002>\t!a+[3x\u0011\u001d\tY\u0005\u0001C\u0001\u0003o\t\u0011\u0003\\8bIF+Xm\u001d;j_:t\u0017-\u001b:f\u0011\u001d\ty\u0005\u0001C\u0001\u0003#\n!bZ3u'R,H-\u001a8u)\u0005\t\u0006bBA+\u0001\u0011\u0005\u0013qG\u0001\u0005g\u00064X\r")
public class EvaluateStdAction
extends RestfulAction<EvaluateResult> {
    private LessonFilterStrategyFactory lessonFilterStrategyFactory;
    private StdEvaluateSwitchService evaluateSwitchService;

    public EvaluateResult getResultByStdIdAndLessonId(long stdId, long lessonId, long teacherId) {
        OqlBuilder query = OqlBuilder$.MODULE$.from(EvaluateResult.class, "evaluateResult");
        query.where("evaluateResult.student.id =:stdId", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)stdId)}));
        query.where("evaluateResult.lesson.id =:lessonId", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)lessonId)}));
        AbstractQueryBuilder abstractQueryBuilder = 0L != teacherId ? query.where("evaluateResult.teacher.id =:teacherId", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)teacherId)})) : query.where("evaluateResult.teacher is null", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
        scala.collection.immutable.Seq result = this.entityDao().search((QueryBuilder)query);
        return result.size() > 0 ? (EvaluateResult)result.head() : null;
    }

    public Map<String, String> getLessonIdAndTeacherIdOfResult(Student student, Semester semester) {
        OqlBuilder query = OqlBuilder$.MODULE$.from(EvaluateResult.class, "evaluateResult");
        query.where("evaluateResult.student = :student ", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{student}));
        query.where("evaluateResult.lesson.semester = :semester", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{semester}));
        scala.collection.immutable.Seq a = this.entityDao().search((QueryBuilder)query);
        return ((TraversableOnce)a.map((Function1 & Serializable & scala.Serializable)obj -> new Tuple2((Object)(BoxesRunTime.unboxToLong((Object)obj.lesson().id()) + "_" + (obj.teacher() == null ? "0" : obj.teacher().id())), (Object)"1"), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public Seq<Lesson> getStdLessons(Student student, Semester semester) {
        Seq stdLessons;
        block0: {
            OqlBuilder query = OqlBuilder$.MODULE$.from(CourseTaker.class, "courseTaker");
            query.select("distinct courseTaker.lesson.id ");
            query.where("courseTaker.std=:std", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{student}));
            query.where("courseTaker.semester =:semester", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{semester}));
            scala.collection.immutable.Seq lessonIds = this.entityDao().search((QueryBuilder)query);
            stdLessons = (Seq)scala.collection.Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
            if (lessonIds.isEmpty()) break block0;
            OqlBuilder entityquery = (OqlBuilder)OqlBuilder$.MODULE$.from(Lesson.class, "lesson").where("lesson.id in (:lessonIds)", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{lessonIds}));
            stdLessons = this.entityDao().search((QueryBuilder)entityquery);
        }
        return stdLessons;
    }

    public LessonFilterStrategyFactory lessonFilterStrategyFactory() {
        return this.lessonFilterStrategyFactory;
    }

    public void lessonFilterStrategyFactory_$eq(LessonFilterStrategyFactory x$1) {
        this.lessonFilterStrategyFactory = x$1;
    }

    public StdEvaluateSwitchService evaluateSwitchService() {
        return this.evaluateSwitchService;
    }

    public void evaluateSwitchService_$eq(StdEvaluateSwitchService x$1) {
        this.evaluateSwitchService = x$1;
    }

    public void indexSetting() {
        Student std = this.getStudent();
        Object object = std == null ? this.forward("error.std.stdNo.needed") : BoxedUnit.UNIT;
        scala.collection.immutable.Seq semesters = this.entityDao().getAll(Semester.class);
        this.put("semesters", semesters);
        OqlBuilder semesterQuery = (OqlBuilder)OqlBuilder$.MODULE$.from(Semester.class, "semester").where(":now between semester.beginOn and semester.endOn", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{LocalDate.now()}));
        this.put("currentSemester", this.entityDao().search((QueryBuilder)semesterQuery).head());
    }

    public View search() {
        Student std = this.getStudent();
        OqlBuilder semesterQuery = (OqlBuilder)OqlBuilder$.MODULE$.from(Semester.class, "semester").where(":now between semester.beginOn and semester.endOn", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{LocalDate.now()}));
        int semesterId = BoxesRunTime.unboxToInt((Object)this.getInt("semester.id").getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> BoxesRunTime.unboxToInt((Object)((NumId)this.entityDao().search((QueryBuilder)semesterQuery).head()).id())));
        Semester semester = (Semester)this.entityDao().get(Semester.class, (Object)BoxesRunTime.boxToInteger((int)semesterId));
        Seq<Lesson> lessonList = this.getStdLessons(std, semester);
        Seq myLessons = (Seq)scala.collection.Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
        if (!lessonList.isEmpty()) {
            OqlBuilder query = OqlBuilder$.MODULE$.from(QuestionnaireLesson.class, "questionnaireLesson");
            query.where("questionnaireLesson.lesson in (:lessonList)", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{lessonList}));
            scala.collection.immutable.Seq myquestionnaires = this.entityDao().search((QueryBuilder)query);
            myLessons = myquestionnaires;
        }
        Map<String, String> evaluateMap = this.getLessonIdAndTeacherIdOfResult(std, semester);
        this.put("evaluateMap", evaluateMap);
        this.put("questionnaireLessons", myLessons);
        return this.forward(this.forward$default$1());
    }

    public View loadQuestionnaire() {
        Growable growable;
        String lessonId = (String)this.get("lessonId").get();
        String evaluateState = (String)this.get("evaluateState").get();
        int semesterId = BoxesRunTime.unboxToInt((Object)this.getInt("semester.id").get());
        String[] ids = ((String)this.get("lessonId").get()).split(",");
        Lesson lesson = (Lesson)this.entityDao().get(Lesson.class, (Object)BoxesRunTime.boxToLong((long)new StringOps(Predef$.MODULE$.augmentString(ids[0])).toLong()));
        if (lesson == null) {
            this.addMessage("\u627e\u4e0d\u5230\u8be5\u8bfe\u7a0b!", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
            return this.forward("errors");
        }
        Seq evaluateSwitch = this.evaluateSwitchService().getEvaluateSwitch(lesson.semester(), lesson.project());
        if (evaluateSwitch == null) {
            this.addMessage("\u73b0\u5728\u8fd8\u6ca1\u6709\u5f00\u653e\u8bfe\u7a0b\u8bc4\u6559!", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
            return this.forward("errors");
        }
        scala.collection.immutable.Seq questionnaireLessons = this.entityDao().findBy(QuestionnaireLesson.class, "lesson.id", (Iterable)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{BoxesRunTime.unboxToLong((Object)lesson.id())})));
        if (questionnaireLessons.isEmpty()) {
            this.addMessage("\u7f3a\u5931\u8bc4\u6559\u95ee\u5377!", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
            return this.forward("errors");
        }
        QuestionnaireLesson questionnaireLesson = (QuestionnaireLesson)questionnaireLessons.head();
        Buffer questions = questionnaireLesson.questionnaire().questions();
        questions.sortWith((Function2 & Serializable & scala.Serializable)(x, y) -> BoxesRunTime.boxToBoolean((boolean)EvaluateStdAction.$anonfun$loadQuestionnaire$1(x, y)));
        Buffer teachers = Collections$.MODULE$.newBuffer();
        if (questionnaireLesson.evaluateByTeacher()) {
            Teacher teacher = (Teacher)this.entityDao().get(Teacher.class, (Object)BoxesRunTime.boxToLong((long)new StringOps(Predef$.MODULE$.augmentString(ids[1])).toLong()));
            growable = teachers.$plus$eq((Object)teacher);
        } else {
            growable = teachers.$plus$plus$eq((TraversableOnce)lesson.teachers());
        }
        if ("update".equals(evaluateState)) {
            BoxedUnit boxedUnit;
            long teacherId = 0L;
            teacherId = questionnaireLesson.evaluateByTeacher() ? new StringOps(Predef$.MODULE$.augmentString(ids[1])).toLong() : BoxesRunTime.unboxToLong((Object)((NumId)teachers.head()).id());
            Student std = this.getStudent();
            EvaluateResult evaluateResult = this.getResultByStdIdAndLessonId(BoxesRunTime.unboxToLong((Object)std.id()), BoxesRunTime.unboxToLong((Object)lesson.id()), teacherId);
            if (evaluateResult == null) {
                this.addMessage("error.dataRealm.insufficient", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
                boxedUnit = this.forward("errors");
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            scala.collection.immutable.Map questionMap = ((TraversableOnce)evaluateResult.questionResults().map((Function1 & Serializable & scala.Serializable)q -> new Tuple2((Object)q.question().id().toString(), q.option().id()), Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            this.put("questionMap", questionMap);
            this.put("evaluateResult", evaluateResult);
        }
        this.put("lesson", lesson);
        this.put("teachers", teachers);
        this.put("questions", questions);
        this.put("questionnaire", questionnaireLesson.questionnaire());
        this.put("evaluateState", evaluateState);
        return this.forward(this.forward$default$1());
    }

    public Student getStudent() {
        scala.collection.immutable.Seq stds = this.entityDao().search((QueryBuilder)OqlBuilder$.MODULE$.from(Student.class, "s").where("s.code=:code", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Securities$.MODULE$.user()})));
        if (stds.isEmpty()) {
            throw new RuntimeException("Cannot find student with code " + Securities$.MODULE$.user());
        }
        return (Student)stds.head();
    }

    public View save() {
        View view;
        BoxedUnit boxedUnit;
        Student std = this.getStudent();
        long lessonId = BoxesRunTime.unboxToLong((Object)this.getLong("lesson.id").get());
        long teacherId = BoxesRunTime.unboxToLong((Object)this.getLong("teacherId").get());
        List teacherIds = this.longIds("teacher");
        OqlBuilder query = OqlBuilder$.MODULE$.from(QuestionnaireLesson.class, "questionnaireLesson");
        query.where("questionnaireLesson.lesson.id =:lessonId", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)lessonId)}));
        scala.collection.immutable.Seq questionnaireLessons = this.entityDao().search((QueryBuilder)query);
        if (questionnaireLessons.isEmpty()) {
            this.addMessage("field.evaluate.questionnaire", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
            boxedUnit = this.forward("errors");
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        QuestionnaireLesson questionnaireLesson = (QuestionnaireLesson)questionnaireLessons.head();
        Seq evaluateResults = (Seq)scala.collection.Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
        OqlBuilder queryResult = OqlBuilder$.MODULE$.from(EvaluateResult.class, "evaluateResult");
        queryResult.where("evaluateResult.lesson.id =:lessonId", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)lessonId)}));
        queryResult.where("evaluateResult.student =:std", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{std}));
        if (teacherIds.size() == 0) {
            evaluateResults = this.entityDao().search((QueryBuilder)queryResult);
        } else if (teacherIds.size() == 1) {
            queryResult.where("evaluateResult.teacher.id =:teacherId", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)teacherId)}));
            evaluateResults = this.entityDao().search((QueryBuilder)queryResult);
        } else if (teacherIds.size() > 1) {
            queryResult.where("evaluateResult.teacher.id in(:teacherIds)", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{teacherIds}));
            evaluateResults = this.entityDao().search((QueryBuilder)queryResult);
        }
        ObjectRef lesson = ObjectRef.create(null);
        ObjectRef teacher2 = ObjectRef.create(null);
        ObjectRef newTeacherIds = ObjectRef.create((Object)Collections$.MODULE$.newBuffer());
        try {
            if (evaluateResults.size() > 0) {
                evaluateResults.foreach((Function1 & Serializable & scala.Serializable)evaluateResult -> {
                    EvaluateStdAction.$anonfun$save$1(this, questionnaireLesson, lesson, teacher2, newTeacherIds, evaluateResult);
                    return BoxedUnit.UNIT;
                });
                LongRef newId = LongRef.create((long)0L);
                if (teacherIds.size() > ((Buffer)newTeacherIds.elem).size()) {
                    teacherIds.foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)id -> {
                        block0: {
                            if (((Buffer)newTeacherIds$1.elem).contains((Object)BoxesRunTime.boxToLong((long)id))) break block0;
                            newId$1.elem = id;
                        }
                    });
                    EvaluateResult evaluateResult2 = new EvaluateResult();
                    evaluateResult2.lesson_$eq((Lesson)lesson.elem);
                    evaluateResult2.department_$eq(((Lesson)lesson.elem).teachDepart());
                    evaluateResult2.student_$eq(std);
                    evaluateResult2.teacher_$eq((Teacher)this.entityDao().get(Teacher.class, (Object)BoxesRunTime.boxToLong((long)newId.elem)));
                    evaluateResult2.evaluateAt_$eq(Instant.now());
                    questionnaireLesson.questionnaire().questions().foreach((Function1 & Serializable & scala.Serializable)question -> {
                        long optionId = BoxesRunTime.unboxToLong((Object)this.getLong("select" + question.id()).get());
                        Option option = (Option)this.entityDao().get(Option.class, (Object)BoxesRunTime.boxToLong((long)optionId));
                        QuestionResult questionResult = new QuestionResult();
                        questionResult.question_$eq(question);
                        questionResult.questionType_$eq(question.questionType());
                        questionResult.result_$eq(evaluateResult2);
                        questionResult.option_$eq(option);
                        questionResult.score_$eq(question.score() * Predef$.MODULE$.float2Float(option.proportion()).floatValue());
                        evaluateResult2.questionnaire_$eq(questionnaireLesson.questionnaire());
                        return (Set)evaluateResult2.questionResults().$plus$eq((Object)questionResult);
                    });
                    evaluateResult2.remark_$eq((String)this.get("evaluateResult.remark").getOrElse((Function0 & Serializable & scala.Serializable)() -> ""));
                    this.entityDao().saveOrUpdate((Object)evaluateResult2, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new EvaluateResult[0]));
                }
            } else {
                BoxedUnit boxedUnit2;
                lesson.elem = (Lesson)this.entityDao().get(Lesson.class, (Object)BoxesRunTime.boxToLong((long)lessonId));
                scala.collection.immutable.Seq teachers = this.entityDao().find(Teacher.class, (Iterable)teacherIds);
                Questionnaire questionnaire = questionnaireLesson.questionnaire();
                if (questionnaire == null || questionnaire.questions() == null) {
                    this.addMessage("\u8bc4\u6559\u95ee\u5377\u6709\u8bef!", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
                    boxedUnit2 = this.forward("errors");
                } else {
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                if (teachers.size() == 1) {
                    teacher2.elem = (Teacher)teachers.head();
                    Teacher evaluateTeacher = (Teacher)teacher2.elem;
                    EvaluateResult evaluateResult3 = new EvaluateResult();
                    evaluateResult3.lesson_$eq((Lesson)lesson.elem);
                    evaluateResult3.department_$eq(((Lesson)lesson.elem).teachDepart());
                    evaluateResult3.student_$eq(std);
                    evaluateResult3.teacher_$eq(evaluateTeacher);
                    evaluateResult3.evaluateAt_$eq(Instant.now());
                    questionnaire.questions().foreach((Function1 & Serializable & scala.Serializable)question -> {
                        long optionId = BoxesRunTime.unboxToLong((Object)this.getLong("select" + question.id()).get());
                        Option option = (Option)this.entityDao().get(Option.class, (Object)BoxesRunTime.boxToLong((long)optionId));
                        QuestionResult questionResult = new QuestionResult();
                        questionResult.question_$eq(question);
                        questionResult.questionType_$eq(question.questionType());
                        questionResult.result_$eq(evaluateResult3);
                        questionResult.option_$eq(option);
                        questionResult.score_$eq(question.score() * Predef$.MODULE$.float2Float(option.proportion()).floatValue());
                        evaluateResult3.questionnaire_$eq(questionnaire);
                        return (Set)evaluateResult3.questionResults().$plus$eq((Object)questionResult);
                    });
                    evaluateResult3.remark_$eq((String)this.get("evaluateResult.remark").getOrElse((Function0 & Serializable & scala.Serializable)() -> ""));
                    evaluateResult3.statType_$eq(1);
                    this.entityDao().saveOrUpdate((Object)evaluateResult3, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new EvaluateResult[0]));
                }
                if (teachers.size() > 1 & !questionnaireLesson.evaluateByTeacher()) {
                    teachers.foreach((Function1 & Serializable & scala.Serializable)teacher -> {
                        EvaluateStdAction.$anonfun$save$11(this, std, lesson, questionnaire, teacher);
                        return BoxedUnit.UNIT;
                    });
                }
            }
            view = this.redirect("search", "&semester.id=" + ((Lesson)lesson.elem).semester().id(), "info.save.success");
        }
        catch (Exception e) {
            e.printStackTrace();
            view = this.redirect("search", "&semester.id=" + ((Lesson)lesson.elem).semester().id(), "info.save.failure");
        }
        return view;
    }

    public static final /* synthetic */ boolean $anonfun$loadQuestionnaire$1(Question x, Question y) {
        return x.priority() < y.priority();
    }

    public static final /* synthetic */ void $anonfun$save$5(EvaluateStdAction $this, QuestionResult questionResult) {
        block1: {
            Question question = questionResult.question();
            long optionId = BoxesRunTime.unboxToLong((Object)$this.getLong("select" + question.id()).get());
            if (optionId == 0L) {
                questionResult.result_$eq(null);
                $this.entityDao().remove((Object)questionResult, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new QuestionResult[0]));
            }
            if (questionResult.option().id().equals(BoxesRunTime.boxToLong((long)optionId))) break block1;
            Option option = (Option)$this.entityDao().get(Option.class, (Object)BoxesRunTime.boxToLong((long)optionId));
            questionResult.option_$eq(option);
            questionResult.score_$eq(question.score() * Predef$.MODULE$.float2Float(option.proportion()).floatValue());
        }
    }

    public static final /* synthetic */ void $anonfun$save$1(EvaluateStdAction $this, QuestionnaireLesson questionnaireLesson$1, ObjectRef lesson$1, ObjectRef teacher$1, ObjectRef newTeacherIds$1, EvaluateResult evaluateResult) {
        lesson$1.elem = evaluateResult.lesson();
        teacher$1.elem = evaluateResult.teacher();
        ((Buffer)newTeacherIds$1.elem).$plus$eq(((Teacher)teacher$1.elem).id());
        Set questionResults = evaluateResult.questionResults();
        Buffer questions = questionnaireLesson$1.questionnaire().questions();
        Buffer oldQuestions = Collections$.MODULE$.newBuffer();
        questionResults.foreach((Function1 & Serializable & scala.Serializable)questionResult -> oldQuestions.$plus$eq((Object)questionResult.question()));
        questions.foreach((Function1 & Serializable & scala.Serializable)question -> {
            BoxedUnit boxedUnit;
            if (!oldQuestions.contains(question)) {
                long optionId = BoxesRunTime.unboxToLong((Object)$this.getLong("select" + question.id()).get());
                Option option = (Option)$this.entityDao().get(Option.class, (Object)BoxesRunTime.boxToLong((long)optionId));
                QuestionResult questionResult = new QuestionResult();
                questionResult.questionType_$eq(question.questionType());
                questionResult.question_$eq(question);
                questionResult.option_$eq(option);
                questionResult.result_$eq(evaluateResult);
                boxedUnit = evaluateResult.questionResults().$plus$eq((Object)questionResult);
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return boxedUnit;
        });
        evaluateResult.remark_$eq((String)$this.get("evaluateResult.remark").getOrElse((Function0 & Serializable & scala.Serializable)() -> ""));
        questionResults.foreach((Function1 & Serializable & scala.Serializable)questionResult -> {
            EvaluateStdAction.$anonfun$save$5($this, questionResult);
            return BoxedUnit.UNIT;
        });
        $this.entityDao().saveOrUpdate((Iterable)questionResults);
    }

    public static final /* synthetic */ void $anonfun$save$11(EvaluateStdAction $this, Student std$1, ObjectRef lesson$1, Questionnaire questionnaire$1, Teacher teacher) {
        EvaluateResult evaluateResult = new EvaluateResult();
        evaluateResult.lesson_$eq((Lesson)lesson$1.elem);
        evaluateResult.department_$eq(((Lesson)lesson$1.elem).teachDepart());
        evaluateResult.student_$eq(std$1);
        evaluateResult.teacher_$eq(teacher);
        evaluateResult.evaluateAt_$eq(Instant.now());
        evaluateResult.statType_$eq(1);
        questionnaire$1.questions().foreach((Function1 & Serializable & scala.Serializable)question -> {
            long optionId = BoxesRunTime.unboxToLong((Object)$this.getLong("select" + question.id()).get());
            Option option = (Option)$this.entityDao().get(Option.class, (Object)BoxesRunTime.boxToLong((long)optionId));
            QuestionResult questionResult = new QuestionResult();
            questionResult.question_$eq(question);
            questionResult.questionType_$eq(question.questionType());
            questionResult.result_$eq(evaluateResult);
            questionResult.option_$eq(option);
            questionResult.score_$eq(question.score() * Predef$.MODULE$.float2Float(option.proportion()).floatValue());
            evaluateResult.questionnaire_$eq(questionnaire$1);
            return (Set)evaluateResult.questionResults().$plus$eq((Object)questionResult);
        });
        evaluateResult.remark_$eq((String)$this.get("evaluateResult.remark").getOrElse((Function0 & Serializable & scala.Serializable)() -> ""));
        $this.entityDao().saveOrUpdate((Object)evaluateResult, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new EvaluateResult[0]));
    }
}

