/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.evaluation.course.web.action;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.Collection;
import java.util.HashMap;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import net.sf.jxls.transformer.XLSTransformer;
import org.apache.poi.ss.usermodel.Workbook;
import org.beangle.commons.collection.Order$;
import org.beangle.commons.lang.ClassLoaders$;
import org.beangle.data.dao.OqlBuilder;
import org.beangle.data.dao.OqlBuilder$;
import org.beangle.data.dao.QueryBuilder;
import org.beangle.data.model.NumId;
import org.beangle.webmvc.api.context.ActionContext$;
import org.beangle.webmvc.api.view.Status$;
import org.beangle.webmvc.api.view.View;
import org.openurp.base.model.Department;
import org.openurp.base.model.Semester;
import org.openurp.edu.base.code.model.Education;
import org.openurp.edu.base.code.model.StdType;
import org.openurp.edu.base.model.Teacher;
import org.openurp.edu.evaluation.app.lesson.service.Ranker$;
import org.openurp.edu.evaluation.course.web.action.ProjectRestfulAction;
import org.openurp.edu.evaluation.department.model.DepartEvaluate;
import org.openurp.edu.evaluation.department.model.SupervisiorEvaluate;
import org.openurp.edu.evaluation.lesson.result.model.QuestionResult;
import org.openurp.edu.evaluation.lesson.stat.model.FinalTeacherScore;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001)3A!\u0001\u0002\u0001#\t9b)\u001b8bYR+\u0017m\u00195feN\u001bwN]3BGRLwN\u001c\u0006\u0003\u0007\u0011\ta!Y2uS>t'BA\u0003\u0007\u0003\r9XM\u0019\u0006\u0003\u000f!\taaY8veN,'BA\u0005\u000b\u0003))g/\u00197vCRLwN\u001c\u0006\u0003\u00171\t1!\u001a3v\u0015\tia\"A\u0004pa\u0016tWO\u001d9\u000b\u0003=\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\n\u0011\u0007M!b#D\u0001\u0003\u0013\t)\"A\u0001\u000bQe>TWm\u0019;SKN$h-\u001e7BGRLwN\u001c\t\u0003/yi\u0011\u0001\u0007\u0006\u00033i\tQ!\\8eK2T!a\u0007\u000f\u0002\tM$\u0018\r\u001e\u0006\u0003;!\ta\u0001\\3tg>t\u0017BA\u0010\u0019\u0005E1\u0015N\\1m)\u0016\f7\r[3s'\u000e|'/\u001a\u0005\u0006C\u0001!\tAI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\r\u0002\"a\u0005\u0001\t\u000b\u0015\u0002A\u0011\t\u0014\u0002\u000b%tG-\u001a=\u0015\u0003\u001d\u0002\"\u0001K\u0019\u000e\u0003%R!AK\u0016\u0002\tYLWm\u001e\u0006\u0003Y5\n1!\u00199j\u0015\tqs&\u0001\u0004xK\nlgo\u0019\u0006\u0003a9\tqAY3b]\u001edW-\u0003\u00023S\t!a+[3x\u0011\u0015!\u0004\u0001\"\u0011'\u0003\u0019\u0019X-\u0019:dQ\")a\u0007\u0001C\u0001M\u00051Q\r\u001f9peRDQ\u0001\u000f\u0001\u0005\u0002\u0019\n\u0001B]1oWN#\u0018\r\u001e\u0005\u0006u\u0001!\taO\u0001\u0007e\u0016lwN^3\u0015\u0005q\u0012\u0005CA\u001fA\u001b\u0005q$\"A \u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0005s$\u0001B+oSRDQaQ\u001dA\u0002\u0011\u000b!b]3nKN$XM]%e!\tiT)\u0003\u0002G}\t\u0019\u0011J\u001c;\t\u000b!\u0003A\u0011\u0001\u0014\u0002\u0011M$\u0018\r\u001e%p[\u0016DQa\u0007\u0001\u0005\u0002\u0019\u0002")
public class FinalTeacherScoreAction
extends ProjectRestfulAction<FinalTeacherScore> {
    public View index() {
        this.put("departments", this.findItemsBySchool(Department.class));
        this.put("semesters", this.getSemesters());
        OqlBuilder semesterQuery = (OqlBuilder)OqlBuilder$.MODULE$.from(Semester.class, "semester").where(":now between semester.beginOn and semester.endOn", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{LocalDate.now()}));
        this.put("currentSemester", this.entityDao().search((QueryBuilder)semesterQuery).head());
        return this.forward(this.forward$default$1());
    }

    public View search() {
        OqlBuilder semesterQuery = (OqlBuilder)OqlBuilder$.MODULE$.from(Semester.class, "semester").where(":now between semester.beginOn and semester.endOn", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{LocalDate.now()}));
        int semesterId = BoxesRunTime.unboxToInt((Object)this.getInt("semester.id").getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> BoxesRunTime.unboxToInt((Object)((NumId)this.entityDao().search((QueryBuilder)semesterQuery).head()).id())));
        Semester semester = (Semester)this.entityDao().get(Semester.class, (Object)BoxesRunTime.boxToInteger((int)semesterId));
        OqlBuilder finalScores = OqlBuilder$.MODULE$.from(FinalTeacherScore.class, "finalTeacherScore");
        this.populateConditions(finalScores);
        finalScores.orderBy((String)this.get(Order$.MODULE$.OrderStr()).orNull(Predef$.MODULE$.$conforms())).limit(this.getPageLimit());
        finalScores.where("finalTeacherScore.semester=:semester", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{semester}));
        this.put("finalTeacherScores", this.entityDao().search((QueryBuilder)finalScores));
        this.put("semesterId", BoxesRunTime.boxToInteger((int)semesterId));
        return this.forward(this.forward$default$1());
    }

    public View export() {
        int semesterId = BoxesRunTime.unboxToInt((Object)this.getInt("semester.id").get());
        OqlBuilder finalScores = OqlBuilder$.MODULE$.from(FinalTeacherScore.class, "finalTeacherScore");
        this.populateConditions(finalScores);
        finalScores.orderBy((String)this.get(Order$.MODULE$.OrderStr()).orNull(Predef$.MODULE$.$conforms())).limit(this.getPageLimit());
        finalScores.where("finalTeacherScore.semester.id=:semesterId", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)semesterId)}));
        Collection list = JavaConverters$.MODULE$.asJavaCollection((Iterable)this.entityDao().search((QueryBuilder)finalScores));
        HashMap<String, Collection> beans = new HashMap<String, Collection>();
        beans.put("list", list);
        InputStream path = (InputStream)ClassLoaders$.MODULE$.getResourceAsStream("template/finalTeacherScore.xls", ClassLoaders$.MODULE$.getResourceAsStream$default$2()).get();
        HttpServletResponse response = ActionContext$.MODULE$.current().response();
        response.setContentType("application/x-excel");
        response.setHeader("Content-Disposition", "attachmentfilename=finalTeacherScore.xls");
        XLSTransformer transformer = new XLSTransformer();
        try (ServletOutputStream os = response.getOutputStream();){
            Workbook workbook = transformer.transformXLS(path, beans);
            workbook.write((OutputStream)os);
        }
        return Status$.MODULE$.Ok();
    }

    public View rankStat() {
        OqlBuilder semesterQuery = (OqlBuilder)OqlBuilder$.MODULE$.from(Semester.class, "semester").where(":now between semester.beginOn and semester.endOn", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{LocalDate.now()}));
        int semesterId = BoxesRunTime.unboxToInt((Object)this.getInt("semester.id").getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> BoxesRunTime.unboxToInt((Object)((NumId)this.entityDao().search((QueryBuilder)semesterQuery).head()).id())));
        Semester semester = (Semester)this.entityDao().get(Semester.class, (Object)BoxesRunTime.boxToInteger((int)semesterId));
        OqlBuilder rankQuery = OqlBuilder$.MODULE$.from(FinalTeacherScore.class, "finalTeacherScore");
        rankQuery.where("finalTeacherScore.semester.id=:semesterId", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)semesterId)}));
        scala.collection.immutable.Seq evals = this.entityDao().search((QueryBuilder)rankQuery);
        Ranker$.MODULE$.rOver((Seq)evals, (Function2 & Serializable & scala.Serializable)(x, r) -> {
            x.rank_$eq(BoxesRunTime.unboxToInt((Object)r));
            return BoxedUnit.UNIT;
        });
        Map departEvalMaps = evals.groupBy((Function1 & Serializable & scala.Serializable)x -> x.teacher().user().department());
        departEvalMaps.values().foreach((Function1 & Serializable & scala.Serializable)departEvals -> {
            Ranker$.MODULE$.rOver((Seq)departEvals, (Function2 & Serializable & scala.Serializable)(x, r) -> {
                x.departRank_$eq(BoxesRunTime.unboxToInt((Object)r));
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        });
        this.entityDao().saveOrUpdate((Iterable)evals);
        return this.redirect("index", "info.action.success");
    }

    public void remove(int semesterId) {
        OqlBuilder query = OqlBuilder$.MODULE$.from(FinalTeacherScore.class, "finalScore");
        query.where("finalScore.semester.id=:semesterId", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)semesterId)}));
        this.entityDao().remove((Iterable)this.entityDao().search((QueryBuilder)query));
    }

    public View statHome() {
        this.put("stdTypeList", this.entityDao().getAll(StdType.class));
        this.put("departmentList", this.entityDao().getAll(Department.class));
        this.put("educations", this.entityDao().getAll(Education.class));
        scala.collection.immutable.Seq teachingDeparts = this.entityDao().search((QueryBuilder)OqlBuilder$.MODULE$.from(Department.class, "depart").where("depart.teaching =:tea", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToBoolean((boolean)true)})));
        this.put("departments", teachingDeparts);
        scala.collection.immutable.Seq semesters = this.entityDao().getAll(Semester.class);
        this.put("semesters", semesters);
        OqlBuilder semesterQuery = (OqlBuilder)OqlBuilder$.MODULE$.from(Semester.class, "semester").where(":now between semester.beginOn and semester.endOn", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{LocalDate.now()}));
        this.put("currentSemester", this.entityDao().search((QueryBuilder)semesterQuery).head());
        return this.forward(this.forward$default$1());
    }

    public View stat() {
        int semesterId = BoxesRunTime.unboxToInt((Object)this.getInt("semester.id").get());
        Semester semester = (Semester)this.entityDao().get(Semester.class, (Object)BoxesRunTime.boxToInteger((int)semesterId));
        this.remove(semesterId);
        OqlBuilder quer = OqlBuilder$.MODULE$.from(QuestionResult.class.getName() + " questionR," + DepartEvaluate.class.getName() + " departEvaluate," + SupervisiorEvaluate.class.getName() + " supervisiorEvaluate");
        quer.where("questionR.result.lesson.semester.id=:semesterId", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)semesterId)}));
        quer.where("questionR.result.statType is 1", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
        quer.select("questionR.result.teacher.id,supervisiorEvaluate.totalScore,departEvaluate.totalScore,sum(questionR.score)/count(distinct questionR.result.id)");
        quer.where("questionR.result.lesson.semester.id=departEvaluate.semester.id", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
        quer.where("questionR.result.teacher.id=departEvaluate.teacher.id", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
        quer.where("questionR.result.lesson.semester.id=supervisiorEvaluate.semester.id", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
        quer.where("questionR.result.teacher.id=supervisiorEvaluate.teacher.id", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
        quer.where("questionR.result.lesson.semester.id =:semesterId", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)semesterId)}));
        quer.groupBy("questionR.result.teacher.id,supervisiorEvaluate.totalScore,departEvaluate.totalScore");
        scala.collection.immutable.Seq finalScores = this.entityDao().search((QueryBuilder)quer);
        finalScores.foreach((Function1 & Serializable & scala.Serializable)ob -> {
            FinalTeacherScoreAction.$anonfun$stat$1(this, semester, ob);
            return BoxedUnit.UNIT;
        });
        return this.redirect("index", "info.action.success");
    }

    public static final /* synthetic */ void $anonfun$stat$1(FinalTeacherScoreAction $this, Semester semester$1, Object[] ob) {
        FinalTeacherScore questionS = new FinalTeacherScore();
        questionS.teacher_$eq(new Teacher());
        questionS.teacher().id_$eq((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)ob[0])));
        questionS.semester_$eq(semester$1);
        questionS.stdScore_$eq(new StringOps(Predef$.MODULE$.augmentString(ob[3].toString())).toFloat() * (float)10);
        questionS.supviScore_$eq(new StringOps(Predef$.MODULE$.augmentString(ob[1].toString())).toFloat());
        questionS.departScore_$eq(new StringOps(Predef$.MODULE$.augmentString(ob[2].toString())).toFloat());
        questionS.score_$eq((float)((double)(new StringOps(Predef$.MODULE$.augmentString(ob[3].toString())).toFloat() * (float)10) * 0.5 + (double)new StringOps(Predef$.MODULE$.augmentString(ob[1].toString())).toFloat() * 0.3 + (double)new StringOps(Predef$.MODULE$.augmentString(ob[2].toString())).toFloat() * 0.2));
        $this.entityDao().saveOrUpdate((Object)questionS, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new FinalTeacherScore[0]));
    }
}

