/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.evaluation.course.web.action;

import java.io.Serializable;
import java.time.Instant;
import java.time.LocalDate;
import java.util.Date;
import org.beangle.commons.collection.Collections$;
import org.beangle.commons.collection.Order$;
import org.beangle.data.dao.AbstractQueryBuilder;
import org.beangle.data.dao.OqlBuilder;
import org.beangle.data.dao.OqlBuilder$;
import org.beangle.data.dao.QueryBuilder;
import org.beangle.data.model.NumId;
import org.beangle.webmvc.api.view.View;
import org.openurp.base.model.Department;
import org.openurp.base.model.Semester;
import org.openurp.edu.base.code.model.Education;
import org.openurp.edu.base.code.model.StdType;
import org.openurp.edu.base.model.Project;
import org.openurp.edu.base.model.Teacher;
import org.openurp.edu.evaluation.app.lesson.service.Ranker$;
import org.openurp.edu.evaluation.course.web.action.ProjectRestfulAction;
import org.openurp.edu.evaluation.lesson.result.model.EvaluateResult;
import org.openurp.edu.evaluation.lesson.result.model.QuestionResult;
import org.openurp.edu.evaluation.lesson.stat.model.EvalStat;
import org.openurp.edu.evaluation.lesson.stat.model.LessonEvalStat;
import org.openurp.edu.evaluation.lesson.stat.model.LessonOptionStat;
import org.openurp.edu.evaluation.lesson.stat.model.LessonQuestionStat;
import org.openurp.edu.evaluation.lesson.stat.model.LessonQuestionTypeStat;
import org.openurp.edu.evaluation.lesson.stat.model.QuestionStat;
import org.openurp.edu.evaluation.lesson.stat.model.QuestionTypeStat;
import org.openurp.edu.evaluation.model.EvaluationCriteriaItem;
import org.openurp.edu.evaluation.model.Question;
import org.openurp.edu.evaluation.model.QuestionType;
import org.openurp.edu.evaluation.model.Questionnaire;
import org.openurp.edu.lesson.model.Lesson;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\r4A!\u0001\u0002\u0001#\t!B*Z:t_:,e/\u00197Ti\u0006$\u0018i\u0019;j_:T!a\u0001\u0003\u0002\r\u0005\u001cG/[8o\u0015\t)a!A\u0002xK\nT!a\u0002\u0005\u0002\r\r|WO]:f\u0015\tI!\"\u0001\u0006fm\u0006dW/\u0019;j_:T!a\u0003\u0007\u0002\u0007\u0015$WO\u0003\u0002\u000e\u001d\u00059q\u000e]3okJ\u0004(\"A\b\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001\u0011\u0002cA\n\u0015-5\t!!\u0003\u0002\u0016\u0005\t!\u0002K]8kK\u000e$(+Z:uMVd\u0017i\u0019;j_:\u0004\"a\u0006\u0010\u000e\u0003aQ!!\u0007\u000e\u0002\u000b5|G-\u001a7\u000b\u0005ma\u0012\u0001B:uCRT!!\b\u0005\u0002\r1,7o]8o\u0013\ty\u0002D\u0001\bMKN\u001cxN\\#wC2\u001cF/\u0019;\t\u000b\u0005\u0002A\u0011\u0001\u0012\u0002\rqJg.\u001b;?)\u0005\u0019\u0003CA\n\u0001\u0011\u0015)\u0003\u0001\"\u0011'\u0003\u0015Ig\u000eZ3y)\u00059\u0003C\u0001\u00152\u001b\u0005I#B\u0001\u0016,\u0003\u00111\u0018.Z<\u000b\u00051j\u0013aA1qS*\u0011afL\u0001\u0007o\u0016\u0014WN^2\u000b\u0005Ar\u0011a\u00022fC:<G.Z\u0005\u0003e%\u0012AAV5fo\")A\u0007\u0001C!M\u000511/Z1sG\"DQA\u000e\u0001\u0005B\u0019\naA]3n_Z,\u0007\"\u0002\u001d\u0001\t\u0013I\u0014a\u0003:f[>4Xm\u0015;biN$2A\u000f!J!\tYd(D\u0001=\u0015\u0005i\u0014!B:dC2\f\u0017BA =\u0005\u0011)f.\u001b;\t\u000b\u0005;\u0004\u0019\u0001\"\u0002\u000fA\u0014xN[3diB\u00111iR\u0007\u0002\t*\u0011\u0011$\u0012\u0006\u0003\r*\tAAY1tK&\u0011\u0001\n\u0012\u0002\b!J|'.Z2u\u0011\u0015Qu\u00071\u0001L\u0003)\u0019X-\\3ti\u0016\u0014\u0018\n\u001a\t\u0003w1K!!\u0014\u001f\u0003\u0007%sG\u000fC\u0003P\u0001\u0011\u0005a%\u0001\beKBD\u0015n\u001d;pef\u001cF/\u0019;\t\u000bE\u0003A\u0011\u0001\u0014\u0002-\u0011,\u0007/\u0019:u[\u0016tGo\u00115pS\u000e,7i\u001c8gS\u001eDQa\u0015\u0001\u0005\u0002\u0019\n!\u0003[5ti>\u0014\u0018pQ8mY\u0016<Wm\u0015;bi\")Q\u000b\u0001C\u0001M\u0005!2m\u001c7mK\u001e,wI]8va&#X-\\%oM>DQa\u0016\u0001\u0005\u0002\u0019\nA#\u001a<bYV\fG/\u001a+fC\u000eD\u0007*[:u_JL\b\"B-\u0001\t\u00031\u0013a\u0006;fC\u000eD\u0017+^3ti&|g\u000eR3uC&d7\u000b^1u\u0011\u0015Y\u0006\u0001\"\u0001'\u0003!\u0019H/\u0019;I_6,\u0007\"B/\u0001\t\u00031\u0013!D5oSR4\u0016\r\\5e\u0011>lW\rC\u0003`\u0001\u0011\u0005a%\u0001\u0005tKR4\u0016\r\\5e\u0011\u0015\t\u0007\u0001\"\u0001'\u0003!\u0011\u0018M\\6Ti\u0006$\b\"B\u000e\u0001\t\u00031\u0003")
public class LessonEvalStatAction
extends ProjectRestfulAction<LessonEvalStat> {
    public View index() {
        String searchFormFlag = (String)this.get("searchFormFlag").orNull(Predef$.MODULE$.$conforms());
        if (searchFormFlag == null) {
            searchFormFlag = "beenStat";
        }
        this.put("searchFormFlag", searchFormFlag);
        this.put("departments", this.findItemsBySchool(Department.class));
        OqlBuilder query = (OqlBuilder)OqlBuilder$.MODULE$.from(Questionnaire.class, "questionnaire").where("questionnaire.state =:state", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToBoolean((boolean)true)}));
        this.put("questionnaires", this.entityDao().search((QueryBuilder)query));
        this.put("semesters", this.getSemesters());
        OqlBuilder semesterQuery = (OqlBuilder)OqlBuilder$.MODULE$.from(Semester.class, "semester").where(":now between semester.beginOn and semester.endOn", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{LocalDate.now()}));
        this.put("currentSemester", this.entityDao().search((QueryBuilder)semesterQuery).head());
        return this.forward(this.forward$default$1());
    }

    public View search() {
        OqlBuilder semesterQuery = (OqlBuilder)OqlBuilder$.MODULE$.from(Semester.class, "semester").where(":now between semester.beginOn and semester.endOn", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{LocalDate.now()}));
        int semesterId = BoxesRunTime.unboxToInt((Object)this.getInt("semester.id").getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> BoxesRunTime.unboxToInt((Object)((NumId)this.entityDao().search((QueryBuilder)semesterQuery).head()).id())));
        Semester semester = (Semester)this.entityDao().get(Semester.class, (Object)BoxesRunTime.boxToInteger((int)semesterId));
        OqlBuilder lessonEvalStat = OqlBuilder$.MODULE$.from(LessonEvalStat.class, "lessonEvalStat");
        this.populateConditions(lessonEvalStat);
        lessonEvalStat.orderBy((String)this.get(Order$.MODULE$.OrderStr()).orNull(Predef$.MODULE$.$conforms())).limit(this.getPageLimit());
        lessonEvalStat.where("lessonEvalStat.lesson.semester=:semester", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{semester}));
        this.put("lessonEvalStats", this.entityDao().search((QueryBuilder)lessonEvalStat));
        return this.forward(this.forward$default$1());
    }

    public View remove() {
        List questionSIds = this.longIds("lessonEvalStat");
        OqlBuilder query = OqlBuilder$.MODULE$.from(LessonEvalStat.class, "questionS");
        query.where("questionS.id in(:ids)", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{questionSIds}));
        this.entityDao().remove((Iterable)this.entityDao().search((QueryBuilder)query));
        return this.redirect("search", "info.remove.success");
    }

    private void removeStats(Project project, int semesterId) {
        OqlBuilder query = OqlBuilder$.MODULE$.from(LessonEvalStat.class, "les");
        query.where("les.lesson.semester.id=:semesterId", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)semesterId)}));
        query.where("les.lesson.project=:project", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{project}));
        this.entityDao().remove((Iterable)this.entityDao().search((QueryBuilder)query));
    }

    public View depHistoryStat() {
        AbstractQueryBuilder abstractQueryBuilder;
        scala.collection.immutable.Seq lis = this.entityDao().search((QueryBuilder)OqlBuilder$.MODULE$.from(EvaluationCriteriaItem.class, "criteriaItem").where("criteriaItem.criteria.id =:id", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)1L)})));
        Object object = lis.size() < 1 ? this.redirect("search", "\u672a\u627e\u5230\u8bc4\u4ef7\u6807\u51c6\uff01") : BoxedUnit.UNIT;
        this.put("criterias", lis);
        Option depId = this.getInt("department.id");
        this.put("departId", depId);
        this.put("departments", this.entityDao().search((QueryBuilder)OqlBuilder$.MODULE$.from(Department.class, "dep").where("dep.teaching=true", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]))));
        OqlBuilder evaquery = OqlBuilder$.MODULE$.from(EvaluateResult.class, "evaluateR");
        evaquery.select("distinct evaluateR.lesson.semester.id");
        evaquery.where("evaluateR.lesson.teachDepart.id=:depId", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{depId}));
        scala.collection.immutable.Seq semesterIds = this.entityDao().search((QueryBuilder)evaquery);
        OqlBuilder qur = OqlBuilder$.MODULE$.from(Semester.class, "semester");
        qur.where("semester.beginOn<=:dat", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new Date()}));
        OqlBuilder quetionQuery = OqlBuilder$.MODULE$.from(LessonEvalStat.class, "questionnaireS");
        if (semesterIds.size() > 0) {
            qur.where("semester.id in(:ids)", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{semesterIds}));
            abstractQueryBuilder = quetionQuery.where("questionnaireS.lesson.semester.id in(:semesterIds)", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{semesterIds}));
        } else {
            qur.where("semester.id is null", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
            abstractQueryBuilder = quetionQuery.where("questionnaireS.lesson.semester.id is null", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
        }
        quetionQuery.where("questionnaireS.lesson.teachDepart.id=:depId", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{depId}));
        this.put("evaSemesters", this.entityDao().search((QueryBuilder)qur));
        quetionQuery.select("questionnaireS.lesson.semester.id,count(questionnaireS.teacher.id)");
        quetionQuery.groupBy("questionnaireS.lesson.semester.id");
        this.put("questionNums", this.entityDao().search((QueryBuilder)quetionQuery));
        Map maps = Collections$.MODULE$.newMap();
        lis.foreach((Function1 & Serializable & scala.Serializable)evaluationCriteriaItem -> {
            OqlBuilder query = OqlBuilder$.MODULE$.from(LessonEvalStat.class, "questionnaireStat");
            query.select("questionnaireStat.semester.id,count(questionnaireStat.teacher.id)");
            query.where("questionnaireStat.score>=" + evaluationCriteriaItem.min() + " and questionnaireStat.score<" + evaluationCriteriaItem.max(), (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
            query.where("questionnaireStat.lesson.teachDepart.id=:depId", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{depId}));
            query.groupBy("questionnaireStat.semester.id");
            return maps.put((Object)evaluationCriteriaItem.id().toString(), (Object)this.entityDao().search((QueryBuilder)query));
        });
        this.put("questionDeps", maps);
        return this.forward(this.forward$default$1());
    }

    public View departmentChoiceConfig() {
        OqlBuilder semesterQuery = (OqlBuilder)OqlBuilder$.MODULE$.from(Semester.class, "semester").where(":now between semester.beginOn and semester.endOn", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{LocalDate.now()}));
        int semesterId = BoxesRunTime.unboxToInt((Object)this.getInt("semester.id").getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> BoxesRunTime.unboxToInt((Object)((NumId)this.entityDao().search((QueryBuilder)semesterQuery).head()).id())));
        Semester semester = (Semester)this.entityDao().get(Semester.class, (Object)BoxesRunTime.boxToInteger((int)semesterId));
        scala.collection.immutable.Seq lis = this.entityDao().search((QueryBuilder)OqlBuilder$.MODULE$.from(EvaluationCriteriaItem.class, "criteriaItem").where("criteriaItem.criteria.id =:id", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)1L)})));
        Object object = lis.size() < 1 ? this.redirect("search", "\u672a\u627e\u5230\u8bc4\u4ef7\u6807\u51c6\uff01") : BoxedUnit.UNIT;
        this.put("criterias", lis);
        this.put("departments", this.entityDao().search((QueryBuilder)OqlBuilder$.MODULE$.from(Department.class, "depart").where("depart.teaching =:teaching", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToBoolean((boolean)true)}))));
        this.put("semester", semester);
        OqlBuilder que = OqlBuilder$.MODULE$.from(EvaluateResult.class.getName() + " evaluateResult," + QuestionResult.class.getName() + " questionResult");
        que.select("sum(questionResult.score)/count(distinct evaluateResult.id)");
        que.where("evaluateResult.id=questionResult.result.id", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
        que.where("evaluateResult.lesson.semester.id=" + semesterId, (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
        scala.collection.immutable.Seq lit = this.entityDao().search((QueryBuilder)que);
        float fl = 0.0f;
        if (lit.size() > 0 && lit.apply(0) != null) {
            fl = new StringOps(Predef$.MODULE$.augmentString(lit.apply(0).toString())).toFloat();
        }
        this.put("evaluateResults", BoxesRunTime.boxToFloat((float)fl));
        OqlBuilder query = OqlBuilder$.MODULE$.from(LessonEvalStat.class, "evaluateR");
        query.select("evaluateR.lesson.teachDepart.id,count( evaluateR.teacher.id)");
        query.where("evaluateR.lesson.semester.id =:semesterId ", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)semesterId)}));
        query.groupBy("evaluateR.lesson.teachDepart.id,evaluateR.lesson.semester.id");
        this.put("questionNums", this.entityDao().search((QueryBuilder)query));
        Map maps = Collections$.MODULE$.newMap();
        lis.foreach((Function1 & Serializable & scala.Serializable)evaluationCriteriaItem -> {
            OqlBuilder query = OqlBuilder$.MODULE$.from(LessonEvalStat.class, "questionnaireStat");
            query.where("questionnaireStat.lesson.semester.id=:semesterId", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)semesterId)}));
            query.select("questionnaireStat.lesson.teachDepart.id,count(questionnaireStat.teacher.id)");
            query.where("questionnaireStat.score>=" + evaluationCriteriaItem.min() + " and questionnaireStat.score<" + evaluationCriteriaItem.max(), (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
            query.groupBy("questionnaireStat.lesson.teachDepart.id");
            return maps.put((Object)evaluationCriteriaItem.id().toString(), (Object)this.entityDao().search((QueryBuilder)query));
        });
        this.put("questionDeps", maps);
        return this.forward(this.forward$default$1());
    }

    public View historyCollegeStat() {
        AbstractQueryBuilder abstractQueryBuilder;
        scala.collection.immutable.Seq lis = this.entityDao().search((QueryBuilder)OqlBuilder$.MODULE$.from(EvaluationCriteriaItem.class, "criteriaItem").where("criteriaItem.criteria.id =:id", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)1L)})));
        Object object = lis.size() < 1 ? this.redirect("search", "\u672a\u627e\u5230\u8bc4\u4ef7\u6807\u51c6\uff01") : BoxedUnit.UNIT;
        this.put("criterias", lis);
        OqlBuilder evaquery = OqlBuilder$.MODULE$.from(EvaluateResult.class, "evaluateR");
        evaquery.select("distinct evaluateR.lesson.semester.id");
        scala.collection.immutable.Seq semesterIds = this.entityDao().search((QueryBuilder)evaquery);
        OqlBuilder qur = OqlBuilder$.MODULE$.from(Semester.class, "semester");
        qur.where("semester.beginOn<=:dat", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new Date()}));
        OqlBuilder quetionQuery = OqlBuilder$.MODULE$.from(LessonEvalStat.class, "questionnaireS");
        if (semesterIds.size() > 0) {
            qur.where("semester.id in(:ids)", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{semesterIds}));
            abstractQueryBuilder = quetionQuery.where("questionnaireS.lesson.semester.id in(:semesterIds)", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{semesterIds}));
        } else {
            qur.where("semester.id is null", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
            abstractQueryBuilder = quetionQuery.where("questionnaireS.lesson.semester.id is null", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
        }
        this.put("evaSemesters", this.entityDao().search((QueryBuilder)qur));
        quetionQuery.select("questionnaireS.lesson.semester.id,count(questionnaireS.teacher.id)");
        quetionQuery.groupBy("questionnaireS.lesson.semester.id");
        this.put("questionNums", this.entityDao().search((QueryBuilder)quetionQuery));
        Map maps = Collections$.MODULE$.newMap();
        lis.foreach((Function1 & Serializable & scala.Serializable)evaluationCriteriaItem -> {
            OqlBuilder query = OqlBuilder$.MODULE$.from(LessonEvalStat.class, "questionnaireStat");
            query.select("questionnaireStat.lesson.semester.id,count(questionnaireStat.teacher.id)");
            query.where("questionnaireStat.score>=" + evaluationCriteriaItem.min() + " and questionnaireStat.score<" + evaluationCriteriaItem.max(), (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
            query.groupBy("questionnaireStat.lesson.semester.id");
            return maps.put((Object)evaluationCriteriaItem.id().toString(), (Object)this.entityDao().search((QueryBuilder)query));
        });
        this.put("questionDeps", maps);
        return this.forward(this.forward$default$1());
    }

    public View collegeGroupItemInfo() {
        AbstractQueryBuilder abstractQueryBuilder;
        scala.collection.immutable.Seq lis = this.entityDao().search((QueryBuilder)OqlBuilder$.MODULE$.from(EvaluationCriteriaItem.class, "criteriaItem").where("criteriaItem.criteria.id =:id", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)1L)})));
        Object object = lis.size() < 1 ? this.redirect("search", "\u672a\u627e\u5230\u8bc4\u4ef7\u6807\u51c6\uff01") : BoxedUnit.UNIT;
        this.put("criterias", lis);
        OqlBuilder evaquery = OqlBuilder$.MODULE$.from(LessonEvalStat.class, "questionnaireStat");
        evaquery.where("questionnaireStat.lesson.semester.id=:semesId", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.getInt("semester.id").get()}));
        evaquery.join("questionnaireStat.questionTypeStats", "questionType");
        evaquery.select("distinct questionType.questionType.id");
        scala.collection.immutable.Seq queTypeIds = this.entityDao().search((QueryBuilder)evaquery);
        OqlBuilder quTqur = OqlBuilder$.MODULE$.from(QuestionType.class, "questionType");
        OqlBuilder quetionQuery = OqlBuilder$.MODULE$.from(LessonEvalStat.class, "questionnaireS");
        quetionQuery.join("questionnaireS.questionTypeStats", "questionTypeStat");
        if (queTypeIds.size() > 0) {
            quTqur.where("questionType.id in(:ids)", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{queTypeIds}));
            abstractQueryBuilder = quetionQuery.where("questionTypeStat.questionType.id in(:queTypeIds)", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{queTypeIds}));
        } else {
            quTqur.where("questionType.id is null", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
            abstractQueryBuilder = quetionQuery.where("questionTypeStat.questionType.id is null", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
        }
        this.put("questionTypes", this.entityDao().search((QueryBuilder)quTqur));
        quetionQuery.select("questionTypeStat.questionType.id,count(questionnaireS.teacher.id)");
        quetionQuery.groupBy("questionTypeStat.questionType.id");
        this.put("quesTypeNums", this.entityDao().search((QueryBuilder)quetionQuery));
        Map maps = Collections$.MODULE$.newMap();
        lis.foreach((Function1 & Serializable & scala.Serializable)evaluationCriteriaItem -> {
            OqlBuilder query = OqlBuilder$.MODULE$.from(LessonEvalStat.class, "questionnaireStat");
            query.where("questionnaireStat.lesson.semester.id=:semesId", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.getInt("semester.id").get()}));
            query.join("questionnaireStat.questionTypeStats", "questionTypeStat");
            query.select("questionTypeStat.questionType.id,count(questionnaireStat.teacher.id)");
            query.where("questionTypeStat.score>=" + evaluationCriteriaItem.min() + " and questionTypeStat.score<" + evaluationCriteriaItem.max(), (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
            query.groupBy("questionTypeStat.questionType.id");
            return maps.put((Object)evaluationCriteriaItem.id().toString(), (Object)this.entityDao().search((QueryBuilder)query));
        });
        this.put("questionDeps", maps);
        OqlBuilder que = OqlBuilder$.MODULE$.from(EvaluateResult.class, "evaluateR");
        que.where("evaluateR.lesson.semester.id=:seiD", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.getInt("semester.id").get()}));
        que.where("evaluateR.statType is 1", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
        que.select("distinct evaluateR.teacher.id");
        scala.collection.immutable.Seq list = this.entityDao().search((QueryBuilder)que);
        this.put("persons", BoxesRunTime.boxToInteger((int)list.size()));
        return this.forward(this.forward$default$1());
    }

    public View evaluateTeachHistory() {
        long id = BoxesRunTime.unboxToLong((Object)this.getLong("lessonEvalStat.id").get());
        LessonEvalStat questionnaires = (LessonEvalStat)this.entityDao().get(LessonEvalStat.class, (Object)BoxesRunTime.boxToLong((long)id));
        OqlBuilder query = OqlBuilder$.MODULE$.from(LessonEvalStat.class, "questionnaires");
        query.where("questionnaires.teacher.id=:teaIds", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{questionnaires.teacher().id()}));
        query.orderBy("questionnaires.semester.beginOn");
        this.put("teacher", questionnaires.teacher());
        this.put("teachEvaluates", this.entityDao().search((QueryBuilder)query));
        return this.forward(this.forward$default$1());
    }

    public View teachQuestionDetailStat() {
        this.put("questionnaires", this.entityDao().get(LessonEvalStat.class, this.getLong("questionnaireStat.id").get()));
        return this.forward(this.forward$default$1());
    }

    public View statHome() {
        this.put("stdTypeList", this.entityDao().getAll(StdType.class));
        this.put("departmentList", this.entityDao().getAll(Department.class));
        this.put("educations", this.entityDao().getAll(Education.class));
        scala.collection.immutable.Seq teachingDeparts = this.entityDao().search((QueryBuilder)OqlBuilder$.MODULE$.from(Department.class, "depart").where("depart.teaching =:tea", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToBoolean((boolean)true)})));
        this.put("departments", teachingDeparts);
        Seq<Semester> semesters = this.getSemesters();
        this.put("semesters", semesters);
        OqlBuilder semesterQuery = (OqlBuilder)OqlBuilder$.MODULE$.from(Semester.class, "semester").where(":now between semester.beginOn and semester.endOn", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{LocalDate.now()}));
        this.put("currentSemester", this.entityDao().search((QueryBuilder)semesterQuery).head());
        return this.forward(this.forward$default$1());
    }

    public View initValidHome() {
        return this.forward(this.forward$default$1());
    }

    public View setValid() {
        return this.forward(this.forward$default$1());
    }

    public View rankStat() {
        int semesterId = BoxesRunTime.unboxToInt((Object)this.getInt("semester.id").getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0));
        Semester semester = (Semester)this.entityDao().get(Semester.class, (Object)BoxesRunTime.boxToInteger((int)semesterId));
        Project project = this.currentProject();
        OqlBuilder rankQuery = OqlBuilder$.MODULE$.from(LessonEvalStat.class, "les");
        rankQuery.where("les.lesson.semester.id=:semesterId", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)semesterId)}));
        rankQuery.where("les.lesson.project=:project", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{project}));
        scala.collection.immutable.Seq evals = this.entityDao().search((QueryBuilder)rankQuery);
        Ranker$.MODULE$.over((Seq)evals, (Function2 & Serializable & scala.Serializable)(x, r) -> {
            x.rank_$eq(BoxesRunTime.unboxToInt((Object)r));
            return BoxedUnit.UNIT;
        });
        scala.collection.immutable.Map departEvalMaps = evals.groupBy((Function1 & Serializable & scala.Serializable)x -> x.lesson().teachDepart());
        departEvalMaps.values().foreach((Function1 & Serializable & scala.Serializable)departEvals -> {
            Ranker$.MODULE$.over((Seq)departEvals, (Function2 & Serializable & scala.Serializable)(x, r) -> {
                x.departRank_$eq(BoxesRunTime.unboxToInt((Object)r));
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        });
        this.entityDao().saveOrUpdate((Iterable)evals);
        return this.redirect("index", "info.action.success");
    }

    public View stat() {
        int semesterId = BoxesRunTime.unboxToInt((Object)this.getInt("semester.id").getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0));
        Semester semester = (Semester)this.entityDao().get(Semester.class, (Object)BoxesRunTime.boxToInteger((int)semesterId));
        Project project = this.currentProject();
        this.removeStats(project, semesterId);
        OqlBuilder que = OqlBuilder$.MODULE$.from(QuestionResult.class.getName(), "questionR");
        que.where("questionR.result.lesson.project=:project", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{project}));
        que.where("questionR.result.lesson.semester.id=:semesterId", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)semesterId)}));
        que.where("questionR.result.statType is 1", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
        que.select("questionR.result.teacher.id,questionR.result.lesson.id,questionR.question.id,sum(questionR.score),avg(questionR.score)");
        que.groupBy("questionR.result.teacher.id,questionR.result.lesson.id,questionR.question.id");
        HashMap wtStatMap = new HashMap();
        scala.collection.immutable.Seq rs2 = this.entityDao().search((QueryBuilder)que);
        rs2.foreach((Function1 & Serializable & scala.Serializable)a -> {
            Buffer buffer = (Buffer)wtStatMap.getOrElseUpdate((Object)new Tuple2(a[0], a[1]), (Function0 & Serializable & scala.Serializable)() -> new ListBuffer());
            return buffer.$plus$eq((Object)new Tuple3((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)a[2])), (Object)((Number)a[3]), (Object)((Number)a[4])));
        });
        OqlBuilder quer = OqlBuilder$.MODULE$.from(QuestionResult.class.getName(), "questionR");
        quer.where("questionR.result.lesson.semester.id=:semesterId", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)semesterId)}));
        quer.where("questionR.result.lesson.project=:project", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{project}));
        quer.where("questionR.result.statType is 1", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
        quer.select("questionR.result.lesson.id,questionR.result.teacher.id,questionR.result.questionnaire.id,sum(questionR.score),sum(questionR.score)/count(distinct questionR.result.id),count(distinct questionR.result.id)");
        quer.groupBy("questionR.result.lesson.id,questionR.result.teacher.id,questionR.result.questionnaire.id");
        scala.collection.immutable.Seq wjStat = this.entityDao().search((QueryBuilder)quer);
        OqlBuilder tyquery = OqlBuilder$.MODULE$.from(QuestionResult.class.getName(), "questionR");
        tyquery.where("questionR.result.lesson.semester.id=:semesterId", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)semesterId)}));
        tyquery.where("questionR.result.lesson.project=:project", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{project}));
        tyquery.where("questionR.result.statType is 1", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
        tyquery.where("questionR.result.teacher is not null", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
        tyquery.select("questionR.result.lesson.id,questionR.result.teacher.id,questionR.question.questionType.id,sum(questionR.score),sum(questionR.score)/count(distinct questionR.result.id)");
        tyquery.groupBy("questionR.result.lesson.id,questionR.result.teacher.id,questionR.question.questionType.id");
        HashMap typeStatMap = new HashMap();
        this.entityDao().search((QueryBuilder)tyquery).foreach((Function1 & Serializable & scala.Serializable)a -> {
            Buffer buffer = (Buffer)typeStatMap.getOrElseUpdate((Object)new Tuple2(a[0], a[1]), (Function0 & Serializable & scala.Serializable)() -> new ListBuffer());
            return buffer.$plus$eq((Object)new Tuple3((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)a[2])), (Object)((Number)a[3]), (Object)((Number)a[4])));
        });
        OqlBuilder opQuery = OqlBuilder$.MODULE$.from(QuestionResult.class.getName(), "questionR");
        opQuery.where("questionR.result.lesson.semester.id=:semesterId", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)semesterId)}));
        opQuery.where("questionR.result.lesson.project=:project", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{project}));
        opQuery.where("questionR.result.statType is 1", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
        opQuery.select("questionR.result.lesson.id,questionR.result.teacher.id,questionR.question.id,questionR.option.id,count(questionR.id)");
        opQuery.groupBy("questionR.result.lesson.id,questionR.result.teacher.id,questionR.question.id,questionR.option.id");
        HashMap optionStatMap = new HashMap();
        this.entityDao().search((QueryBuilder)opQuery).foreach((Function1 & Serializable & scala.Serializable)a -> {
            Buffer buffer = (Buffer)optionStatMap.getOrElseUpdate((Object)new Tuple3(a[0], a[1], a[2]), (Function0 & Serializable & scala.Serializable)() -> new ListBuffer());
            return buffer.$plus$eq((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)a[3])), (Object)((Number)a[4])));
        });
        scala.collection.immutable.Map questionMap = ((TraversableOnce)this.entityDao().getAll(Question.class).map((Function1 & Serializable & scala.Serializable)o -> new Tuple2(o.id(), o), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        scala.collection.immutable.Map questiontyMap = ((TraversableOnce)this.entityDao().getAll(QuestionType.class).map((Function1 & Serializable & scala.Serializable)o -> new Tuple2(o.id(), o), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        scala.collection.immutable.Map optionMap = ((TraversableOnce)this.entityDao().getAll(org.openurp.edu.evaluation.model.Option.class).map((Function1 & Serializable & scala.Serializable)o -> new Tuple2(o.id(), o), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        wjStat.foreach((Function1 & Serializable & scala.Serializable)evaObject -> {
            LessonEvalStatAction.$anonfun$stat$11(this, semester, wtStatMap, typeStatMap, optionStatMap, questionMap, questiontyMap, optionMap, evaObject);
            return BoxedUnit.UNIT;
        });
        OqlBuilder rankQuery = OqlBuilder$.MODULE$.from(LessonEvalStat.class, "les");
        rankQuery.where("les.lesson.semester.id=:semesterId", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)semesterId)}));
        rankQuery.where("les.lesson.project=:project", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{project}));
        scala.collection.immutable.Seq evals = this.entityDao().search((QueryBuilder)rankQuery);
        Ranker$.MODULE$.over((Seq)evals, (Function2 & Serializable & scala.Serializable)(x, r) -> {
            x.rank_$eq(BoxesRunTime.unboxToInt((Object)r));
            return BoxedUnit.UNIT;
        });
        scala.collection.immutable.Map departEvalMaps = evals.groupBy((Function1 & Serializable & scala.Serializable)x -> x.lesson().teachDepart());
        departEvalMaps.values().foreach((Function1 & Serializable & scala.Serializable)departEvals -> {
            Ranker$.MODULE$.over((Seq)departEvals, (Function2 & Serializable & scala.Serializable)(x, r) -> {
                x.departRank_$eq(BoxesRunTime.unboxToInt((Object)r));
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        });
        this.entityDao().saveOrUpdate((Iterable)evals);
        return this.redirect("index", "info.action.success");
    }

    public static final /* synthetic */ void $anonfun$stat$11(LessonEvalStatAction $this, Semester semester$1, HashMap wtStatMap$1, HashMap typeStatMap$1, HashMap optionStatMap$1, scala.collection.immutable.Map questionMap$1, scala.collection.immutable.Map questiontyMap$1, scala.collection.immutable.Map optionMap$1, Object[] evaObject) {
        LessonEvalStat questionS = new LessonEvalStat();
        questionS.lesson_$eq(new Lesson());
        questionS.lesson().id_$eq((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)evaObject[0])));
        questionS.teacher_$eq(new Teacher());
        questionS.teacher().id_$eq((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)evaObject[1])));
        questionS.semester_$eq(semester$1);
        questionS.statAt_$eq(Instant.now());
        questionS.questionnaire_$eq(new Questionnaire());
        questionS.questionnaire().id_$eq((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)evaObject[2])));
        questionS.totalScore_$eq(new StringOps(Predef$.MODULE$.augmentString(evaObject[3].toString())).toFloat());
        float avgScore = new StringOps(Predef$.MODULE$.augmentString(evaObject[4].toString())).toFloat();
        questionS.avgScore_$eq(Predef$.MODULE$.double2Double((double)Math.round(avgScore * (float)100) * 1.0 / (double)100).floatValue());
        questionS.tickets_$eq(Predef$.MODULE$.Integer2int(Integer.valueOf(evaObject[5].toString())));
        questionS.totalTickets_$eq(questionS.tickets());
        Buffer questionDetailStats = Collections$.MODULE$.newBuffer();
        wtStatMap$1.get((Object)new Tuple2.mcJJ.sp(BoxesRunTime.unboxToLong((Object)questionS.teacher().id()), BoxesRunTime.unboxToLong((Object)questionS.lesson().id()))).foreach((Function1 & Serializable & scala.Serializable)buffer -> {
            buffer.foreach((Function1 & Serializable & scala.Serializable)wt -> {
                LessonQuestionStat detailStat = new LessonQuestionStat();
                detailStat.question_$eq((Question)questionMap$1.apply(wt._1()));
                detailStat.totalScore_$eq((double)new StringOps(Predef$.MODULE$.augmentString(wt._2().toString())).toFloat());
                detailStat.avgScore_$eq((double)new StringOps(Predef$.MODULE$.augmentString(wt._3().toString())).toFloat());
                detailStat.evalStat_$eq((EvalStat)questionS$1);
                Buffer optionStates = Collections$.MODULE$.newBuffer();
                optionStatMap$1.get((Object)new Tuple3(questionS$1.lesson().id(), questionS$1.teacher().id(), detailStat.question().id())).foreach((Function1 & Serializable & scala.Serializable)buffer -> {
                    buffer.foreach((Function1 & Serializable & scala.Serializable)os -> {
                        LessonOptionStat optionstat = new LessonOptionStat();
                        optionstat.amount_$eq(((Number)os._2()).intValue());
                        optionstat.option_$eq((org.openurp.edu.evaluation.model.Option)optionMap$1.apply((Object)BoxesRunTime.boxToLong((long)os._1$mcJ$sp())));
                        optionstat.questionStat_$eq((QuestionStat)detailStat$1);
                        return optionStates$1.$plus$eq((Object)optionstat);
                    });
                    return BoxedUnit.UNIT;
                });
                detailStat.optionStats_$eq(optionStates);
                return questionDetailStats$1.$plus$eq((Object)detailStat);
            });
            return BoxedUnit.UNIT;
        });
        questionS.questionStats_$eq((Buffer<QuestionStat>)questionDetailStats);
        Buffer questionTypeStats = Collections$.MODULE$.newBuffer();
        typeStatMap$1.get((Object)new Tuple2.mcJJ.sp(BoxesRunTime.unboxToLong((Object)questionS.lesson().id()), BoxesRunTime.unboxToLong((Object)questionS.teacher().id()))).foreach((Function1 & Serializable & scala.Serializable)buffer -> {
            buffer.foreach((Function1 & Serializable & scala.Serializable)os -> {
                LessonQuestionTypeStat questionTs = new LessonQuestionTypeStat();
                questionTs.totalScore_$eq(((Number)os._2()).floatValue());
                questionTs.avgScore_$eq(((Number)os._3()).floatValue());
                questionTs.evalStat_$eq((EvalStat)questionS$1);
                questionTs.questionType_$eq((QuestionType)questiontyMap$1.apply(os._1()));
                return questionTypeStats$1.$plus$eq((Object)questionTs);
            });
            return BoxedUnit.UNIT;
        });
        questionS.questionTypeStats_$eq((Buffer<QuestionTypeStat>)questionTypeStats);
        $this.entityDao().saveOrUpdate((Object)questionS, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new LessonEvalStat[0]));
    }
}

