/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.evaluation.course.web.action;

import java.io.Serializable;
import java.time.LocalDate;
import org.beangle.commons.collection.Collections$;
import org.beangle.commons.collection.Order$;
import org.beangle.data.dao.OqlBuilder;
import org.beangle.data.dao.OqlBuilder$;
import org.beangle.data.dao.QueryBuilder;
import org.beangle.data.model.NumId;
import org.beangle.webmvc.api.view.View;
import org.beangle.webmvc.entity.action.RestfulAction;
import org.openurp.base.model.Semester;
import org.openurp.edu.evaluation.lesson.result.model.EvaluateResult;
import org.openurp.edu.evaluation.lesson.result.model.QuestionResult;
import org.openurp.edu.evaluation.lesson.stat.model.TeacherEvalStat;
import org.openurp.edu.evaluation.model.Option;
import org.openurp.edu.evaluation.model.Question;
import org.openurp.edu.lesson.model.CourseTaker;
import org.openurp.edu.lesson.model.Lesson;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001m2A!\u0001\u0002\u0001#\t9B+Z1dQ\u0016\u0014XI^1m'\u0016\f'o\u00195BGRLwN\u001c\u0006\u0003\u0007\u0011\ta!Y2uS>t'BA\u0003\u0007\u0003\r9XM\u0019\u0006\u0003\u000f!\taaY8veN,'BA\u0005\u000b\u0003))g/\u00197vCRLwN\u001c\u0006\u0003\u00171\t1!\u001a3v\u0015\tia\"A\u0004pa\u0016tWO\u001d9\u000b\u0003=\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\n\u0011\u0007MYR$D\u0001\u0015\u0015\t\u0019QC\u0003\u0002\u0017/\u00051QM\u001c;jifT!\u0001G\r\u0002\r],'-\u001c<d\u0015\tQb\"A\u0004cK\u0006tw\r\\3\n\u0005q!\"!\u0004*fgR4W\u000f\\!di&|g\u000e\u0005\u0002\u001fK5\tqD\u0003\u0002!C\u0005)Qn\u001c3fY*\u0011!eI\u0001\u0005gR\fGO\u0003\u0002%\u0011\u00051A.Z:t_:L!AJ\u0010\u0003\u001fQ+\u0017m\u00195fe\u00163\u0018\r\\*uCRDQ\u0001\u000b\u0001\u0005\u0002%\na\u0001P5oSRtD#\u0001\u0016\u0011\u0005-\u0002Q\"\u0001\u0002\t\u000b5\u0002A\u0011\t\u0018\u0002\u000b%tG-\u001a=\u0015\u0003=\u0002\"\u0001M\u001b\u000e\u0003ER!AM\u001a\u0002\tYLWm\u001e\u0006\u0003i]\t1!\u00199j\u0013\t1\u0014G\u0001\u0003WS\u0016<\b\"\u0002\u001d\u0001\t\u0003r\u0013AB:fCJ\u001c\u0007\u000eC\u0003;\u0001\u0011\u0005a&\u0001\u0003j]\u001a|\u0007")
public class TeacherEvalSearchAction
extends RestfulAction<TeacherEvalStat> {
    public View index() {
        scala.collection.immutable.Seq semesters = this.entityDao().getAll(Semester.class);
        this.put("semesters", semesters);
        OqlBuilder semesterQuery = (OqlBuilder)OqlBuilder$.MODULE$.from(Semester.class, "semester").where(":now between semester.beginOn and semester.endOn", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{LocalDate.now()}));
        this.put("currentSemester", this.entityDao().search((QueryBuilder)semesterQuery).head());
        return this.forward(this.forward$default$1());
    }

    public View search() {
        OqlBuilder semesterQuery = (OqlBuilder)OqlBuilder$.MODULE$.from(Semester.class, "semester").where(":now between semester.beginOn and semester.endOn", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{LocalDate.now()}));
        int semesterId = BoxesRunTime.unboxToInt((Object)this.getInt("semester.id").getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> BoxesRunTime.unboxToInt((Object)((NumId)this.entityDao().search((QueryBuilder)semesterQuery).head()).id())));
        Semester semester = (Semester)this.entityDao().get(Semester.class, (Object)BoxesRunTime.boxToInteger((int)semesterId));
        OqlBuilder teacherEvalStat = OqlBuilder$.MODULE$.from(TeacherEvalStat.class, "teacherEvalStat");
        this.populateConditions(teacherEvalStat);
        teacherEvalStat.orderBy((String)this.get(Order$.MODULE$.OrderStr()).orNull(Predef$.MODULE$.$conforms())).limit(this.getPageLimit());
        teacherEvalStat.where("teacherEvalStat.semester=:semester", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{semester}));
        this.put("teacherEvalStats", this.entityDao().search((QueryBuilder)teacherEvalStat));
        return this.forward(this.forward$default$1());
    }

    public View info() {
        TeacherEvalStat questionnaireStat = (TeacherEvalStat)this.entityDao().get(TeacherEvalStat.class, this.getLong("teacherEvalStat.id").get());
        this.put("questionnaireStat", questionnaireStat);
        OqlBuilder query = OqlBuilder$.MODULE$.from(EvaluateResult.class.getName(), "result");
        query.where("result.teacher =:tea", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{questionnaireStat.teacher()}));
        query.where("result.questionnaire=:quen", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{questionnaireStat.questionnaire()}));
        query.select("case when result.statType =1 then count(result.id) end,count(result.id)");
        query.groupBy("result.statType");
        this.entityDao().search((QueryBuilder)query).foreach((Function1 & Serializable & scala.Serializable)a -> {
            TeacherEvalSearchAction.$anonfun$info$1(this, a);
            return BoxedUnit.UNIT;
        });
        Buffer list = Collections$.MODULE$.newBuffer();
        Buffer questions = questionnaireStat.questionnaire().questions();
        questions.foreach((Function1 & Serializable & scala.Serializable)question -> {
            TeacherEvalSearchAction.$anonfun$info$2(list, question);
            return BoxedUnit.UNIT;
        });
        this.put("options", list);
        OqlBuilder lessonQue = OqlBuilder$.MODULE$.from(EvaluateResult.class.getName(), "evalResult");
        lessonQue.select("distinct evalResult.lesson");
        lessonQue.where("evalResult.lesson.semester.id =:semesterId", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{questionnaireStat.semester().id()}));
        lessonQue.join("evalResult.lesson.teachers", "teacher");
        lessonQue.where("teacher.id=:teacherId", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{questionnaireStat.teacher().id()}));
        LongRef numbers = LongRef.create((long)0L);
        scala.collection.immutable.Seq lessons = this.entityDao().search((QueryBuilder)lessonQue);
        lessons.foreach((Function1 & Serializable & scala.Serializable)lesson -> {
            TeacherEvalSearchAction.$anonfun$info$5(this, questionnaireStat, numbers, lesson);
            return BoxedUnit.UNIT;
        });
        this.put("numbers", BoxesRunTime.boxToLong((long)numbers.elem));
        OqlBuilder que = OqlBuilder$.MODULE$.from(QuestionResult.class, "questionR");
        que.where("questionR.result.teacher=:teaId", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{questionnaireStat.teacher()}));
        que.where("questionR.result.questionnaire=:quen", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{questionnaireStat.questionnaire()}));
        que.select("questionR.question.id,questionR.option.id,count(*)");
        que.groupBy("questionR.question.id,questionR.option.id");
        this.put("questionRs", this.entityDao().search((QueryBuilder)que));
        OqlBuilder quer = OqlBuilder$.MODULE$.from(QuestionResult.class, "questionR");
        quer.where("questionR.result.teacher=:teaId", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{questionnaireStat.teacher()}));
        quer.where("questionR.result.questionnaire=:quen", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{questionnaireStat.questionnaire()}));
        quer.select("questionR.question.id,questionR.question.content,sum(questionR.score)/count(questionR.id)*100");
        quer.groupBy("questionR.question.id,questionR.question.content");
        this.put("questionResults", this.entityDao().search((QueryBuilder)quer));
        return this.forward(this.forward$default$1());
    }

    public static final /* synthetic */ void $anonfun$info$1(TeacherEvalSearchAction $this, Object[] a) {
        $this.put("number1", a[0]);
        $this.put("number2", a[1]);
    }

    public static final /* synthetic */ void $anonfun$info$4(IntRef tt$1, Option option$1, Option oldOption) {
        block0: {
            if (BoxesRunTime.unboxToLong((Object)oldOption.id()) != BoxesRunTime.unboxToLong((Object)option$1.id())) break block0;
            ++tt$1.elem;
        }
    }

    public static final /* synthetic */ void $anonfun$info$2(Buffer list$1, Question question) {
        Set options = question.optionGroup().options();
        options.foreach((Function1 & Serializable & scala.Serializable)option -> {
            IntRef tt = IntRef.create((int)0);
            list$1.foreach((Function1 & Serializable & scala.Serializable)oldOption -> {
                TeacherEvalSearchAction.$anonfun$info$4(tt, option, oldOption);
                return BoxedUnit.UNIT;
            });
            return tt.elem == 0 ? list$1.$plus$eq(option) : BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$info$5(TeacherEvalSearchAction $this, TeacherEvalStat questionnaireStat$1, LongRef numbers$1, Lesson lesson) {
        OqlBuilder querys = OqlBuilder$.MODULE$.from(CourseTaker.class.getName(), "courseTake");
        querys.join("courseTake.lesson.teachers", "teacher");
        querys.where("teacher.id=:teacherId", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{questionnaireStat$1.teacher().id()}));
        querys.where("courseTake.semester.id=:semesterId", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{questionnaireStat$1.semester().id()}));
        querys.where("courseTake.lesson = (:lesson)", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{lesson}));
        querys.select("count(courseTake.std.id)");
        numbers$1.elem += BoxesRunTime.unboxToLong((Object)$this.entityDao().search((QueryBuilder)querys).apply(0));
    }
}

