/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.evaluation.course.web.action;

import java.io.Serializable;
import java.time.Instant;
import java.time.LocalDate;
import java.util.Date;
import org.beangle.commons.collection.Collections$;
import org.beangle.commons.collection.Order$;
import org.beangle.commons.lang.Strings$;
import org.beangle.data.dao.AbstractQueryBuilder;
import org.beangle.data.dao.OqlBuilder;
import org.beangle.data.dao.OqlBuilder$;
import org.beangle.data.dao.QueryBuilder;
import org.beangle.data.model.NumId;
import org.beangle.webmvc.api.view.View;
import org.openurp.base.model.Department;
import org.openurp.base.model.Semester;
import org.openurp.edu.base.code.model.Education;
import org.openurp.edu.base.code.model.StdType;
import org.openurp.edu.base.model.Teacher;
import org.openurp.edu.evaluation.app.lesson.service.Ranker$;
import org.openurp.edu.evaluation.course.web.action.ProjectRestfulAction;
import org.openurp.edu.evaluation.lesson.result.model.EvaluateResult;
import org.openurp.edu.evaluation.lesson.result.model.QuestionResult;
import org.openurp.edu.evaluation.lesson.stat.model.EvalStat;
import org.openurp.edu.evaluation.lesson.stat.model.QuestionStat;
import org.openurp.edu.evaluation.lesson.stat.model.TeacherEvalStat;
import org.openurp.edu.evaluation.lesson.stat.model.TeacherOptionStat;
import org.openurp.edu.evaluation.lesson.stat.model.TeacherQuestionStat;
import org.openurp.edu.evaluation.lesson.stat.model.TeacherQuestionTypeStat;
import org.openurp.edu.evaluation.model.EvaluationCriteriaItem;
import org.openurp.edu.evaluation.model.Option;
import org.openurp.edu.evaluation.model.Question;
import org.openurp.edu.evaluation.model.QuestionType;
import org.openurp.edu.evaluation.model.Questionnaire;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.ListBuffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001-4A!\u0001\u0002\u0001#\t)B+Z1dQ\u0016\u0014XI^1m'R\fG/Q2uS>t'BA\u0002\u0005\u0003\u0019\t7\r^5p]*\u0011QAB\u0001\u0004o\u0016\u0014'BA\u0004\t\u0003\u0019\u0019w.\u001e:tK*\u0011\u0011BC\u0001\u000bKZ\fG.^1uS>t'BA\u0006\r\u0003\r)G-\u001e\u0006\u0003\u001b9\tqa\u001c9f]V\u0014\bOC\u0001\u0010\u0003\ry'oZ\u0002\u0001'\t\u0001!\u0003E\u0002\u0014)Yi\u0011AA\u0005\u0003+\t\u0011A\u0003\u0015:pU\u0016\u001cGOU3ti\u001a,H.Q2uS>t\u0007CA\f\u001f\u001b\u0005A\"BA\r\u001b\u0003\u0015iw\u000eZ3m\u0015\tYB$\u0001\u0003ti\u0006$(BA\u000f\t\u0003\u0019aWm]:p]&\u0011q\u0004\u0007\u0002\u0010)\u0016\f7\r[3s\u000bZ\fGn\u0015;bi\")\u0011\u0005\u0001C\u0001E\u00051A(\u001b8jiz\"\u0012a\t\t\u0003'\u0001AQ!\n\u0001\u0005B\u0019\nQ!\u001b8eKb$\u0012a\n\t\u0003QEj\u0011!\u000b\u0006\u0003U-\nAA^5fo*\u0011A&L\u0001\u0004CBL'B\u0001\u00180\u0003\u00199XMY7wG*\u0011\u0001GD\u0001\bE\u0016\fgn\u001a7f\u0013\t\u0011\u0014F\u0001\u0003WS\u0016<\b\"\u0002\u001b\u0001\t\u00032\u0013AB:fCJ\u001c\u0007\u000eC\u00037\u0001\u0011\u0005c%\u0001\u0004sK6|g/\u001a\u0005\u0006m\u0001!\t\u0001\u000f\u000b\u0005s}*v\u000b\u0005\u0002;{5\t1HC\u0001=\u0003\u0015\u00198-\u00197b\u0013\tq4H\u0001\u0003V]&$\b\"\u0002!8\u0001\u0004\t\u0015\u0001E3ek\u000e\fG/[8o)f\u0004X-\u00133t!\r\u0011%*\u0014\b\u0003\u0007\"s!\u0001R$\u000e\u0003\u0015S!A\u0012\t\u0002\rq\u0012xn\u001c;?\u0013\u0005a\u0014BA%<\u0003\u001d\u0001\u0018mY6bO\u0016L!a\u0013'\u0003\t1K7\u000f\u001e\u0006\u0003\u0013n\u0002\"AT*\u000e\u0003=S!\u0001U)\u0002\t1\fgn\u001a\u0006\u0002%\u0006!!.\u0019<b\u0013\t!vJA\u0004J]R,w-\u001a:\t\u000bY;\u0004\u0019A!\u0002\u001b\u0011,\u0007/\u0019:u[\u0016tG/\u00133t\u0011\u0015Av\u00071\u0001Z\u0003)\u0019X-\\3ti\u0016\u0014\u0018\n\u001a\t\u0003uiK!aW\u001e\u0003\u0007%sG\u000fC\u0003^\u0001\u0011\u0005a%\u0001\u0005ti\u0006$\bj\\7f\u0011\u0015Y\u0002\u0001\"\u0001'\u0011\u0015\u0001\u0007\u0001\"\u0001'\u0003!\u0011\u0018M\\6Ti\u0006$\b\"\u00022\u0001\t\u00031\u0013\u0001F3wC2,\u0018\r^3UK\u0006\u001c\u0007\u000eS5ti>\u0014\u0018\u0010C\u0003e\u0001\u0011\u0005a%\u0001\feKB\f'\u000f^7f]R\u001c\u0005n\\5dK\u000e{gNZ5h\u0011\u00151\u0007\u0001\"\u0001'\u00039!W\r\u001d%jgR|'/_*uCRDQ\u0001\u001b\u0001\u0005\u0002\u0019\n!\u0003[5ti>\u0014\u0018pQ8mY\u0016<Wm\u0015;bi\")!\u000e\u0001C\u0001M\u0005!2m\u001c7mK\u001e,wI]8va&#X-\\%oM>\u0004")
public class TeacherEvalStatAction
extends ProjectRestfulAction<TeacherEvalStat> {
    public View index() {
        this.put("departments", this.findItemsBySchool(Department.class));
        OqlBuilder builder = OqlBuilder$.MODULE$.from(EvaluateResult.class, "evaluateResult");
        Seq<Semester> semesters = this.getSemesters();
        this.put("semesters", semesters);
        OqlBuilder semesterQuery = (OqlBuilder)OqlBuilder$.MODULE$.from(Semester.class, "semester").where(":now between semester.beginOn and semester.endOn", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{LocalDate.now()}));
        this.put("currentSemester", this.entityDao().search((QueryBuilder)semesterQuery).head());
        Object object = semesters != null ? builder.where("evaluateResult.lesson.semester in (:ids)", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{semesters})) : BoxedUnit.UNIT;
        builder.select("distinct questionnaire");
        this.put("questionnaires", this.entityDao().search((QueryBuilder)builder));
        return this.forward(this.forward$default$1());
    }

    public View search() {
        OqlBuilder semesterQuery = (OqlBuilder)OqlBuilder$.MODULE$.from(Semester.class, "semester").where(":now between semester.beginOn and semester.endOn", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{LocalDate.now()}));
        int semesterId = BoxesRunTime.unboxToInt((Object)this.getInt("semester.id").getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> BoxesRunTime.unboxToInt((Object)((NumId)this.entityDao().search((QueryBuilder)semesterQuery).head()).id())));
        Semester semester = (Semester)this.entityDao().get(Semester.class, (Object)BoxesRunTime.boxToInteger((int)semesterId));
        OqlBuilder queryBuilder = OqlBuilder$.MODULE$.from(TeacherEvalStat.class, "teacherEvalStat");
        this.populateConditions(queryBuilder);
        queryBuilder.orderBy((String)this.get(Order$.MODULE$.OrderStr()).orNull(Predef$.MODULE$.$conforms())).limit(this.getPageLimit());
        queryBuilder.where("teacherEvalStat.semester =:semester", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{semester}));
        this.put("teacherEvalStats", this.entityDao().search((QueryBuilder)queryBuilder));
        return this.forward(this.forward$default$1());
    }

    public View remove() {
        List questionSIds = this.longIds("evaluate");
        OqlBuilder query = OqlBuilder$.MODULE$.from(TeacherEvalStat.class, "questionS");
        query.where("questionS.id in(:ids)", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{questionSIds}));
        this.entityDao().remove((Iterable)this.entityDao().search((QueryBuilder)query));
        return this.redirect("search", "info.remove.success");
    }

    public void remove(List<Integer> educationTypeIds, List<Integer> departmentIds, int semesterId) {
        Semester semester = (Semester)this.entityDao().get(Semester.class, (Object)BoxesRunTime.boxToInteger((int)semesterId));
        OqlBuilder query = OqlBuilder$.MODULE$.from(TeacherEvalStat.class, "questionS");
        query.where("questionS.semester =:semester", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{semester}));
        scala.collection.immutable.Seq results = this.entityDao().search((QueryBuilder)query);
        this.entityDao().remove((Iterable)results);
    }

    public View statHome() {
        this.put("stdTypeList", this.entityDao().getAll(StdType.class));
        this.put("departmentList", this.entityDao().getAll(Department.class));
        this.put("educations", this.entityDao().getAll(Education.class));
        scala.collection.immutable.Seq teachingDeparts = this.entityDao().search((QueryBuilder)OqlBuilder$.MODULE$.from(Department.class, "depart").where("depart.teaching =:tea", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToBoolean((boolean)true)})));
        this.put("departments", teachingDeparts);
        scala.collection.immutable.Seq semesters = this.entityDao().getAll(Semester.class);
        this.put("semesters", semesters);
        OqlBuilder semesterQuery = (OqlBuilder)OqlBuilder$.MODULE$.from(Semester.class, "semester").where(":now between semester.beginOn and semester.endOn", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{LocalDate.now()}));
        this.put("currentSemester", this.entityDao().search((QueryBuilder)semesterQuery).head());
        return this.forward(this.forward$default$1());
    }

    public View stat() {
        String eduStr = (String)this.get("educatIds").get();
        String depStr = (String)this.get("departIds").get();
        String[] eduIds = eduStr.split(",");
        String[] depIds = depStr.split(",");
        List educationTypeIds = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])Strings$.MODULE$.transformToInteger(eduIds))).toList();
        List departmentIds = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])Strings$.MODULE$.transformToInteger(depIds))).toList();
        OqlBuilder semesterQuery = (OqlBuilder)OqlBuilder$.MODULE$.from(Semester.class, "semester").where(":now between semester.beginOn and semester.endOn", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{LocalDate.now()}));
        int semesterId = BoxesRunTime.unboxToInt((Object)this.getInt("semester.id").getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> BoxesRunTime.unboxToInt((Object)((NumId)this.entityDao().search((QueryBuilder)semesterQuery).head()).id())));
        Semester semester = (Semester)this.entityDao().get(Semester.class, (Object)BoxesRunTime.boxToInteger((int)semesterId));
        this.remove((List<Integer>)educationTypeIds, (List<Integer>)departmentIds, semesterId);
        OqlBuilder que = OqlBuilder$.MODULE$.from(QuestionResult.class.getName(), "questionR");
        que.where("questionR.result.lesson.semester.id=:semesterId", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)semesterId)}));
        que.where("questionR.result.statType is 1", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
        que.where("questionR.question.addition is false", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
        que.where("questionR.result.department.id in(:depIds)", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{departmentIds}));
        que.select("questionR.result.lesson.semester.id,questionR.result.teacher.id,questionR.question.id,sum(questionR.score),avg(questionR.score),count(questionR.id)");
        que.groupBy("questionR.result.lesson.semester.id,questionR.result.teacher.id,questionR.question.id");
        HashMap wtStatMap = new HashMap();
        this.entityDao().search((QueryBuilder)que).foreach((Function1 & Serializable & scala.Serializable)a -> {
            Buffer buffer = (Buffer)wtStatMap.getOrElseUpdate((Object)new Tuple2(a[0], a[1]), (Function0 & Serializable & scala.Serializable)() -> new ListBuffer());
            return buffer.$plus$eq((Object)new Tuple4((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)a[2])), (Object)((Number)a[3]), (Object)((Number)a[4]), (Object)((Number)a[5])));
        });
        OqlBuilder quer = OqlBuilder$.MODULE$.from(QuestionResult.class.getName(), "questionR");
        quer.where("questionR.result.lesson.semester.id=:semesterId", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)semesterId)}));
        quer.where("questionR.result.statType is 1", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
        quer.where("questionR.result.department.id in(:depIds)", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{departmentIds}));
        quer.where("questionR.question.addition is false", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
        quer.select("questionR.result.lesson.semester.id,questionR.result.teacher.id,questionR.result.questionnaire.id,sum(questionR.score),case when questionR.result.statType =1 then count(distinct questionR.result.id) end,count(distinct questionR.result.id),case when questionR.result.statType =1 then sum(questionR.score) end,sum(questionR.score)/count(distinct questionR.result.id)");
        quer.groupBy("questionR.result.lesson.semester.id,questionR.result.teacher.id,questionR.result.questionnaire.id,questionR.result.statType");
        scala.collection.immutable.Seq wjStat = this.entityDao().search((QueryBuilder)quer);
        OqlBuilder tyquery = OqlBuilder$.MODULE$.from(QuestionResult.class.getName(), "questionR");
        tyquery.where("questionR.result.lesson.semester.id=:semesterId", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)semesterId)}));
        tyquery.where("questionR.result.statType is 1", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
        tyquery.where("questionR.result.teacher is not null", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
        tyquery.where("questionR.result.department.id in(:depIds)", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{departmentIds}));
        tyquery.where("questionR.question.addition is false", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
        tyquery.select("questionR.result.lesson.semester.id,questionR.result.teacher.id,questionR.question.questionType.id,sum(questionR.score)/count(distinct questionR.result.id)");
        tyquery.groupBy("questionR.result.lesson.semester.id,questionR.result.teacher.id,questionR.question.questionType.id");
        HashMap typeStatMap = new HashMap();
        this.entityDao().search((QueryBuilder)tyquery).foreach((Function1 & Serializable & scala.Serializable)a -> {
            Buffer buffer = (Buffer)typeStatMap.getOrElseUpdate((Object)new Tuple2(a[0], a[1]), (Function0 & Serializable & scala.Serializable)() -> new ListBuffer());
            return buffer.$plus$eq((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)a[2])), (Object)((Number)a[3])));
        });
        OqlBuilder opQuery = OqlBuilder$.MODULE$.from(QuestionResult.class.getName(), "questionR");
        opQuery.where("questionR.result.lesson.semester.id=:semesterId", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)semesterId)}));
        opQuery.where("questionR.result.statType is 1", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
        opQuery.where("questionR.result.department.id in(:depIds)", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{departmentIds}));
        opQuery.where("questionR.question.addition is false", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
        opQuery.select("questionR.result.lesson.semester.id,questionR.result.teacher.id,questionR.question.id,questionR.option.id,count(questionR.id)");
        opQuery.groupBy("questionR.result.lesson.semester.id,questionR.result.teacher.id,questionR.question.id,questionR.option.id");
        HashMap optionStatMap = new HashMap();
        this.entityDao().search((QueryBuilder)opQuery).foreach((Function1 & Serializable & scala.Serializable)a -> {
            Buffer buffer = (Buffer)optionStatMap.getOrElseUpdate((Object)new Tuple3(a[0], a[1], a[2]), (Function0 & Serializable & scala.Serializable)() -> new ListBuffer());
            return buffer.$plus$eq((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)a[3])), (Object)((Number)a[4])));
        });
        Map questionMap = ((TraversableOnce)this.entityDao().getAll(Question.class).map((Function1 & Serializable & scala.Serializable)o -> new Tuple2(o.id(), o), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        Map questiontyMap = ((TraversableOnce)this.entityDao().getAll(QuestionType.class).map((Function1 & Serializable & scala.Serializable)o -> new Tuple2(o.id(), o), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        Map optionMap = ((TraversableOnce)this.entityDao().getAll(Option.class).map((Function1 & Serializable & scala.Serializable)o -> new Tuple2(o.id(), o), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        OqlBuilder lquery = OqlBuilder$.MODULE$.from(Teacher.class, "sf");
        lquery.where("sf.state.department.id in(:depIds)", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{departmentIds}));
        scala.collection.immutable.Seq teacherList = this.entityDao().search((QueryBuilder)lquery);
        wjStat.foreach((Function1 & Serializable & scala.Serializable)evaObject -> {
            TeacherEvalStatAction.$anonfun$stat$11(this, semester, wtStatMap, typeStatMap, optionStatMap, questionMap, questiontyMap, optionMap, evaObject);
            return BoxedUnit.UNIT;
        });
        return this.redirect("index", "info.action.success");
    }

    public View rankStat() {
        OqlBuilder semesterQuery = (OqlBuilder)OqlBuilder$.MODULE$.from(Semester.class, "semester").where(":now between semester.beginOn and semester.endOn", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{LocalDate.now()}));
        int semesterId = BoxesRunTime.unboxToInt((Object)this.getInt("semester.id").getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> BoxesRunTime.unboxToInt((Object)((NumId)this.entityDao().search((QueryBuilder)semesterQuery).head()).id())));
        Semester semester = (Semester)this.entityDao().get(Semester.class, (Object)BoxesRunTime.boxToInteger((int)semesterId));
        OqlBuilder rankQuery = OqlBuilder$.MODULE$.from(TeacherEvalStat.class, "teacherEvalStat");
        rankQuery.where("teacherEvalStat.semester.id=:semesterId", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)semesterId)}));
        scala.collection.immutable.Seq evals = this.entityDao().search((QueryBuilder)rankQuery);
        Ranker$.MODULE$.over((Seq)evals, (Function2 & Serializable & scala.Serializable)(x, r) -> {
            x.rank_$eq(BoxesRunTime.unboxToInt((Object)r));
            return BoxedUnit.UNIT;
        });
        Map departEvalMaps = evals.groupBy((Function1 & Serializable & scala.Serializable)x -> x.teacher().user().department());
        departEvalMaps.values().foreach((Function1 & Serializable & scala.Serializable)departEvals -> {
            Ranker$.MODULE$.over((Seq)departEvals, (Function2 & Serializable & scala.Serializable)(x, r) -> {
                x.departRank_$eq(BoxesRunTime.unboxToInt((Object)r));
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        });
        this.entityDao().saveOrUpdate((Iterable)evals);
        return this.redirect("index", "info.action.success");
    }

    public View evaluateTeachHistory() {
        long id = BoxesRunTime.unboxToLong((Object)this.getLong("teacherEvalStat.id").get());
        TeacherEvalStat questionnaires = (TeacherEvalStat)this.entityDao().get(TeacherEvalStat.class, (Object)BoxesRunTime.boxToLong((long)id));
        OqlBuilder query = OqlBuilder$.MODULE$.from(TeacherEvalStat.class, "questionnaires");
        query.where("questionnaires.teacher.id=:teaIds", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{questionnaires.teacher().id()}));
        query.orderBy("questionnaires.semester.beginOn");
        this.put("teacher", questionnaires.teacher());
        this.put("teachEvaluates", this.entityDao().search((QueryBuilder)query));
        return this.forward(this.forward$default$1());
    }

    public View departmentChoiceConfig() {
        OqlBuilder semesterQuery = (OqlBuilder)OqlBuilder$.MODULE$.from(Semester.class, "semester").where(":now between semester.beginOn and semester.endOn", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{LocalDate.now()}));
        int semesterId = BoxesRunTime.unboxToInt((Object)this.getInt("semester.id").getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> BoxesRunTime.unboxToInt((Object)((NumId)this.entityDao().search((QueryBuilder)semesterQuery).head()).id())));
        Semester semester = (Semester)this.entityDao().get(Semester.class, (Object)BoxesRunTime.boxToInteger((int)semesterId));
        scala.collection.immutable.Seq lis = this.entityDao().search((QueryBuilder)OqlBuilder$.MODULE$.from(EvaluationCriteriaItem.class, "criteriaItem").where("criteriaItem.criteria.id =:id", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)1L)})));
        Object object = lis.size() < 1 ? this.redirect("search", "\u672a\u627e\u5230\u8bc4\u4ef7\u6807\u51c6\uff01") : BoxedUnit.UNIT;
        this.put("criterias", lis);
        this.put("departments", this.entityDao().search((QueryBuilder)OqlBuilder$.MODULE$.from(Department.class, "depart").where("depart.teaching =:teaching", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToBoolean((boolean)true)}))));
        this.put("semester", semester);
        OqlBuilder query = OqlBuilder$.MODULE$.from(TeacherEvalStat.class, "evaluateR");
        query.select("evaluateR.teacher.state.department.id,count( evaluateR.teacher.id)");
        query.where("evaluateR.semester.id =:semesterId ", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)semesterId)}));
        query.groupBy("evaluateR.teacher.state.department.id,evaluateR.semester.id");
        this.put("questionNums", this.entityDao().search((QueryBuilder)query));
        scala.collection.mutable.Map maps = Collections$.MODULE$.newMap();
        lis.foreach((Function1 & Serializable & scala.Serializable)evaluationCriteriaItem -> {
            OqlBuilder query = OqlBuilder$.MODULE$.from(TeacherEvalStat.class, "questionnaireStat");
            query.where("questionnaireStat.semester.id=:semesterId", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)semesterId)}));
            query.select("questionnaireStat.teacher.state.department.id,count(questionnaireStat.teacher.id)");
            query.where("questionnaireStat.score>=" + evaluationCriteriaItem.min() + " and questionnaireStat.score<" + evaluationCriteriaItem.max(), (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
            query.groupBy("questionnaireStat.teacher.state.department.id");
            return maps.put((Object)evaluationCriteriaItem.id().toString(), (Object)this.entityDao().search((QueryBuilder)query));
        });
        this.put("questionDeps", maps);
        return this.forward(this.forward$default$1());
    }

    public View depHistoryStat() {
        AbstractQueryBuilder abstractQueryBuilder;
        scala.collection.immutable.Seq lis = this.entityDao().search((QueryBuilder)OqlBuilder$.MODULE$.from(EvaluationCriteriaItem.class, "criteriaItem").where("criteriaItem.criteria.id =:id", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)1L)})));
        Object object = lis.size() < 1 ? this.redirect("search", "\u672a\u627e\u5230\u8bc4\u4ef7\u6807\u51c6\uff01") : BoxedUnit.UNIT;
        this.put("criterias", lis);
        int depId = BoxesRunTime.unboxToInt((Object)this.getInt("department.id").getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 20));
        this.put("departId", BoxesRunTime.boxToInteger((int)depId));
        this.put("departments", this.entityDao().search((QueryBuilder)OqlBuilder$.MODULE$.from(Department.class, "dep").where("dep.teaching=true", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]))));
        OqlBuilder evaquery = OqlBuilder$.MODULE$.from(EvaluateResult.class, "evaluateR");
        evaquery.select("distinct evaluateR.lesson.semester.id");
        evaquery.where("evaluateR.teacher.state.department.id=:depId", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)depId)}));
        scala.collection.immutable.Seq semesterIds = this.entityDao().search((QueryBuilder)evaquery);
        OqlBuilder qur = OqlBuilder$.MODULE$.from(Semester.class, "semester");
        qur.where("semester.beginOn<=:dat", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new Date()}));
        OqlBuilder quetionQuery = OqlBuilder$.MODULE$.from(TeacherEvalStat.class, "questionnaireS");
        if (semesterIds.size() > 0) {
            qur.where("semester.id in(:ids)", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{semesterIds}));
            abstractQueryBuilder = quetionQuery.where("questionnaireS.semester.id in(:semesterIds)", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{semesterIds}));
        } else {
            qur.where("semester.id is null", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
            abstractQueryBuilder = quetionQuery.where("questionnaireS.semester.id is null", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
        }
        quetionQuery.where("questionnaireS.teacher.state.department.id=:depId", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)depId)}));
        this.put("evaSemesters", this.entityDao().search((QueryBuilder)qur));
        quetionQuery.select("questionnaireS.semester.id,count(questionnaireS.teacher.id)");
        quetionQuery.groupBy("questionnaireS.semester.id");
        this.put("questionNums", this.entityDao().search((QueryBuilder)quetionQuery));
        scala.collection.mutable.Map maps = Collections$.MODULE$.newMap();
        lis.foreach((Function1 & Serializable & scala.Serializable)evaluationCriteriaItem -> {
            OqlBuilder query = OqlBuilder$.MODULE$.from(TeacherEvalStat.class, "questionnaireStat");
            query.select("questionnaireStat.semester.id,count(questionnaireStat.teacher.id)");
            query.where("questionnaireStat.score>=" + evaluationCriteriaItem.min() + " and questionnaireStat.score<" + evaluationCriteriaItem.max(), (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
            query.where("questionnaireStat.teacher.state.department.id=:depId", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)depId)}));
            query.groupBy("questionnaireStat.semester.id");
            return maps.put((Object)evaluationCriteriaItem.id().toString(), (Object)this.entityDao().search((QueryBuilder)query));
        });
        this.put("questionDeps", maps);
        return this.forward(this.forward$default$1());
    }

    public View historyCollegeStat() {
        AbstractQueryBuilder abstractQueryBuilder;
        scala.collection.immutable.Seq lis = this.entityDao().search((QueryBuilder)OqlBuilder$.MODULE$.from(EvaluationCriteriaItem.class, "criteriaItem").where("criteriaItem.criteria.id =:id", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)1L)})));
        Object object = lis.size() < 1 ? this.redirect("search", "\u672a\u627e\u5230\u8bc4\u4ef7\u6807\u51c6\uff01") : BoxedUnit.UNIT;
        this.put("criterias", lis);
        OqlBuilder evaquery = OqlBuilder$.MODULE$.from(EvaluateResult.class, "evaluateR");
        evaquery.select("distinct evaluateR.lesson.semester.id");
        scala.collection.immutable.Seq semesterIds = this.entityDao().search((QueryBuilder)evaquery);
        OqlBuilder qur = OqlBuilder$.MODULE$.from(Semester.class, "semester");
        qur.where("semester.beginOn<=:dat", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new Date()}));
        OqlBuilder quetionQuery = OqlBuilder$.MODULE$.from(TeacherEvalStat.class, "questionnaireS");
        if (semesterIds.size() > 0) {
            qur.where("semester.id in(:ids)", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{semesterIds}));
            abstractQueryBuilder = quetionQuery.where("questionnaireS.semester.id in(:semesterIds)", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{semesterIds}));
        } else {
            qur.where("semester.id is null", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
            abstractQueryBuilder = quetionQuery.where("questionnaireS.semester.id is null", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
        }
        this.put("evaSemesters", this.entityDao().search((QueryBuilder)qur));
        quetionQuery.select("questionnaireS.semester.id,count(questionnaireS.teacher.id)");
        quetionQuery.groupBy("questionnaireS.semester.id");
        this.put("questionNums", this.entityDao().search((QueryBuilder)quetionQuery));
        scala.collection.mutable.Map maps = Collections$.MODULE$.newMap();
        lis.foreach((Function1 & Serializable & scala.Serializable)evaluationCriteriaItem -> {
            OqlBuilder query = OqlBuilder$.MODULE$.from(TeacherEvalStat.class, "questionnaireStat");
            query.select("questionnaireStat.semester.id,count(questionnaireStat.teacher.id)");
            query.where("questionnaireStat.score>=" + evaluationCriteriaItem.min() + " and questionnaireStat.score<" + evaluationCriteriaItem.max(), (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
            query.groupBy("questionnaireStat.semester.id");
            return maps.put((Object)evaluationCriteriaItem.id().toString(), (Object)this.entityDao().search((QueryBuilder)query));
        });
        this.put("questionDeps", maps);
        return this.forward(this.forward$default$1());
    }

    public View collegeGroupItemInfo() {
        AbstractQueryBuilder abstractQueryBuilder;
        scala.collection.immutable.Seq lis = this.entityDao().search((QueryBuilder)OqlBuilder$.MODULE$.from(EvaluationCriteriaItem.class, "criteriaItem").where("criteriaItem.criteria.id =:id", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)1L)})));
        Object object = lis.size() < 1 ? this.redirect("search", "\u672a\u627e\u5230\u8bc4\u4ef7\u6807\u51c6\uff01") : BoxedUnit.UNIT;
        this.put("criterias", lis);
        OqlBuilder evaquery = OqlBuilder$.MODULE$.from(TeacherEvalStat.class, "questionnaireStat");
        evaquery.where("questionnaireStat.semester.id=:semesId", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.getInt("semester.id").get()}));
        evaquery.join("questionnaireStat.questionTypeStats", "questionType");
        evaquery.select("distinct questionType.questionType.id");
        scala.collection.immutable.Seq queTypeIds = this.entityDao().search((QueryBuilder)evaquery);
        OqlBuilder quTqur = OqlBuilder$.MODULE$.from(QuestionType.class, "questionType");
        OqlBuilder quetionQuery = OqlBuilder$.MODULE$.from(TeacherEvalStat.class, "questionnaireS");
        quetionQuery.join("questionnaireS.questionTypeStats", "questionTypeStat");
        if (queTypeIds.size() > 0) {
            quTqur.where("questionType.id in(:ids)", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{queTypeIds}));
            abstractQueryBuilder = quetionQuery.where("questionTypeStat.questionType.id in(:queTypeIds)", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{queTypeIds}));
        } else {
            quTqur.where("questionType.id is null", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
            abstractQueryBuilder = quetionQuery.where("questionTypeStat.questionType.id is null", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
        }
        this.put("questionTypes", this.entityDao().search((QueryBuilder)quTqur));
        quetionQuery.select("questionTypeStat.questionType.id,count(questionnaireS.teacher.id)");
        quetionQuery.groupBy("questionTypeStat.questionType.id");
        this.put("quesTypeNums", this.entityDao().search((QueryBuilder)quetionQuery));
        scala.collection.mutable.Map maps = Collections$.MODULE$.newMap();
        lis.foreach((Function1 & Serializable & scala.Serializable)evaluationCriteriaItem -> {
            OqlBuilder query = OqlBuilder$.MODULE$.from(TeacherEvalStat.class, "questionnaireStat");
            query.where("questionnaireStat.semester.id=:semesId", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.getInt("semester.id").get()}));
            query.join("questionnaireStat.questionTypeStats", "questionTypeStat");
            query.select("questionTypeStat.questionType.id,count(questionnaireStat.teacher.id)");
            query.where("questionTypeStat.score>=" + evaluationCriteriaItem.min() + " and questionTypeStat.score<" + evaluationCriteriaItem.max(), (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
            query.groupBy("questionTypeStat.questionType.id");
            return maps.put((Object)evaluationCriteriaItem.id().toString(), (Object)this.entityDao().search((QueryBuilder)query));
        });
        this.put("questionDeps", maps);
        OqlBuilder que = OqlBuilder$.MODULE$.from(EvaluateResult.class, "evaluateR");
        que.where("evaluateR.lesson.semester.id=:seiD", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.getInt("semester.id").get()}));
        que.select("distinct evaluateR.teacher.id");
        scala.collection.immutable.Seq list = this.entityDao().search((QueryBuilder)que);
        this.put("persons", BoxesRunTime.boxToInteger((int)list.size()));
        return this.forward(this.forward$default$1());
    }

    public static final /* synthetic */ void $anonfun$stat$11(TeacherEvalStatAction $this, Semester semester$1, HashMap wtStatMap$1, HashMap typeStatMap$1, HashMap optionStatMap$1, Map questionMap$1, Map questiontyMap$1, Map optionMap$1, Object[] evaObject) {
        TeacherEvalStat questionS = new TeacherEvalStat();
        questionS.teacher_$eq(new Teacher());
        questionS.teacher().id_$eq((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)evaObject[1])));
        questionS.semester_$eq(semester$1);
        questionS.statAt_$eq(Instant.now());
        questionS.totalScore_$eq(new StringOps(Predef$.MODULE$.augmentString(evaObject[7].toString())).toFloat() * (float)10);
        questionS.avgScore_$eq(new StringOps(Predef$.MODULE$.augmentString(evaObject[6].toString())).toFloat() * (float)10 / (float)Predef$.MODULE$.Integer2int(Integer.valueOf(evaObject[5].toString())));
        questionS.tickets_$eq(Predef$.MODULE$.Integer2int(Integer.valueOf(evaObject[4].toString())));
        questionS.totalTickets_$eq(Predef$.MODULE$.Integer2int(Integer.valueOf(evaObject[5].toString())));
        questionS.questionnaire_$eq(new Questionnaire());
        questionS.questionnaire().id_$eq((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)evaObject[2])));
        Buffer questionDetailStats = Collections$.MODULE$.newBuffer();
        wtStatMap$1.get((Object)new Tuple2.mcIJ.sp(BoxesRunTime.unboxToInt((Object)questionS.semester().id()), BoxesRunTime.unboxToLong((Object)questionS.teacher().id()))).foreach((Function1 & Serializable & scala.Serializable)buffer -> {
            buffer.foreach((Function1 & Serializable & scala.Serializable)wt -> {
                TeacherQuestionStat detailStat = new TeacherQuestionStat();
                detailStat.question_$eq((Question)questionMap$1.apply(wt._1()));
                detailStat.totalScore_$eq((double)(new StringOps(Predef$.MODULE$.augmentString(wt._2().toString())).toFloat() * (float)100));
                detailStat.avgScore_$eq((double)(new StringOps(Predef$.MODULE$.augmentString(wt._3().toString())).toFloat() * (float)100));
                detailStat.evalStat_$eq((EvalStat)questionS$1);
                Buffer optionStates = Collections$.MODULE$.newBuffer();
                optionStatMap$1.get((Object)new Tuple3(questionS$1.semester().id(), questionS$1.teacher().id(), detailStat.question().id())).foreach((Function1 & Serializable & scala.Serializable)buffer -> {
                    buffer.foreach((Function1 & Serializable & scala.Serializable)os -> {
                        TeacherOptionStat optionstat = new TeacherOptionStat();
                        optionstat.amount_$eq(((Number)os._2()).intValue());
                        optionstat.option_$eq((Option)optionMap$1.apply((Object)BoxesRunTime.boxToLong((long)os._1$mcJ$sp())));
                        optionstat.questionStat_$eq((QuestionStat)detailStat$1);
                        return optionStates$1.$plus$eq((Object)optionstat);
                    });
                    return BoxedUnit.UNIT;
                });
                detailStat.optionStats_$eq(optionStates);
                return questionDetailStats$1.$plus$eq((Object)detailStat);
            });
            return BoxedUnit.UNIT;
        });
        questionS.questionStats_$eq(questionDetailStats);
        Buffer questionTypeStats = Collections$.MODULE$.newBuffer();
        typeStatMap$1.get((Object)new Tuple2.mcIJ.sp(BoxesRunTime.unboxToInt((Object)questionS.semester().id()), BoxesRunTime.unboxToLong((Object)questionS.teacher().id()))).foreach((Function1 & Serializable & scala.Serializable)buffer -> {
            buffer.foreach((Function1 & Serializable & scala.Serializable)os -> {
                TeacherQuestionTypeStat questionTs = new TeacherQuestionTypeStat();
                questionTs.totalScore_$eq(new StringOps(Predef$.MODULE$.augmentString(os._2().toString())).toFloat() * (float)100);
                questionTs.evalStat_$eq((EvalStat)questionS$1);
                questionTs.questionType_$eq((QuestionType)questiontyMap$1.apply((Object)BoxesRunTime.boxToLong((long)os._1$mcJ$sp())));
                return questionTypeStats$1.$plus$eq((Object)questionTs);
            });
            return BoxedUnit.UNIT;
        });
        questionS.questionTypeStats_$eq(questionTypeStats);
        $this.entityDao().saveOrUpdate((Object)questionS, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new TeacherEvalStat[0]));
    }
}

