/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.evaluation.course.web.action;

import java.io.Serializable;
import java.time.Instant;
import java.time.LocalDate;
import org.beangle.commons.collection.Collections$;
import org.beangle.data.dao.OqlBuilder;
import org.beangle.data.dao.OqlBuilder$;
import org.beangle.data.dao.QueryBuilder;
import org.beangle.data.model.NumId;
import org.beangle.webmvc.api.view.View;
import org.beangle.webmvc.entity.action.RestfulAction;
import org.openurp.base.model.Semester;
import org.openurp.edu.base.model.Student;
import org.openurp.edu.base.model.Teacher;
import org.openurp.edu.evaluation.app.lesson.model.TextEvaluateSwitch;
import org.openurp.edu.evaluation.lesson.model.TeacherRemessage;
import org.openurp.edu.evaluation.lesson.model.TextEvaluation;
import org.openurp.edu.lesson.model.CourseTaker;
import org.openurp.edu.lesson.model.Lesson;
import org.openurp.platform.api.security.Securities$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.BufferLike;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005me\u0001B\u0001\u0003\u0001E\u0011Q\u0003V3yi\u00163\u0018\r\\;bi\u0016\u001cF\u000fZ!di&|gN\u0003\u0002\u0004\t\u00051\u0011m\u0019;j_:T!!\u0002\u0004\u0002\u0007],'M\u0003\u0002\b\u0011\u000511m\\;sg\u0016T!!\u0003\u0006\u0002\u0015\u00154\u0018\r\\;bi&|gN\u0003\u0002\f\u0019\u0005\u0019Q\rZ;\u000b\u00055q\u0011aB8qK:,(\u000f\u001d\u0006\u0002\u001f\u0005\u0019qN]4\u0004\u0001M\u0011\u0001A\u0005\t\u0004'miR\"\u0001\u000b\u000b\u0005\r)\"B\u0001\f\u0018\u0003\u0019)g\u000e^5us*\u0011\u0001$G\u0001\u0007o\u0016\u0014WN^2\u000b\u0005iq\u0011a\u00022fC:<G.Z\u0005\u00039Q\u0011QBU3ti\u001a,H.Q2uS>t\u0007C\u0001\u0010$\u001b\u0005y\"B\u0001\u0011\"\u0003\u0015iw\u000eZ3m\u0015\t\u0011\u0003\"\u0001\u0004mKN\u001cxN\\\u0005\u0003I}\u0011a\u0002V3yi\u00163\u0018\r\\;bi&|g\u000eC\u0003'\u0001\u0011\u0005q%\u0001\u0004=S:LGO\u0010\u000b\u0002QA\u0011\u0011\u0006A\u0007\u0002\u0005!)1\u0006\u0001C\u0001Y\u0005Qq-\u001a;TiV$WM\u001c;\u0015\u00035\u0002\"A\f\u001a\u000e\u0003=R!\u0001\t\u0019\u000b\u0005ER\u0011\u0001\u00022bg\u0016L!aM\u0018\u0003\u000fM#X\u000fZ3oi\")Q\u0007\u0001C\u0001m\u0005Yq-\u001a;Pi\",'/T1q)\u00119DJ\u0014,\u0011\tajthQ\u0007\u0002s)\u0011!hO\u0001\u000bG>dG.Z2uS>t'\"\u0001\u001f\u0002\u000bM\u001c\u0017\r\\1\n\u0005yJ$aA'baB\u0011\u0001)Q\u0007\u0002w%\u0011!i\u000f\u0002\u0005\u0019>tw\rE\u0002E\u000f&k\u0011!\u0012\u0006\u0003\rf\nq!\\;uC\ndW-\u0003\u0002I\u000b\n1!)\u001e4gKJ\u0004\"A\b&\n\u0005-{\"\u0001\u0005+fC\u000eDWM\u001d*f[\u0016\u001c8/Y4f\u0011\u0015iE\u00071\u0001.\u0003\r\u0019H\u000f\u001a\u0005\u0006\u001fR\u0002\r\u0001U\u0001\tg\u0016lWm\u001d;feB\u0011\u0011\u000bV\u0007\u0002%*\u0011\u0001e\u0015\u0006\u0003c1I!!\u0016*\u0003\u0011M+W.Z:uKJDQa\u0016\u001bA\u0002a\u000b\u0001\u0002^3bG\",'o\u001d\t\u00043\u0006$gB\u0001.`\u001d\tYf,D\u0001]\u0015\ti\u0006#\u0001\u0004=e>|GOP\u0005\u0002y%\u0011\u0001mO\u0001\ba\u0006\u001c7.Y4f\u0013\t\u00117MA\u0002TKFT!\u0001Y\u001e\u0011\u00059*\u0017B\u000140\u0005\u001d!V-Y2iKJDQ\u0001\u001b\u0001\u0005\u0002%\facZ3u\u001bf$V\r\u001f;Fm\u0006dW/\u0019;j_:l\u0015\r\u001d\u000b\u0005U2lg\u000e\u0005\u00039{}Z\u0007c\u0001#H;!)Qj\u001aa\u0001[!)qj\u001aa\u0001!\")qk\u001aa\u00011\")\u0001\u000f\u0001C\u0001c\u0006Iq-\u001a;B]:l\u0015\r\u001d\u000b\u0005oI\u001cH\u000fC\u0003N_\u0002\u0007Q\u0006C\u0003P_\u0002\u0007\u0001\u000bC\u0003X_\u0002\u0007\u0001\fC\u0003w\u0001\u0011\u0005q/\u0001\rhKR$V-Y2iKJ\u001c()\u001f'fgN|g.\u00133TKF$\"\u0001\u0017=\t\u000be,\b\u0019\u0001>\u0002\u00171,7o]8o\u0013\u0012\u001cV-\u001d\t\u00043n|\u0014B\u0001?d\u0005\u0011a\u0015n\u001d;\t\u000by\u0004A\u0011A@\u0002;\u001d,G\u000fV3bG\",'\u000fT3tg>t')\u001f'fgN|g.\u00133TKF$B!!\u0001\u0002\u0010A!\u0011,YA\u0002!\u0015\u0001\u0015QAA\u0005\u0013\r\t9a\u000f\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0004\u0001\u0006-\u0011bAA\u0007w\t\u0019\u0011I\\=\t\u000bel\b\u0019\u0001>\t\u000f\u0005M\u0001\u0001\"\u0001\u0002\u0016\u0005)r-\u001a;UKb$XI^1mk\u0006$\u0018n\u001c8MSN$H\u0003CA\f\u00033\ti\"a\u000b\u0011\u0007e\u000bW\u0004C\u0004\u0002\u001c\u0005E\u0001\u0019A\u0017\u0002\u000fM$X\u000fZ3oi\"9!%!\u0005A\u0002\u0005}\u0001\u0003BA\u0011\u0003Oi!!a\t\u000b\u0007\u0001\n)C\u0003\u0002#\u0015%!\u0011\u0011FA\u0012\u0005\u0019aUm]:p]\"9\u0011QFA\t\u0001\u0004!\u0017a\u0002;fC\u000eDWM\u001d\u0005\b\u0003c\u0001A\u0011AA\u001a\u0003%9W\r^*xSR\u001c\u0007\u000e\u0006\u0002\u00026A!\u0011qGA!\u001b\t\tIDC\u0002!\u0003wQ1AIA\u001f\u0015\r\ty\u0004C\u0001\u0004CB\u0004\u0018\u0002BA\"\u0003s\u0011!\u0003V3yi\u00163\u0018\r\\;bi\u0016\u001cv/\u001b;dQ\"9\u0011q\t\u0001\u0005\u0002\u0005%\u0013aH4fi2+7o]8o\u0013\u0012\fe\u000e\u001a+fC\u000eDWM]%e\u001f\u001a\u0014Vm];miR1\u00111JA/\u0003?\u0002b\u0001O\u001f\u0002N\u00055\u0003\u0003BA(\u0003/rA!!\u0015\u0002TA\u00111lO\u0005\u0004\u0003+Z\u0014A\u0002)sK\u0012,g-\u0003\u0003\u0002Z\u0005m#AB*ue&twMC\u0002\u0002VmBq!a\u0007\u0002F\u0001\u0007Q\u0006\u0003\u0004P\u0003\u000b\u0002\r\u0001\u0015\u0005\b\u0003G\u0002A\u0011AA3\u000359W\r^*uI2+7o]8ogR1\u0011qMA5\u0003W\u0002B!W1\u0002 !9\u00111DA1\u0001\u0004i\u0003BB(\u0002b\u0001\u0007\u0001\u000bC\u0004\u0002p\u0001!\t&!\u001d\u0002\u0019%tG-\u001a=TKR$\u0018N\\4\u0015\u0005\u0005M\u0004c\u0001!\u0002v%\u0019\u0011qO\u001e\u0003\tUs\u0017\u000e\u001e\u0005\b\u0003w\u0002A\u0011IA?\u0003\u0019\u0019X-\u0019:dQR\u0011\u0011q\u0010\t\u0005\u0003\u0003\u000bY)\u0004\u0002\u0002\u0004*!\u0011QQAD\u0003\u00111\u0018.Z<\u000b\u0007\u0005%u#A\u0002ba&LA!!$\u0002\u0004\n!a+[3x\u0011\u001d\t\t\n\u0001C\u0001\u0003{\n\u0001\u0003\\8bIR+\u0007\u0010^#wC2,\u0018\r^3\t\u000f\u0005U\u0005\u0001\"\u0001\u0002~\u0005\u00012/\u0019<f)\u0016DH/\u0012<bYV\fG/\u001a\u0005\b\u00033\u0003A\u0011AA?\u0003%\u0011X-\\:h\u0019&\u001cH\u000f")
public class TextEvaluateStdAction
extends RestfulAction<TextEvaluation> {
    public Student getStudent() {
        scala.collection.immutable.Seq stds = this.entityDao().search((QueryBuilder)OqlBuilder$.MODULE$.from(Student.class, "s").where("s.code=:code", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Securities$.MODULE$.user()})));
        if (stds.isEmpty()) {
            throw new RuntimeException("Cannot find student with code " + Securities$.MODULE$.user());
        }
        return (Student)stds.head();
    }

    public Map<Object, Buffer<TeacherRemessage>> getOtherMap(Student std, Semester semester, Seq<Teacher> teachers) {
        OqlBuilder query = OqlBuilder$.MODULE$.from(TeacherRemessage.class, "teacherRemessage");
        query.join("left", "teacherRemessage.students", "student");
        query.join("left", "teacherRemessage.textEvaluation", "textEvaluation");
        query.where("student =:std", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{std}));
        query.where("textEvaluation.lesson.semester =:semester", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{semester}));
        query.where("textEvaluation.student !=:std", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{std}));
        query.where("teacherRemessage.visible = true", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
        query.orderBy("teacherRemessage.createdAt desc");
        scala.collection.mutable.Map otherMap = Collections$.MODULE$.newMap();
        scala.collection.immutable.Seq results = this.entityDao().search((QueryBuilder)query);
        results.foreach((Function1 & Serializable & scala.Serializable)teacherRemessage -> ((BufferLike)otherMap.getOrElseUpdate(teacherRemessage.textEvaluation().teacher().id(), (Function0 & Serializable & scala.Serializable)() -> Collections$.MODULE$.newBuffer())).$plus$eq(teacherRemessage));
        teachers.foreach((Function1 & Serializable & scala.Serializable)teacher -> !otherMap.contains(teacher.id()) ? otherMap.put(teacher.id(), null) : BoxedUnit.UNIT);
        return otherMap;
    }

    public Map<Object, Buffer<TextEvaluation>> getMyTextEvaluationMap(Student std, Semester semester, Seq<Teacher> teachers) {
        OqlBuilder query = OqlBuilder$.MODULE$.from(TextEvaluation.class, "textEvaluation");
        query.where("textEvaluation.student =:std", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{std}));
        query.where("textEvaluation.lesson.semester =:semester", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{semester}));
        query.where("textEvaluation.state = true", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
        scala.collection.mutable.Map textEvaluateMap = Collections$.MODULE$.newMap();
        scala.collection.immutable.Seq results = this.entityDao().search((QueryBuilder)query);
        results.foreach((Function1 & Serializable & scala.Serializable)textEvaluation -> ((BufferLike)textEvaluateMap.getOrElseUpdate(textEvaluation.teacher().id(), (Function0 & Serializable & scala.Serializable)() -> Collections$.MODULE$.newBuffer())).$plus$eq(textEvaluation));
        teachers.foreach((Function1 & Serializable & scala.Serializable)teacher -> !textEvaluateMap.contains(teacher.id()) ? textEvaluateMap.put(teacher.id(), null) : BoxedUnit.UNIT);
        return textEvaluateMap;
    }

    public Map<Object, Buffer<TeacherRemessage>> getAnnMap(Student std, Semester semester, Seq<Teacher> teachers) {
        OqlBuilder query = OqlBuilder$.MODULE$.from(TeacherRemessage.class, "teacherRemessage");
        query.join("left", "teacherRemessage.students", "student");
        query.join("left", "teacherRemessage.textEvaluation", "textEvaluation");
        query.where("student =:std", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{std}));
        query.where("textEvaluation.lesson.semester = :semester", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{semester}));
        query.where("teacherRemessage.visible = false", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
        scala.collection.mutable.Map annMap = Collections$.MODULE$.newMap();
        scala.collection.immutable.Seq results = this.entityDao().search((QueryBuilder)query);
        results.foreach((Function1 & Serializable & scala.Serializable)teacherRemessage -> ((BufferLike)annMap.getOrElseUpdate(teacherRemessage.textEvaluation().teacher().id(), (Function0 & Serializable & scala.Serializable)() -> Collections$.MODULE$.newBuffer())).$plus$eq(teacherRemessage));
        teachers.foreach((Function1 & Serializable & scala.Serializable)teacher -> !annMap.contains(teacher.id()) ? annMap.put(teacher.id(), null) : BoxedUnit.UNIT);
        return annMap;
    }

    public Seq<Teacher> getTeachersByLessonIdSeq(List<Object> lessonIdSeq) {
        OqlBuilder query = OqlBuilder$.MODULE$.from(Lesson.class.getName() + " lesson");
        query.join("lesson.teachers", "teacher");
        query.select("teacher");
        query.where("lesson.id in (:lessonIdSeq)", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{lessonIdSeq}));
        return this.entityDao().search((QueryBuilder)query);
    }

    public Seq<Object[]> getTeacherLessonByLessonIdSeq(List<Object> lessonIdSeq) {
        OqlBuilder query = OqlBuilder$.MODULE$.from(Lesson.class.getName() + " lesson");
        query.join("lesson.teachers", "teacher");
        query.select("teacher,lesson");
        query.where("lesson.id in (:lessonIdSeq)", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{lessonIdSeq}));
        return this.entityDao().search((QueryBuilder)query);
    }

    public Seq<TextEvaluation> getTextEvaluationList(Student student, Lesson lesson, Teacher teacher) {
        OqlBuilder query = OqlBuilder$.MODULE$.from(TextEvaluation.class, "textEvaluation");
        query.where("textEvaluation.student =:student", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{student}));
        query.where("textEvaluation.lesson =:lesson", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{lesson}));
        query.where("textEvaluation.teacher =:teacher", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{teacher}));
        return this.entityDao().search((QueryBuilder)query);
    }

    public TextEvaluateSwitch getSwitch() {
        Iterator iterator = this.entityDao().getAll(TextEvaluateSwitch.class).iterator();
        return iterator.hasNext() ? (TextEvaluateSwitch)iterator.next() : new TextEvaluateSwitch();
    }

    public Map<String, String> getLessonIdAndTeacherIdOfResult(Student student, Semester semester) {
        OqlBuilder query = OqlBuilder$.MODULE$.from(TextEvaluation.class, "textEvaluation");
        query.where("textEvaluation.student = :student ", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{student}));
        query.where("textEvaluation.lesson.semester = :semester", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{semester}));
        scala.collection.immutable.Seq a = this.entityDao().search((QueryBuilder)query);
        return ((TraversableOnce)a.map((Function1 & Serializable & scala.Serializable)obj -> new Tuple2((Object)(BoxesRunTime.unboxToLong((Object)obj.lesson().id()) + "_" + (obj.teacher() == null ? "0" : obj.teacher().id())), (Object)"1"), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public Seq<Lesson> getStdLessons(Student student, Semester semester) {
        Seq stdLessons;
        block0: {
            OqlBuilder query = OqlBuilder$.MODULE$.from(CourseTaker.class, "courseTake");
            query.select("distinct courseTake.lesson.id ");
            query.where("courseTake.std=:std", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{student}));
            query.where("courseTake.semester =:semester", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{semester}));
            scala.collection.immutable.Seq lessonIds = this.entityDao().search((QueryBuilder)query);
            stdLessons = (Seq)scala.collection.Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
            if (lessonIds.isEmpty()) break block0;
            OqlBuilder entityquery = (OqlBuilder)OqlBuilder$.MODULE$.from(Lesson.class, "lesson").where("lesson.id in (:lessonIds)", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{lessonIds}));
            stdLessons = this.entityDao().search((QueryBuilder)entityquery);
        }
        return stdLessons;
    }

    public void indexSetting() {
        Student std = this.getStudent();
        Object object = std == null ? this.forward("error.std.stdNo.needed") : BoxedUnit.UNIT;
        scala.collection.immutable.Seq semesters = this.entityDao().getAll(Semester.class);
        this.put("semesters", semesters);
    }

    public View search() {
        BoxedUnit boxedUnit;
        Student std = this.getStudent();
        Object object = std == null ? this.forward("error.std.stdNo.needed") : BoxedUnit.UNIT;
        OqlBuilder semesterQuery = (OqlBuilder)OqlBuilder$.MODULE$.from(Semester.class, "semester").where(":now between semester.beginOn and semester.endOn", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{LocalDate.now()}));
        int semesterId = BoxesRunTime.unboxToInt((Object)this.getInt("semester.id").getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> BoxesRunTime.unboxToInt((Object)((NumId)this.entityDao().search((QueryBuilder)semesterQuery).head()).id())));
        Semester semester = (Semester)this.entityDao().get(Semester.class, (Object)BoxesRunTime.boxToInteger((int)semesterId));
        Seq<Lesson> lessons = this.getStdLessons(std, semester);
        if (lessons.isEmpty()) {
            this.addMessage("\u5bf9\u4e0d\u8d77,\u6ca1\u6709\u8bc4\u6559\u8bfe\u7a0b!", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
            boxedUnit = this.forward("errors");
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        ObjectRef myCourses = ObjectRef.create((Object)Collections$.MODULE$.newBuffer());
        lessons.foreach((Function1 & Serializable & scala.Serializable)lesson -> !lesson.teachers().isEmpty() ? ((Buffer)myCourses$1.elem).$plus$eq(lesson) : BoxedUnit.UNIT);
        this.put("lessons", (Buffer)myCourses.elem);
        this.put("evaluateMap", this.getLessonIdAndTeacherIdOfResult(std, semester));
        return this.forward(this.forward$default$1());
    }

    public View loadTextEvaluate() {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        String evaluateId = (String)this.get("evaluateId").get();
        String evaluateState = (String)this.get("evaluateState").get();
        String[] ids = ((String)this.get("evaluateId").get()).split(",");
        Lesson lesson = (Lesson)this.entityDao().get(Lesson.class, (Object)BoxesRunTime.boxToLong((long)new StringOps(Predef$.MODULE$.augmentString(ids[0])).toLong()));
        if (lesson == null) {
            this.addMessage("\u627e\u4e0d\u5230\u8be5\u8bfe\u7a0b!", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
            return this.forward("errors");
        }
        TextEvaluateSwitch textEvaluationSwitch = this.getSwitch();
        if (textEvaluationSwitch == null) {
            this.addMessage("\u73b0\u5728\u8fd8\u6ca1\u6709\u5f00\u653e\u6587\u5b57\u8bc4\u6559!", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
            boxedUnit2 = this.forward("errors");
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        Teacher teacher = (Teacher)this.entityDao().get(Teacher.class, (Object)BoxesRunTime.boxToLong((long)new StringOps(Predef$.MODULE$.augmentString(ids[1])).toLong()));
        if (teacher == null) {
            this.addMessage("\u8be5\u8bfe\u7a0b\u6ca1\u6709\u6307\u5b9a\u4efb\u8bfe\u6559\u5e08!", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
            boxedUnit = this.forward("errors");
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        if ("update".equals(evaluateState)) {
            Student std = this.getStudent();
            Seq<TextEvaluation> textEvaluations = this.getTextEvaluationList(std, lesson, teacher);
            this.put("textEvaluations", textEvaluations);
        }
        this.put("teacher", teacher);
        this.put("lesson", lesson);
        this.put("evaluateState", evaluateState);
        return this.forward(this.forward$default$1());
    }

    public View saveTextEvaluate() {
        View view;
        Student std = this.getStudent();
        long LessonId = this.longId("lesson");
        Option teacherId = this.getLong("teacherId");
        Lesson lesson = (Lesson)this.entityDao().get(Lesson.class, (Object)BoxesRunTime.boxToLong((long)LessonId));
        Teacher teacher = (Teacher)this.entityDao().get(Teacher.class, teacherId.get());
        String textOpinion = ((String)this.get("textOpinion").get()).toString();
        boolean evaluateByTeacher = BoxesRunTime.unboxToBoolean((Object)this.getBoolean("evaluateByTeacher").get());
        try {
            if (!textOpinion.isEmpty()) {
                TextEvaluation textEvaluation = new TextEvaluation();
                textEvaluation.student_$eq(std);
                textEvaluation.lesson_$eq(lesson);
                textEvaluation.teacher_$eq(teacher);
                textEvaluation.content_$eq(textOpinion);
                textEvaluation.evaluateByTeacher_$eq(evaluateByTeacher);
                textEvaluation.evaluateAt_$eq(Instant.now());
                this.entityDao().saveOrUpdate((Object)textEvaluation, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new TextEvaluation[0]));
            }
            view = this.redirect("search", "&semester.id=" + lesson.semester().id(), "info.save.success");
        }
        catch (Exception e) {
            view = this.redirect("search", "&semester.id=" + lesson.semester().id(), "info.save.failure");
        }
        return view;
    }

    public View remsgList() {
        Student std = this.getStudent();
        List ids = this.longIds("lesson");
        Seq<Teacher> teachers = this.getTeachersByLessonIdSeq((List<Object>)ids);
        Seq<Object[]> lessons = this.getTeacherLessonByLessonIdSeq((List<Object>)ids);
        Lesson lesson = (Lesson)this.entityDao().get(Lesson.class, ids.apply(0));
        Semester semester = lesson.semester();
        this.put("lessons", lessons);
        this.put("annMap", this.getAnnMap(std, semester, teachers));
        this.put("textEvaluationMap", this.getMyTextEvaluationMap(std, semester, teachers));
        this.put("otherMap", this.getOtherMap(std, semester, teachers));
        return this.forward(this.forward$default$1());
    }
}

