/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.evaluation.course.web.action;

import java.io.Serializable;
import java.time.Instant;
import java.time.LocalDate;
import java.util.Date;
import org.beangle.data.dao.OqlBuilder;
import org.beangle.data.dao.OqlBuilder$;
import org.beangle.data.dao.QueryBuilder;
import org.beangle.data.model.NumId;
import org.beangle.webmvc.api.view.View;
import org.beangle.webmvc.entity.action.RestfulAction;
import org.openurp.base.model.Semester;
import org.openurp.edu.base.model.Student;
import org.openurp.edu.base.model.Teacher;
import org.openurp.edu.evaluation.app.lesson.model.TextEvaluateSwitch;
import org.openurp.edu.evaluation.lesson.model.TeacherRemessage;
import org.openurp.edu.evaluation.lesson.model.TextEvaluation;
import org.openurp.edu.lesson.model.Lesson;
import org.openurp.platform.api.security.Securities$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001I3A!\u0001\u0002\u0001#\tYB+\u001a=u\u000bZ\fG.^1uS>tG+Z1dQ\u0016\u0014\u0018i\u0019;j_:T!a\u0001\u0003\u0002\r\u0005\u001cG/[8o\u0015\t)a!A\u0002xK\nT!a\u0002\u0005\u0002\r\r|WO]:f\u0015\tI!\"\u0001\u0006fm\u0006dW/\u0019;j_:T!a\u0003\u0007\u0002\u0007\u0015$WO\u0003\u0002\u000e\u001d\u00059q\u000e]3okJ\u0004(\"A\b\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001\u0011\u0002cA\n\u001c;5\tAC\u0003\u0002\u0004+)\u0011acF\u0001\u0007K:$\u0018\u000e^=\u000b\u0005aI\u0012AB<fE648M\u0003\u0002\u001b\u001d\u00059!-Z1oO2,\u0017B\u0001\u000f\u0015\u00055\u0011Vm\u001d;gk2\f5\r^5p]B\u0011adI\u0007\u0002?)\u0011\u0001%I\u0001\u0006[>$W\r\u001c\u0006\u0003E!\ta\u0001\\3tg>t\u0017B\u0001\u0013 \u00059!V\r\u001f;Fm\u0006dW/\u0019;j_:DQA\n\u0001\u0005\u0002\u001d\na\u0001P5oSRtD#\u0001\u0015\u0011\u0005%\u0002Q\"\u0001\u0002\t\u000b-\u0002A\u0011\u0001\u0017\u0002\u0015\u001d,G\u000fV3bG\",'\u000fF\u0001.!\tq#'D\u00010\u0015\t\u0001\u0003G\u0003\u00022\u0015\u0005!!-Y:f\u0013\t\u0019tFA\u0004UK\u0006\u001c\u0007.\u001a:\t\u000bU\u0002A\u0011\u000b\u001c\u0002\u0019%tG-\u001a=TKR$\u0018N\\4\u0015\u0003]\u0002\"\u0001O\u001e\u000e\u0003eR\u0011AO\u0001\u0006g\u000e\fG.Y\u0005\u0003ye\u0012A!\u00168ji\")a\b\u0001C!\u007f\u000511/Z1sG\"$\u0012\u0001\u0011\t\u0003\u0003\u001ak\u0011A\u0011\u0006\u0003\u0007\u0012\u000bAA^5fo*\u0011QiF\u0001\u0004CBL\u0017BA$C\u0005\u00111\u0016.Z<\t\u000b%\u0003A\u0011A \u0002)M,\u0017M]2i)\u0016DH/\u0012<bYV\fG/[8o\u0011\u0015Y\u0005\u0001\"\u0001@\u0003i\u0019\u0018M^3Fm\u0006dW/\u0019;f%\u0016lWm]:bO\u0016$vn\u0015;e\u0011\u0015i\u0005\u0001\"\u0001@\u0003q\u0019\u0018M^3Fm\u0006dW/\u0019;f%\u0016lWm]:bO\u0016$vn\u00117bgNDQa\u0014\u0001\u0005\u0002}\nqa\u001d5po\u0006sg\u000eC\u0003R\u0001\u0011\u0005q(A\u0004mSN$\u0018I\u001c8")
public class TextEvaluationTeacherAction
extends RestfulAction<TextEvaluation> {
    public Teacher getTeacher() {
        scala.collection.immutable.Seq teachers = this.entityDao().search((QueryBuilder)OqlBuilder$.MODULE$.from(Teacher.class, "s").where("s.code=:code", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Securities$.MODULE$.user()})));
        if (teachers.isEmpty()) {
            throw new RuntimeException("Cannot find teacher with code " + Securities$.MODULE$.user());
        }
        return (Teacher)teachers.head();
    }

    public void indexSetting() {
        scala.collection.immutable.Seq semesters = this.entityDao().getAll(Semester.class);
        this.put("semesters", semesters);
        OqlBuilder semesterQuery = (OqlBuilder)OqlBuilder$.MODULE$.from(Semester.class, "semester").where(":now between semester.beginOn and semester.endOn", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{LocalDate.now()}));
        this.put("currentSemester", this.entityDao().search((QueryBuilder)semesterQuery).head());
    }

    public View search() {
        Teacher teacher = this.getTeacher();
        Object object = teacher == null ? this.forward("error.teacher.teaNo.needed") : BoxedUnit.UNIT;
        OqlBuilder semesterQuery = (OqlBuilder)OqlBuilder$.MODULE$.from(Semester.class, "semester").where(":now between semester.beginOn and semester.endOn", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{LocalDate.now()}));
        int semesterId = BoxesRunTime.unboxToInt((Object)this.getInt("semester.id").getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> BoxesRunTime.unboxToInt((Object)((NumId)this.entityDao().search((QueryBuilder)semesterQuery).head()).id())));
        Semester semester = (Semester)this.entityDao().get(Semester.class, (Object)BoxesRunTime.boxToInteger((int)semesterId));
        if (teacher == null) {
            this.addMessage("\u5bf9\u4e0d\u8d77,\u60a8\u6ca1\u6709\u6743\u9650!", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
            return this.forward("errors");
        }
        OqlBuilder query = OqlBuilder$.MODULE$.from(Lesson.class, "lesson");
        query.join("left", "lesson.teachers", "teacher");
        query.where("lesson.project.id=:projectId", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)}));
        query.where("lesson.semester =:semester", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{semester}));
        query.where("teacher=:teacher", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{teacher}));
        query.orderBy("lesson.semester.id").limit(this.getPageLimit());
        scala.collection.immutable.Seq results = this.entityDao().search((QueryBuilder)query);
        this.put("lessons", results);
        this.put("semester", semester);
        return this.forward(this.forward$default$1());
    }

    public View searchTextEvaluation() {
        Teacher teacher = this.getTeacher();
        Object object = teacher == null ? this.forward("error.teacher.teaNo.needed") : BoxedUnit.UNIT;
        long lessonId = BoxesRunTime.unboxToLong((Object)this.getLong("lesson.id").get());
        OqlBuilder semesterQuery = (OqlBuilder)OqlBuilder$.MODULE$.from(Semester.class, "semester").where(":now between semester.beginOn and semester.endOn", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{LocalDate.now()}));
        Semester currentSemester = (Semester)this.entityDao().search((QueryBuilder)semesterQuery).head();
        Lesson lesson = (Lesson)this.entityDao().get(Lesson.class, (Object)BoxesRunTime.boxToLong((long)lessonId));
        Semester semester = (Semester)this.entityDao().get(Semester.class, lesson.semester().id());
        boolean isCurrent = false;
        if (Predef$.MODULE$.int2Integer(BoxesRunTime.unboxToInt((Object)currentSemester.id())).longValue() == Predef$.MODULE$.int2Integer(BoxesRunTime.unboxToInt((Object)semester.id())).longValue()) {
            isCurrent = true;
        }
        Seq textEvaluations = (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
        OqlBuilder query = OqlBuilder$.MODULE$.from(TextEvaluation.class, "textEvaluation");
        query.where("textEvaluation.lesson.id =:lessonId", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)lessonId)}));
        query.where("textEvaluation.teacher =:teacher", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{teacher}));
        OqlBuilder switchQuery = (OqlBuilder)OqlBuilder$.MODULE$.from(TextEvaluateSwitch.class, "switch").where("switch.semester.id=:semesterId", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{lesson.semester().id()}));
        scala.collection.immutable.Seq textEvaluationSwitch = this.entityDao().search((QueryBuilder)switchQuery);
        if (!((TextEvaluateSwitch)textEvaluationSwitch.head()).opened()) {
            this.addMessage("\u73b0\u5728\u8fd8\u6ca1\u6709\u5f00\u653e\u6587\u5b57\u8bc4\u6559\u67e5\u8be2!", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
            return this.forward("errors");
        }
        if (isCurrent && !((TextEvaluateSwitch)textEvaluationSwitch.head()).openedTeacher()) {
            this.addMessage("\u73b0\u5728\u4e0d\u5728\u53cc\u5411\u8bc4\u6559\u65f6\u95f4!", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
            return this.forward("errors");
        }
        textEvaluations = this.entityDao().search((QueryBuilder)query);
        this.put("textEvaluations", textEvaluations);
        OqlBuilder teachClass = OqlBuilder$.MODULE$.from(Lesson.class, "lesson");
        teachClass.join("left", "lesson.teachers", "teacher");
        teachClass.where("teacher=:teacher", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{teacher}));
        teachClass.where("lesson.semester =:semester", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{semester}));
        teachClass.select("lesson.teachclass");
        scala.collection.immutable.Seq teachClasses = this.entityDao().search((QueryBuilder)teachClass);
        this.put("isCurrent", BoxesRunTime.boxToBoolean((boolean)isCurrent));
        this.put("lesson", this.entityDao().get(Lesson.class, (Object)BoxesRunTime.boxToLong((long)lessonId)));
        this.put("teachclasses", teachClasses);
        this.put("semester", semester);
        return this.forward(this.forward$default$1());
    }

    public View saveEvaluateRemessageToStd() {
        View view;
        Teacher teacher = this.getTeacher();
        Object object = teacher == null ? this.forward("error.teacher.teaNo.needed") : BoxedUnit.UNIT;
        long lessonId = BoxesRunTime.unboxToLong((Object)this.getLong("lessonId").get());
        Lesson lesson = (Lesson)this.entityDao().get(Lesson.class, (Object)BoxesRunTime.boxToLong((long)lessonId));
        int semesterId = BoxesRunTime.unboxToInt((Object)lesson.semester().id());
        long stdId = BoxesRunTime.unboxToLong((Object)this.getLong("sendObj").get());
        long textEvaluationId = BoxesRunTime.unboxToLong((Object)this.getLong("textEvaluationId").get());
        String reMessage = (String)this.get("reMessage").get();
        Object object2 = teacher == null ? this.redirect("searchTextEvaluation", "&lesson.id=" + lessonId + "&semesterId=" + semesterId, "\u4fdd\u5b58\u5931\u8d25,\u4f60\u6ca1\u6709\u6743\u9650!") : BoxedUnit.UNIT;
        Student std = (Student)this.entityDao().get(Student.class, (Object)BoxesRunTime.boxToLong((long)stdId));
        TextEvaluation textEvaluation = (TextEvaluation)this.entityDao().get(TextEvaluation.class, (Object)BoxesRunTime.boxToLong((long)textEvaluationId));
        Date date = new Date();
        TeacherRemessage teacherRemessage = new TeacherRemessage();
        teacherRemessage.textEvaluation_$eq(textEvaluation);
        teacherRemessage.students().$plus$eq((Object)std);
        teacherRemessage.visible_$eq(true);
        teacherRemessage.createdAt_$eq(Instant.now());
        teacherRemessage.updatedAt_$eq(Instant.now());
        reMessage.replaceAll("<", "&lt;").replaceAll(">", "&gt;").replaceAll("\r\n", "<br/>").replaceAll("\n", "<br>").replaceAll("\\'", "&acute;").replaceAll("\"", "&quot;").replaceAll(" ", "&nbsp;");
        teacherRemessage.remessage_$eq(reMessage);
        try {
            this.entityDao().saveOrUpdate((Object)teacherRemessage, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new TeacherRemessage[0]));
            view = this.redirect("searchTextEvaluation", "&lesson.id=" + lessonId + "&semesterId=" + semesterId, "info.save.success");
        }
        catch (Exception e) {
            e.printStackTrace();
            view = this.redirect("searchTextEvaluation", "&lesson.id=" + lessonId + "&semesterId=" + semesterId, "info.save.failure");
        }
        return view;
    }

    public View saveEvaluateRemessageToClass() {
        BoxedUnit boxedUnit;
        Teacher teacher = this.getTeacher();
        Object object = teacher == null ? this.forward("error.teacher.teaNo.needed") : BoxedUnit.UNIT;
        long lessonId = BoxesRunTime.unboxToLong((Object)this.getLong("lessonId").get());
        Lesson lesson = (Lesson)this.entityDao().get(Lesson.class, (Object)BoxesRunTime.boxToLong((long)lessonId));
        int semesterId = BoxesRunTime.unboxToInt((Object)lesson.semester().id());
        String classNames = (String)this.get("classNames").get();
        Option stdId = this.getLong("stdId");
        long textEvaluationId = BoxesRunTime.unboxToLong((Object)this.getLong("textEvaluationId").get());
        boolean isAnn = BoxesRunTime.unboxToBoolean((Object)this.getBoolean("isAnn").get());
        String reMessage = (String)this.get("reMessage").get();
        Object object2 = teacher == null ? this.redirect("searchTextEvaluation", "&lesson.id=" + lessonId + "&semesterId=" + semesterId, "\u4fdd\u5b58\u5931\u8d25,\u4f60\u6ca1\u6709\u6743\u9650!") : BoxedUnit.UNIT;
        OqlBuilder query = OqlBuilder$.MODULE$.from(Lesson.class.getName(), "lesson");
        query.join("left", "lesson.teachers", "teacher");
        query.join("left", "lesson.teachclass.courseTakers", "courseTaker");
        query.select("courseTaker");
        query.where("teacher=:teacher", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{teacher}));
        query.where("lesson.semester.id = :semesterId", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)semesterId)}));
        query.where("lesson.teachclass.name in (:classNames)", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new StringOps(Predef$.MODULE$.augmentString(classNames)).split(',')}));
        scala.collection.immutable.Seq courseTakers = this.entityDao().search((QueryBuilder)query);
        Object object3 = courseTakers.isEmpty() ? this.redirect("searchTextEvaluation", "\u4fdd\u5b58\u5931\u8d25,\u73ed\u7ea7\u4e3a\u7a7a!", "&lesson.id=" + lessonId + "&semesterId=" + semesterId) : BoxedUnit.UNIT;
        TextEvaluation textEvaluation = (TextEvaluation)this.entityDao().get(TextEvaluation.class, (Object)BoxesRunTime.boxToLong((long)textEvaluationId));
        Date date = new Date();
        TeacherRemessage teacherRemessage = new TeacherRemessage();
        teacherRemessage.textEvaluation_$eq(textEvaluation);
        courseTakers.foreach((Function1 & Serializable & scala.Serializable)courseTaker -> (Set)teacherRemessage.students().$plus$eq((Object)courseTaker.std()));
        if (!isAnn) {
            Student std = (Student)this.entityDao().get(Student.class, stdId.get());
            boxedUnit = teacherRemessage.students().$plus$eq((Object)std);
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        teacherRemessage.visible_$eq(!isAnn);
        teacherRemessage.createdAt_$eq(Instant.now());
        teacherRemessage.updatedAt_$eq(Instant.now());
        reMessage.replaceAll("<", "&lt;").replaceAll(">", "&gt;").replaceAll("\r\n", "<br/>").replaceAll("\n", "<br>").replaceAll("\\'", "&acute;").replaceAll("\"", "&quot;").replaceAll(" ", "&nbsp;");
        teacherRemessage.remessage_$eq(reMessage);
        try {
            this.entityDao().saveOrUpdate((Object)teacherRemessage, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new TeacherRemessage[0]));
            return this.redirect("searchTextEvaluation", "&lesson.id=" + lessonId + "&semesterId=" + semesterId, "info.save.success");
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.redirect("searchTextEvaluation", "&lesson.id=" + lessonId + "&semesterId=" + semesterId, "info.save.failure");
        }
    }

    public View showAnn() {
        int semesterId = BoxesRunTime.unboxToInt((Object)this.getInt("semesterId").getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0));
        if (0 == semesterId) {
            semesterId = BoxesRunTime.unboxToInt((Object)this.getInt("semester.id").get());
        }
        this.put("lessonId", this.getLong("lessonId"));
        this.put("semesterId", BoxesRunTime.boxToInteger((int)semesterId));
        this.put("semester", this.entityDao().get(Semester.class, (Object)BoxesRunTime.boxToInteger((int)semesterId)));
        return this.forward(this.forward$default$1());
    }

    public View listAnn() {
        Teacher teacher = this.getTeacher();
        Object object = teacher == null ? this.forward("error.teacher.teaNo.needed") : BoxedUnit.UNIT;
        long lessonId = BoxesRunTime.unboxToLong((Object)this.getLong("lessonId").get());
        int semesterId = BoxesRunTime.unboxToInt((Object)((Lesson)this.entityDao().get(Lesson.class, (Object)BoxesRunTime.boxToLong((long)lessonId))).semester().id());
        OqlBuilder query = OqlBuilder$.MODULE$.from(TeacherRemessage.class, "teacherRemessage");
        query.where("teacherRemessage.visible = false", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
        query.where("teacherRemessage.textEvaluation.teacher =:teacher", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{teacher}));
        query.where("teacherRemessage.textEvaluation.lesson.semester.id =:semesterId", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)semesterId)}));
        query.orderBy("teacherRemessage.createdAt desc").limit(this.getPageLimit());
        this.put("teacherRemessages", this.entityDao().search((QueryBuilder)query));
        return this.forward(this.forward$default$1());
    }
}

