/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.evaluation.course.web.action;

import java.io.Serializable;
import java.time.Instant;
import java.time.LocalDate;
import org.beangle.commons.collection.Collections$;
import org.beangle.commons.collection.Order$;
import org.beangle.commons.lang.Strings$;
import org.beangle.data.dao.OqlBuilder;
import org.beangle.data.dao.OqlBuilder$;
import org.beangle.data.dao.QueryBuilder;
import org.beangle.data.model.NumId;
import org.beangle.webmvc.api.view.View;
import org.beangle.webmvc.entity.action.RestfulAction;
import org.openurp.base.model.Department;
import org.openurp.code.edu.model.EducationLevel;
import org.openurp.edu.base.code.model.StdType;
import org.openurp.edu.base.model.Course;
import org.openurp.edu.base.model.Semester;
import org.openurp.edu.base.model.Teacher;
import org.openurp.edu.course.model.Clazz;
import org.openurp.edu.evaluation.clazz.result.model.QuestionResult;
import org.openurp.edu.evaluation.clazz.stat.model.CourseEvalStat;
import org.openurp.edu.evaluation.clazz.stat.model.CourseOptionStat;
import org.openurp.edu.evaluation.clazz.stat.model.CourseQuestionStat;
import org.openurp.edu.evaluation.clazz.stat.model.CourseQuestionTypeStat;
import org.openurp.edu.evaluation.clazz.stat.model.EvalStat;
import org.openurp.edu.evaluation.clazz.stat.model.QuestionStat;
import org.openurp.edu.evaluation.model.Option;
import org.openurp.edu.evaluation.model.Question;
import org.openurp.edu.evaluation.model.QuestionType;
import org.openurp.edu.evaluation.model.Questionnaire;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.ListBuffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001u3A!\u0003\u0006\u00013!)q\u0006\u0001C\u0001a!)1\u0007\u0001C!i!)Q\b\u0001C!i!)a\b\u0001C\u0001i!)q\b\u0001C\u0001i!)\u0001\t\u0001C!i!)\u0001\t\u0001C\u0001\u0003\")!\u0006\u0001C\u0001i\t!2i\\;sg\u0016,e/\u00197Ti\u0006$\u0018i\u0019;j_:T!a\u0003\u0007\u0002\r\u0005\u001cG/[8o\u0015\tia\"A\u0002xK\nT!a\u0004\t\u0002\r\r|WO]:f\u0015\t\t\"#\u0001\u0006fm\u0006dW/\u0019;j_:T!a\u0005\u000b\u0002\u0007\u0015$WO\u0003\u0002\u0016-\u00059q\u000e]3okJ\u0004(\"A\f\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001Q\u0002cA\u000e$K5\tAD\u0003\u0002\f;)\u0011adH\u0001\u0007K:$\u0018\u000e^=\u000b\u0005\u0001\n\u0013AB<fE648M\u0003\u0002#-\u00059!-Z1oO2,\u0017B\u0001\u0013\u001d\u00055\u0011Vm\u001d;gk2\f5\r^5p]B\u0011a%L\u0007\u0002O)\u0011\u0001&K\u0001\u0006[>$W\r\u001c\u0006\u0003U-\nAa\u001d;bi*\u0011A\u0006E\u0001\u0006G2\f'P_\u0005\u0003]\u001d\u0012abQ8veN,WI^1m'R\fG/\u0001\u0004=S:LGO\u0010\u000b\u0002cA\u0011!\u0007A\u0007\u0002\u0015\u0005)\u0011N\u001c3fqR\tQ\u0007\u0005\u00027w5\tqG\u0003\u00029s\u0005!a/[3x\u0015\tQt$A\u0002ba&L!\u0001P\u001c\u0003\tYKWm^\u0001\u0007g\u0016\f'o\u00195\u0002)\u00154\u0018\r\\;bi\u0016$V-Y2i\u0011&\u001cHo\u001c:z\u0003!\u0019H/\u0019;I_6,\u0017A\u0002:f[>4X\r\u0006\u0003C\u0011f[\u0006CA\"G\u001b\u0005!%\"A#\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u001d#%\u0001B+oSRDQ!S\u0004A\u0002)\u000b\u0001#\u001a3vG\u0006$\u0018n\u001c8UsB,\u0017\nZ:\u0011\u0007-\u001bfK\u0004\u0002M#:\u0011Q\nU\u0007\u0002\u001d*\u0011q\nG\u0001\u0007yI|w\u000e\u001e \n\u0003\u0015K!A\u0015#\u0002\u000fA\f7m[1hK&\u0011A+\u0016\u0002\u0004'\u0016\f(B\u0001*E!\t\u0019u+\u0003\u0002Y\t\n\u0019\u0011J\u001c;\t\u000bi;\u0001\u0019\u0001&\u0002\u001b\u0011,\u0007/\u0019:u[\u0016tG/\u00133t\u0011\u0015av\u00011\u0001W\u0003)\u0019X-\\3ti\u0016\u0014\u0018\n\u001a")
public class CourseEvalStatAction
extends RestfulAction<CourseEvalStat> {
    public View index() {
        StdType stdType = (StdType)this.entityDao().get(StdType.class, (Object)BoxesRunTime.boxToInteger((int)5));
        this.put("stdTypeList", stdType);
        Department department = (Department)this.entityDao().get(Department.class, (Object)BoxesRunTime.boxToInteger((int)20));
        this.put("departmentList", department);
        String searchFormFlag = (String)this.get("searchFormFlag").orNull(Predef$.MODULE$.$conforms());
        if (searchFormFlag == null) {
            searchFormFlag = "beenStat";
        }
        this.put("searchFormFlag", searchFormFlag);
        this.put("departments", this.entityDao().search((QueryBuilder)OqlBuilder$.MODULE$.from(Department.class, "dep").where("dep.teaching =:tea", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToBoolean((boolean)true)}))));
        OqlBuilder query = (OqlBuilder)OqlBuilder$.MODULE$.from(Questionnaire.class, "questionnaire").where("questionnaire.state =:state", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToBoolean((boolean)true)}));
        this.put("questionnaires", this.entityDao().search((QueryBuilder)query));
        scala.collection.immutable.Seq semesters = this.entityDao().getAll(Semester.class);
        this.put("semesters", semesters);
        OqlBuilder semesterQuery = (OqlBuilder)OqlBuilder$.MODULE$.from(Semester.class, "semester").where(":now between semester.beginOn and semester.endOn", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{LocalDate.now()}));
        this.put("currentSemester", this.entityDao().search((QueryBuilder)semesterQuery).head());
        return this.forward(this.forward$default$1());
    }

    public View search() {
        OqlBuilder semesterQuery = (OqlBuilder)OqlBuilder$.MODULE$.from(Semester.class, "semester").where(":now between semester.beginOn and semester.endOn", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{LocalDate.now()}));
        int semesterId = BoxesRunTime.unboxToInt((Object)this.getInt("semester.id").getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> BoxesRunTime.unboxToInt((Object)((NumId)this.entityDao().search((QueryBuilder)semesterQuery).head()).id())));
        Semester semester = (Semester)this.entityDao().get(Semester.class, (Object)BoxesRunTime.boxToInteger((int)semesterId));
        OqlBuilder courseEvalStat = OqlBuilder$.MODULE$.from(CourseEvalStat.class, "courseEvalStat");
        this.populateConditions(courseEvalStat);
        courseEvalStat.orderBy((String)this.get(Order$.MODULE$.OrderStr()).orNull(Predef$.MODULE$.$conforms())).limit(this.getPageLimit());
        courseEvalStat.where("courseEvalStat.semester=:semester", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{semester}));
        this.put("courseEvalStats", this.entityDao().search((QueryBuilder)courseEvalStat));
        return this.forward(this.forward$default$1());
    }

    public View evaluateTeachHistory() {
        long id = BoxesRunTime.unboxToLong((Object)this.getLong("courseEvalStat.id").get());
        CourseEvalStat questionnaires = (CourseEvalStat)this.entityDao().get(CourseEvalStat.class, (Object)BoxesRunTime.boxToLong((long)id));
        OqlBuilder query = OqlBuilder$.MODULE$.from(CourseEvalStat.class, "questionnaires");
        query.where("questionnaires.teacher.id=:teaIds", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{questionnaires.teacher().id()}));
        query.orderBy("questionnaires.semester.beginOn");
        this.put("teacher", questionnaires.teacher());
        this.put("courseEvaluates", this.entityDao().search((QueryBuilder)query));
        return this.forward(this.forward$default$1());
    }

    public View statHome() {
        this.put("stdTypeList", this.entityDao().getAll(StdType.class));
        this.put("departmentList", this.entityDao().getAll(Department.class));
        this.put("educations", this.entityDao().getAll(EducationLevel.class));
        scala.collection.immutable.Seq teachingDeparts = this.entityDao().search((QueryBuilder)OqlBuilder$.MODULE$.from(Department.class, "depart").where("depart.teaching =:tea", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToBoolean((boolean)true)})));
        this.put("departments", teachingDeparts);
        scala.collection.immutable.Seq semesters = this.entityDao().getAll(Semester.class);
        this.put("semesters", semesters);
        OqlBuilder semesterQuery = (OqlBuilder)OqlBuilder$.MODULE$.from(Semester.class, "semester").where(":now between semester.beginOn and semester.endOn", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{LocalDate.now()}));
        this.put("currentSemester", this.entityDao().search((QueryBuilder)semesterQuery).head());
        return this.forward(this.forward$default$1());
    }

    public View remove() {
        List questionSIds = this.longIds("courseEvalStat");
        OqlBuilder query = OqlBuilder$.MODULE$.from(CourseEvalStat.class, "questionS");
        query.where("questionS.id in(:ids)", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{questionSIds}));
        this.entityDao().remove((Iterable)this.entityDao().search((QueryBuilder)query));
        return this.redirect("search", "info.remove.success");
    }

    public void remove(Seq<Object> educationTypeIds, Seq<Object> departmentIds, int semesterId) {
        OqlBuilder query = OqlBuilder$.MODULE$.from(CourseEvalStat.class, "questionS");
        query.where("questionS.semester.id=:semesterId", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)semesterId)}));
        this.entityDao().remove((Iterable)this.entityDao().search((QueryBuilder)query));
    }

    public View stat() {
        String eduStr = (String)this.get("educatIds").get();
        String depStr = (String)this.get("departIds").get();
        String[] eduIds = eduStr.split(",");
        String[] depIds = depStr.split(",");
        Seq educationTypeIds = Strings$.MODULE$.splitToInt(eduStr);
        Seq departmentIds = Strings$.MODULE$.splitToInt(depStr);
        OqlBuilder semesterQuery = (OqlBuilder)OqlBuilder$.MODULE$.from(Semester.class, "semester").where(":now between semester.beginOn and semester.endOn", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{LocalDate.now()}));
        int semesterId = BoxesRunTime.unboxToInt((Object)this.getInt("semester.id").getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> BoxesRunTime.unboxToInt((Object)((NumId)this.entityDao().search((QueryBuilder)semesterQuery).head()).id())));
        Semester semester = (Semester)this.entityDao().get(Semester.class, (Object)BoxesRunTime.boxToInteger((int)semesterId));
        this.remove((Seq<Object>)educationTypeIds, (Seq<Object>)departmentIds, semesterId);
        OqlBuilder que = OqlBuilder$.MODULE$.from(QuestionResult.class.getName(), "questionR");
        que.where("questionR.result.clazz.semester.id=:semesterId", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)semesterId)}));
        que.where("questionR.result.statType is 1", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
        que.where("questionR.question.addition is false", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
        que.where("questionR.result.department.id in(:depIds)", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{departmentIds}));
        que.select("questionR.result.teacher.id,questionR.result.clazz.course.id,questionR.question.id,sum(questionR.score),avg(questionR.score),count(questionR.id)");
        que.groupBy("questionR.result.teacher.id,questionR.result.clazz.course.id,questionR.question.id");
        HashMap wtStatMap = new HashMap();
        this.entityDao().search((QueryBuilder)que).foreach((Function1 & Serializable & scala.Serializable)a -> {
            Buffer buffer = (Buffer)wtStatMap.getOrElseUpdate((Object)new Tuple2(a[0], a[1]), (Function0 & Serializable & scala.Serializable)() -> new ListBuffer());
            return buffer.$plus$eq((Object)new Tuple4((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)a[2])), (Object)((Number)a[3]), (Object)((Number)a[4]), (Object)((Number)a[5])));
        });
        OqlBuilder quer = OqlBuilder$.MODULE$.from(QuestionResult.class.getName(), "questionR");
        quer.where("questionR.result.clazz.semester.id=:semesterId", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)semesterId)}));
        quer.where("questionR.result.statType is 1", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
        quer.where("questionR.result.department.id in(:depIds)", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{departmentIds}));
        quer.where("questionR.question.addition is false", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
        quer.select("questionR.result.clazz.course.id,questionR.result.teacher.id,questionR.result.questionnaire.id,sum(questionR.score),case when questionR.result.statType =1 then count(questionR.result.id) end,count(distinct questionR.result.id),case when questionR.result.statType =1 then sum(questionR.score) end,sum(questionR.score)/count(distinct questionR.result.id)");
        quer.groupBy("questionR.result.clazz.course.id,questionR.result.teacher.id,questionR.result.questionnaire.id,questionR.result.statType");
        scala.collection.immutable.Seq wjStat = this.entityDao().search((QueryBuilder)quer);
        OqlBuilder tyquery = OqlBuilder$.MODULE$.from(QuestionResult.class.getName(), "questionR");
        tyquery.where("questionR.result.clazz.semester.id=:semesterId", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)semesterId)}));
        tyquery.where("questionR.result.statType is 1", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
        tyquery.where("questionR.result.teacher is not null", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
        tyquery.where("questionR.result.department.id in(:depIds)", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{departmentIds}));
        tyquery.where("questionR.question.addition is false", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
        tyquery.select("questionR.result.clazz.course.id,questionR.result.teacher.id,questionR.question.questionType.id,sum(questionR.score)/count(distinct questionR.result.id)");
        tyquery.groupBy("questionR.result.clazz.course.id,questionR.result.teacher.id,questionR.question.questionType.id");
        HashMap typeStatMap = new HashMap();
        this.entityDao().search((QueryBuilder)tyquery).foreach((Function1 & Serializable & scala.Serializable)a -> {
            Buffer buffer = (Buffer)typeStatMap.getOrElseUpdate((Object)new Tuple2(a[0], a[1]), (Function0 & Serializable & scala.Serializable)() -> new ListBuffer());
            return buffer.$plus$eq((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)a[2])), (Object)((Number)a[3])));
        });
        OqlBuilder opQuery = OqlBuilder$.MODULE$.from(QuestionResult.class.getName(), "questionR");
        opQuery.where("questionR.result.clazz.semester.id=:semesterId", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)semesterId)}));
        opQuery.where("questionR.result.statType is 1", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
        opQuery.where("questionR.result.department.id in(:depIds)", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{departmentIds}));
        opQuery.where("questionR.question.addition is false", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
        opQuery.select("questionR.result.clazz.course.id,questionR.result.teacher.id,questionR.question.id,questionR.option.id,count(questionR.id)");
        opQuery.groupBy("questionR.result.clazz.course.id,questionR.result.teacher.id,questionR.question.id,questionR.option.id");
        HashMap optionStatMap = new HashMap();
        this.entityDao().search((QueryBuilder)opQuery).foreach((Function1 & Serializable & scala.Serializable)a -> {
            Buffer buffer = (Buffer)optionStatMap.getOrElseUpdate((Object)new Tuple3(a[0], a[1], a[2]), (Function0 & Serializable & scala.Serializable)() -> new ListBuffer());
            return buffer.$plus$eq((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)a[3])), (Object)((Number)a[4])));
        });
        Map questionMap = ((TraversableOnce)this.entityDao().getAll(Question.class).map((Function1 & Serializable & scala.Serializable)o -> new Tuple2(o.id(), o), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        Map questiontyMap = ((TraversableOnce)this.entityDao().getAll(QuestionType.class).map((Function1 & Serializable & scala.Serializable)o -> new Tuple2(o.id(), o), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        Map optionMap = ((TraversableOnce)this.entityDao().getAll(Option.class).map((Function1 & Serializable & scala.Serializable)o -> new Tuple2(o.id(), o), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        OqlBuilder lquery = OqlBuilder$.MODULE$.from(Clazz.class, "le");
        lquery.where("le.semester.id=:seId", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)semesterId)}));
        lquery.where("le.teachDepart.id in(:depIds)", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{departmentIds}));
        scala.collection.immutable.Seq clazzList = this.entityDao().search((QueryBuilder)lquery);
        wjStat.foreach((Function1 & Serializable & scala.Serializable)evaObject -> {
            CourseEvalStatAction.$anonfun$stat$11(this, semester, wtStatMap, questionMap, optionStatMap, optionMap, typeStatMap, questiontyMap, evaObject);
            return BoxedUnit.UNIT;
        });
        return this.redirect("index", "info.action.success");
    }

    public static final /* synthetic */ void $anonfun$stat$11(CourseEvalStatAction $this, Semester semester$1, HashMap wtStatMap$1, Map questionMap$1, HashMap optionStatMap$1, Map optionMap$1, HashMap typeStatMap$1, Map questiontyMap$1, Object[] evaObject) {
        CourseEvalStat questionS = new CourseEvalStat();
        questionS.teacher_$eq(new Teacher());
        questionS.teacher().id_$eq((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)evaObject[1])));
        questionS.semester_$eq(semester$1);
        questionS.statAt_$eq(Instant.now());
        questionS.course_$eq(new Course());
        questionS.course().id_$eq((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)evaObject[0])));
        questionS.totalScore_$eq(new StringOps(Predef$.MODULE$.augmentString(evaObject[7].toString())).toFloat());
        questionS.tickets_$eq(Predef$.MODULE$.Integer2int(Integer.valueOf(evaObject[4].toString())));
        questionS.avgScore_$eq(questionS.totalScore() / (float)questionS.tickets());
        questionS.totalTickets_$eq(Predef$.MODULE$.Integer2int(Integer.valueOf(evaObject[5].toString())));
        questionS.questionnaire_$eq(new Questionnaire());
        questionS.questionnaire().id_$eq((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)evaObject[2])));
        Buffer questionDetailStats = Collections$.MODULE$.newBuffer();
        wtStatMap$1.get((Object)new Tuple2.mcJJ.sp(BoxesRunTime.unboxToLong((Object)questionS.teacher().id()), BoxesRunTime.unboxToLong((Object)questionS.course().id()))).foreach((Function1 & Serializable & scala.Serializable)buffer -> {
            buffer.foreach((Function1 & Serializable & scala.Serializable)wt -> {
                CourseQuestionStat detailStat = new CourseQuestionStat();
                detailStat.question_$eq((Question)questionMap$1.apply(wt._1()));
                detailStat.totalScore_$eq((double)new StringOps(Predef$.MODULE$.augmentString(wt._2().toString())).toFloat());
                detailStat.avgScore_$eq((double)new StringOps(Predef$.MODULE$.augmentString(wt._3().toString())).toFloat());
                detailStat.evalStat_$eq((EvalStat)questionS$1);
                Buffer optionStates = Collections$.MODULE$.newBuffer();
                optionStatMap$1.get((Object)new Tuple3(questionS$1.course().id(), questionS$1.teacher().id(), detailStat.question().id())).foreach((Function1 & Serializable & scala.Serializable)buffer -> {
                    buffer.foreach((Function1 & Serializable & scala.Serializable)os -> {
                        CourseOptionStat optionstat = new CourseOptionStat();
                        optionstat.amount_$eq(((Number)os._2()).intValue());
                        optionstat.option_$eq((Option)optionMap$1.apply((Object)BoxesRunTime.boxToLong((long)os._1$mcJ$sp())));
                        optionstat.questionStat_$eq((QuestionStat)detailStat$1);
                        return optionStates$1.$plus$eq((Object)optionstat);
                    });
                    return BoxedUnit.UNIT;
                });
                detailStat.optionStats_$eq(optionStates);
                return questionDetailStats$1.$plus$eq((Object)detailStat);
            });
            return BoxedUnit.UNIT;
        });
        questionS.questionStats_$eq(questionDetailStats);
        Buffer questionTypeStats = Collections$.MODULE$.newBuffer();
        typeStatMap$1.get((Object)new Tuple2.mcJJ.sp(BoxesRunTime.unboxToLong((Object)questionS.course().id()), BoxesRunTime.unboxToLong((Object)questionS.teacher().id()))).foreach((Function1 & Serializable & scala.Serializable)buffer -> {
            buffer.foreach((Function1 & Serializable & scala.Serializable)os -> {
                CourseQuestionTypeStat questionTs = new CourseQuestionTypeStat();
                questionTs.totalScore_$eq(new StringOps(Predef$.MODULE$.augmentString(os._2().toString())).toFloat());
                questionTs.evalStat_$eq((EvalStat)questionS$1);
                questionTs.questionType_$eq((QuestionType)questiontyMap$1.apply((Object)BoxesRunTime.boxToLong((long)os._1$mcJ$sp())));
                return questionTypeStats$1.$plus$eq((Object)questionTs);
            });
            return BoxedUnit.UNIT;
        });
        questionS.questionTypeStats_$eq(questionTypeStats);
        $this.entityDao().saveOrUpdate((Object)questionS, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new CourseEvalStat[0]));
    }
}

