/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.evaluation.department.helper;

import java.io.Serializable;
import java.time.Instant;
import org.beangle.data.dao.EntityDao;
import org.beangle.data.dao.OqlBuilder;
import org.beangle.data.dao.OqlBuilder$;
import org.beangle.data.dao.QueryBuilder;
import org.beangle.data.transfer.AbstractTransferListener;
import org.beangle.data.transfer.TransferResult;
import org.openurp.base.model.Semester;
import org.openurp.edu.base.model.Teacher;
import org.openurp.edu.evaluation.department.model.DepartEvaluate;
import org.openurp.edu.evaluation.model.Questionnaire;
import org.openurp.platform.api.security.Securities$;
import scala.Function1;
import scala.Predef$;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.immutable.List$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u00153A!\u0001\u0002\u0001\u001f\t!\u0012*\u001c9peR$U\r]1si2K7\u000f^3oKJT!a\u0001\u0003\u0002\r!,G\u000e]3s\u0015\t)a!\u0001\u0006eKB\f'\u000f^7f]RT!a\u0002\u0005\u0002\u0015\u00154\u0018\r\\;bi&|gN\u0003\u0002\n\u0015\u0005\u0019Q\rZ;\u000b\u0005-a\u0011aB8qK:,(\u000f\u001d\u0006\u0002\u001b\u0005\u0019qN]4\u0004\u0001M\u0011\u0001\u0001\u0005\t\u0003#ai\u0011A\u0005\u0006\u0003'Q\t\u0001\u0002\u001e:b]N4WM\u001d\u0006\u0003+Y\tA\u0001Z1uC*\u0011q\u0003D\u0001\bE\u0016\fgn\u001a7f\u0013\tI\"C\u0001\rBEN$(/Y2u)J\fgn\u001d4fe2K7\u000f^3oKJD\u0001b\u0007\u0001\u0003\u0002\u0003\u0006I\u0001H\u0001\nK:$\u0018\u000e^=EC>\u0004\"!\b\u0011\u000e\u0003yQ!a\b\u000b\u0002\u0007\u0011\fw.\u0003\u0002\"=\tIQI\u001c;jif$\u0015m\u001c\u0005\u0006G\u0001!\t\u0001J\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005\u0015:\u0003C\u0001\u0014\u0001\u001b\u0005\u0011\u0001\"B\u000e#\u0001\u0004a\u0002\"B\u0015\u0001\t\u0003R\u0013aC8o\u0013R,Wn\u0015;beR$\"aK\u0019\u0011\u00051zS\"A\u0017\u000b\u00039\nQa]2bY\u0006L!\u0001M\u0017\u0003\tUs\u0017\u000e\u001e\u0005\u0006e!\u0002\raM\u0001\u0003iJ\u0004\"!\u0005\u001b\n\u0005U\u0012\"A\u0004+sC:\u001ch-\u001a:SKN,H\u000e\u001e\u0005\u0006o\u0001!\t\u0005O\u0001\r_:LE/Z7GS:L7\u000f\u001b\u000b\u0003WeBQA\r\u001cA\u0002MBQa\u000f\u0001\u0005\u0002q\n!bZ3u)\u0016\f7\r[3s)\u0005i\u0004C\u0001 D\u001b\u0005y$B\u0001!B\u0003\u0015iw\u000eZ3m\u0015\t\u0011\u0005\"\u0001\u0003cCN,\u0017B\u0001#@\u0005\u001d!V-Y2iKJ\u0004")
public class ImportDepartListener
extends AbstractTransferListener {
    private final EntityDao entityDao;

    public void onItemStart(TransferResult tr) {
        Object teacherCode = this.transfer().curData().get((Object)"teacher.code").get();
        String semesterCode = this.transfer().curData().get((Object)"semester.code").get().toString();
        int departmentId = BoxesRunTime.unboxToInt((Object)this.getTeacher().user().department().id());
        OqlBuilder semesterBuilder = (OqlBuilder)OqlBuilder$.MODULE$.from(Semester.class, "s").where("s.code=:code ", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{semesterCode}));
        scala.collection.immutable.Seq semesters = this.entityDao.search((QueryBuilder)semesterBuilder);
        if (semesters.isEmpty()) {
            tr.addFailure("\u5b66\u671f\u6570\u636e\u683c\u5f0f\u975e\u6cd5", (Object)semesterCode);
        } else {
            OqlBuilder builder = OqlBuilder$.MODULE$.from(DepartEvaluate.class, "de");
            builder.where("de.teacher.code=:code and de.semester.code=:scode and de.department.id=:id", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{teacherCode, semesterCode, BoxesRunTime.boxToInteger((int)departmentId)}));
            this.entityDao.search((QueryBuilder)builder).foreach((Function1 & Serializable & scala.Serializable)s -> {
                ImportDepartListener.$anonfun$onItemStart$1(this, s);
                return BoxedUnit.UNIT;
            });
        }
    }

    public void onItemFinish(TransferResult tr) {
        DepartEvaluate departEvaluate = (DepartEvaluate)tr.transfer().current();
        Questionnaire questionnaire = (Questionnaire)this.entityDao.get(Questionnaire.class, (Object)BoxesRunTime.boxToLong((long)322L));
        departEvaluate.questionnaire_$eq(questionnaire);
        departEvaluate.evaluateAt_$eq(Instant.now());
        departEvaluate.department_$eq(this.getTeacher().user().department());
        this.entityDao.saveOrUpdate((Object)departEvaluate, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new DepartEvaluate[0]));
    }

    public Teacher getTeacher() {
        scala.collection.immutable.Seq teachers = this.entityDao.findBy(Teacher.class, "code", (Iterable)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{Securities$.MODULE$.user()})));
        if (teachers.isEmpty()) {
            throw new RuntimeException("Cannot find teacher with code " + Securities$.MODULE$.user());
        }
        return (Teacher)teachers.head();
    }

    public static final /* synthetic */ void $anonfun$onItemStart$1(ImportDepartListener $this, DepartEvaluate s) {
        $this.transfer().current_$eq((Object)s);
    }

    public ImportDepartListener(EntityDao entityDao) {
        this.entityDao = entityDao;
    }
}

