/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.exam.model;

import java.util.Date;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ManyToOne;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.beangle.commons.entity.pojo.LongIdObject;
import org.openurp.base.model.Department;
import org.openurp.edu.base.model.Teacher;
import org.openurp.edu.exam.model.ExamRoom;

@Entity(name="org.openurp.edu.exam.model.Invigilation")
public class Invigilation
extends LongIdObject {
    private static final long serialVersionUID = -7734720828900446321L;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    private ExamRoom examRoom;
    @ManyToOne(fetch=FetchType.LAZY)
    protected Teacher teacher;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    protected Department department;
    @Size(max=50)
    protected String teacherName;
    private boolean chief;
    private boolean published;
    private Date updatedAt;

    public Invigilation() {
    }

    public Invigilation(ExamRoom examRoom, Teacher teacher, Department department) {
        this.teacher = teacher;
        this.examRoom = examRoom;
        this.department = department;
        this.updatedAt = new Date(System.currentTimeMillis());
    }

    public Invigilation(ExamRoom examRoom, String teacherName, Department department) {
        this.teacherName = teacherName;
        this.examRoom = examRoom;
        this.department = department;
        this.updatedAt = new Date(System.currentTimeMillis());
    }

    public ExamRoom getExamRoom() {
        return this.examRoom;
    }

    public void setExamRoom(ExamRoom examRoom) {
        this.examRoom = examRoom;
    }

    public boolean isSameMonitor(Invigilation other) {
        boolean isSame = this.getDepartment().equals((Object)other.getDepartment()) && this.getTeacher().equals((Object)other.getTeacher());
        return isSame;
    }

    public Department getDepartment() {
        return this.department;
    }

    public void setDepartment(Department department) {
        this.department = department;
    }

    public Teacher getTeacher() {
        return this.teacher;
    }

    public void setTeacher(Teacher teacher) {
        this.teacher = teacher;
    }

    public String getTeacherName() {
        return this.teacherName;
    }

    public void setTeacherName(String teacherName) {
        this.teacherName = teacherName;
    }

    public boolean isChief() {
        return this.chief;
    }

    public void setChief(boolean chief) {
        this.chief = chief;
    }

    public boolean isPublished() {
        return this.published;
    }

    public void setPublished(boolean published) {
        this.published = published;
    }

    public Date getUpdatedAt() {
        return this.updatedAt;
    }

    public void setUpdatedAt(Date updatedAt) {
        this.updatedAt = updatedAt;
    }
}

