/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.exam.model;

import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ManyToOne;
import javax.validation.constraints.NotNull;
import org.beangle.commons.entity.pojo.LongIdObject;
import org.openurp.base.model.Semester;
import org.openurp.edu.base.code.model.ExamType;
import org.openurp.edu.base.model.Student;
import org.openurp.edu.course.model.Clazz;
import org.openurp.edu.course.model.ExamTaker;
import org.openurp.edu.exam.model.ExamActivity;
import org.openurp.edu.exam.model.ExamRoom;

@Entity(name="org.openurp.edu.exam.model.ExamStudent")
public class ExamStudent
extends LongIdObject
implements Cloneable {
    private static final long serialVersionUID = -1593583921052845498L;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    private Clazz clazz;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    private Semester semester;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    private Student std;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    private ExamType examType;
    @ManyToOne(fetch=FetchType.LAZY)
    private ExamRoom examRoom;
    @ManyToOne(fetch=FetchType.LAZY)
    private ExamActivity activity;
    private Short seatNo = 0;

    public Short getSeatNo() {
        return this.seatNo;
    }

    public void setSeatNo(Short seatNo) {
        this.seatNo = seatNo;
    }

    public ExamStudent() {
    }

    public ExamStudent(ExamTaker taker) {
        this.clazz = taker.getClazz();
        this.semester = taker.getClazz().getSemester();
        this.examType = taker.getExamType();
        this.std = taker.getStd();
    }

    public Clazz getClazz() {
        return this.clazz;
    }

    public void setClazz(Clazz clazz) {
        this.clazz = clazz;
    }

    public Semester getSemester() {
        return this.semester;
    }

    public void setSemester(Semester semester) {
        this.semester = semester;
    }

    public Student getStd() {
        return this.std;
    }

    public void setStd(Student std) {
        this.std = std;
    }

    public ExamType getExamType() {
        return this.examType;
    }

    public void setExamType(ExamType examType) {
        this.examType = examType;
    }

    public ExamRoom getExamRoom() {
        return this.examRoom;
    }

    public void setExamRoom(ExamRoom examRoom) {
        this.examRoom = examRoom;
    }

    public ExamActivity getActivity() {
        return this.activity;
    }

    public void setActivity(ExamActivity activity) {
        this.activity = activity;
    }

    public Object clone() {
        try {
            ExamStudent taker = (ExamStudent)super.clone();
            taker.setId(null);
            return taker;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }
}

