/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.exam.model;

import java.sql.Date;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.validation.constraints.NotNull;
import org.beangle.commons.collection.CollectUtils;
import org.beangle.commons.entity.pojo.LongIdObject;
import org.beangle.commons.lang.time.HourMinute;
import org.openurp.edu.base.code.model.ExamType;
import org.openurp.edu.base.model.Classroom;
import org.openurp.edu.base.model.Project;
import org.openurp.edu.base.model.Semester;
import org.openurp.edu.exam.model.DateTurn;
import org.openurp.edu.exam.model.ExamTask;
import org.openurp.edu.exam.model.ExamTurn;
import org.openurp.edu.exam.model.PublishState;
import org.openurp.edu.exam.model.RoomAllocSetting;

@Entity(name="org.openurp.edu.exam.model.ExamGroup")
public class ExamGroup
extends LongIdObject {
    private static final long serialVersionUID = -9155171983268795637L;
    private String name;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    private ExamType examType = new ExamType();
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    private Project project;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    private Semester semester;
    private Date beginOn;
    private Date endOn;
    private boolean allowInClass;
    private int minCourseConflictCount;
    private float maxCourseConflictRatio;
    public PublishState state;
    @OneToMany(mappedBy="group", orphanRemoval=true, cascade={CascadeType.ALL})
    private List<DateTurn> turns = CollectUtils.newArrayList();
    @OneToMany(mappedBy="group")
    private List<ExamTask> tasks = CollectUtils.newArrayList();
    @ManyToMany
    private Set<Classroom> rooms = CollectUtils.newHashSet();
    @NotNull
    private java.util.Date updatedAt;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    private RoomAllocSetting allocSetting;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ExamType getExamType() {
        return this.examType;
    }

    public void setExamType(ExamType examType) {
        this.examType = examType;
    }

    public Project getProject() {
        return this.project;
    }

    public void setProject(Project project) {
        this.project = project;
    }

    public Semester getSemester() {
        return this.semester;
    }

    public void setSemester(Semester semester) {
        this.semester = semester;
    }

    public Date getBeginOn() {
        return this.beginOn;
    }

    public void setBeginOn(Date beginOn) {
        this.beginOn = beginOn;
    }

    public Date getEndOn() {
        return this.endOn;
    }

    public void setEndOn(Date endOn) {
        this.endOn = endOn;
    }

    public PublishState getState() {
        return this.state;
    }

    public void setState(PublishState state) {
        this.state = state;
    }

    public List<DateTurn> getTurns() {
        return this.turns;
    }

    public void setTurns(List<DateTurn> turns) {
        this.turns = turns;
    }

    public List<ExamTask> getTasks() {
        return this.tasks;
    }

    public void setTasks(List<ExamTask> tasks) {
        this.tasks = tasks;
    }

    public Set<Classroom> getRooms() {
        return this.rooms;
    }

    public void setRooms(Set<Classroom> rooms) {
        this.rooms = rooms;
    }

    public int getMinCourseConflictCount() {
        return this.minCourseConflictCount;
    }

    public void setMinCourseConflictCount(int minCourseConflictCount) {
        this.minCourseConflictCount = minCourseConflictCount;
    }

    public float getMaxCourseConflictRatio() {
        return this.maxCourseConflictRatio;
    }

    public void setMaxCourseConflictRatio(float maxCourseConflictRatio) {
        this.maxCourseConflictRatio = maxCourseConflictRatio;
    }

    public List<ExamTurn> getExamTurns() {
        Set eturns = CollectUtils.newHashSet();
        for (DateTurn t : this.getTurns()) {
            ExamTurn et = new ExamTurn();
            et.setId(new Long(t.getBeginAt().value * 10000 + t.getEndAt().value));
            if (eturns.contains(et)) continue;
            et.setBeginAt(t.getBeginAt());
            et.setEndAt(t.getEndAt());
            eturns.add(et);
        }
        List turnList = CollectUtils.newArrayList((Collection)eturns);
        Collections.sort(turnList);
        return turnList;
    }

    public boolean turnExists(Date date, HourMinute beginAt, HourMinute endAt) {
        for (DateTurn t : this.getTurns()) {
            if (!t.getExamOn().equals(date) || !t.getBeginAt().equals((Object)beginAt) || !t.getEndAt().equals((Object)endAt)) continue;
            return true;
        }
        return false;
    }

    public DateTurn getDateTurn(Date date, HourMinute beginAt, HourMinute endAt) {
        for (DateTurn t : this.getTurns()) {
            if (!t.getExamOn().equals(date) || !t.getBeginAt().equals((Object)beginAt) || !t.getEndAt().equals((Object)endAt)) continue;
            return t;
        }
        return null;
    }

    public List<Date> getDates() {
        Set dates = CollectUtils.newHashSet();
        for (DateTurn t : this.getTurns()) {
            dates.add(t.getExamOn());
        }
        List dateList = CollectUtils.newArrayList((Collection)dates);
        Collections.sort(dateList);
        return dateList;
    }

    public java.util.Date getUpdatedAt() {
        return this.updatedAt;
    }

    public void setUpdatedAt(java.util.Date updatedAt) {
        this.updatedAt = updatedAt;
    }

    public RoomAllocSetting getAllocSetting() {
        return this.allocSetting;
    }

    public void setAllocSetting(RoomAllocSetting allocSetting) {
        this.allocSetting = allocSetting;
    }

    public boolean isAllowInClass() {
        return this.allowInClass;
    }

    public void setAllowInClass(boolean allowInClass) {
        this.allowInClass = allowInClass;
    }
}

