/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.exam.model;

import java.sql.Date;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.beangle.commons.collection.CollectUtils;
import org.beangle.commons.entity.pojo.LongIdObject;
import org.openurp.base.model.Campus;
import org.openurp.base.model.Department;
import org.openurp.edu.base.model.Project;
import org.openurp.edu.base.model.Semester;
import org.openurp.edu.base.model.Teacher;
import org.openurp.edu.exam.model.InvigilationQuota;

@Entity(name="org.openurp.edu.exam.model.Invigilator")
public class Invigilator
extends LongIdObject {
    private static final long serialVersionUID = -2403939113974261022L;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    private Project project;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    private Semester semester;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    private Teacher teacher;
    private int quota;
    @OneToMany(mappedBy="invigilator", cascade={CascadeType.ALL})
    private List<InvigilationQuota> quotas = new ArrayList<InvigilationQuota>();
    @ElementCollection
    @JoinColumn(name="invigilator_id")
    @Column(name="exclude_on", nullable=false)
    @JoinTable(name="invigilators_exclude_dates")
    private List<Date> excludeDates;
    @Size(max=200)
    private String remark;

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getRemark() {
        return this.remark;
    }

    public Semester getSemester() {
        return this.semester;
    }

    public void setSemester(Semester semester) {
        this.semester = semester;
    }

    public Project getProject() {
        return this.project;
    }

    public void setProject(Project project) {
        this.project = project;
    }

    public Teacher getTeacher() {
        return this.teacher;
    }

    public void setTeacher(Teacher teacher) {
        this.teacher = teacher;
    }

    public int getQuota() {
        return this.quota;
    }

    public void setQuota(int quota) {
        this.quota = quota;
    }

    public List<Date> getExcludeDates() {
        return this.excludeDates;
    }

    public void setExcludeDates(List<Date> excludeDates) {
        this.excludeDates = excludeDates;
    }

    public List<InvigilationQuota> getQuotas() {
        return this.quotas;
    }

    public void setQuotas(List<InvigilationQuota> quotas) {
        this.quotas = quotas;
    }

    public InvigilationQuota addQuota(Campus campus, Department depart, float quota) {
        InvigilationQuota finded = null;
        for (InvigilationQuota iq : this.quotas) {
            if (!iq.getCampus().equals((Object)campus) || !iq.getDepart().equals((Object)depart)) continue;
            iq.setQuota(iq.getQuota() + quota);
            finded = iq;
            break;
        }
        if (null == finded) {
            finded = new InvigilationQuota(campus, depart, quota);
            finded.setInvigilator(this);
            this.getQuotas().add(finded);
        }
        double sum = 0.0;
        for (InvigilationQuota iq : this.quotas) {
            sum += (double)iq.getQuota();
        }
        this.quota = new Double(Math.round(sum)).intValue();
        return finded;
    }

    public void clearQuota() {
        this.quota = 0;
        for (InvigilationQuota iq : this.quotas) {
            iq.setQuota(0.0f);
        }
    }

    public boolean cleanup() {
        List removed = CollectUtils.newArrayList();
        double sum = 0.0;
        for (InvigilationQuota iq : this.quotas) {
            if (Float.compare(0.0f, iq.getQuota()) == 0) {
                removed.add(iq);
            }
            iq.setQuota(new Double(Math.round(iq.getQuota())).intValue());
            sum += (double)iq.getQuota();
        }
        this.setQuota(new Double(sum).intValue());
        return this.quotas.removeAll(removed);
    }

    public Set<Department> getDeparts() {
        Set departs = CollectUtils.newHashSet();
        for (InvigilationQuota iq : this.quotas) {
            departs.add(iq.getDepart());
        }
        return departs;
    }

    public Set<Campus> getCampuses() {
        Set cs = CollectUtils.newHashSet();
        for (InvigilationQuota iq : this.quotas) {
            cs.add(iq.getCampus());
        }
        return cs;
    }

    public int getCampusQuota(Campus campus) {
        double sum = 0.0;
        for (InvigilationQuota iq : this.quotas) {
            if (!iq.getCampus().equals((Object)campus)) continue;
            sum += (double)iq.getQuota();
        }
        return new Double(sum).intValue();
    }
}

