/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.exam.model;

import java.util.Date;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ManyToOne;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.beangle.commons.entity.pojo.LongIdObject;
import org.openurp.base.model.Department;
import org.openurp.base.model.User;
import org.openurp.edu.exam.model.ExamRoom;

@Entity(name="org.openurp.edu.exam.model.Invigilation")
public class Invigilation
extends LongIdObject {
    private static final long serialVersionUID = -7734720828900446321L;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    private ExamRoom examRoom;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    protected Department department;
    @ManyToOne(fetch=FetchType.LAZY)
    protected User invigilator;
    @Size(max=50)
    protected String invigilatorName;
    private boolean chief;
    private boolean published;
    private Date updatedAt;

    public Invigilation() {
    }

    public Invigilation(ExamRoom examRoom, User user, Department department) {
        this.invigilator = user;
        this.examRoom = examRoom;
        this.department = department;
        this.updatedAt = new Date(System.currentTimeMillis());
    }

    public Invigilation(ExamRoom examRoom, String teacherName, Department department) {
        this.invigilatorName = teacherName;
        this.examRoom = examRoom;
        this.department = department;
        this.updatedAt = new Date(System.currentTimeMillis());
    }

    public ExamRoom getExamRoom() {
        return this.examRoom;
    }

    public void setExamRoom(ExamRoom examRoom) {
        this.examRoom = examRoom;
    }

    public boolean isSameMonitor(Invigilation other) {
        return this.getDepartment().equals((Object)other.getDepartment()) && this.getInvigilator().equals((Object)other.getInvigilator());
    }

    public Department getDepartment() {
        return this.department;
    }

    public void setDepartment(Department department) {
        this.department = department;
    }

    public User getInvigilator() {
        return this.invigilator;
    }

    public void setInvigilator(User invigilator) {
        this.invigilator = invigilator;
    }

    public String getInvigilatorName() {
        return this.invigilatorName;
    }

    public void setInvigilatorName(String invigilatorName) {
        this.invigilatorName = invigilatorName;
    }

    public boolean isChief() {
        return this.chief;
    }

    public void setChief(boolean chief) {
        this.chief = chief;
    }

    public boolean isPublished() {
        return this.published;
    }

    public void setPublished(boolean published) {
        this.published = published;
    }

    public Date getUpdatedAt() {
        return this.updatedAt;
    }

    public void setUpdatedAt(Date updatedAt) {
        this.updatedAt = updatedAt;
    }
}

