/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.extern.web.action.certificate;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.time.Instant;
import java.time.ZoneId;
import org.beangle.commons.collection.Collections$;
import org.beangle.commons.lang.Strings$;
import org.beangle.data.dao.OqlBuilder;
import org.beangle.data.dao.OqlBuilder$;
import org.beangle.data.dao.QueryBuilder;
import org.beangle.data.excel.schema.ExcelColumn;
import org.beangle.data.excel.schema.ExcelScheet;
import org.beangle.data.excel.schema.ExcelSchema;
import org.beangle.data.model.Entity;
import org.beangle.data.transfer.exporter.ExportSetting;
import org.beangle.data.transfer.exporter.PropertyExtractor;
import org.beangle.web.action.annotation.response;
import org.beangle.web.action.view.PathView$;
import org.beangle.web.action.view.Stream$;
import org.beangle.web.action.view.View;
import org.beangle.webmvc.support.action.EntityAction;
import org.beangle.webmvc.support.action.ExportSupport;
import org.beangle.webmvc.support.action.RestfulAction;
import org.openurp.base.model.Project;
import org.openurp.base.model.Semester;
import org.openurp.base.service.SemesterService;
import org.openurp.base.std.model.Student;
import org.openurp.code.edu.model.CourseTakeType;
import org.openurp.code.edu.model.CourseTakeType$;
import org.openurp.code.edu.model.ExamStatus;
import org.openurp.code.edu.model.GradingMode;
import org.openurp.edu.extern.code.model.CertificateCategory;
import org.openurp.edu.extern.code.model.CertificateSubject;
import org.openurp.edu.extern.model.CertificateGrade;
import org.openurp.edu.extern.service.ExemptionCourse;
import org.openurp.edu.extern.service.ExemptionCourse$;
import org.openurp.edu.extern.service.ExemptionService;
import org.openurp.edu.extern.web.helper.CertificateGradePropertyExtractor;
import org.openurp.edu.grade.course.model.CourseGrade;
import org.openurp.edu.grade.model.Grade;
import org.openurp.edu.program.domain.CoursePlanProvider;
import org.openurp.edu.program.model.CoursePlan;
import org.openurp.edu.program.model.PlanCourse;
import org.openurp.edu.program.model.Program;
import org.openurp.starter.edu.helper.ProjectSupport;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Option;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.Map;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction1;

public class GradeAction
extends RestfulAction<CertificateGrade>
implements ProjectSupport {
    private ExemptionService exemptionService;
    private SemesterService semesterService;
    private CoursePlanProvider coursePlanProvider;

    public ExemptionService exemptionService() {
        return this.exemptionService;
    }

    public void exemptionService_$eq(ExemptionService x$1) {
        this.exemptionService = x$1;
    }

    public SemesterService semesterService() {
        return this.semesterService;
    }

    public void semesterService_$eq(SemesterService x$1) {
        this.semesterService = x$1;
    }

    public CoursePlanProvider coursePlanProvider() {
        return this.coursePlanProvider;
    }

    public void coursePlanProvider_$eq(CoursePlanProvider x$1) {
        this.coursePlanProvider = x$1;
    }

    public void indexSetting() {
        this.put("certificateSubjects", this.getCodes(CertificateSubject.class));
        this.put("certificateCategories", this.getCodes(CertificateCategory.class));
        this.put("departments", this.getDeparts());
        this.put("project", this.getProject());
    }

    public void editSetting(CertificateGrade entity) {
        super.editSetting((Entity)entity);
        this.put("certificateSubjects", this.getCodes(CertificateSubject.class));
        this.put("certificateCategories", this.getCodes(CertificateCategory.class));
        this.put("semesters", this.entityDao().getAll(Semester.class));
        this.put("gradingModes", this.getCodes(GradingMode.class));
        this.put("examStatuses", this.getCodes(ExamStatus.class));
    }

    public View saveAndRedirect(CertificateGrade grade) {
        Project project = this.getProject();
        String stdCode = (String)this.get("certificateGrade.std.user.code", "");
        if (grade.std() == null && Strings$.MODULE$.isNotBlank((CharSequence)stdCode)) {
            OqlBuilder q = OqlBuilder$.MODULE$.from(Student.class, "s");
            q.where("s.user.code=:code and s.project=:project", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{stdCode, project}));
            this.entityDao().search((QueryBuilder)q).foreach((Function1)(JProcedure1 & Serializable)std -> grade.std_$eq(std));
        }
        if (grade.std() == null) {
            return this.redirect("search", "\u4fdd\u5b58\u5931\u8d25,\u5b66\u53f7\u4e0d\u5b58\u5728");
        }
        if (this.isExist(grade)) {
            return this.redirect("search", "\u4fdd\u5b58\u5931\u8d25,\u6210\u7ee9\u91cd\u590d");
        }
        grade.status_$eq(Grade.Status$.MODULE$.Published());
        grade.updatedAt_$eq(Instant.now());
        return super.saveAndRedirect((Entity)grade);
    }

    private boolean isExist(CertificateGrade grade) {
        boolean bl;
        OqlBuilder query = OqlBuilder$.MODULE$.from(CertificateGrade.class, "grade");
        query.where("grade.std= :std", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{grade.std()}));
        query.where("grade.acquiredOn = :acquiredOn", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{grade.acquiredOn()}));
        query.where("grade.subject = :subject", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{grade.subject()}));
        if (!grade.persisted()) {
            bl = this.entityDao().search((QueryBuilder)query).nonEmpty();
        } else {
            query.where("grade.id <>:id", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{grade.id()}));
            bl = this.entityDao().search((QueryBuilder)query).nonEmpty();
        }
        return bl;
    }

    public View convertList() {
        CertificateGrade grade = (CertificateGrade)this.entityDao().get(CertificateGrade.class, (Object)BoxesRunTime.boxToLong((long)this.longId("certificateGrade")));
        this.put("grade", grade);
        Student std = grade.std();
        Option plan = this.coursePlanProvider().getCoursePlan(grade.std());
        if (plan.isEmpty()) {
            return PathView$.MODULE$.apply("noPlanMsg");
        }
        scala.collection.immutable.Seq planCourses = this.exemptionService().getConvertablePlanCourses(std, (CoursePlan)plan.get(), grade.acquiredOn());
        Map semesters = Collections$.MODULE$.newMap();
        planCourses.foreach((Function1)(JProcedure1 & Serializable)pc -> this.exemptionService().getSemester(((CoursePlan)plan.get()).program(), grade.acquiredOn(), pc.terms().termList().headOption()).foreach((Function1 & Serializable)s -> semesters.put(pc, s)));
        this.put("semesters", semesters);
        this.put("convertedGrades", this.exemptionService().getConvertedGrades(std, (Iterable)grade.courses()));
        this.put("planCourses", planCourses);
        this.put("ExemptionType", this.entityDao().get(CourseTakeType.class, (Object)BoxesRunTime.boxToInteger((int)CourseTakeType$.MODULE$.Exemption())));
        this.put("gradingModes", this.getCodes(GradingMode.class));
        return this.forward(this.forward$default$1());
    }

    public View convert() {
        CertificateGrade eg = (CertificateGrade)this.entityDao().get(CertificateGrade.class, (Object)BoxesRunTime.boxToLong((long)this.longId("grade")));
        CoursePlan plan = (CoursePlan)this.coursePlanProvider().getCoursePlan(eg.std()).get();
        HashMap planCourses = new HashMap();
        plan.groups().foreach((Function1)(JProcedure1 & Serializable)g -> g.planCourses().foreach((Function1 & Serializable)pc -> planCourses.put(pc.id(), pc)));
        Buffer ecs = Collections$.MODULE$.newBuffer();
        Program program = plan.program();
        List planCourseIds = this.longIds("planCourse");
        planCourseIds.foreach((Function1)(JFunction1.mcVJ.sp & Serializable)pcId -> {
            PlanCourse pc = (PlanCourse)planCourses.apply((Object)BoxesRunTime.boxToLong((long)pcId));
            Semester semester = (Semester)this.exemptionService().getSemester(program, eg.acquiredOn(), pc.terms().termList().headOption()).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
            Option scoreText = this.get("scoreText" + pc.id());
            if (semester != null && scoreText.nonEmpty()) {
                GradingMode gradingMode = (GradingMode)this.entityDao().get(GradingMode.class, (Object)BoxesRunTime.boxToInteger((int)this.getInt("gradingMode.id" + pc.id(), 0)));
                ExemptionCourse ec = ExemptionCourse$.MODULE$.apply(pc.course(), pc.group().courseType(), semester, pc.course().examMode(), gradingMode, this.getFloat("score" + pc.id()), scoreText);
                ecs.$plus$eq((Object)ec);
            }
        });
        this.exemptionService().addExemption(eg, ecs.toSeq());
        return this.redirect("search", "info.action.success");
    }

    public View removeCourseGrade() {
        CertificateGrade grade = (CertificateGrade)this.entityDao().get(CertificateGrade.class, (Object)BoxesRunTime.boxToLong((long)this.longId("grade")));
        CourseGrade cg = (CourseGrade)this.entityDao().get(CourseGrade.class, (Object)BoxesRunTime.boxToLong((long)this.longId("courseGrade")));
        this.exemptionService().removeExemption(grade, cg.course());
        return this.redirect("search", "info.action.success");
    }

    @response
    public Object downloadTemplate() {
        scala.collection.immutable.Seq gradingModes = (scala.collection.immutable.Seq)this.getCodes(GradingMode.class).map((Function1 & Serializable)_$4 -> _$4.name());
        scala.collection.immutable.Seq subjects = (scala.collection.immutable.Seq)this.getCodes(CertificateSubject.class).map((Function1 & Serializable)_$5 -> _$5.name());
        ExcelSchema schema = new ExcelSchema();
        ExcelScheet sheet = schema.createScheet("\u6570\u636e\u6a21\u677f");
        sheet.title("\u8bc1\u4e66\u6210\u7ee9\u6a21\u677f");
        sheet.remark("\u7279\u522b\u8bf4\u660e\uff1a\n1\u3001\u4e0d\u53ef\u6539\u53d8\u672c\u8868\u683c\u7684\u884c\u5217\u7ed3\u6784\u4ee5\u53ca\u6279\u6ce8\uff0c\u5426\u5219\u5c06\u4f1a\u5bfc\u5165\u5931\u8d25\uff01\n2\u3001\u987b\u6309\u7167\u89c4\u683c\u8bf4\u660e\u7684\u683c\u5f0f\u586b\u5199\u3002\n3\u3001\u53ef\u4ee5\u591a\u6b21\u5bfc\u5165\uff0c\u91cd\u590d\u7684\u4fe1\u606f\u4f1a\u88ab\u65b0\u6570\u636e\u66f4\u65b0\u8986\u76d6\u3002\n4\u3001\u4fdd\u5b58\u7684excel\u6587\u4ef6\u540d\u79f0\u53ef\u4ee5\u81ea\u5b9a\u3002");
        ExcelColumn excelColumn = sheet.add("\u5b66\u53f7", "certifiateGrade.std.user.code").length(15);
        excelColumn.required(excelColumn.required$default$1());
        ExcelColumn excelColumn2 = sheet.add("\u8003\u8bd5\u79d1\u76ee", "certifiateGrade.subject.name").ref((Seq)subjects);
        excelColumn2.required(excelColumn2.required$default$1());
        ExcelColumn excelColumn3 = sheet.add("\u6210\u7ee9", "certifiateGrade.scoreText");
        excelColumn3.required(excelColumn3.required$default$1());
        ExcelColumn excelColumn4 = sheet.add("\u83b7\u5f97\u65e5\u671f", "certifiateGrade.acquiredOn");
        ExcelColumn excelColumn5 = excelColumn4.date(excelColumn4.date$default$1());
        excelColumn5.required(excelColumn5.required$default$1());
        ExcelColumn excelColumn6 = sheet.add("\u6210\u7ee9\u8bb0\u5f55\u65b9\u5f0f", "certifiateGrade.gradingMode.name").ref((Seq)gradingModes);
        excelColumn6.required(excelColumn6.required$default$1());
        sheet.add("\u8bc1\u4e66\u7f16\u53f7", "certifiateGrade.certificate");
        sheet.add("\u51c6\u8003\u8bc1\u53f7", "certifiateGrade.examNo");
        ExcelScheet code = schema.createScheet("\u6570\u636e\u5b57\u5178");
        code.add("\u8003\u8bd5\u79d1\u76ee").data((Seq)subjects);
        code.add("\u6210\u7ee9\u8bb0\u5f55\u65b9\u5f0f").data((Seq)gradingModes);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        schema.generate((OutputStream)os);
        return Stream$.MODULE$.apply((InputStream)new ByteArrayInputStream(os.toByteArray()), "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", "\u8bc1\u4e66\u4fe1\u606f.xlsx", Stream$.MODULE$.apply$default$4());
    }

    public void configExport(ExportSetting setting) {
        ExportSupport.configExport$((ExportSupport)this, (ExportSetting)setting);
        setting.context().extractor_$eq((PropertyExtractor)new CertificateGradePropertyExtractor());
    }

    /*
     * WARNING - void declaration
     */
    public OqlBuilder<CertificateGrade> getQueryBuilder() {
        void var1_1;
        OqlBuilder builder = EntityAction.getQueryBuilder$((EntityAction)this);
        this.getFloat("from").foreach((Function1 & Serializable)from -> GradeAction.getQueryBuilder$$anonfun$1(builder, BoxesRunTime.unboxToFloat((Object)from)));
        this.getFloat("to").foreach((Function1 & Serializable)to -> GradeAction.getQueryBuilder$$anonfun$2(builder, BoxesRunTime.unboxToFloat((Object)to)));
        this.getDate("fromAt").foreach((Function1 & Serializable)fromAt -> (OqlBuilder)builder.where("certificateGrade.updatedAt >= :fromAt", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{fromAt.atTime(0, 0, 0).atZone(ZoneId.systemDefault()).toInstant()})));
        this.getDate("toAt").foreach((Function1 & Serializable)toAt -> (OqlBuilder)builder.where(" certificateGrade.updatedAt <= :toAt", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{toAt.plusDays(1L).atTime(0, 0, 0).atZone(ZoneId.systemDefault()).toInstant()})));
        this.getBoolean("hasCourse").foreach((Function1 & Serializable)hasCourse -> GradeAction.getQueryBuilder$$anonfun$5(builder, BoxesRunTime.unboxToBoolean((Object)hasCourse)));
        return var1_1;
    }

    private static final /* synthetic */ OqlBuilder getQueryBuilder$$anonfun$1(OqlBuilder builder$1, float from) {
        return (OqlBuilder)builder$1.where("certificateGrade.score >=:F", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToFloat((float)from)}));
    }

    private static final /* synthetic */ OqlBuilder getQueryBuilder$$anonfun$2(OqlBuilder builder$2, float to) {
        return (OqlBuilder)builder$2.where("certificateGrade.score <=:T", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToFloat((float)to)}));
    }

    private static final /* synthetic */ OqlBuilder getQueryBuilder$$anonfun$5(OqlBuilder builder$5, boolean hasCourse) {
        return (OqlBuilder)builder$5.where((hasCourse ? "" : "not ") + "exists (from certificateGrade.courses ec)", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
    }
}

