/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.extern.web.action.signup;

import java.io.Serializable;
import java.time.Instant;
import org.beangle.commons.config.property.PropertyConfig;
import org.beangle.commons.lang.Strings$;
import org.beangle.commons.logging.Logger$;
import org.beangle.commons.logging.Logging;
import org.beangle.data.dao.EntityDao;
import org.beangle.data.dao.OqlBuilder;
import org.beangle.data.dao.OqlBuilder$;
import org.beangle.data.dao.QueryBuilder;
import org.beangle.web.action.To;
import org.beangle.web.action.support.ActionSupport;
import org.beangle.web.action.support.EntitySupport;
import org.beangle.web.action.view.PathView;
import org.beangle.web.action.view.View;
import org.beangle.web.servlet.util.RequestUtils$;
import org.beangle.webmvc.support.action.EntityAction;
import org.openurp.base.model.Project;
import org.openurp.base.std.model.Student;
import org.openurp.edu.extern.model.CertExamSignup;
import org.openurp.edu.extern.model.CertExamSignupConfig;
import org.openurp.edu.extern.model.CertExamSignupSetting;
import org.openurp.edu.extern.model.CertificateGrade;
import org.openurp.edu.extern.service.signup.CertSignupService;
import org.openurp.starter.edu.helper.ProjectSupport;
import org.slf4j.Logger;
import scala.Function1;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.package$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;

public class StdAction
implements ActionSupport,
EntityAction<CertExamSignup>,
ProjectSupport {
    private Logger logger;
    private Class entityType;
    private EntityDao entityDao;
    private PropertyConfig config;
    private CertSignupService examSignupService;

    public StdAction() {
        Logging.$init$((Logging)this);
        EntitySupport.$init$((EntitySupport)this);
        EntityAction.$init$((EntityAction)this);
        Statics.releaseFence();
    }

    public Logger logger() {
        return this.logger;
    }

    public void org$beangle$commons$logging$Logging$_setter_$logger_$eq(Logger x$0) {
        this.logger = x$0;
    }

    public Class entityType() {
        return this.entityType;
    }

    public void org$beangle$web$action$support$EntitySupport$_setter_$entityType_$eq(Class x$0) {
        this.entityType = x$0;
    }

    public EntityDao entityDao() {
        return this.entityDao;
    }

    public PropertyConfig config() {
        return this.config;
    }

    public void entityDao_$eq(EntityDao x$1) {
        this.entityDao = x$1;
    }

    public void config_$eq(PropertyConfig x$1) {
        this.config = x$1;
    }

    public CertSignupService examSignupService() {
        return this.examSignupService;
    }

    public void examSignupService_$eq(CertSignupService x$1) {
        this.examSignupService = x$1;
    }

    public View index() {
        Student std = (Student)this.getUser(Student.class);
        OqlBuilder builder = (OqlBuilder)OqlBuilder$.MODULE$.from(CertExamSignup.class, "signUp").where("signUp.std =:std", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{std}));
        Seq signUpList = this.entityDao().search((QueryBuilder)builder);
        OqlBuilder gradeBuilder = (OqlBuilder)OqlBuilder$.MODULE$.from(CertificateGrade.class, "grade").where("grade.std =:std", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{std}));
        this.put("grades", this.entityDao().search((QueryBuilder)gradeBuilder));
        this.put("signUps", signUpList);
        return this.forward(this.forward$default$1());
    }

    public View configs() {
        PathView pathView;
        Student std = (Student)this.getUser(Student.class);
        Iterable configs = this.examSignupService().getOpenedConfigs(std.project());
        if (configs.isEmpty()) {
            pathView = this.forward("noconfig");
        } else {
            ArrayBuffer signUpList = new ArrayBuffer();
            configs.foreach((Function1 & Serializable)config -> {
                Iterable signUps = this.examSignupService().search(std, config);
                return (ArrayBuffer)signUpList.$plus$plus$eq((IterableOnce)signUps);
            });
            if (!signUpList.isEmpty()) {
                this.put("signUpSubjects", ((IterableOnceOps)signUpList.map((Function1 & Serializable)_$2 -> _$2.subject())).toSet());
            }
            Seq grades = this.entityDao().findBy(CertificateGrade.class, "std", package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Student[]{std})));
            Seq passedSubjects = (Seq)((IterableOps)grades.filter((Function1 & Serializable)_$3 -> _$3.passed())).map((Function1 & Serializable)_$4 -> _$4.subject());
            this.put("passedSubjects", passedSubjects);
            this.put("signUpList", signUpList);
            this.put("configs", configs);
            this.put("student", std);
            pathView = this.forward(this.forward$default$1());
        }
        return pathView;
    }

    public View notice() {
        View view;
        CertExamSignupSetting setting = (CertExamSignupSetting)this.entityDao().get(CertExamSignupSetting.class, (Object)BoxesRunTime.boxToLong((long)this.longId("setting")));
        Student std = (Student)this.getUser(Student.class);
        String msg = this.examSignupService().canSignup(std, setting);
        if (msg != null) {
            return this.redirect("configs", "&t=" + System.currentTimeMillis(), msg);
        }
        CertExamSignupConfig config = setting.config();
        if (Strings$.MODULE$.isBlank((CharSequence)config.notice())) {
            view = this.forward((To)this.to(this, "signUpForm"));
        } else {
            this.put("config", config);
            view = this.forward(this.forward$default$1());
        }
        return view;
    }

    public View signUpForm() {
        Student std = (Student)this.getUser(Student.class);
        CertExamSignupSetting setting = (CertExamSignupSetting)this.entityDao().get(CertExamSignupSetting.class, (Object)BoxesRunTime.boxToLong((long)this.longId("setting")));
        this.put("setting", setting);
        this.put("student", std);
        return this.forward(this.forward$default$1());
    }

    public View save() {
        View view;
        Student std = (Student)this.getUser(Student.class);
        CertExamSignupSetting setting = (CertExamSignupSetting)this.entityDao().get(CertExamSignupSetting.class, (Object)BoxesRunTime.boxToLong((long)this.longId("setting")));
        CertExamSignupConfig config = setting.config();
        if (!config.isTimeSuitable() || !config.opened()) {
            return this.redirect("configs", "\u4e0d\u5728\u62a5\u540d\u65f6\u95f4\u6bb5\u5185");
        }
        CertExamSignup signup = new CertExamSignup();
        signup.std_$eq(std);
        signup.updatedAt_$eq(Instant.now());
        signup.ip_$eq(RequestUtils$.MODULE$.getIpAddr(this.request()));
        signup.semester_$eq(setting.config().semester());
        signup.subject_$eq(setting.subject());
        Project project = std.project();
        if (config.isTimeSuitable()) {
            String msg = this.examSignupService().signup(signup, setting);
            if (msg == null) {
                msg = config.prediction() ? "\u9884\u62a5\u540d\u6210\u529f" : "\u62a5\u540d\u6210\u529f";
                Logger$.MODULE$.info$extension(this.logger(), () -> this.save$$anonfun$1(std, signup));
            }
            view = this.redirect("configs", msg);
        } else {
            view = this.redirect("configs", "\u4e0d\u5728\u62a5\u540d\u65f6\u95f4\u5185");
        }
        return view;
    }

    public View cancel() {
        View view;
        CertExamSignup signup = (CertExamSignup)this.entityDao().get(CertExamSignup.class, (Object)BoxesRunTime.boxToLong((long)this.longId("signup")));
        Student std = (Student)this.getUser(Student.class);
        Student student = signup.std();
        Student student2 = std;
        if (student == null ? student2 != null : !student.equals(student2)) {
            return this.redirect("configs", "\u975e\u6cd5\u64cd\u4f5c\uff0c\u53ea\u80fd\u53d6\u6d88\u81ea\u5df1\u7684\u62a5\u540d\u4fe1\u606f!");
        }
        Iterable configs = this.examSignupService().getOpenedConfigs(std.project());
        BooleanRef openConfig = BooleanRef.create((boolean)false);
        configs.withFilter((Function1 & Serializable)config -> !openConfig$1.elem).foreach((Function1)(JProcedure1 & Serializable)config -> {
            if (this.examSignupService().search(std, config).toSeq().contains((Object)signup)) {
                boolean bl;
                openConfig$2.elem = bl = true;
            }
        });
        if (openConfig.elem) {
            this.entityDao().remove((Object)signup, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CertExamSignup[0]));
            String remoteAddr = RequestUtils$.MODULE$.getIpAddr(this.request());
            Logger$.MODULE$.info$extension(this.logger(), () -> StdAction.cancel$$anonfun$3(signup, std, remoteAddr));
            view = this.redirect("configs", "\u53d6\u6d88\u62a5\u540d\u6210\u529f!");
        } else {
            view = this.redirect("configs", "\u4e0d\u5728\u62a5\u540d\u65f6\u95f4\u5185");
        }
        return view;
    }

    private final String save$$anonfun$1(Student std$2, CertExamSignup signup$1) {
        return std$2.user().code() + " \u62a5\u540d " + signup$1.subject().name() + " @" + this.remoteAddr();
    }

    private static final String cancel$$anonfun$3(CertExamSignup signup$3, Student std$4, String remoteAddr$1) {
        return std$4.user().code() + " \u53d6\u6d88\u4e86 " + signup$3.subject().name() + " @" + remoteAddr$1;
    }
}

