/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.extern.web.action.course;

import java.io.Serializable;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import org.beangle.commons.collection.Collections$;
import org.beangle.commons.collection.Properties;
import org.beangle.data.dao.OqlBuilder;
import org.beangle.data.dao.OqlBuilder$;
import org.beangle.data.dao.QueryBuilder;
import org.beangle.data.transfer.exporter.ExportSetting;
import org.beangle.data.transfer.exporter.PropertyExtractor;
import org.beangle.web.action.annotation.response;
import org.beangle.web.action.view.PathView$;
import org.beangle.web.action.view.View;
import org.beangle.webmvc.support.action.EntityAction;
import org.beangle.webmvc.support.action.ExportSupport;
import org.beangle.webmvc.support.action.RestfulAction;
import org.openurp.base.model.Semester;
import org.openurp.base.std.model.ExternStudent;
import org.openurp.base.std.model.Student;
import org.openurp.code.edu.model.CourseTakeType;
import org.openurp.code.edu.model.CourseTakeType$;
import org.openurp.code.edu.model.GradingMode;
import org.openurp.edu.extern.model.ExternGrade;
import org.openurp.edu.extern.service.ExemptionCourse;
import org.openurp.edu.extern.service.ExemptionCourse$;
import org.openurp.edu.extern.service.ExemptionService;
import org.openurp.edu.extern.web.helper.ExternGradePropertyExtractor;
import org.openurp.edu.grade.model.CourseGrade;
import org.openurp.edu.program.domain.CoursePlanProvider;
import org.openurp.edu.program.model.CoursePlan;
import org.openurp.edu.program.model.PlanCourse;
import org.openurp.edu.program.model.Program;
import org.openurp.starter.edu.helper.ProjectSupport;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Option;
import scala.collection.Iterable;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Map;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public class GradeAction
extends RestfulAction<ExternGrade>
implements ProjectSupport {
    private CoursePlanProvider coursePlanProvider;
    private ExemptionService exemptionService;

    public CoursePlanProvider coursePlanProvider() {
        return this.coursePlanProvider;
    }

    public void coursePlanProvider_$eq(CoursePlanProvider x$1) {
        this.coursePlanProvider = x$1;
    }

    public ExemptionService exemptionService() {
        return this.exemptionService;
    }

    public void exemptionService_$eq(ExemptionService x$1) {
        this.exemptionService = x$1;
    }

    /*
     * WARNING - void declaration
     */
    public OqlBuilder<ExternGrade> getQueryBuilder() {
        void var1_1;
        OqlBuilder builder = EntityAction.getQueryBuilder$((EntityAction)this);
        this.getDate("fromAt").foreach((Function1 & Serializable)fromAt -> (OqlBuilder)builder.where("externGrade.updatedAt >= :fromAt", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{fromAt.atTime(0, 0, 0).atZone(ZoneId.systemDefault()).toInstant()})));
        this.getDate("toAt").foreach((Function1 & Serializable)toAt -> (OqlBuilder)builder.where(" externGrade.updatedAt <= :toAt", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{toAt.plusDays(1L).atTime(0, 0, 0).atZone(ZoneId.systemDefault()).toInstant()})));
        this.getBoolean("hasCourse").foreach((Function1 & Serializable)hasCourse -> GradeAction.getQueryBuilder$$anonfun$3(builder, BoxesRunTime.unboxToBoolean((Object)hasCourse)));
        return var1_1;
    }

    @response
    public Seq<Properties> loadStudent() {
        OqlBuilder query = OqlBuilder$.MODULE$.from(ExternStudent.class, "es");
        query.where("es.std.user.code=:code", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.get("q", "")}));
        DateTimeFormatter yyyyMM = DateTimeFormatter.ofPattern("yyyy-MM");
        return (Seq)this.entityDao().search((QueryBuilder)query).map((Function1 & Serializable)es -> {
            void var2_2;
            Properties p = new Properties();
            p.put((Object)"value", (Object)es.id().toString());
            p.put((Object)"text", (Object)(es.std().user().code() + " " + es.std().user().name() + " " + es.school().name() + "(" + es.beginOn().format(yyyyMM) + ")"));
            return var2_2;
        });
    }

    public View convertList() {
        ExternGrade grade = (ExternGrade)this.entityDao().get(ExternGrade.class, (Object)BoxesRunTime.boxToLong((long)this.longId("externGrade")));
        this.put("grade", grade);
        ExternStudent es = grade.externStudent();
        Student std = es.std();
        Option plan = this.coursePlanProvider().getCoursePlan(grade.externStudent().std());
        if (plan.isEmpty()) {
            return PathView$.MODULE$.apply("noPlanMsg");
        }
        Seq planCourses = this.exemptionService().getConvertablePlanCourses(std, (CoursePlan)plan.get(), grade.acquiredOn());
        this.put("convertedGrades", this.exemptionService().getConvertedGrades(std, (Iterable)grade.courses()));
        Map semesters = Collections$.MODULE$.newMap();
        planCourses.foreach((Function1)(JProcedure1 & Serializable)pc -> this.exemptionService().getSemester(((CoursePlan)plan.get()).program(), grade.acquiredOn(), pc.terms().termList().headOption()).foreach((Function1 & Serializable)s -> semesters.put(pc, s)));
        this.put("semesters", semesters);
        this.put("planCourses", planCourses);
        this.put("ExemptionType", this.entityDao().get(CourseTakeType.class, (Object)BoxesRunTime.boxToInteger((int)CourseTakeType$.MODULE$.Exemption())));
        this.put("gradingModes", this.getCodes(GradingMode.class));
        return this.forward(this.forward$default$1());
    }

    public View convert() {
        ExternGrade eg = (ExternGrade)this.entityDao().get(ExternGrade.class, (Object)BoxesRunTime.boxToLong((long)this.longId("grade")));
        Seq planCourses = this.entityDao().find(PlanCourse.class, (Iterable)this.longIds("planCourse"));
        Buffer ecs = Collections$.MODULE$.newBuffer();
        Program program = ((PlanCourse)planCourses.head()).group().plan().program();
        planCourses.foreach((Function1)(JProcedure1 & Serializable)pc -> {
            Semester semester = (Semester)this.exemptionService().getSemester(program, eg.acquiredOn(), pc.terms().termList().headOption()).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
            Option scoreText = this.get("scoreText" + pc.id());
            if (semester != null && scoreText.nonEmpty()) {
                GradingMode gradingMode = (GradingMode)this.entityDao().get(GradingMode.class, (Object)BoxesRunTime.boxToInteger((int)this.getInt("gradingMode.id" + pc.id(), 0)));
                ExemptionCourse ec = ExemptionCourse$.MODULE$.apply(pc.course(), pc.group().courseType(), semester, pc.course().examMode(), gradingMode, this.getFloat("score" + pc.id()), scoreText);
                ecs.$plus$eq((Object)ec);
            }
        });
        this.exemptionService().addExemption(eg, ecs.toSeq());
        return this.redirect("search", "info.action.success");
    }

    public View removeCourseGrade() {
        ExternGrade eg = (ExternGrade)this.entityDao().get(ExternGrade.class, (Object)BoxesRunTime.boxToLong((long)this.longId("grade")));
        CourseGrade cg = (CourseGrade)this.entityDao().get(CourseGrade.class, (Object)BoxesRunTime.boxToLong((long)this.longId("courseGrade")));
        this.exemptionService().removeExemption(eg, cg.course());
        return this.redirect("search", "info.action.success");
    }

    public void configExport(ExportSetting setting) {
        ExportSupport.configExport$((ExportSupport)this, (ExportSetting)setting);
        setting.context().extractor_$eq((PropertyExtractor)new ExternGradePropertyExtractor());
    }

    private static final /* synthetic */ OqlBuilder getQueryBuilder$$anonfun$3(OqlBuilder builder$3, boolean hasCourse) {
        return (OqlBuilder)builder$3.where((hasCourse ? "" : "not ") + "exists (from externGrade.courses ec)", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
    }
}

