/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.extern.web.action.certificate;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.time.Instant;
import java.time.ZoneId;
import org.beangle.commons.collection.Collections$;
import org.beangle.commons.lang.Strings$;
import org.beangle.data.dao.OqlBuilder;
import org.beangle.data.dao.OqlBuilder$;
import org.beangle.data.dao.QueryBuilder;
import org.beangle.data.excel.schema.ExcelColumn;
import org.beangle.data.excel.schema.ExcelScheet;
import org.beangle.data.excel.schema.ExcelSchema;
import org.beangle.data.model.Entity;
import org.beangle.data.transfer.exporter.ExportSetting;
import org.beangle.data.transfer.exporter.PropertyExtractor;
import org.beangle.data.transfer.importer.ImportListener;
import org.beangle.data.transfer.importer.ImportSetting;
import org.beangle.data.transfer.importer.listener.ForeignerListener;
import org.beangle.web.action.annotation.response;
import org.beangle.web.action.view.PathView$;
import org.beangle.web.action.view.Stream$;
import org.beangle.web.action.view.View;
import org.beangle.webmvc.support.action.EntityAction;
import org.beangle.webmvc.support.action.ExportSupport;
import org.beangle.webmvc.support.action.RestfulAction;
import org.openurp.base.edu.model.Course;
import org.openurp.base.model.Project;
import org.openurp.base.model.Semester;
import org.openurp.base.service.ProjectPropertyService;
import org.openurp.base.service.SemesterService;
import org.openurp.base.std.model.Student;
import org.openurp.code.edu.model.CourseTakeType;
import org.openurp.code.edu.model.CourseTakeType$;
import org.openurp.code.edu.model.ExamStatus;
import org.openurp.code.edu.model.GradingMode;
import org.openurp.code.service.CodeService;
import org.openurp.edu.extern.code.CertificateCategory;
import org.openurp.edu.extern.code.CertificateSubject;
import org.openurp.edu.extern.model.CertificateGrade;
import org.openurp.edu.extern.service.ExemptionService;
import org.openurp.edu.extern.web.helper.CertificateGradeImportListener;
import org.openurp.edu.extern.web.helper.CertificateGradePropertyExtractor;
import org.openurp.edu.grade.model.CourseGrade;
import org.openurp.edu.grade.model.Grade;
import org.openurp.edu.program.domain.CoursePlanProvider;
import org.openurp.edu.program.model.CoursePlan;
import org.openurp.starter.web.support.ProjectSupport;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.mutable.Map;
import scala.collection.mutable.Set;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public class GradeAction
extends RestfulAction<CertificateGrade>
implements ProjectSupport {
    private CodeService codeService;
    private ProjectPropertyService projectPropertyService;
    private SemesterService semesterService;
    private ExemptionService exemptionService;
    private CoursePlanProvider coursePlanProvider;

    public GradeAction() {
        ProjectSupport.$init$((ProjectSupport)this);
    }

    public CodeService codeService() {
        return this.codeService;
    }

    public ProjectPropertyService projectPropertyService() {
        return this.projectPropertyService;
    }

    public SemesterService semesterService() {
        return this.semesterService;
    }

    public void codeService_$eq(CodeService x$1) {
        this.codeService = x$1;
    }

    public void projectPropertyService_$eq(ProjectPropertyService x$1) {
        this.projectPropertyService = x$1;
    }

    public void semesterService_$eq(SemesterService x$1) {
        this.semesterService = x$1;
    }

    public ExemptionService exemptionService() {
        return this.exemptionService;
    }

    public void exemptionService_$eq(ExemptionService x$1) {
        this.exemptionService = x$1;
    }

    public CoursePlanProvider coursePlanProvider() {
        return this.coursePlanProvider;
    }

    public void coursePlanProvider_$eq(CoursePlanProvider x$1) {
        this.coursePlanProvider = x$1;
    }

    public void indexSetting() {
        LazyRef lazyRef = new LazyRef();
        this.put("certificateSubjects", this.getCodes(CertificateSubject.class, this.project$1(lazyRef)));
        this.put("certificateCategories", this.getCodes(CertificateCategory.class, this.project$1(lazyRef)));
        this.put("departments", this.getDeparts(this.project$1(lazyRef)));
        this.put("project", this.getProject());
    }

    public void editSetting(CertificateGrade entity) {
        LazyRef lazyRef = new LazyRef();
        super.editSetting((Entity)entity);
        this.put("certificateSubjects", this.getCodes(CertificateSubject.class, this.project$2(lazyRef)));
        this.put("certificateCategories", this.getCodes(CertificateCategory.class, this.project$2(lazyRef)));
        this.put("semesters", this.entityDao().getAll(Semester.class));
        this.put("gradingModes", this.getCodes(GradingMode.class, this.project$2(lazyRef)));
        this.put("examStatuses", this.getCodes(ExamStatus.class, this.project$2(lazyRef)));
    }

    public View saveAndRedirect(CertificateGrade grade) {
        Project project = this.getProject();
        String stdCode = (String)this.get("certificateGrade.std.code", "");
        if (grade.std() == null && Strings$.MODULE$.isNotBlank((CharSequence)stdCode)) {
            OqlBuilder q = OqlBuilder$.MODULE$.from(Student.class, "s");
            q.where("s.code=:code and s.project=:project", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{stdCode, project}));
            this.entityDao().search((QueryBuilder)q).foreach((Function1)(JProcedure1 & Serializable)std -> grade.std_$eq(std));
        }
        if (grade.std() == null) {
            return this.redirect("search", "\u4fdd\u5b58\u5931\u8d25,\u5b66\u53f7\u4e0d\u5b58\u5728");
        }
        if (this.isExist(grade)) {
            return this.redirect("search", "\u4fdd\u5b58\u5931\u8d25,\u6210\u7ee9\u91cd\u590d");
        }
        grade.status_$eq(Grade.Status$.MODULE$.Published());
        grade.updatedAt_$eq(Instant.now());
        return super.saveAndRedirect((Entity)grade);
    }

    private boolean isExist(CertificateGrade grade) {
        OqlBuilder query = OqlBuilder$.MODULE$.from(CertificateGrade.class, "grade");
        query.where("grade.std= :std", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{grade.std()}));
        query.where("grade.acquiredOn = :acquiredOn", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{grade.acquiredOn()}));
        query.where("grade.subject = :subject", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{grade.subject()}));
        if (!grade.persisted()) {
            return this.entityDao().search((QueryBuilder)query).nonEmpty();
        }
        query.where("grade.id <>:id", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{grade.id()}));
        return this.entityDao().search((QueryBuilder)query).nonEmpty();
    }

    public View convertList() {
        LazyRef lazyRef = new LazyRef();
        CertificateGrade grade = (CertificateGrade)this.entityDao().get(CertificateGrade.class, (Object)BoxesRunTime.boxToLong((long)this.longId("certificateGrade")));
        this.put("grade", grade);
        Student std = grade.std();
        Option plan = this.coursePlanProvider().getCoursePlan(grade.std());
        if (plan.isEmpty()) {
            return PathView$.MODULE$.apply("noPlanMsg");
        }
        scala.collection.immutable.Seq planCourses = this.exemptionService().getConvertablePlanCourses(std, (CoursePlan)plan.get());
        Map semesters = Collections$.MODULE$.newMap();
        planCourses.foreach((Function1)(JProcedure1 & Serializable)pc -> this.exemptionService().getSemester(((CoursePlan)plan.get()).program(), pc.terms().termList().headOption()).foreach((Function1 & Serializable)s -> semesters.put(pc, s)));
        this.put("semesters", semesters);
        this.put("convertedGrades", this.exemptionService().getConvertedGrades(std, (Iterable)grade.courses()));
        this.put("planCourses", planCourses);
        this.put("ExemptionType", this.entityDao().get(CourseTakeType.class, (Object)BoxesRunTime.boxToInteger((int)CourseTakeType$.MODULE$.Exemption())));
        this.put("gradingModes", this.getCodes(GradingMode.class, this.project$3(lazyRef)));
        return this.forward(this.forward$default$1());
    }

    public View convert() {
        CertificateGrade eg = (CertificateGrade)this.entityDao().get(CertificateGrade.class, (Object)BoxesRunTime.boxToLong((long)this.longId("grade")));
        scala.collection.immutable.Seq courses = this.entityDao().find(Course.class, (Iterable)this.longIds("course"));
        Set exemptionCourses = Collections$.MODULE$.newSet();
        courses.foreach((Function1)(JProcedure1 & Serializable)c -> {
            String scoreText = (String)this.get("scoreText_" + c.id(), "");
            if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(scoreText))) {
                exemptionCourses.addOne(c);
                return;
            }
        });
        this.exemptionService().addExemption(eg, (Iterable)exemptionCourses);
        return this.redirect("search", "info.action.success");
    }

    public View removeCourseGrade() {
        CertificateGrade grade = (CertificateGrade)this.entityDao().get(CertificateGrade.class, (Object)BoxesRunTime.boxToLong((long)this.longId("grade")));
        CourseGrade cg = (CourseGrade)this.entityDao().get(CourseGrade.class, (Object)BoxesRunTime.boxToLong((long)this.longId("courseGrade")));
        this.exemptionService().removeExemption(grade, cg.course());
        return this.redirect("search", "info.action.success");
    }

    @response
    public Object downloadTemplate() {
        LazyRef lazyRef = new LazyRef();
        Seq gradingModes = (Seq)this.getCodes(GradingMode.class, this.project$4(lazyRef)).map((Function1 & Serializable)x -> x.code() + " " + x.name());
        Seq subjects = (Seq)this.getCodes(CertificateSubject.class, this.project$4(lazyRef)).map((Function1 & Serializable)x -> x.code() + " " + x.name());
        ExcelSchema schema = new ExcelSchema();
        ExcelScheet sheet = schema.createScheet("\u6570\u636e\u6a21\u677f");
        sheet.title("\u6821\u5916\u8bc1\u4e66\u6210\u7ee9\u6a21\u677f");
        sheet.remark("\u7279\u522b\u8bf4\u660e\uff1a\n1\u3001\u4e0d\u53ef\u6539\u53d8\u672c\u8868\u683c\u7684\u884c\u5217\u7ed3\u6784\u4ee5\u53ca\u6279\u6ce8\uff0c\u5426\u5219\u5c06\u4f1a\u5bfc\u5165\u5931\u8d25\uff01\n2\u3001\u987b\u6309\u7167\u89c4\u683c\u8bf4\u660e\u7684\u683c\u5f0f\u586b\u5199\u3002\n3\u3001\u53ef\u4ee5\u591a\u6b21\u5bfc\u5165\uff0c\u91cd\u590d\u7684\u4fe1\u606f\u4f1a\u88ab\u65b0\u6570\u636e\u66f4\u65b0\u8986\u76d6\u3002\n4\u3001\u4fdd\u5b58\u7684excel\u6587\u4ef6\u540d\u79f0\u53ef\u4ee5\u81ea\u5b9a\u3002");
        ExcelColumn excelColumn = sheet.add("\u5b66\u53f7", "certificateGrade.std.code").length(15);
        excelColumn.required(excelColumn.required$default$1());
        ExcelColumn excelColumn2 = sheet.add("\u8003\u8bd5\u79d1\u76ee", "certificateGrade.subject.code").ref(subjects);
        excelColumn2.required(excelColumn2.required$default$1());
        ExcelColumn excelColumn3 = sheet.add("\u6210\u7ee9", "certificateGrade.scoreText");
        excelColumn3.required(excelColumn3.required$default$1());
        ExcelColumn excelColumn4 = sheet.add("\u662f\u5426\u901a\u8fc7", "certificateGrade.passed").bool();
        excelColumn4.required(excelColumn4.required$default$1());
        ExcelColumn excelColumn5 = sheet.add("\u83b7\u5f97\u65e5\u671f", "certificateGrade.acquiredOn");
        ExcelColumn excelColumn6 = excelColumn5.date(excelColumn5.date$default$1());
        excelColumn6.required(excelColumn6.required$default$1());
        ExcelColumn excelColumn7 = sheet.add("\u6210\u7ee9\u8bb0\u5f55\u65b9\u5f0f", "certificateGrade.gradingMode.code").ref(gradingModes);
        excelColumn7.required(excelColumn7.required$default$1());
        sheet.add("\u8bc1\u4e66\u7f16\u53f7", "certificateGrade.certificate");
        sheet.add("\u51c6\u8003\u8bc1\u53f7", "certificateGrade.examNo");
        sheet.add("\u514d\u4fee\u8bfe\u7a0b\u4ee3\u7801", "courseCodes").remark("\u591a\u4e2a\u8bfe\u7a0b\u53ef\u7528\u534a\u89d2\u9017\u53f7\u5206\u9694");
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        schema.generate((OutputStream)os);
        return Stream$.MODULE$.apply((InputStream)new ByteArrayInputStream(os.toByteArray()), "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", "\u8bc1\u4e66\u4fe1\u606f.xlsx", Stream$.MODULE$.apply$default$4());
    }

    public void configImport(ImportSetting setting) {
        ForeignerListener fl = new ForeignerListener(this.entityDao());
        setting.listeners_$eq((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ImportListener[]{fl, new CertificateGradeImportListener(this.entityDao(), this.getProject(), this.exemptionService())})));
    }

    public void configExport(ExportSetting setting) {
        ExportSupport.configExport$((ExportSupport)this, (ExportSetting)setting);
        setting.context().extractor_$eq((PropertyExtractor)new CertificateGradePropertyExtractor());
    }

    public OqlBuilder<CertificateGrade> getQueryBuilder() {
        OqlBuilder builder = EntityAction.getQueryBuilder$((EntityAction)this);
        this.getFloat("from").foreach((Function1 & Serializable)from -> GradeAction.getQueryBuilder$$anonfun$1(builder, BoxesRunTime.unboxToFloat((Object)from)));
        this.getFloat("to").foreach((Function1 & Serializable)to -> GradeAction.getQueryBuilder$$anonfun$2(builder, BoxesRunTime.unboxToFloat((Object)to)));
        this.getDate("fromAt").foreach((Function1 & Serializable)fromAt -> (OqlBuilder)builder.where("certificateGrade.updatedAt >= :fromAt", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{fromAt.atTime(0, 0, 0).atZone(ZoneId.systemDefault()).toInstant()})));
        this.getDate("toAt").foreach((Function1 & Serializable)toAt -> (OqlBuilder)builder.where(" certificateGrade.updatedAt <= :toAt", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{toAt.plusDays(1L).atTime(0, 0, 0).atZone(ZoneId.systemDefault()).toInstant()})));
        this.getBoolean("hasCourse").foreach((Function1 & Serializable)hasCourse -> GradeAction.getQueryBuilder$$anonfun$5(builder, BoxesRunTime.unboxToBoolean((Object)hasCourse)));
        return builder;
    }

    private final Project project$lzyINIT1$1(LazyRef project$lzy1$1) {
        Project project;
        LazyRef lazyRef = project$lzy1$1;
        synchronized (lazyRef) {
            project = (Project)(project$lzy1$1.initialized() ? project$lzy1$1.value() : project$lzy1$1.initialize((Object)this.getProject()));
        }
        return project;
    }

    private final Project project$1(LazyRef project$lzy1$2) {
        return (Project)(project$lzy1$2.initialized() ? project$lzy1$2.value() : this.project$lzyINIT1$1(project$lzy1$2));
    }

    private final Project project$lzyINIT2$1(LazyRef project$lzy2$1) {
        Project project;
        LazyRef lazyRef = project$lzy2$1;
        synchronized (lazyRef) {
            project = (Project)(project$lzy2$1.initialized() ? project$lzy2$1.value() : project$lzy2$1.initialize((Object)this.getProject()));
        }
        return project;
    }

    private final Project project$2(LazyRef project$lzy2$2) {
        return (Project)(project$lzy2$2.initialized() ? project$lzy2$2.value() : this.project$lzyINIT2$1(project$lzy2$2));
    }

    private final Project project$lzyINIT3$1(LazyRef project$lzy3$1) {
        Project project;
        LazyRef lazyRef = project$lzy3$1;
        synchronized (lazyRef) {
            project = (Project)(project$lzy3$1.initialized() ? project$lzy3$1.value() : project$lzy3$1.initialize((Object)this.getProject()));
        }
        return project;
    }

    private final Project project$3(LazyRef project$lzy3$2) {
        return (Project)(project$lzy3$2.initialized() ? project$lzy3$2.value() : this.project$lzyINIT3$1(project$lzy3$2));
    }

    private final Project project$lzyINIT4$1(LazyRef project$lzy4$1) {
        Project project;
        LazyRef lazyRef = project$lzy4$1;
        synchronized (lazyRef) {
            project = (Project)(project$lzy4$1.initialized() ? project$lzy4$1.value() : project$lzy4$1.initialize((Object)this.getProject()));
        }
        return project;
    }

    private final Project project$4(LazyRef project$lzy4$2) {
        return (Project)(project$lzy4$2.initialized() ? project$lzy4$2.value() : this.project$lzyINIT4$1(project$lzy4$2));
    }

    private static final /* synthetic */ OqlBuilder getQueryBuilder$$anonfun$1(OqlBuilder builder$1, float from) {
        return (OqlBuilder)builder$1.where("certificateGrade.score >=:F", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToFloat((float)from)}));
    }

    private static final /* synthetic */ OqlBuilder getQueryBuilder$$anonfun$2(OqlBuilder builder$2, float to) {
        return (OqlBuilder)builder$2.where("certificateGrade.score <=:T", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToFloat((float)to)}));
    }

    private static final /* synthetic */ OqlBuilder getQueryBuilder$$anonfun$5(OqlBuilder builder$5, boolean hasCourse) {
        return (OqlBuilder)builder$5.where((hasCourse ? "" : "not ") + "exists (from certificateGrade.courses ec)", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
    }
}

