/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.extern.web.helper;

import java.io.Serializable;
import java.time.Instant;
import java.time.LocalDate;
import org.beangle.commons.collection.Collections$;
import org.beangle.commons.conversion.impl.DefaultConversion$;
import org.beangle.commons.lang.Numbers$;
import org.beangle.commons.lang.Strings$;
import org.beangle.data.dao.EntityDao;
import org.beangle.data.dao.OqlBuilder;
import org.beangle.data.dao.OqlBuilder$;
import org.beangle.data.dao.QueryBuilder;
import org.beangle.data.transfer.importer.ImportListener;
import org.beangle.data.transfer.importer.ImportResult;
import org.beangle.data.transfer.importer.Importer;
import org.openurp.base.edu.model.Course;
import org.openurp.base.model.Project;
import org.openurp.code.edu.model.ExamStatus;
import org.openurp.code.edu.model.ExamStatus$;
import org.openurp.edu.extern.code.CertificateSubject;
import org.openurp.edu.extern.model.CertificateGrade;
import org.openurp.edu.extern.service.ExemptionService;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Some$;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Map;
import scala.collection.mutable.Set;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public class CertificateGradeImportListener
implements ImportListener {
    private Importer transfer;
    private final EntityDao entityDao;
    private final Project project;
    private final ExemptionService exemptionService;

    public CertificateGradeImportListener(EntityDao entityDao, Project project, ExemptionService exemptionService) {
        this.entityDao = entityDao;
        this.project = project;
        this.exemptionService = exemptionService;
        ImportListener.$init$((ImportListener)this);
    }

    public Importer transfer() {
        return this.transfer;
    }

    public void transfer_$eq(Importer x$1) {
        this.transfer = x$1;
    }

    public void onItemStart(ImportResult tr) {
        Map data = this.transfer().curData();
        data.get((Object)"certificateGrade.std.code").foreach((Function1)(JProcedure1 & Serializable)code -> data.get((Object)"certificateGrade.subject.code").foreach((Function1)(JProcedure1 & Serializable)subjectCode -> data.get((Object)"certificateGrade.acquiredOn").foreach((Function1)(JProcedure1 & Serializable)acquiredOn -> {
            String q = subjectCode.toString().contains(" ") ? Strings$.MODULE$.substringBefore(subjectCode.toString(), " ") : subjectCode.toString();
            OqlBuilder sQuery = OqlBuilder$.MODULE$.from(CertificateSubject.class, "cs");
            sQuery.where("cs.code = :q or cs.name = :q", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{q}));
            sQuery.cacheable(sQuery.cacheable$default$1());
            Seq subjects = this.entityDao.search((QueryBuilder)sQuery);
            if (subjects.size() == 1) {
                LocalDate acquiredOnDate = (LocalDate)DefaultConversion$.MODULE$.Instance().convert(acquiredOn, LocalDate.class);
                OqlBuilder query = OqlBuilder$.MODULE$.from(CertificateGrade.class, "cg");
                query.where("cg.std.project = :project", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.project}));
                query.where("cg.std.code = :stdCode", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{code}));
                query.where("cg.subject = :subject", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{subjects.head()}));
                query.where("cg.acquiredOn = :acquiredOn", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{acquiredOnDate}));
                Seq grades = this.entityDao.search((QueryBuilder)query);
                if (grades.nonEmpty()) {
                    this.transfer().current_$eq(grades.head());
                    return;
                }
                return;
            }
        })));
    }

    public void onItemFinish(ImportResult tr) {
        CertificateGrade grade = (CertificateGrade)this.transfer().current();
        if (grade.examStatus() == null) {
            grade.examStatus_$eq(new ExamStatus(ExamStatus$.MODULE$.Normal()));
        }
        if (Numbers$.MODULE$.isDigits(grade.scoreText()) && (grade.score() == null || grade.score().isEmpty())) {
            grade.score_$eq((Option)Some$.MODULE$.apply((Object)BoxesRunTime.boxToFloat((float)Numbers$.MODULE$.toFloat(grade.scoreText(), Numbers$.MODULE$.toFloat$default$2()))));
        }
        grade.updatedAt_$eq(Instant.now());
        this.entityDao.saveOrUpdate((Object)grade, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CertificateGrade[0]));
        this.transfer().curData().get((Object)"courseCodes").foreach((Function1)(JProcedure1 & Serializable)courseCodes -> {
            if (courseCodes != null && Strings$.MODULE$.isNotBlank((CharSequence)courseCodes.toString())) {
                Object[] codeList = Strings$.MODULE$.split(courseCodes.toString());
                Set courseSets = Collections$.MODULE$.newSet();
                Object object = Predef$.MODULE$.refArrayOps(codeList);
                ArrayOps$.MODULE$.foreach$extension(object, (Function1 & Serializable)courseCode -> {
                    OqlBuilder cQuery = OqlBuilder$.MODULE$.from(Course.class, "c");
                    cQuery.where("c.project=:project", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.project}));
                    cQuery.where("c.code=:code", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{courseCode}));
                    Seq courses = this.entityDao.search((QueryBuilder)cQuery);
                    if (courses.size() == 1) {
                        return courseSets.$plus$plus$eq((IterableOnce)courses);
                    }
                    tr.addFailure("\u627e\u4e0d\u5230\u8bfe\u7a0b\u4ee3\u7801", courseCode);
                    return BoxedUnit.UNIT;
                });
                Object object2 = Predef$.MODULE$.refArrayOps(codeList);
                if (ArrayOps$.MODULE$.size$extension(object2) == courseSets.size()) {
                    this.exemptionService.addExemption(grade, (Iterable)courseSets);
                    return;
                }
                return;
            }
        });
    }
}

