/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.extern.web.action.signup;

import java.io.Serializable;
import java.time.Instant;
import org.beangle.commons.codec.digest.Digests$;
import org.beangle.commons.lang.Strings$;
import org.beangle.commons.logging.Logger$;
import org.beangle.commons.logging.Logging;
import org.beangle.data.dao.OqlBuilder;
import org.beangle.data.dao.OqlBuilder$;
import org.beangle.data.dao.QueryBuilder;
import org.beangle.ems.app.Ems$;
import org.beangle.web.servlet.util.RequestUtils$;
import org.beangle.webmvc.To;
import org.beangle.webmvc.support.EntitySupport;
import org.beangle.webmvc.support.action.EntityAction;
import org.beangle.webmvc.view.View;
import org.openurp.base.model.Project;
import org.openurp.base.std.model.Student;
import org.openurp.edu.extern.config.CertSignupConfig;
import org.openurp.edu.extern.config.CertSignupSetting;
import org.openurp.edu.extern.model.CertSignup;
import org.openurp.edu.extern.model.CertificateGrade;
import org.openurp.edu.extern.service.signup.CertSignupService;
import org.openurp.starter.web.helper.ProjectProfile$;
import org.openurp.starter.web.support.StudentSupport;
import org.slf4j.Logger;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.runtime.BooleanRef;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;

public class StdAction
extends StudentSupport
implements EntityAction<CertSignup>,
Logging {
    private Class entityClass;
    private Logger logger;
    private CertSignupService examSignupService;

    public StdAction() {
        EntitySupport.$init$((EntitySupport)this);
        Logging.$init$((Logging)this);
        Statics.releaseFence();
    }

    public Class entityClass() {
        return this.entityClass;
    }

    public void org$beangle$webmvc$support$EntitySupport$_setter_$entityClass_$eq(Class x$0) {
        this.entityClass = x$0;
    }

    public Logger logger() {
        return this.logger;
    }

    public void org$beangle$commons$logging$Logging$_setter_$logger_$eq(Logger x$0) {
        this.logger = x$0;
    }

    public CertSignupService examSignupService() {
        return this.examSignupService;
    }

    public void examSignupService_$eq(CertSignupService x$1) {
        this.examSignupService = x$1;
    }

    public View projectIndex(Student std) {
        OqlBuilder builder = (OqlBuilder)OqlBuilder$.MODULE$.from(CertSignup.class, "signUp").where("signUp.std =:std", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{std}));
        Seq signUpList = this.entityDao().search((QueryBuilder)builder);
        OqlBuilder gradeBuilder = (OqlBuilder)OqlBuilder$.MODULE$.from(CertificateGrade.class, "grade").where("grade.std =:std", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{std}));
        this.put("grades", this.entityDao().search((QueryBuilder)gradeBuilder));
        this.put("signUps", signUpList);
        this.put("configs", this.examSignupService().getOpenedConfigs(std.project()));
        return this.forward(this.forward$default$1());
    }

    public View configs() {
        Student std = this.getStudent();
        Iterable configs = this.examSignupService().getOpenedConfigs(std.project());
        if (configs.isEmpty()) {
            return this.forward("noconfig");
        }
        ArrayBuffer signUpList = new ArrayBuffer();
        configs.foreach((Function1 & Serializable)config -> {
            Iterable signUps = this.examSignupService().search(std, config);
            return (ArrayBuffer)signUpList.$plus$plus$eq((IterableOnce)signUps);
        });
        if (signUpList.nonEmpty()) {
            this.put("signUpCertificates", ((IterableOnceOps)signUpList.map((Function1 & Serializable)_$2 -> _$2.certificate())).toSet());
        }
        Seq grades = this.entityDao().findBy(CertificateGrade.class, "std", (Object)new .colon.colon((Object)std, (List)Nil$.MODULE$));
        Seq passedCertificates = (Seq)((IterableOps)grades.filter((Function1 & Serializable)_$3 -> _$3.passed())).map((Function1 & Serializable)_$4 -> _$4.subject());
        this.put("passedCertificates", passedCertificates);
        this.put("signUpList", signUpList);
        this.put("configs", configs);
        this.put("student", std);
        return this.forward(this.forward$default$1());
    }

    public View notice() {
        CertSignupSetting setting = (CertSignupSetting)this.entityDao().get(CertSignupSetting.class, (Object)BoxesRunTime.boxToLong((long)this.getLongId("setting")));
        Student std = this.getStudent();
        String msg = this.examSignupService().canSignup(std, setting);
        if (msg != null) {
            return this.redirect("configs", "&t=" + System.currentTimeMillis(), msg);
        }
        CertSignupConfig config = setting.config();
        if (Strings$.MODULE$.isBlank((CharSequence)config.notice())) {
            return this.forward((To)this.to((Object)this, "signUpForm"));
        }
        this.put("config", config);
        return this.forward(this.forward$default$1());
    }

    public View signUpForm() {
        Student std = this.getStudent();
        CertSignupSetting setting = (CertSignupSetting)this.entityDao().get(CertSignupSetting.class, (Object)BoxesRunTime.boxToLong((long)this.getLongId("setting")));
        this.put("setting", setting);
        this.put("student", std);
        return this.forward(this.forward$default$1());
    }

    public View save() {
        Student std = this.getStudent();
        CertSignupSetting setting = (CertSignupSetting)this.entityDao().get(CertSignupSetting.class, (Object)BoxesRunTime.boxToLong((long)this.getLongId("setting")));
        CertSignupConfig config = setting.config();
        if (!config.isTimeSuitable()) {
            return this.redirect("configs", "\u4e0d\u5728\u62a5\u540d\u65f6\u95f4\u6bb5\u5185");
        }
        CertSignup signup = new CertSignup();
        signup.std_$eq(std);
        signup.updatedAt_$eq(Instant.now());
        signup.ip_$eq(RequestUtils$.MODULE$.getIpAddr(this.request()));
        signup.semester_$eq(setting.config().semester());
        signup.certificate_$eq(setting.certificate());
        Project project = std.project();
        if (config.isTimeSuitable()) {
            String msg = this.examSignupService().signup(signup, setting);
            if (msg == null) {
                msg = config.prediction() ? "\u9884\u62a5\u540d\u6210\u529f" : "\u62a5\u540d\u6210\u529f";
                Logger$.MODULE$.info$extension(this.logger(), () -> this.save$$anonfun$1(std, signup));
            }
            return this.redirect("configs", msg);
        }
        return this.redirect("configs", "\u4e0d\u5728\u62a5\u540d\u65f6\u95f4\u5185");
    }

    public View cancel() {
        CertSignup signup = (CertSignup)this.entityDao().get(CertSignup.class, (Object)BoxesRunTime.boxToLong((long)this.getLongId("signup")));
        Student std = this.getStudent();
        Student student = signup.std();
        Student student2 = std;
        if (student == null ? student2 != null : !student.equals(student2)) {
            return this.redirect("configs", "\u975e\u6cd5\u64cd\u4f5c\uff0c\u53ea\u80fd\u53d6\u6d88\u81ea\u5df1\u7684\u62a5\u540d\u4fe1\u606f!");
        }
        Iterable configs = this.examSignupService().getOpenedConfigs(std.project());
        BooleanRef openConfig = BooleanRef.create((boolean)false);
        configs.withFilter((Function1 & Serializable)config -> !openConfig$1.elem).foreach((Function1)(JProcedure1 & Serializable)config -> {
            if (this.examSignupService().search(std, config).toSeq().contains((Object)signup)) {
                openConfig$2.elem = true;
                return;
            }
        });
        if (openConfig.elem) {
            this.entityDao().remove((Object)signup, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CertSignup[0]));
            String remoteAddr = RequestUtils$.MODULE$.getIpAddr(this.request());
            Logger$.MODULE$.info$extension(this.logger(), () -> StdAction.cancel$$anonfun$3(std, signup, remoteAddr));
            return this.redirect("configs", "\u53d6\u6d88\u62a5\u540d\u6210\u529f!");
        }
        return this.redirect("configs", "\u4e0d\u5728\u62a5\u540d\u65f6\u95f4\u5185");
    }

    public View examCertificate() {
        CertSignup signup = (CertSignup)this.entityDao().get(CertSignup.class, (Object)BoxesRunTime.boxToLong((long)this.getLongId("signup")));
        Object[] objectArray = new Tuple2[2];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"certificate");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)signup.certificate());
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"config.semester");
        objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)signup.semester());
        CertSignupSetting setting = (CertSignupSetting)this.entityDao().findBy(CertSignupSetting.class, (Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)).head();
        this.put("setting", setting);
        this.put("signup", signup);
        this.put("avatarURL", Ems$.MODULE$.api() + "/platform/user/avatars/" + Digests$.MODULE$.md5Hex(signup.std().code()));
        ProjectProfile$.MODULE$.set(signup.std().project());
        return this.forward(this.forward$default$1());
    }

    private final String save$$anonfun$1(Student std$2, CertSignup signup$1) {
        return std$2.code() + " \u62a5\u540d " + signup$1.certificate().name() + " @" + RequestUtils$.MODULE$.getIpAddr(this.request());
    }

    private static final String cancel$$anonfun$3(Student std$4, CertSignup signup$3, String remoteAddr$1) {
        return std$4.code() + " \u53d6\u6d88\u4e86 " + signup$3.certificate().name() + " @" + remoteAddr$1;
    }
}

