/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.extern.web.action.course;

import java.io.Serializable;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import org.beangle.commons.bean.PropertyExtractor;
import org.beangle.commons.collection.Collections$;
import org.beangle.commons.collection.Properties;
import org.beangle.commons.lang.Numbers$;
import org.beangle.data.dao.OqlBuilder;
import org.beangle.data.dao.OqlBuilder$;
import org.beangle.data.dao.QueryBuilder;
import org.beangle.doc.transfer.exporter.ExportContext;
import org.beangle.webmvc.annotation.response;
import org.beangle.webmvc.support.action.EntityAction;
import org.beangle.webmvc.support.action.ExportSupport;
import org.beangle.webmvc.support.action.RestfulAction;
import org.beangle.webmvc.view.PathView$;
import org.beangle.webmvc.view.View;
import org.openurp.base.edu.model.Course;
import org.openurp.base.model.Project;
import org.openurp.base.service.ProjectConfigService;
import org.openurp.base.service.SemesterService;
import org.openurp.base.std.model.ExternStudent;
import org.openurp.base.std.model.Student;
import org.openurp.code.edu.model.CourseTakeType;
import org.openurp.code.edu.model.CourseTakeType$;
import org.openurp.code.edu.model.GradingMode;
import org.openurp.code.service.CodeService;
import org.openurp.edu.exempt.service.ExemptionService;
import org.openurp.edu.extern.model.ExternGrade;
import org.openurp.edu.extern.web.helper.ExternGradePropertyExtractor;
import org.openurp.edu.grade.model.CourseGrade;
import org.openurp.edu.program.domain.CoursePlanProvider;
import org.openurp.edu.program.model.CoursePlan;
import org.openurp.starter.web.support.ProjectSupport;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some$;
import scala.collection.Iterable;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Map;
import scala.collection.mutable.Set;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

/*
 * Exception performing whole class analysis ignored.
 */
public class GradeAction
extends RestfulAction<ExternGrade>
implements ExportSupport<ExternGrade>,
ProjectSupport {
    private CodeService codeService;
    private ProjectConfigService configService;
    private SemesterService semesterService;
    private CoursePlanProvider coursePlanProvider;
    private ExemptionService exemptionService;

    public GradeAction() {
        ProjectSupport.$init$((ProjectSupport)this);
    }

    public CodeService codeService() {
        return this.codeService;
    }

    public ProjectConfigService configService() {
        return this.configService;
    }

    public SemesterService semesterService() {
        return this.semesterService;
    }

    public void codeService_$eq(CodeService x$1) {
        this.codeService = x$1;
    }

    public void configService_$eq(ProjectConfigService x$1) {
        this.configService = x$1;
    }

    public void semesterService_$eq(SemesterService x$1) {
        this.semesterService = x$1;
    }

    public CoursePlanProvider coursePlanProvider() {
        return this.coursePlanProvider;
    }

    public void coursePlanProvider_$eq(CoursePlanProvider x$1) {
        this.coursePlanProvider = x$1;
    }

    public ExemptionService exemptionService() {
        return this.exemptionService;
    }

    public void exemptionService_$eq(ExemptionService x$1) {
        this.exemptionService = x$1;
    }

    public OqlBuilder<ExternGrade> getQueryBuilder() {
        OqlBuilder builder = EntityAction.getQueryBuilder$((EntityAction)this);
        this.getDate("fromAt").foreach((Function1 & Serializable)fromAt -> (OqlBuilder)builder.where("externGrade.updatedAt >= :fromAt", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{fromAt.atTime(0, 0, 0).atZone(ZoneId.systemDefault()).toInstant()})));
        this.getDate("toAt").foreach((Function1 & Serializable)toAt -> (OqlBuilder)builder.where(" externGrade.updatedAt <= :toAt", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{toAt.plusDays(1L).atTime(0, 0, 0).atZone(ZoneId.systemDefault()).toInstant()})));
        this.getBoolean("hasCourse").foreach((Function1 & Serializable)hasCourse -> GradeAction.getQueryBuilder$$anonfun$3((OqlBuilder)builder, (boolean)BoxesRunTime.unboxToBoolean((Object)hasCourse)));
        return builder;
    }

    @response
    public Seq<Properties> loadStudent() {
        OqlBuilder query = OqlBuilder$.MODULE$.from(ExternStudent.class, "es");
        query.where("es.std.code=:code", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.get("q", (Object)"")}));
        DateTimeFormatter yyyyMM = DateTimeFormatter.ofPattern("yyyy-MM");
        return (Seq)this.entityDao().search((QueryBuilder)query).map((Function1 & Serializable)es -> {
            Properties p = new Properties();
            p.put((Object)"value", (Object)es.id().toString());
            p.put((Object)"text", (Object)(es.std().code() + " " + es.std().name() + " " + es.school().name() + "(" + es.beginOn().format(yyyyMM) + ")"));
            return p;
        });
    }

    public View convertList() {
        LazyRef lazyRef = new LazyRef();
        ExternGrade grade = (ExternGrade)this.entityDao().get(ExternGrade.class, (Object)BoxesRunTime.boxToLong((long)this.getLongId("externGrade")));
        this.put("grade", (Object)grade);
        ExternStudent es = grade.externStudent();
        Student std = es.std();
        Option plan = this.coursePlanProvider().getCoursePlan(grade.externStudent().std());
        if (plan.isEmpty()) {
            return PathView$.MODULE$.apply("noPlanMsg");
        }
        Seq planCourses = this.exemptionService().getConvertablePlanCourses(std, (CoursePlan)plan.get());
        this.put("convertedGrades", (Object)this.exemptionService().getConvertedGrades(std, (Iterable)grade.exempts()));
        Map semesters = Collections$.MODULE$.newMap();
        planCourses.foreach((Function1)(JProcedure1 & Serializable)pc -> this.exemptionService().getSemester(((CoursePlan)plan.get()).program(), pc.terms().termList().headOption()).foreach((Function1 & Serializable)s -> semesters.put(pc, s)));
        this.put("semesters", (Object)semesters);
        this.put("planCourses", (Object)planCourses);
        this.put("ExemptionType", (Object)this.entityDao().get(CourseTakeType.class, (Object)BoxesRunTime.boxToInteger((int)CourseTakeType$.MODULE$.Exemption())));
        this.put("gradingModes", (Object)this.getCodes(GradingMode.class, GradeAction.project$1((LazyRef)lazyRef, (ExternGrade)grade)));
        return this.forward(this.forward$default$1());
    }

    public View convert() {
        ExternGrade eg = (ExternGrade)this.entityDao().get(ExternGrade.class, (Object)BoxesRunTime.boxToLong((long)this.getLongId("grade")));
        Seq courses = this.entityDao().find(Course.class, (Iterable)this.getLongIds("course"));
        Set exemptCourses = Collections$.MODULE$.newSet();
        ObjectRef score = ObjectRef.create((Object)None$.MODULE$);
        courses.foreach((Function1)(JProcedure1 & Serializable)c -> {
            String scoreText = (String)this.get("scoreText_" + c.id(), (Object)"");
            if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(scoreText))) {
                exemptCourses.$plus$eq(c);
                if (Numbers$.MODULE$.isDigits(scoreText)) {
                    score$1.elem = Some$.MODULE$.apply((Object)BoxesRunTime.boxToFloat((float)StringOps$.MODULE$.toFloat$extension(Predef$.MODULE$.augmentString(scoreText))));
                    return;
                }
                return;
            }
        });
        this.exemptionService().addExemption(eg, (Iterable)exemptCourses, (Option)score.elem);
        return this.redirect("search", "info.action.success");
    }

    public View removeCourseGrade() {
        ExternGrade eg = (ExternGrade)this.entityDao().get(ExternGrade.class, (Object)BoxesRunTime.boxToLong((long)this.getLongId("grade")));
        CourseGrade cg = (CourseGrade)this.entityDao().get(CourseGrade.class, (Object)BoxesRunTime.boxToLong((long)this.getLongId("courseGrade")));
        this.exemptionService().removeExemption(eg, cg.course());
        return this.redirect("search", "info.action.success");
    }

    public void configExport(ExportContext context) {
        ExportSupport.configExport$((ExportSupport)this, (ExportContext)context);
        context.extractor_$eq((PropertyExtractor)new ExternGradePropertyExtractor());
    }

    private static final /* synthetic */ OqlBuilder getQueryBuilder$$anonfun$3(OqlBuilder builder$3, boolean hasCourse) {
        return (OqlBuilder)builder$3.where((hasCourse ? "" : "not ") + "exists (from externGrade.exempts ec)", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
    }

    private static final Project project$lzyINIT1$1(LazyRef project$lzy1$1, ExternGrade grade$1) {
        Project project;
        LazyRef lazyRef = project$lzy1$1;
        synchronized (lazyRef) {
            project = (Project)(project$lzy1$1.initialized() ? project$lzy1$1.value() : project$lzy1$1.initialize((Object)grade$1.externStudent().std().project()));
        }
        return project;
    }

    private static final Project project$1(LazyRef project$lzy1$2, ExternGrade grade$2) {
        return (Project)(project$lzy1$2.initialized() ? project$lzy1$2.value() : GradeAction.project$lzyINIT1$1((LazyRef)project$lzy1$2, (ExternGrade)grade$2));
    }
}

