/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.grade.course.domain;

import java.io.Serializable;
import java.time.Instant;
import org.beangle.commons.collection.Collections$;
import org.openurp.edu.base.model.Semester;
import org.openurp.edu.base.model.Student;
import org.openurp.edu.grade.course.domain.GpaPolicy;
import org.openurp.edu.grade.course.domain.NumRounder;
import org.openurp.edu.grade.course.domain.NumRounder$Normal$;
import org.openurp.edu.grade.course.domain.WeightedMean$;
import org.openurp.edu.grade.course.model.CourseGrade;
import org.openurp.edu.grade.course.model.StdGpa;
import org.openurp.edu.grade.course.model.StdSemesterGpa;
import org.openurp.edu.grade.course.model.StdYearGpa;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.TraversableOnce;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.FloatRef;

@ScalaSignature(bytes="\u0006\u0001Q4A!\u0001\u0002\u0001\u001f\t\u0001B)\u001a4bk2$x\t]1Q_2L7-\u001f\u0006\u0003\u0007\u0011\ta\u0001Z8nC&t'BA\u0003\u0007\u0003\u0019\u0019w.\u001e:tK*\u0011q\u0001C\u0001\u0006OJ\fG-\u001a\u0006\u0003\u0013)\t1!\u001a3v\u0015\tYA\"A\u0004pa\u0016tWO\u001d9\u000b\u00035\t1a\u001c:h\u0007\u0001\u00192\u0001\u0001\t\u0017!\t\tB#D\u0001\u0013\u0015\u0005\u0019\u0012!B:dC2\f\u0017BA\u000b\u0013\u0005\u0019\te.\u001f*fMB\u0011q\u0003G\u0007\u0002\u0005%\u0011\u0011D\u0001\u0002\n\u000fB\f\u0007k\u001c7jGfDQa\u0007\u0001\u0005\u0002q\ta\u0001P5oSRtD#A\u000f\u0011\u0005]\u0001\u0001bB\u0010\u0001\u0001\u0004%\t\u0001I\u0001\naJ,7-[:j_:,\u0012!\t\t\u0003#\tJ!a\t\n\u0003\u0007%sG\u000fC\u0004&\u0001\u0001\u0007I\u0011\u0001\u0014\u0002\u001bA\u0014XmY5tS>tw\fJ3r)\t9#\u0006\u0005\u0002\u0012Q%\u0011\u0011F\u0005\u0002\u0005+:LG\u000fC\u0004,I\u0005\u0005\t\u0019A\u0011\u0002\u0007a$\u0013\u0007\u0003\u0004.\u0001\u0001\u0006K!I\u0001\u000baJ,7-[:j_:\u0004\u0003bB\u0018\u0001\u0001\u0004%\t\u0001M\u0001\be>,h\u000eZ3s+\u0005\t\u0004CA\f3\u0013\t\u0019$A\u0001\u0006Ok6\u0014v.\u001e8eKJDq!\u000e\u0001A\u0002\u0013\u0005a'A\u0006s_VtG-\u001a:`I\u0015\fHCA\u00148\u0011\u001dYC'!AA\u0002EBa!\u000f\u0001!B\u0013\t\u0014\u0001\u0003:pk:$WM\u001d\u0011\t\u000bm\u0002A\u0011\u0001\u001f\u0002\r\r\fGnY$b)\ti\u0004\t\u0005\u0002\u0012}%\u0011qH\u0005\u0002\u0006\r2|\u0017\r\u001e\u0005\u0006\u0003j\u0002\rAQ\u0001\u0007OJ\fG-Z:\u0011\u0007\r[eJ\u0004\u0002E\u0013:\u0011Q\tS\u0007\u0002\r*\u0011qID\u0001\u0007yI|w\u000e\u001e \n\u0003MI!A\u0013\n\u0002\u000fA\f7m[1hK&\u0011A*\u0014\u0002\t\u0013R,'/\u00192mK*\u0011!J\u0005\t\u0003\u001fJk\u0011\u0001\u0015\u0006\u0003#\u0012\tQ!\\8eK2L!a\u0015)\u0003\u0017\r{WO]:f\u000fJ\fG-\u001a\u0005\u0006+\u0002!\tAV\u0001\bG\u0006d7m\u00129b)\tit\u000bC\u0003B)\u0002\u0007!\tC\u0003Z\u0001\u0011\u0005!,\u0001\u0003dC2\u001cG\u0003B._O\"\u0004\"a\u0014/\n\u0005u\u0003&AB*uI\u001e\u0003\u0018\rC\u0003`1\u0002\u0007\u0001-A\u0002ti\u0012\u0004\"!Y3\u000e\u0003\tT!!U2\u000b\u0005\u0011D\u0011\u0001\u00022bg\u0016L!A\u001a2\u0003\u000fM#X\u000fZ3oi\")\u0011\t\u0017a\u0001\u0005\")\u0011\u000e\u0017a\u0001U\u0006Q1\u000f^1u\t\u0016$\u0018-\u001b7\u0011\u0005EY\u0017B\u00017\u0013\u0005\u001d\u0011un\u001c7fC:DQA\u001c\u0001\u0005\n=\f1b\u001d;bi\u000e\u0013X\rZ5ugR\u0011\u0001o\u001d\t\u0004#El\u0014B\u0001:\u0013\u0005\u0015\t%O]1z\u0011\u0015\tU\u000e1\u0001C\u0001")
public class DefaultGpaPolicy
implements GpaPolicy {
    private int precision = 2;
    private NumRounder rounder = NumRounder$Normal$.MODULE$;

    @Override
    public int precision() {
        return this.precision;
    }

    public void precision_$eq(int x$1) {
        this.precision = x$1;
    }

    public NumRounder rounder() {
        return this.rounder;
    }

    public void rounder_$eq(NumRounder x$1) {
        this.rounder = x$1;
    }

    @Override
    public float calcGa(Iterable<CourseGrade> grades) {
        return this.rounder().round(WeightedMean$.MODULE$.calcGa(grades), this.precision());
    }

    @Override
    public float calcGpa(Iterable<CourseGrade> grades) {
        return this.rounder().round(WeightedMean$.MODULE$.calcGpa(grades), this.precision());
    }

    @Override
    public StdGpa calc(Student std, Iterable<CourseGrade> grades, boolean statDetail) {
        StdGpa stdGpa = new StdGpa(std);
        if (statDetail) {
            Map gradesMap = Collections$.MODULE$.newMap();
            grades.foreach((Function1 & Serializable & scala.Serializable)grade -> {
                Buffer semesterGrades = (Buffer)gradesMap.getOrElseUpdate((Object)grade.semester(), (Function0 & Serializable & scala.Serializable)() -> Collections$.MODULE$.newBuffer());
                return semesterGrades.$plus$eq(grade);
            });
            Map yearGradeMap = Collections$.MODULE$.newMap();
            gradesMap.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                DefaultGpaPolicy.$anonfun$calc$3(this, stdGpa, yearGradeMap, x0$1);
                return BoxedUnit.UNIT;
            });
            yearGradeMap.foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                DefaultGpaPolicy.$anonfun$calc$5(this, stdGpa, x0$2);
                return BoxedUnit.UNIT;
            });
        }
        stdGpa.gpa_$eq(this.calcGpa(grades));
        stdGpa.ga_$eq(this.calcGa(grades));
        Map courseMap = Collections$.MODULE$.newMap();
        grades.foreach((Function1 & Serializable & scala.Serializable)grade -> {
            boolean bl;
            Option option = courseMap.get((Object)grade.course());
            if (None$.MODULE$.equals(option)) {
                bl = true;
            } else if (option instanceof Some) {
                Some some = (Some)option;
                CourseGrade exist = (CourseGrade)some.value();
                bl = !exist.passed();
            } else {
                throw new MatchError((Object)option);
            }
            boolean add = bl;
            return add ? courseMap.put((Object)grade.course(), grade) : BoxedUnit.UNIT;
        });
        stdGpa.count_$eq(courseMap.size());
        float[] totalStats = this.statCredits((Iterable<CourseGrade>)courseMap.values());
        stdGpa.totalCredits_$eq(totalStats[0]);
        stdGpa.credits_$eq(totalStats[1]);
        stdGpa.updatedAt_$eq(Instant.now());
        return stdGpa;
    }

    private float[] statCredits(Iterable<CourseGrade> grades) {
        FloatRef credits = FloatRef.create((float)0.0f);
        FloatRef all = FloatRef.create((float)0.0f);
        grades.foreach((Function1 & Serializable & scala.Serializable)grade -> {
            DefaultGpaPolicy.$anonfun$statCredits$1(credits, all, grade);
            return BoxedUnit.UNIT;
        });
        return new float[]{all.elem, credits.elem};
    }

    public static final /* synthetic */ void $anonfun$calc$3(DefaultGpaPolicy $this, StdGpa stdGpa$1, Map yearGradeMap$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Semester semester = (Semester)tuple2._1();
        Buffer semesterGrades = (Buffer)tuple2._2();
        StdSemesterGpa stdTermGpa = new StdSemesterGpa();
        stdTermGpa.semester_$eq(semester);
        stdGpa$1.add(stdTermGpa);
        Buffer yearGrades = (Buffer)yearGradeMap$1.getOrElseUpdate((Object)semester.schoolYear(), (Function0 & Serializable & scala.Serializable)() -> Collections$.MODULE$.newBuffer());
        yearGrades.$plus$plus$eq((TraversableOnce)semesterGrades);
        stdTermGpa.gpa_$eq($this.calcGpa((Iterable<CourseGrade>)semesterGrades));
        stdTermGpa.ga_$eq($this.calcGa((Iterable<CourseGrade>)semesterGrades));
        stdTermGpa.count_$eq(semesterGrades.size());
        float[] stats = $this.statCredits((Iterable<CourseGrade>)semesterGrades);
        stdTermGpa.totalCredits_$eq(stats[0]);
        stdTermGpa.credits_$eq(stats[1]);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$calc$5(DefaultGpaPolicy $this, StdGpa stdGpa$1, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String year = (String)tuple2._1();
        Buffer yearGrades = (Buffer)tuple2._2();
        StdYearGpa stdYearGpa = new StdYearGpa();
        stdYearGpa.schoolYear_$eq(year);
        stdGpa$1.add(stdYearGpa);
        stdYearGpa.gpa_$eq($this.calcGpa((Iterable<CourseGrade>)yearGrades));
        stdYearGpa.ga_$eq($this.calcGa((Iterable<CourseGrade>)yearGrades));
        stdYearGpa.count_$eq(yearGrades.size());
        float[] stats = $this.statCredits((Iterable<CourseGrade>)yearGrades);
        stdYearGpa.totalCredits_$eq(stats[0]);
        stdYearGpa.credits_$eq(stats[1]);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$statCredits$1(FloatRef credits$1, FloatRef all$1, CourseGrade grade) {
        if (grade.passed()) {
            credits$1.elem += grade.course().credits();
        }
        all$1.elem += grade.course().credits();
    }
}

