/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.grade.audit.model;

import java.util.Set;
import javax.persistence.Embeddable;
import org.beangle.commons.collection.CollectUtils;
import org.beangle.commons.entity.Component;
import org.openurp.edu.base.model.Course;

@Embeddable
public class AuditStat
implements Component {
    private float creditsRequired;
    private float creditsCompleted;
    private int numRequired;
    private int numCompleted;
    private transient Set<Course> passedCourses = CollectUtils.newHashSet();
    private float creditsConverted;

    public AuditStat() {
    }

    public AuditStat(float creditCompleted, int totalNum) {
        this.creditsCompleted = creditCompleted;
        this.numCompleted = totalNum;
    }

    public void addCredits(float credits) {
        this.creditsCompleted += credits;
    }

    public void addNum(int num) {
        this.numCompleted += num;
    }

    public boolean isPassed() {
        return this.getCreditsRequired() <= this.getCreditsCompleted() + this.getCreditsConverted() && this.getNumRequired() <= this.getNumCompleted();
    }

    public float getCreditNeeded(boolean returnNegative) {
        float needToComplete = this.creditsRequired - this.creditsConverted - this.creditsCompleted;
        if (needToComplete < 0.0f) {
            if (returnNegative) {
                return needToComplete;
            }
            return 0.0f;
        }
        return needToComplete;
    }

    public int getNumRequired() {
        return this.numRequired;
    }

    public void setNumRequired(int courseNumRequired) {
        this.numRequired = courseNumRequired;
    }

    public float getCreditsCompleted() {
        return this.creditsCompleted;
    }

    public void setCreditsCompleted(float creditsCompleted) {
        this.creditsCompleted = creditsCompleted;
    }

    public float getCreditsRequired() {
        return this.creditsRequired;
    }

    public void setCreditsRequired(float creditsRequired) {
        this.creditsRequired = creditsRequired;
    }

    public Set<Course> getPassedCourses() {
        return this.passedCourses;
    }

    public void setPassedCourses(Set<Course> passCourses) {
        this.passedCourses = passCourses;
    }

    public int getNumCompleted() {
        return this.numCompleted;
    }

    public void setNumCompleted(int totalCourseNum) {
        this.numCompleted = totalCourseNum;
    }

    public float getCreditsConverted() {
        return this.creditsConverted;
    }

    public void setCreditsConverted(float creditsConverted) {
        this.creditsConverted = creditsConverted;
    }

    public void reduceRequired(float credits, int num) {
        this.creditsRequired -= credits;
        this.creditsRequired = this.creditsRequired < 0.0f ? 0.0f : this.creditsRequired;
        this.numRequired -= num;
        this.numRequired = this.numRequired < 0 ? 0 : this.numRequired;
    }
}

