/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.grade.course.model;

import java.util.Date;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ManyToOne;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.beangle.commons.entity.pojo.NumberIdObject;
import org.hibernate.annotations.NaturalId;
import org.openurp.edu.base.code.model.GradeType;
import org.openurp.edu.base.code.model.GradingMode;
import org.openurp.edu.base.model.Student;
import org.openurp.edu.grade.Grade;
import org.openurp.edu.grade.course.model.CourseGrade;

@Entity(name="org.openurp.edu.grade.course.model.GaGrade")
public class GaGrade
extends NumberIdObject<Long>
implements Grade {
    private static final long serialVersionUID = 3737090012804400743L;
    @NaturalId
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    private GradeType gradeType;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    private GradingMode gradingMode;
    private Float score;
    private String scoreText;
    private Float delta;
    @NaturalId
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    private CourseGrade courseGrade;
    protected int status;
    private boolean passed;
    @Size(max=50)
    private String operator;
    private Float gp;
    private Date updatedAt;
    @Size(max=100)
    private String remark;

    public Float getGp() {
        return this.gp;
    }

    public void setGp(Float gp) {
        this.gp = gp;
    }

    public GaGrade() {
    }

    public GaGrade(GradeType gradeType, Float score) {
        this.gradeType = gradeType;
        this.score = score;
    }

    @Override
    public Student getStd() {
        return this.courseGrade == null ? null : this.courseGrade.getStd();
    }

    public GaGrade init(GradeType gradeType, Float score) {
        this.gradeType = gradeType;
        this.score = score;
        return this;
    }

    public CourseGrade getCourseGrade() {
        return this.courseGrade;
    }

    public void setCourseGrade(CourseGrade courseGrade) {
        this.courseGrade = courseGrade;
    }

    public GradeType getGradeType() {
        return this.gradeType;
    }

    public void setGradeType(GradeType gradeType) {
        this.gradeType = gradeType;
    }

    @Override
    public Float getScore() {
        return this.score;
    }

    @Override
    public void setScore(Float score) {
        this.score = score;
    }

    @Override
    public String getScoreText() {
        return this.scoreText;
    }

    @Override
    public void setScoreText(String scoreText) {
        this.scoreText = scoreText;
    }

    @Override
    public boolean isPublished() {
        return this.getStatus() == 2;
    }

    @Override
    public boolean isConfirmed() {
        return this.status >= 1;
    }

    @Override
    public int getStatus() {
        return this.status;
    }

    @Override
    public void setStatus(int status) {
        this.status = status;
    }

    @Override
    public int compareTo(Grade grade) {
        if (this.getScore() == null) {
            return 1;
        }
        if (grade.getScore() == null) {
            return -1;
        }
        return grade.getScore().compareTo(this.getScore());
    }

    @Override
    public boolean isPassed() {
        return this.passed;
    }

    @Override
    public void setPassed(boolean isPass) {
        this.passed = isPass;
    }

    @Override
    public GradingMode getGradingMode() {
        return this.gradingMode;
    }

    @Override
    public void setGradingMode(GradingMode gradingMode) {
        this.gradingMode = gradingMode;
    }

    @Override
    public String getOperator() {
        return this.operator;
    }

    @Override
    public void setOperator(String operator) {
        this.operator = operator;
    }

    public boolean isBeyondSubmit() {
        return this.status >= 1;
    }

    public Float getDelta() {
        return this.delta;
    }

    public void setDelta(Float delta) {
        this.delta = delta;
    }

    public Date getUpdatedAt() {
        return this.updatedAt;
    }

    public void setUpdatedAt(Date updatedAt) {
        this.updatedAt = updatedAt;
    }

    public String getRemark() {
        return this.remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }
}

