[#ftl]
[@b.head/]
[#assign gradeStatus={'0':'新添加','1':'已提交','2':'已发布'}/]
[#assign grade=courseGrade/]
<style>
table.info-table {
  table-layout: fixed;
}
table.info-table td.title {
  padding: 0.2rem 0rem;
  text-align: right;
  color: #6c757d !important;
}
.grid-caption {
  background-color: white;
  color: black;
  font-weight: bold;
  margin-bottom: 0;
  padding: 5px;
}
#grades-table th{
  color:#6c757d !important;
  font-weight: normal;
}
</style>
[#if (Parameters['modal']!'0')=='0']
[@b.toolbar title="学生单科成绩信息"]
   bar.addBack("${b.text("action.back")}");
[/@]
[/#if]
<div class="container-fluid">
  <div class="card card-primary card-outline">
    <div class="card-header">
      <h4 class="card-title">
        [@ems.avatar username=grade.std.code style="border-radius: 10%;height:30px;"/]
        ${grade.std.name} ${grade.course.name}(${grade.semester.schoolYear} ${grade.semester.name}) 成绩：${grade.scoreText!}
      </h4>
      <div class="card-tools">
        [@b.a href="!semester?std.id=${grade.std.id}&semester.id=${grade.semester.id}"]<i class="fa-solid fa-list"></i>本学期成绩[/@]
        <span class="text-muted" style="margin-left:10px;">操作人:${grade.operator!'--'} 更新时间:${grade.updatedAt?string('yyyy-MM-dd HH:mm:ss')}</span>
      </div>
    </div>
    <div class="card-body" style="padding-top:0px;">
      <table class="table table-sm info-table" width="100%">
        <colgroup>
          <col width="9%"/>
          <col width="20%"/>
          <col width="9%"/>
          <col width="10%"/>
          <col width="9%"/>
          <col/>
          <col width="9%"/>
          <col width="20%"/>
        </colgroup>
        <tbody>
          <tr>
            <td class="title">学号：</td>
            <td><a href="/std/info/admin/search/${grade.std.id}" target="_blank">${grade.std.code} ${grade.std.name}</a> ${grade.std.gender.name}</td>
            <td class="title">年级：</td>
            <td>${grade.std.grade.name}</td>
            <td class="title">院系：</td>
            <td>${grade.std.state.department.shortName!grade.std.state.department.name}</td>
            <td class="title">班级：</td>
            <td>${(grade.std.state.squad.name)!}</td>
          </tr>
          <tr>
            <td class="title">课程名称：</td>
            <td>${grade.course.name}</td>
            <td class="title">课程序号：</td>
            <td>
              [#if grade.clazz??]
                [@b.a href="!clazz?clazz.id=${grade.clazz.id}" target="_blank"]${grade.crn}[/@]
              [#else]
              ${grade.crn?if_exists}
              [/#if]
            </td>
            <td class="title">课程代码：</td>
            <td>${grade.course.code}</td>
            <td class="title">任课教师：</td>
            <td>[#if grade.clazz??][#list grade.clazz.teachers as t]${t.name}[#sep],[/#list][/#if]</td>
          </tr>
          <tr>
            <td class="title">学年学期：</td>
            <td>${grade.semester.schoolYear}(${grade.semester.name})</td>
            <td class="title">学分：</td>
            <td>${(grade.credits)?if_exists}</td>
            <td class="title">考核方式：</td>
            <td>${grade.examMode.name}</td>
            <td class="title">课程类别：</td>
            <td>${grade.courseType.name}</td>
          </tr>
          <tr>
            <td class="title">得分：</td>
            <td><span [#if !grade.passed]style="color:red"[/#if]>${(grade.scoreText)!}</span></td>
            <td class="title">修读类别：</td>
            <td>${grade.courseTakeType.name} [#if grade.freeListening]<sup style="color:green">免听</sup>[/#if]</td>
            <td class="title">记录方式：</td>
            <td>${grade.gradingMode.name}</td>
            <td class="title">状态：</td>
            <td>${gradeStatus[grade.status?default(0)?string]}</td>
          </tr>
          <tr>
            <td class="title">绩点：</td>
            <td>${(grade.gp?string("#.##"))?if_exists}</td>
            <td class="title">是否通过：</td>
            <td>[#if grade.passed]是[#else]<font color="red">否[/#if]</td>
            <td class="title">备注：</td>
            <td colspan="3">${(grade.remark)!}</td>
          </tr>
        </tbody>
      </table>
    </div>
  </div>

  [#assign elements = []/]
  [#assign elements = elements + grade.gaGrades/]
  [#assign elements = elements + grade.examGrades/]
  [#if elements?size>0]
  <div class="card card-primary card-outline">
    <div class="card-header">
      <h4 class="card-title">成绩组成</h4>
    </div>
    <div class="card-body" style="padding-top:0px;">
    [@b.grid items=elements var="g" theme="mini" style="table-layout: fixed;" id="grades-table"]
      [@b.row]
        [@b.col width="15%" title="成绩类型"]${g.gradeType.name}[/@]
        [@b.col width="10%" title="得分"]<span [#if !g.passed] style="color:red" [/#if]>${(g.scoreText)!}</span>[/@]
        [@b.col width="10%" title="绩点/考试情况"][#if g.examStatus??]${g.examStatus.name}[#else]${(g.gp)!}[/#if][/@]
        [@b.col width="15%" title="记录方式"]${g.gradingMode.name}[/@]
        [@b.col width="10%" title="其他说明"]
          [#if g.examStatus??]
            [#if g.weight?exists]${g.weight}%[/#if]
          [#else]
            ${g.delta!}[#if g.delta?? && g.remark??](${g.remark})[/#if]
          [/#if]
        [/@]
        [@b.col width="10%" title="是否通过"][#if g.passed]是[#else]<font color="red">否</font>[/#if][/@]
        [@b.col width="10%" title="状态"]${gradeStatus[g.status?string]}[/@]
        [@b.col title="更新时间"]<span class="text-muted">${g.operator!'--'} ${(g.updatedAt?string("yyyy-MM-dd HH:mm:ss"))!}</span>[/@]
      [/@]
    [/@]
    </div>
  </div>
  [/#if]
</div>
[@b.foot/]
