[@b.head title="${clazz.crn} 课程成绩"/]
[@b.toolbar title="单个教学任务成绩信息"]
   bar.addClose();
[/@]
<style>
  .table-mini th{
    color:#6c757d !important;
    font-weight: normal;
  }
</style>
[#macro displayStd(grade)]
 ${grade.std.code}&nbsp;
 <a href="${b.url('!info?id=${grade.id}&modal=1')}" data-toggle="modal" data-target="#gradeInfo" title="${grade.std.name}的${grade.course.name}成绩">${grade.std.name}</a>
[/#macro]
[#macro displayScore(grade)]
[#if grade.passed]${grade.scoreText!}[#else]<span style="color:red">${grade.scoreText!}</span>[/#if]
[#if grade.courseTakeType.id != 1]<sup style="color:red">${grade.courseTakeType.name}</sup>[/#if]
[/#macro]

<div class="container">

  [@b.card class="card card-primary card-outline"]
    [@b.card_header style="padding: 0.5rem 1.25rem;"]
      <h3 class="card-title"><i class="fa-solid fa-circle-info"></i> ${clazz.course.name}(${clazz.semester.schoolYear}学年${clazz.semester.name}学期 ${clazz.crn})</h3>
    [/@]
    [@b.card_body style="padding-top: 0px;"]
      <table class="table table-sm" style="width:100%">
        <tr>
          <td class="title" width="10%">课程代码:</td>
          <td width="23%">${clazz.course.code}</td>
          <td class="title" width="10%">课程名称:</td>
          <td width="24%"><a href="/edu/course/profile/info/${clazz.course.id}" target="_blank">${clazz.course.name}[#if clazz.subject??]--${clazz.subject}[/#if]</a></td>
          <td class="title" width="10%">开课院系:</td>
          <td width="23%">${clazz.teachDepart.name}</td>
        </tr>
        <tr>
          <td class="title" >学分:</td>
          <td>${clazz.course.creditsInfo} </td>
          <td class="title" >课程英文名:</td>
          <td colspan="3">${clazz.course.enName!'--'}</td>
        </tr>
        <tr>
          <td class="title">课程类别:</td>
          <td>${clazz.courseType.name}</td>
          <td class="title">校区:</td>
          <td>${clazz.campus.name}</td>
          <td class="title">考核方式:</td>
          <td>${(clazz.examMode.name)!}</td>
        </tr>
        <tr>
          <td class="title">授课语言:</td>
          <td>${clazz.langType.name}</td>
          <td class="title">任课教师:</td>
          <td>[#list clazz.teachers as teacher]${teacher.name}[#sep]&nbsp;[/#list]</td>
          <td class="title">上课人数:</td>
          <td>${clazz.enrollment.stdCount}</td>
        </tr>
      </table>
    [/@]
  [/@]

  <div class="card card-primary card-outline">
    <div class="card-header">
      <h4 class="card-title">
        <i class="fa-solid fa-list"></i>成绩明细
      </h4>
    </div>
    <div class="card-body" style="padding-top:0px;">
      <table class="table table-hover table-sm table-mini">
        <thead>
          <tr>
            <th width="5%">序号</th>
            <th width="20%">学生</th>
            <th width="8%">成绩</th>

            <th width="5%">序号</th>
            <th width="20%">学生</th>
            <th width="8%">成绩</th>

            <th width="5%">序号</th>
            <th width="20%">学生</th>
            <th width="9%">成绩</th>
          </tr>
        </thead>
        <tbody>
        [#if grades?size>0]
        [#assign gradeLists = grades?chunk((grades?size+2)/3)]
        [#assign firstColSize=gradeLists?first?size/]
        [#list 1..firstColSize as i]
          <tr>
            [#assign grade=gradeLists[0][i-1]/]
            <td class="text-muted">${i}</td>
            <td>[@displayStd grade/]</td>
            <td>[@displayScore grade/]</td>

            [#if (gradeLists[1][i-1])??]
              [#assign grade=(gradeLists[1][i-1])/]
              <td class="text-muted">${firstColSize+i}</td>
              <td>[@displayStd grade/]</td>
              <td>[@displayScore grade!/]</td>
            [#else]
              <td></td><td></td><td></td>
            [/#if]

            [#if gradeLists[2]?? && gradeLists[2][i-1]??]
            [#assign grade=(gradeLists[2][i-1])/]
            <td class="text-muted">${firstColSize*2+i}</td>
            <td>[@displayStd grade/]</td>
            <td>[@displayScore grade!/]</td>
            [#else]
              <td></td><td></td><td></td>
            [/#if]
          </tr>
        [/#list]
        [/#if]
        </tbody>
      </table>
    </div>
  </div>
  [@b.dialog id="gradeInfo" title="学生成绩信息" class="modal-xl"/]
</div>

[@b.foot/]
