/*
 * Copyright (C) 2014, The OpenURP Software.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package org.openurp.edu.grade.web.action.regular

import org.openurp.base.util.FloatSegment
import org.openurp.edu.grade.service.stat.GradeSegStat

object SegmentStat {

  def stat(scores: collection.Seq[Float], segments: Iterable[FloatSegment]): GradeSegStat = {
    val segs = segments.map(_.clone)
    val lowest = scores.head
    val highest = scores.last
    val stdCount = scores.size
    var sum = 0L
    var average = 0f
    scores foreach { s =>
      val score = s.floatValue()
      sum += (score * 100).intValue
      segs.find(_.contains(score)).foreach { seg => seg.count += 1 }
    }
    if 0 != stdCount then average = (BigDecimal(sum) / BigDecimal(stdCount * 100)).floatValue
    new GradeSegStat(null, segs, stdCount, highest.floatValue, lowest.floatValue, average)
  }
}
