[@b.head title="${clazz.crn} 课程成绩"/]
[@b.toolbar title="单个教学任务平时成绩信息"]
   bar.addClose();
[/@]
<style>
  .table-mini th{
    color:#6c757d !important;
    font-weight: normal;
  }
  .table-mini{
    table-layout: fixed;
  }
</style>
[#macro displayStd(grade)]
<div class="text-ellipsis">
  ${grade.std.code} ${grade.std.name}
</div>
[/#macro]
[#macro displayScore(grade)]
[#if grade.score>59.9]${grade.score!}[#else]<span style="color:red">${grade.score!}</span>[/#if]
[/#macro]

[#macro displayTestScore(grade,tests,component)]
[#if tests[component.name]??]
  [#local test = tests[component.name]/]
  [#if test.score>59.9]${test.score}[#else]<span style="color:red">${test.score}</span>[/#if]
[/#if]
[/#macro]

<div class="container">

  [@b.card class="card card-primary card-outline"]
    [@b.card_header style="padding: 0.5rem 1.25rem;"]
      <h3 class="card-title"><i class="fa-solid fa-circle-info"></i> ${clazz.course.name}(${clazz.semester.schoolYear}学年${clazz.semester.name}学期 ${clazz.crn})</h3>
    [/@]
    [@b.card_body style="padding-top: 0px;"]
      <table class="table table-sm" style="width:100%">
        <tr>
          <td class="title" width="10%">课程代码:</td>
          <td width="23%">${clazz.course.code}</td>
          <td class="title" width="10%">课程名称:</td>
          <td width="24%"><a href="/edu/course/profile/info/${clazz.course.id}" target="_blank">${clazz.course.name}[#if clazz.subject??]--${clazz.subject}[/#if]</a></td>
          <td class="title" width="10%">开课院系:</td>
          <td width="23%">${clazz.teachDepart.name}</td>
        </tr>
        <tr>
          <td class="title" >学分:</td>
          <td>${clazz.course.creditsInfo} </td>
          <td class="title" >课程英文名:</td>
          <td colspan="3">${clazz.course.enName!'--'}</td>
        </tr>
        <tr>
          <td class="title">课程类别:</td>
          <td>${clazz.courseType.name}</td>
          <td class="title">校区:</td>
          <td>${clazz.campus.name}</td>
          <td class="title">考核方式:</td>
          <td>${(clazz.examMode.name)!}</td>
        </tr>
        <tr>
          <td class="title">授课语言:</td>
          <td>${clazz.langType.name}</td>
          <td class="title">任课教师:</td>
          <td>[#list clazz.teachers as teacher]${teacher.name}[#sep]&nbsp;[/#list]</td>
          <td class="title">上课人数:</td>
          <td>${clazz.enrollment.stdCount}</td>
        </tr>
      </table>
    [/@]
  [/@]

  [#include "pie.ftl"/]

  [#assign components = state.components?values/]
  <div class="card card-primary card-outline">
    <div class="card-header">
      <h4 class="card-title">
        <i class="fa-solid fa-list"></i>平时成绩统计分布
      </h4>
      <div class="card-tools">
      [#assign colors=['#5470c6', '#91cc75', '#fac858', '#ee6666', '#73c0de', '#3ba272', '#fc8452', '#9a60b4', '#ea7ccc']/]
      [#list segments as seg]
      <span style="background-color:${colors[seg_index]};border-radius: 35%;margin-right: 2px;">&nbsp;&nbsp;&nbsp;&nbsp;</span>${seg.min}~${seg.max}
      [/#list]
      </div>
    </div>
    <div class="card-body" style="padding-top:0px;">
      <div style="display:flex;justify-content: center;">
      [#list components as c]
        [#if stats[c.name]??]
          [#assign stat = stats[c.name]/]
          [#assign statData={}/]
          [#list stat.segments as seg][#assign statData=statData+{'${seg.min}~${seg.max}':seg.count}/][/#list]
          [@pie "test${c_index}" "${c.name}成绩" statData/]
        [/#if]
      [/#list]
      </div>
    </div>
  </div>

  <div class="card card-primary card-outline">
    <div class="card-header">
      <h4 class="card-title">
        <i class="fa-solid fa-list"></i>平时成绩明细
      </h4>
      <div class="card-tools">
      人数:${grades?size}
      优秀率:${state.excellentRate*100}%
      [#list components as c]${c.name}(${c.weight}%)[#sep]&nbsp;[/#list]
      </div>
    </div>
    <div class="card-body" style="padding-top:0px;">
      <table class="table table-hover table-sm table-mini">
        <thead>
          <tr>
            <th width="4%">序号</th>
            <th width="15%">学生</th>
            [#list components as c]<th width="${25/components?size}%">${c.name}</th>[/#list]
            <th width="6%">成绩</th>
            <th width="5%">序号</th>
            <th width="15%">学生</th>
            [#list components as c]<th width="${25/components?size}%">${c.name}</th>[/#list]
            <th width="6%">成绩</th>
          </tr>
        </thead>
        <tbody>

        [#if grades?size>0]
        [#assign gradeLists = grades?chunk((grades?size+1)/2)]
        [#assign firstColSize=gradeLists?first?size/]
        [#list 1..firstColSize as i]
          <tr>
            [#assign grade=gradeLists[0][i-1]/]
            <td class="text-muted">${i}</td>
            <td>[@displayStd grade/]</td>
            [#assign tests = grade.tests/]
            [#list components as c]<td>[@displayTestScore grade,tests,c/]</td>[/#list]
            <td>[@displayScore grade/]</td>

            [#if gradeLists[1]?? && gradeLists[1][i-1]??]
              [#assign grade=gradeLists[1][i-1]/]
              <td class="text-muted">${firstColSize*2+i}</td>
              <td>[@displayStd grade/]</td>
              [#assign tests = grade.tests/]
              [#list components as c]<td>[@displayTestScore grade,tests,c/]</td>[/#list]
              <td>[@displayScore grade!/]</td>
            [#else]
              [#list 1..3+components?size as d]<td></td>[/#list]
            [/#if]
          </tr>
        [/#list]
        [/#if]
        </tbody>
      </table>
    </div>
  </div>
</div>

[@b.foot/]
